/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.jdmresult;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Timestamp;
import java.util.Date;
import javax.datamining.ExecutionHandle;
import javax.datamining.JDMException;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.jdm.data.OraPhysicalDataSet;
import oracle.dmt.jdm.jdmresult.OraNamedObject;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.OraBuildTask;

public class OraMiningBuildResult
implements MiningObject {
    private NamedObject m_objectType = OraNamedObject.buildResults;
    private String m_description = "";
    private String m_name = "";
    private String m_creatorInfo = "";
    private String m_identifier = "";
    private Timestamp m_startingTimestamp;
    private Timestamp m_completionTimestamp;
    private String m_miningModel;
    private String m_inputTableName;
    private String m_inputSchemaNamea;
    private String m_taskName = "";
    private static final String SQL_MINING_BUILD = "SELECT * FROM  DM4J$RESULTS_STATE_V WHERE TYPE='BUILD' AND RESULT_NAME = ?";
    private static final String CREATION_DATE = "CREATION_DATE";
    private static final String MODEL = "MODEL_NAME";
    private static final String TASK = "TASK_NAME";

    OraMiningBuildResult() {
    }

    public NamedObject getObjectType() {
        return this.m_objectType;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String string) throws JDMException {
        this.m_description = string;
    }

    public String getName() {
        return this.m_name;
    }

    protected void setName(String string) throws JDMException {
        this.m_name = string;
        this.m_identifier = this.getObjectType().name() + "_" + string;
    }

    public String getTaskName() {
        return this.m_taskName;
    }

    protected void setTaskName(String string) throws JDMException {
        this.m_taskName = string;
    }

    protected void setCreatorInfo(String string) throws JDMException {
        this.m_creatorInfo = string;
    }

    public String getCreatorInfo() {
        return this.m_creatorInfo;
    }

    protected void setCreationDate(Date date) throws JDMException {
        this.m_startingTimestamp = new Timestamp(date.getTime());
    }

    public Date getCreationDate() {
        return new Date(this.m_startingTimestamp.getTime());
    }

    protected void setCompletionTimestamp(Date date) {
        this.m_completionTimestamp = new Timestamp(date.getTime());
    }

    public Timestamp getCompletionTimestamp() {
        return this.m_completionTimestamp;
    }

    public String getObjectIdentifier() {
        return this.m_identifier;
    }

    protected void setObjectIdentifier(String string) throws JDMException {
        this.m_identifier = string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MiningObject restore(javax.datamining.resource.Connection connection, String string) {
        OraMiningBuildResult oraMiningBuildResult = new OraMiningBuildResult();
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        Connection connection2 = null;
        try {
            connection2 = ((OraConnection)connection).getDatabaseConnection();
            preparedStatement = connection2.prepareStatement(SQL_MINING_BUILD);
            preparedStatement.setString(1, string);
            resultSet = preparedStatement.executeQuery();
            while (resultSet.next()) {
                String string2;
                String string3 = resultSet.getString(MODEL);
                if (string3 != null) {
                    oraMiningBuildResult.setMiningModel(string3);
                }
                if ((string2 = resultSet.getString(TASK)) == null) continue;
                oraMiningBuildResult.setTaskName(string2);
                OraBuildTask oraBuildTask = (OraBuildTask)connection.retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string2), NamedObject.task);
                if (oraBuildTask == null) continue;
                OraPhysicalDataSet oraPhysicalDataSet = (OraPhysicalDataSet)oraBuildTask.getBuildData();
                oraMiningBuildResult.setInputTableName(oraPhysicalDataSet.getTableName());
                String string4 = oraPhysicalDataSet.getSchemaName();
                if (string4 == null) {
                    string4 = connection2.getMetaData().getUserName();
                }
                oraMiningBuildResult.setInputSchemaName(string4);
                ExecutionHandle executionHandle = oraBuildTask.getExecutionHandle();
                Date date = executionHandle.getStartTime();
                if (date == null) continue;
                oraMiningBuildResult.setCreationDate(date);
                Integer n = executionHandle.getDurationInSeconds();
                if (n == null) continue;
                Date date2 = new Date(date.getTime() + (long)(n * 1000));
                oraMiningBuildResult.setCompletionTimestamp(date2);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return oraMiningBuildResult;
    }

    public Timestamp getStartingTimestamp() {
        return this.m_startingTimestamp;
    }

    public String getMiningModel() {
        return this.m_miningModel;
    }

    protected void setMiningModel(String string) {
        this.m_miningModel = string;
    }

    protected void setInputTableName(String string) {
        this.m_inputTableName = string;
    }

    public String getInputTableName() {
        return this.m_inputTableName;
    }

    protected void setInputSchemaName(String string) {
        this.m_inputSchemaNamea = string;
    }

    public String getSchemaName() {
        return this.m_inputSchemaNamea;
    }
}

