/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.jdm.jdmresult;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.Date;
import javax.datamining.ExecutionHandle;
import javax.datamining.JDMException;
import javax.datamining.MiningObject;
import javax.datamining.NamedObject;
import javax.datamining.task.apply.ApplyTask;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.jdm.data.OraPhysicalDataSet;
import oracle.dmt.jdm.jdmresult.OraNamedObject;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dmt.jdm.task.apply.OraDataSetApplyTask;

public class OraMiningApplyResult
implements MiningObject {
    private NamedObject m_objectType = OraNamedObject.applyResults;
    private String m_description = "";
    private String m_name = "";
    private String m_creatorInfo = "";
    private String m_identifier = "";
    private Timestamp m_startingTimestamp;
    private Timestamp m_completionTimestamp;
    private String m_miningModel;
    private String m_inputTableName;
    private String m_inputSchemaName;
    private String m_applyOutputTableName;
    private String m_taskName = "";
    private ApplyTask m_applyTask;
    private static final String SQL_MINING_APPLY = "SELECT * FROM  DM4J$RESULTS_STATE_V WHERE (TYPE='APPLY' OR TYPE='PLOT') AND RESULT_NAME = {result}";
    private static final String CREATION_DATE = "CREATION_DATE";
    private static final String MODEL = "MODEL_NAME";
    private static final String TASK = "TASK_NAME";

    OraMiningApplyResult() {
    }

    public NamedObject getObjectType() {
        return this.m_objectType;
    }

    public String getDescription() {
        return this.m_description;
    }

    public void setDescription(String string) throws JDMException {
        this.m_description = string;
    }

    public String getName() {
        return this.m_name;
    }

    protected void setName(String string) throws JDMException {
        this.m_name = string;
        this.m_identifier = this.getObjectType().name() + "_" + string;
    }

    public String getTaskName() {
        return this.m_taskName;
    }

    public void setTaskName(String string) throws JDMException {
        this.m_taskName = string;
    }

    protected void setCreatorInfo(String string) throws JDMException {
        this.m_creatorInfo = string;
    }

    public String getCreatorInfo() {
        return this.m_creatorInfo;
    }

    protected void setCreationDate(Date date) throws JDMException {
        this.m_startingTimestamp = new Timestamp(date.getTime());
    }

    public Date getCreationDate() {
        return new Date(this.m_startingTimestamp.getTime());
    }

    protected void setCompletionTimestamp(Date date) {
        this.m_completionTimestamp = new Timestamp(date.getTime());
    }

    public Timestamp getCompletionTimestamp() {
        return this.m_completionTimestamp;
    }

    public String getObjectIdentifier() {
        return this.m_identifier;
    }

    protected void setObjectIdentifier(String string) throws JDMException {
        this.m_identifier = string;
    }

    public ApplyTask getApplyTask() {
        return this.m_applyTask;
    }

    protected void setApplyTask(ApplyTask applyTask) throws JDMException {
        this.m_applyTask = applyTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MiningObject restore(javax.datamining.resource.Connection connection, String string) {
        OraMiningApplyResult oraMiningApplyResult = new OraMiningApplyResult();
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection2 = null;
        try {
            connection2 = ((OraConnection)connection).getDatabaseConnection();
            string = DM4JStringUtils.isDoubleQuotedString(string) ? DM4JStringUtils.trimDoubleQuotes(string) : string;
            string = "'" + DatabaseMetadata.getReplacedString(string, "'", "''") + "'";
            String string2 = DatabaseMetadata.getReplacedString(SQL_MINING_APPLY, "{result}", string);
            statement = connection2.prepareStatement(string2);
            resultSet = statement.executeQuery();
            while (resultSet.next()) {
                String string3;
                String string4 = resultSet.getString(MODEL);
                if (string4 != null) {
                    oraMiningApplyResult.setMiningModel(string4);
                }
                if ((string3 = resultSet.getString(TASK)) == null) continue;
                oraMiningApplyResult.setTaskName(string3);
                OraDataSetApplyTask oraDataSetApplyTask = (OraDataSetApplyTask)connection.retrieveObject(DMEMetadata.fixObjectNameWhenLoad(string3), NamedObject.task);
                if (oraDataSetApplyTask == null) continue;
                OraPhysicalDataSet oraPhysicalDataSet = (OraPhysicalDataSet)oraDataSetApplyTask.getApplyData();
                oraMiningApplyResult.setInputTableName(oraPhysicalDataSet.getTableName());
                String string5 = oraPhysicalDataSet.getSchemaName();
                if (string5 == null) {
                    string5 = connection2.getMetaData().getUserName();
                }
                oraMiningApplyResult.setInputSchemaName(string5);
                oraMiningApplyResult.setApplyOutputTableName(oraDataSetApplyTask.getApplyOutputDestination());
                ExecutionHandle executionHandle = oraDataSetApplyTask.getExecutionHandle();
                Date date = executionHandle.getStartTime();
                if (date != null) {
                    oraMiningApplyResult.setCreationDate(date);
                    Integer n = executionHandle.getDurationInSeconds();
                    if (n != null) {
                        Date date2 = new Date(date.getTime() + (long)(n * 1000));
                        oraMiningApplyResult.setCompletionTimestamp(date2);
                    }
                }
                oraMiningApplyResult.setApplyTask(oraDataSetApplyTask);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception exception) {}
        }
        return oraMiningApplyResult;
    }

    public Timestamp getStartingTimestamp() {
        return this.m_startingTimestamp;
    }

    public String getMiningModel() {
        return this.m_miningModel;
    }

    protected void setMiningModel(String string) {
        this.m_miningModel = string;
    }

    protected void setInputTableName(String string) {
        this.m_inputTableName = string;
    }

    public String getInputTableName() {
        return this.m_inputTableName;
    }

    protected void setInputSchemaName(String string) {
        String string2;
        this.m_inputSchemaName = string2 = DM4JStringUtils.isDoubleQuotedString(string) ? string : string.toUpperCase();
    }

    public String getSchemaName() {
        return this.m_inputSchemaName;
    }

    protected void setApplyOutputTableName(String string) {
        String string2;
        this.m_applyOutputTableName = string2 = DM4JStringUtils.isDoubleQuotedString(string) ? string : string.toUpperCase();
    }

    public String getApplyOutputTableName() {
        return this.m_applyOutputTableName;
    }
}

