/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.validation;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Random;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JDefaultNameGenerator;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.sql.DBReservedWords;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.jdbc.OraclePreparedStatement;

public class ValidationUtil {
    static final char DOLLAR_SIGN = '$';
    static final char POUND_SIGN = '#';
    static final char UNERSCORE = '_';
    static final char DOUBLE_QUOTE = '\"';
    static final String ROWID = "ROWID";
    static final char SINGLE_QUOTE = '\'';
    static Random randNumberGen = new Random();
    static final int RANDOM_RANGE = 999999999;
    static final int INDEX_RANDOM_RANGE = 999999;
    static final int JDM_RANDOM_RANGE = 99999;
    static int INCREMENT = 0;

    public static boolean validationsContainsErrors(Vector vector) {
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            StateValidation stateValidation = (StateValidation)iterator.next();
            if ("ERROR".compareTo(stateValidation.getValidationType()) != 0) continue;
            bl = true;
        }
        return bl;
    }

    public static boolean validationsContainsOtherNonErrors(Vector vector) {
        Iterator iterator = vector.iterator();
        boolean bl = false;
        while (iterator.hasNext()) {
            StateValidation stateValidation = (StateValidation)iterator.next();
            if ("ERROR".compareTo(stateValidation.getValidationType()) == 0) continue;
            bl = true;
        }
        return bl;
    }

    public static String createUniqueTableName(String string, String string2, Connection connection, String string3) throws SQLException {
        String string4 = ValidationUtil.createUniqueTableName(string, connection, string3);
        return string4;
    }

    public static String createUniqueTableName(String string, Connection connection, String string2) throws SQLException {
        return ValidationUtil.createUniqueTableNameUsingRandom(string, connection, string2);
    }

    public static String createUniqueTableNameUsingRandom(String string, Connection connection, String string2) throws SQLException {
        return ValidationUtil.createUniqueTableNameUsingRandom(string, connection, 999999999, string2);
    }

    public static String createUniquePKConstraintNameUsinRandom(String string, Connection connection) throws SQLException {
        HashMap hashMap = DatabaseMetadata.getUserConstraintNamespaceHashMap(connection);
        String string2 = string.length() > 16 ? string.substring(0, 16) : string;
        String string3 = ValidationUtil.createUniqueDBObjNameUsingRandom(connection, string2, hashMap, 999999, "_PK");
        return string3;
    }

    public static String createUniqueTableNameUsingRandom(String string, Connection connection, int n, String string2) throws SQLException {
        HashMap hashMap = DatabaseMetadata.getPrimaryObjectNamespaceHashMap(connection);
        boolean bl = DM4JStringUtils.isDoubleQuotedString(string);
        int n2 = bl ? 15 : 16;
        String string3 = string.length() > n2 ? string.substring(0, n2) : string;
        String string4 = ValidationUtil.createUniqueDBObjNameUsingRandom(connection, string3, hashMap, n, string2);
        if (bl) {
            string4 = string4 + "\"";
        }
        return string4;
    }

    public static String createUniquePKConstraintName(String string, Connection connection) throws SQLException {
        return ValidationUtil.createUniquePKConstraintNameUsinRandom(string, connection);
    }

    public static String createUniqueIndexName(String string, Connection connection, String string2) throws SQLException {
        String[] stringArray = new String[]{"INDEX"};
        String string3 = ValidationUtil.createUniqueTableNameUsingRandom(string, connection, 999999, string2);
        return string3;
    }

    public static boolean isIndexNameUnique(String string, Connection connection) throws SQLException {
        String[] stringArray = new String[]{"INDEX"};
        return DatabaseMetadata.isUniqueInNamespace(connection, stringArray, string);
    }

    public static String createUniqueObjectName(String string, Connection connection, String string2) throws SQLException {
        HashMap hashMap = DatabaseMetadata.getPrimaryObjectNamespaceHashMap(connection);
        String string3 = ValidationUtil.createUniqueDBObjNameUsingRandom(connection, string, hashMap, 999999999, string2);
        return string3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String createUniqueActivityName(String string, String string2) throws Exception {
        Connection connection = null;
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        HashMap hashMap = null;
        String string3 = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            hashMap = AbstractActivity.getNamesHash(connection);
            int n = Math.min(string.length(), 18);
            String string4 = string.substring(0, n);
            string3 = ValidationUtil.createUniqueDBObjNameUsingRandom(connection, string4, hashMap, 999999999, string2);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return string3;
    }

    private static String createUniqueODMNameRandom(Connection connection, String string, HashMap hashMap, String string2) {
        int n = Math.min(string.length(), 13);
        String string3 = string.substring(0, n);
        String string4 = ValidationUtil.createUniqueDBObjNameUsingRandom(connection, string3, hashMap, 99999, string2);
        if (ValidationUtil.checkStringDBLengthMax(string4, connection, 25)) {
            return string4;
        }
        n = Math.min(string.length(), 4);
        string3 = string.substring(0, n);
        string4 = ValidationUtil.createUniqueDBObjNameUsingRandom(connection, string3, hashMap, 99999, string2);
        if (ValidationUtil.checkStringDBLengthMax(string4, connection, 25)) {
            return string4;
        }
        return "";
    }

    private static String createUniqueODMName(Connection connection, String string, Vector vector, String string2) {
        String string3 = string;
        String string4 = null;
        String string5 = null;
        int n = string3.length();
        int n2 = "DM4J$" == null ? 0 : "DM4J$".length();
        int n3 = string2 == null ? 0 : string2.length();
        int n4 = n3 + n2;
        int n5 = Math.min(n, 25 - (n3 + 3));
        string4 = string3.substring(0, n5);
        string5 = ValidationUtil.createUniqueNameNew(string4, vector, string2);
        if (ValidationUtil.checkStringDBLengthMax(string5, connection, 25)) {
            return string5;
        }
        n5 = Math.min(n, (25 - n4) / 3 + n4);
        string4 = string3.substring(0, n5);
        string5 = ValidationUtil.createUniqueNameNew(string4, vector, string2);
        if (ValidationUtil.checkStringDBLengthMax(string5, connection, 25)) {
            return string5;
        }
        return "";
    }

    private static String createUniqueDBObjName(Connection connection, String string, String[] stringArray, String string2) {
        String string3 = string;
        String string4 = null;
        int n = string3.length();
        int n2 = string2 == null ? 0 : string2.length();
        String string5 = null;
        int n3 = Math.min(n, 25 - n2);
        string4 = string3.substring(0, n3);
        string5 = ValidationUtil.createUniqueName(string4, stringArray, string2);
        if (ValidationUtil.checkStringDBLengthMax(string5, connection, 30)) {
            return string5;
        }
        n3 = Math.min(n, (25 - n2) / 3 + n2);
        string4 = string3.substring(0, n3);
        string5 = ValidationUtil.createUniqueName(string4, stringArray, string2);
        if (ValidationUtil.checkStringDBLengthMax(string5, connection, 30)) {
            return string5;
        }
        return "";
    }

    public static String[] createUniqueDBObjNames(Connection connection, String string, String string2, int n) throws SQLException {
        HashMap hashMap = DatabaseMetadata.getPrimaryObjectNamespaceHashMap(connection);
        String string3 = string.length() > 16 ? string.substring(0, 16) : string;
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ValidationUtil.createUniqueDBObjNameUsingRandom(connection, string3, hashMap, 999999999, string2);
            hashMap.put(stringArray[i], stringArray[i]);
        }
        return stringArray;
    }

    private static String createUniqueDBObjNameUsingRandom(Connection connection, String string, HashMap hashMap, int n, String string2) {
        boolean bl = true;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (bl) {
            string3 = String.valueOf(randNumberGen.nextInt(n));
            string4 = string + string3 + string2;
            if (hashMap != null) {
                string5 = (String)hashMap.get(string4);
            }
            if (string5 != null) continue;
            bl = false;
        }
        return string4;
    }

    private static String createUniqueName(String string, String[] stringArray, String string2) {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < stringArray.length; ++i) {
            vector.add(stringArray[i]);
        }
        return ValidationUtil.createUniqueNameNew(string, vector, string2);
    }

    private static String createUniqueNameNew(String string, Vector vector, String string2) {
        String string3 = string;
        if (vector != null) {
            String string4;
            int n;
            int n2 = vector.size();
            HashMap<String, String> hashMap = new HashMap<String, String>(n2);
            for (n = 0; n < n2; ++n) {
                string4 = (String)vector.get(n);
                hashMap.put(string4, string4);
            }
            n = 1;
            string4 = string3;
            DM4JDefaultNameGenerator dM4JDefaultNameGenerator = new DM4JDefaultNameGenerator(string4, string2, false);
            string3 = dM4JDefaultNameGenerator.nextName();
            boolean bl = true;
            do {
                String string5;
                if ((string5 = (String)hashMap.get(string3)) != null) {
                    String string6;
                    string3 = string6 = dM4JDefaultNameGenerator.nextName();
                    continue;
                }
                bl = false;
            } while (bl);
        }
        return string3;
    }

    public static boolean checkStringLength(String string, int n) {
        if (string == null) {
            return false;
        }
        return string.length() <= n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int checkStringDBLength(String string, Connection connection) {
        int n = 0;
        if (string == null) {
            return n;
        }
        String string2 = "select LENGTHB(?) from DUAL";
        Object var4_4 = null;
        OraclePreparedStatement oraclePreparedStatement = null;
        ResultSet resultSet = null;
        try {
            oraclePreparedStatement = (OraclePreparedStatement)connection.prepareStatement(string2);
            oraclePreparedStatement.setString(1, string);
            resultSet = oraclePreparedStatement.executeQuery();
            if (resultSet.next()) {
                n = resultSet.getInt(1);
            }
        }
        catch (Exception exception) {
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (oraclePreparedStatement != null) {
                    oraclePreparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return n;
    }

    public static boolean checkStringDBLengthMax(String string, Connection connection, int n) {
        return ValidationUtil.checkStringDBLength(string, connection) <= n;
    }

    protected static String getReplacedString(String string, String string2, String string3) {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.length() > 0) {
            while ((n2 = string.indexOf(string2, n)) >= 0) {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(string3);
                n = n2 + string2.length();
            }
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isTableNameUnique(String string, Connection connection) {
        String string2 = ValidationUtil.getReplacedString(string, "'", "''");
        String string3 = "select OBJECT_NAME from USER_OBJECTS where OBJECT_TYPE in ('SYNONYM','VIEW','TABLE','SEQUENCE','PROCEDURE','PACKAGE','MATERIALIZED VIEW','TYPE','FUNCTION') AND OBJECT_NAME = '" + string2 + "'";
        String string4 = null;
        PreparedStatement preparedStatement = null;
        ResultSet resultSet = null;
        try {
            preparedStatement = connection.prepareStatement(string3);
            resultSet = preparedStatement.executeQuery();
            if (resultSet.next()) {
                string4 = resultSet.getString(1);
            }
        }
        catch (Exception exception) {
            string4 = null;
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
                if (preparedStatement != null) {
                    preparedStatement.close();
                }
            }
            catch (Exception exception) {}
        }
        return string4 == null;
    }

    public static boolean isValidNonQuotedDBObjectName(String string) {
        boolean bl = true;
        boolean bl2 = bl = !ValidationUtil.isDBReservedWord(string);
        if (bl) {
            bl = ValidationUtil.containsOnlyValidDBNameCharacters(string);
        }
        return bl;
    }

    public static boolean containsOnlyValidDBNameCharacters(String string) {
        boolean bl = true;
        if (string == null || string.length() == 0) {
            return bl;
        }
        bl = Character.isLetter(string.charAt(0));
        if (bl) {
            char c = ' ';
            for (int i = 1; i < string.length() && bl; ++i) {
                c = string.charAt(i);
                if (!Character.isLetterOrDigit(c)) {
                    if (c == '$' || c == '#' || c == '_') continue;
                    bl = false;
                    continue;
                }
                if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
                bl = false;
            }
        }
        return bl;
    }

    public static boolean isGreater32BytesInDB(String string, Connection connection) {
        return !ValidationUtil.checkStringDBLengthMax(string, connection, 30);
    }

    public static boolean isGreater25BytesInDB(String string, Connection connection) {
        return !ValidationUtil.checkStringDBLengthMax(string, connection, 25);
    }

    public static boolean containsDoubleQuote(String string) {
        boolean bl = false;
        if (string.lastIndexOf(34) != -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean containsSingleQuote(String string) {
        boolean bl = false;
        if (string.lastIndexOf(39) != -1) {
            bl = true;
        }
        return bl;
    }

    public static boolean isFileNameWithSuffix(String string) {
        String string2 = ".";
        if (string == null) {
            return false;
        }
        if (string.startsWith(string2)) {
            return false;
        }
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while ((n2 = string.indexOf(string2, n)) >= 0) {
            ++n3;
            n = n2 + string2.length();
        }
        return n3 == 1;
    }

    public static boolean isEqualToROWID(String string) {
        boolean bl = false;
        if (string.equals(ROWID)) {
            bl = true;
        }
        return bl;
    }

    public static boolean isDBReservedWord(String string) {
        return DBReservedWords.isReservedWord(string);
    }

    public static String createUniqueModelName(String string, Connection connection, String string2) throws SQLException {
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        HashMap hashMap = dMEMetadata.getAllModelsHash(connection);
        if (!ValidationUtil.isValidNonQuotedDBObjectName(string)) {
            string = ValidationUtil.createNonQuotedCompliantName(string);
        }
        int n = Math.min(string.length(), 13);
        String string3 = string.substring(0, n);
        String string4 = ValidationUtil.createUniqueODMNameRandom(connection, string3, hashMap, string2);
        return string4;
    }

    public static String createNonQuotedCompliantName(String string) {
        char[] cArray = string.toUpperCase().toCharArray();
        char[] cArray2 = new char[string.length()];
        cArray2[0] = !Character.isLetter(cArray[0]) ? 65 : cArray[0];
        char c = ' ';
        for (int i = 1; i < cArray.length; ++i) {
            c = cArray[i];
            cArray2[i] = cArray[i];
            if (!Character.isLetterOrDigit(c)) {
                if (c == '$' || c == '#' || c == '_') continue;
                cArray2[i] = 95;
                continue;
            }
            if (!Character.isLetter(c) || !Character.isLowerCase(c)) continue;
            cArray2[i] = 95;
        }
        String string2 = new String(cArray2);
        if (ValidationUtil.isDBReservedWord(string2)) {
            string2 = "NEWNAME" + INCREMENT;
            ++INCREMENT;
        }
        return string2;
    }

    private static Vector listAllResults(Connection connection) throws SQLException {
        return DatabaseMetadata.getPrimaryObjectNamespaceVector(connection);
    }

    private static HashMap listAllResultsHash(Connection connection) throws SQLException {
        return DatabaseMetadata.getPrimaryObjectNamespaceHashMap(connection);
    }

    public static String createUniqueModelTestName(String string, Connection connection, String string2) throws SQLException {
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        HashMap hashMap = ValidationUtil.listAllResultsHash(connection);
        String string3 = ValidationUtil.createUniqueODMNameRandom(connection, string, hashMap, string2);
        return string3;
    }

    public static String createUniqueJDMObjectName(String string, Connection connection, String string2) throws SQLException {
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        HashMap hashMap = ValidationUtil.listAllResultsHash(connection);
        String string3 = ValidationUtil.createUniqueODMNameRandom(connection, string, hashMap, string2);
        return string3;
    }

    public static String[] createUniqueJDMObjectNames(String string, Connection connection, String string2, int n) throws SQLException {
        HashMap hashMap = ValidationUtil.listAllResultsHash(connection);
        String[] stringArray = new String[n];
        for (int i = 0; i < n; ++i) {
            stringArray[i] = ValidationUtil.createUniqueODMNameRandom(connection, string, hashMap, string2);
            hashMap.put(stringArray[i], stringArray[i]);
        }
        return stringArray;
    }

    public static String createUniqueModelLiftName(String string, Connection connection, String string2) throws SQLException {
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        HashMap hashMap = ValidationUtil.listAllResultsHash(connection);
        String string3 = ValidationUtil.createUniqueODMNameRandom(connection, string, hashMap, string2);
        return string3;
    }

    private static boolean isNameUnique(String string, Vector vector) {
        boolean bl = true;
        if (vector != null) {
            int n = vector.size();
            for (int i = 0; i < n; ++i) {
                String string2 = (String)vector.get(i);
                if (string.compareToIgnoreCase(string2) != 0) continue;
                bl = false;
                break;
            }
        }
        return bl;
    }

    private static boolean isNameUnique(String string, HashMap hashMap) {
        String string2;
        boolean bl = true;
        if (hashMap != null && (string2 = (String)hashMap.get(string)) != null) {
            bl = false;
        }
        return bl;
    }

    private static boolean isNameUnique(String string, String[] stringArray) {
        boolean bl = true;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (string.compareToIgnoreCase(stringArray[i]) != 0) continue;
                bl = false;
                i = stringArray.length;
            }
        }
        return bl;
    }

    public static boolean isModelNameUnique(String string, Connection connection) throws SQLException {
        DMEMetadata dMEMetadata = DMEMetadata.getInstance();
        HashMap hashMap = dMEMetadata.getAllModelsHash(connection);
        boolean bl = ValidationUtil.isNameUnique(string, hashMap);
        return bl;
    }

    public static boolean isModelTestNameUnique(String string, Connection connection) throws SQLException {
        HashMap hashMap = ValidationUtil.listAllResultsHash(connection);
        boolean bl = ValidationUtil.isNameUnique(string, hashMap);
        return bl;
    }

    public static boolean isModelLiftNameUnique(String string, Connection connection) throws SQLException {
        HashMap hashMap = ValidationUtil.listAllResultsHash(connection);
        boolean bl = ValidationUtil.isNameUnique(string, hashMap);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isActivityNameUnique(String string) throws Exception {
        Connection connection = null;
        BrowserFrame browserFrame = BrowserFrame.getMainFrame();
        String[] stringArray = null;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            stringArray = AbstractActivity.getNames(connection);
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        return ValidationUtil.isNameUnique(string, stringArray);
    }

    public static String addPrefixToName(String string, String string2) {
        if (string2.startsWith(string)) {
            return string2;
        }
        return string + string2;
    }

    public static boolean doesColumnHaveContextIndex(Connection connection, String string, String string2, String string3) throws SQLException, Exception {
        String string4;
        boolean bl = false;
        CallableStatement callableStatement = null;
        ResultSet resultSet = null;
        String string5 = DM4JConnectionManager.getUser();
        String string6 = TransformsDirector.getReplacedString(string, "'", "''");
        String string7 = TransformsDirector.getReplacedString(string3, "'", "''");
        String string8 = TransformsDirector.getReplacedString(string2, "'", "''");
        if (string5.equals(string2)) {
            String string9 = "user_indexes";
            String string10 = "user_ind_columns";
            string4 = "select INDEX_NAME, ITYP_NAME from " + string9 + " " + "where ITYP_NAME = 'CONTEXT' AND " + "INDEX_NAME = " + "(select INDEX_NAME from " + string10 + " " + "where TABLE_NAME  = '" + string6 + "' AND " + "COLUMN_NAME = '" + string7 + "')";
        } else {
            String string11 = "all_indexes";
            String string12 = "all_ind_columns";
            string4 = "select INDEX_NAME, ITYP_NAME from " + string11 + " " + "where ITYP_NAME = 'CONTEXT' AND " + "INDEX_NAME = " + "(select INDEX_NAME from " + string12 + " " + "where TABLE_NAME  = '" + string6 + "' AND " + "TABLE_OWNER = '" + string8 + "' AND " + "COLUMN_NAME = '" + string7 + "')";
        }
        callableStatement = connection.prepareCall(string4);
        resultSet = callableStatement.executeQuery();
        if (resultSet.next()) {
            bl = true;
        }
        return bl;
    }

    public static String createUniqueDBObjNameCodeGen(String string, HashMap hashMap, String string2) {
        boolean bl = true;
        String string3 = null;
        String string4 = null;
        String string5 = null;
        while (bl) {
            string3 = String.valueOf(randNumberGen.nextInt(999999999));
            string4 = string + string3 + string2;
            if (hashMap != null) {
                string5 = (String)hashMap.get(string4);
            }
            if (string5 != null) continue;
            bl = false;
        }
        return string4;
    }
}

