/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.transforms;

import java.awt.Cursor;
import java.awt.Dimension;
import java.util.Date;
import java.util.Vector;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.activity.data.ActivityUtils;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.DM4JWizardHelp;
import oracle.dmt.dm4j.wizard.dialogs.DM4JWizardDialog;
import oracle.dmt.dm4j.wizard.director.transforms.ExecuteTransformationProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.MultiRecordCaseData;
import oracle.dmt.dm4j.wizard.state.transforms.StratifiedState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CaseCountDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedTargetState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TableViewNameState;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.DM4JWelcomePage;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.FinishPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.StratifiedDataPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.StratifiedSettingsPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.StratifiedTargetPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.TableViewNamePage;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.GeneralError;

public class StratifiedWizard
extends DM4JWizard
implements Runnable {
    public static final String LEFT_IMAGE_OF_WIZARD = "transform_stratified.gif";
    StratifiedState m_state;
    DM4JWizardDialog m_wDialog;
    ImageWizardPage m_currentPage;
    DM4JWelcomePage m_WelcomePage;
    ImageWizardPage m_DataPage;
    ImageWizardPage m_NamePage;
    ImageWizardPage m_TargetColPage;
    ImageWizardPage m_SettingPage;
    ImageWizardPage m_FinishPage;
    boolean m_displayUI = true;
    ProgressBar progressDlg;
    static final String g_skipNextTimeID = "TRANSFORMSTRATIFIED";

    public StratifiedWizard(StratifiedState stratifiedState) throws Exception {
        this(stratifiedState, true);
    }

    public StratifiedWizard(StratifiedState stratifiedState, boolean bl) throws Exception {
        super(stratifiedState, LEFT_IMAGE_OF_WIZARD);
        this.m_displayUI = bl;
        stratifiedState.setDisplayUI(this.m_displayUI);
        this.buildWizard(stratifiedState);
    }

    private void buildWizard(StratifiedState stratifiedState) throws Exception {
        this.m_state = stratifiedState;
        if (this.m_displayUI) {
            this.init();
        } else {
            this.autoRun();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoRun() {
        Object object;
        Object object2;
        BrowserContext browserContext = this.m_state.getBrowserContext();
        ComplexDataStructure complexDataStructure = browserContext.getInputDataDescriptor();
        Vector vector = browserContext.getValidations();
        Date date = null;
        if (DiscretizeDataSource.isDebug()) {
            System.out.println("Sample Step:");
            System.out.println("======================");
            System.out.println("\tInput data");
            object2 = complexDataStructure.getCaseTable();
            object = browserContext.getSampledInputDataDescriptor().getCaseTable();
            ActivityUtils.printLineage(this.m_state.getConnection(), browserContext.getSampledInputDataDescriptor(), browserContext.getInputDataDescriptor(), (String)object, (String)object2);
            date = new Date();
        }
        try {
            object2 = new CaseCountDataState(this.m_state, "DATA_STEP_NAME", StepType.DATA_STEP);
            this.m_state.addStep(StepType.DATA_STEP, (WizardStepState)object2);
            object = new TableViewNameState(this.m_state, "VIEW_NAME_STEP_NAME", StepType.NAME_STEP);
            this.m_state.addStep(StepType.NAME_STEP, (WizardStepState)object);
            StratifiedTargetState stratifiedTargetState = new StratifiedTargetState(this.m_state, "STRATIFIED_TARGET_STEP_NAME", StepType.SETTING_STEP);
            this.m_state.addStep(StepType.SETTING_STEP, stratifiedTargetState);
            StratifiedSettingsState stratifiedSettingsState = new StratifiedSettingsState(this.m_state, "STRATIFIED_SETTINGS_STEP_NAME", StepType.SETTING_STEP_1);
            this.m_state.addStep(StepType.SETTING_STEP_1, stratifiedSettingsState);
            FinishState finishState = new FinishState(this.m_state, "FINISH_STEP_NAME", StepType.FINISH_STEP);
            this.m_state.addStep(StepType.FINISH_STEP, finishState);
            ((MultiRecordCaseData)object2).load();
            ((MultiRecordCaseData)object2).validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            boolean bl = ((CaseCountDataState)object2).postValidate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            ((TableViewNameState)object).load();
            stratifiedTargetState.load();
            stratifiedTargetState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            bl = stratifiedTargetState.postValidate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            stratifiedSettingsState.load();
            stratifiedSettingsState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            finishState.load();
            finishState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            this.m_state.construct();
            ExecuteTransformationProcess executeTransformationProcess = new ExecuteTransformationProcess(this.m_state.getConnection(), this.m_state);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), "", executeTransformationProcess, true, true);
            executeTransformationProcess.setProgressBar(progressBar);
            progressBar.start("", "");
            progressBar.waitUntilDone();
            if (executeTransformationProcess.getException() != null) {
                throw executeTransformationProcess.getException();
            }
            this.m_state.setValidations(vector);
            this.m_state.setWizardFinished();
        }
        catch (Exception exception) {
            try {
                vector.add(new StateValidation((ValidationType)GeneralError.ABNORMAL_FAILURE, exception));
                this.m_state.setValidations(vector);
            }
            catch (Exception exception2) {
                System.out.println("Error: " + exception2.getMessage());
                exception2.printStackTrace();
            }
        }
        finally {
            if (DiscretizeDataSource.isDebug()) {
                Date date2 = new Date();
                System.out.println("Sample step completed in:" + (date2.getTime() - date.getTime()) / 1000L + " sec");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            BrowserContext browserContext = this.m_state.getBrowserContext();
            ComplexDataStructure complexDataStructure = browserContext.getInputDataDescriptor();
            boolean bl = browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
            this.setCursor(new Cursor(3));
            this.m_wDialog = new DM4JWizardDialog((BaseWizard)this, BrowserFrame.getMainFrame(), new Dimension(600, 500));
            this.m_state.setDM4JWizardDialog(this.m_wDialog);
            this.setMustFinish(true);
            this.m_wDialog.setWizardTitle(ResourceUtilities.getUILabel("STRATIFIED_TRANSFORM_WIZARD_NAME"));
            this.m_wDialog.setFinishPageIncluded(true);
            this.addWizardListener(this);
            this.m_WelcomePage = this.createWelcomePage();
            this.addPage((WizardPage)this.m_WelcomePage);
            this.m_wDialog.setWelcomeWizardPage(this.m_WelcomePage);
            this.m_DataPage = new StratifiedDataPage(this.m_state, StepType.DATA_STEP);
            this.m_DataPage.setEnabled(!bl);
            this.m_DataPage.setVisible(!bl);
            this.addPage((WizardPage)this.m_DataPage);
            this.m_NamePage = new TableViewNamePage(this.m_state, StepType.NAME_STEP);
            this.m_NamePage.setEnabled(!bl);
            this.m_NamePage.setVisible(!bl);
            this.addPage((WizardPage)this.m_NamePage);
            this.m_state.setDisplayUI(false);
            this.m_TargetColPage = new StratifiedTargetPage(this.m_state, StepType.SETTING_STEP);
            this.addPage((WizardPage)this.m_TargetColPage);
            this.m_SettingPage = new StratifiedSettingsPage(this.m_state, StepType.SETTING_STEP_1);
            this.addPage((WizardPage)this.m_SettingPage);
            this.m_FinishPage = new FinishPage(this.m_state, StepType.FINISH_STEP);
            this.addPage((WizardPage)this.m_FinishPage);
            if (bl) {
                TableViewNameState tableViewNameState = (TableViewNameState)((DM4JPage)this.m_NamePage).getWizardStepState();
                tableViewNameState.load();
                CaseCountDataState caseCountDataState = (CaseCountDataState)((DM4JPage)this.m_DataPage).getWizardStepState();
                caseCountDataState.setSelectedSchemaName(complexDataStructure.getCaseSchema());
                caseCountDataState.setSelectedTableName(complexDataStructure.getCaseTable());
                Vector vector = new Vector();
                boolean bl2 = caseCountDataState.postValidate(vector);
                StratifiedTargetState stratifiedTargetState = (StratifiedTargetState)((DM4JPage)this.m_TargetColPage).getWizardStepState();
                stratifiedTargetState.setState(StepStateType.UNLOADED);
                if (browserContext.getActivity().getTargetColumn() != null) {
                    stratifiedTargetState.setTargetColumnName(browserContext.getActivity().getTargetColumn().getAlias());
                    vector = new Vector();
                }
            }
        }
        catch (Exception exception) {
            this.m_displayUI = false;
            exception.printStackTrace();
        }
        finally {
            this.progressDlg.setDoneStatus();
            this.setCursor(new Cursor(0));
        }
    }

    private void init() throws Exception {
        this.progressDlg = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("STRATIFIED_TRANSFORM_WIZARD_NAME"), this, true);
        this.progressDlg.setCancelable(false);
        this.progressDlg.start(ResourceUtilities.getUILabel("MODEL_REBUILD_UPPER_DESC"), "");
        this.progressDlg.waitUntilDone();
        if (this.m_displayUI) {
            this.m_wDialog.runDialog();
        }
    }

    private DM4JWelcomePage createWelcomePage() throws Exception {
        String string = ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_STRATIFIED_INTRO");
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append("\n");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_STRATIFIED_LINE1"));
        stringBuffer.append(" ");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_STRATIFIED_LINE2"));
        stringBuffer.append("\n\n");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_STRATIFIED_CLOSER"));
        stringBuffer.append("\n\n");
        stringBuffer.append(ResourceUtilities.getUILabel("CLICK_NEXT"));
        stringBuffer.append("\n");
        DM4JWelcomePage dM4JWelcomePage = new DM4JWelcomePage(this.m_state.getImage(), string, stringBuffer.toString(), g_skipNextTimeID);
        DM4JWizardHelp.registerTopic(dM4JWelcomePage.getContent(), "dm4j_xform_strat_sample_welcome_html");
        return dM4JWelcomePage;
    }

    public StratifiedWizard(StratifiedState stratifiedState, boolean bl, boolean bl2) throws Exception {
        super(stratifiedState, "");
        this.buildWizardForCodeGen(stratifiedState);
    }

    private void buildWizardForCodeGen(StratifiedState stratifiedState) throws Exception {
        this.m_state = stratifiedState;
        this.generateCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCode() {
        BrowserContext browserContext = this.m_state.getBrowserContext();
        Vector vector = browserContext.getValidations();
        this.m_state.setDisplayUI(false);
        try {
            CaseCountDataState caseCountDataState = new CaseCountDataState(this.m_state, "DATA_STEP_NAME", StepType.DATA_STEP);
            this.m_state.addStep(StepType.DATA_STEP, caseCountDataState);
            TableViewNameState tableViewNameState = new TableViewNameState(this.m_state, "VIEW_NAME_STEP_NAME", StepType.NAME_STEP);
            this.m_state.addStep(StepType.NAME_STEP, tableViewNameState);
            StratifiedTargetState stratifiedTargetState = new StratifiedTargetState(this.m_state, "STRATIFIED_TARGET_STEP_NAME", StepType.SETTING_STEP);
            this.m_state.addStep(StepType.SETTING_STEP, stratifiedTargetState);
            StratifiedSettingsState stratifiedSettingsState = new StratifiedSettingsState(this.m_state, "STRATIFIED_SETTINGS_STEP_NAME", StepType.SETTING_STEP_1);
            this.m_state.addStep(StepType.SETTING_STEP_1, stratifiedSettingsState);
            FinishState finishState = new FinishState(this.m_state, "FINISH_STEP_NAME", StepType.FINISH_STEP);
            this.m_state.addStep(StepType.FINISH_STEP, finishState);
            caseCountDataState.load();
            caseCountDataState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            boolean bl = caseCountDataState.postValidate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            tableViewNameState.load();
            stratifiedTargetState.load();
            stratifiedTargetState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            bl = stratifiedTargetState.postValidate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            stratifiedSettingsState.load();
            stratifiedSettingsState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            finishState.load();
            finishState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            this.m_state.constructCodGen();
            this.m_state.setWizardFinished();
        }
        catch (Exception exception) {
            try {
                vector.add(new StateValidation((ValidationType)GeneralError.ABNORMAL_FAILURE, exception));
                this.m_state.setValidations(vector);
            }
            catch (Exception exception2) {
                System.out.println("Error: " + exception2.getMessage());
                exception2.printStackTrace();
            }
        }
    }
}

