/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.transforms;

import java.awt.Cursor;
import java.awt.Dimension;
import java.util.Vector;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.DM4JWizardHelp;
import oracle.dmt.dm4j.wizard.dialogs.DM4JWizardDialog;
import oracle.dmt.dm4j.wizard.director.transforms.ExecuteTransformationProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.SplitState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CaseCountDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FinishState;
import oracle.dmt.dm4j.wizard.state.transformsteps.SplitNameState;
import oracle.dmt.dm4j.wizard.state.transformsteps.SplitSettingsState;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.DM4JWelcomePage;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.SplitDataPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.SplitFinishPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.SplitSettingsPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.SplitTableNamePage;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.GeneralError;

public class SplitWizard
extends DM4JWizard
implements Runnable {
    public static final String LEFT_IMAGE_OF_WIZARD = "transform_split.gif";
    SplitState m_state;
    DM4JWizardDialog m_wDialog;
    ImageWizardPage m_currentPage;
    DM4JWelcomePage m_WelcomePage;
    ImageWizardPage m_DataPage;
    ImageWizardPage m_NamePage;
    ImageWizardPage m_SettingsPage;
    ImageWizardPage m_FinishPage;
    boolean m_displayUI = true;
    ProgressBar progressDlg;
    static final String g_skipNextTimeID = "WELCOMETRANSFORMSPLIT";

    public SplitWizard(SplitState splitState) throws Exception {
        this(splitState, true);
    }

    public SplitWizard(SplitState splitState, boolean bl) throws Exception {
        super(splitState, LEFT_IMAGE_OF_WIZARD);
        this.m_displayUI = bl;
        splitState.setDisplayUI(this.m_displayUI);
        this.buildWizard(splitState);
    }

    private void buildWizard(SplitState splitState) throws Exception {
        this.m_state = splitState;
        if (this.m_displayUI) {
            this.init();
        } else {
            this.autoRun();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoRun() {
        BrowserContext browserContext = this.m_state.getBrowserContext();
        ComplexDataStructure complexDataStructure = browserContext.getInputDataDescriptor();
        Vector vector = browserContext.getValidations();
        try {
            CaseCountDataState caseCountDataState = new CaseCountDataState(this.m_state, "DATA_STEP_NAME", StepType.DATA_STEP);
            this.m_state.addStep(StepType.DATA_STEP, caseCountDataState);
            SplitNameState splitNameState = new SplitNameState(this.m_state, "VIEW_NAME_STEP_NAME", StepType.NAME_STEP);
            this.m_state.addStep(StepType.NAME_STEP, splitNameState);
            SplitSettingsState splitSettingsState = new SplitSettingsState(this.m_state, "SAMPLE_SETTINGS_STEP_NAME", StepType.SETTING_STEP);
            this.m_state.addStep(StepType.SETTING_STEP, splitSettingsState);
            FinishState finishState = new FinishState(this.m_state, "FINISH_STEP_NAME", StepType.FINISH_STEP);
            this.m_state.addStep(StepType.FINISH_STEP, finishState);
            caseCountDataState.load();
            caseCountDataState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            boolean bl = caseCountDataState.postValidate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            splitNameState.load();
            splitNameState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            splitSettingsState.load();
            splitSettingsState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            finishState.load();
            finishState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            this.m_state.construct();
            ExecuteTransformationProcess executeTransformationProcess = new ExecuteTransformationProcess(this.m_state.getConnection(), this.m_state);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), "", executeTransformationProcess, true, true);
            executeTransformationProcess.setProgressBar(progressBar);
            progressBar.start("", "");
            progressBar.waitUntilDone();
            if (executeTransformationProcess.getException() != null) {
                throw executeTransformationProcess.getException();
            }
            this.m_state.setValidations(vector);
            this.m_state.setWizardFinished();
        }
        catch (Exception exception) {
            try {
                vector.add(new StateValidation((ValidationType)GeneralError.ABNORMAL_FAILURE, exception));
                this.m_state.setValidations(vector);
            }
            catch (Exception exception2) {
                System.out.println("Error: " + exception2.getMessage());
                exception2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            BrowserContext browserContext = this.m_state.getBrowserContext();
            ComplexDataStructure complexDataStructure = browserContext.getInputDataDescriptor();
            boolean bl = browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
            this.setCursor(new Cursor(3));
            this.m_wDialog = new DM4JWizardDialog((BaseWizard)this, BrowserFrame.getMainFrame(), new Dimension(690, 550));
            this.m_state.setDM4JWizardDialog(this.m_wDialog);
            this.setMustFinish(true);
            this.m_wDialog.setWizardTitle(ResourceUtilities.getUILabel("SPLIT_TRANSFORM_WIZARD_NAME"));
            this.m_wDialog.setFinishPageIncluded(true);
            this.addWizardListener(this);
            this.m_WelcomePage = this.createWelcomePage();
            this.addPage((WizardPage)this.m_WelcomePage);
            this.m_wDialog.setWelcomeWizardPage(this.m_WelcomePage);
            this.m_DataPage = new SplitDataPage(this.m_state, StepType.DATA_STEP);
            this.m_DataPage.setEnabled(!bl);
            this.m_DataPage.setVisible(!bl);
            this.addPage((WizardPage)this.m_DataPage);
            this.m_NamePage = new SplitTableNamePage(this.m_state, StepType.NAME_STEP);
            this.addPage((WizardPage)this.m_NamePage);
            this.m_SettingsPage = new SplitSettingsPage(this.m_state, StepType.SETTING_STEP);
            this.addPage((WizardPage)this.m_SettingsPage);
            this.m_FinishPage = new SplitFinishPage(this.m_state, StepType.FINISH_STEP, "SPLIT_FINISH_STEP_DESCRIPTION");
            this.addPage((WizardPage)this.m_FinishPage);
            if (bl) {
                CaseCountDataState caseCountDataState = (CaseCountDataState)((DM4JPage)this.m_DataPage).getWizardStepState();
                caseCountDataState.setSelectedSchemaName(complexDataStructure.getCaseSchema());
                caseCountDataState.setSelectedTableName(complexDataStructure.getCaseTable());
                Vector vector = new Vector();
                boolean bl2 = caseCountDataState.postValidate(vector);
            }
        }
        catch (Exception exception) {
            this.m_displayUI = false;
        }
        finally {
            this.progressDlg.setDoneStatus();
            this.setCursor(new Cursor(0));
        }
    }

    private void init() throws Exception {
        this.progressDlg = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("SPLIT_TRANSFORM_WIZARD_NAME"), this, true);
        this.progressDlg.setCancelable(false);
        this.progressDlg.start(ResourceUtilities.getUILabel("MODEL_REBUILD_UPPER_DESC"), "");
        this.progressDlg.waitUntilDone();
        if (this.m_displayUI) {
            this.m_wDialog.runDialog();
        }
    }

    private DM4JWelcomePage createWelcomePage() throws Exception {
        String string = ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_SPLIT_INTRO");
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append("\n");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_SPLIT_LINE1"));
        stringBuffer.append(" ");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_SPLIT_LINE2"));
        stringBuffer.append("\n\n");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_SPLIT_CLOSER"));
        stringBuffer.append("\n\n");
        stringBuffer.append(ResourceUtilities.getUILabel("CLICK_NEXT"));
        stringBuffer.append("\n");
        DM4JWelcomePage dM4JWelcomePage = new DM4JWelcomePage(this.m_state.getImage(), string, stringBuffer.toString(), g_skipNextTimeID);
        DM4JWizardHelp.registerTopic(dM4JWelcomePage.getContent(), "dm4j_xform_split_welcome_html");
        return dM4JWelcomePage;
    }

    public SplitWizard(SplitState splitState, boolean bl, boolean bl2) throws Exception {
        super(splitState, "");
        this.buildWizardForCodeGen(splitState);
    }

    private void buildWizardForCodeGen(SplitState splitState) throws Exception {
        this.m_state = splitState;
        this.generateCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void generateCode() {
        BrowserContext browserContext = this.m_state.getBrowserContext();
        Vector vector = browserContext.getValidations();
        this.m_state.setDisplayUI(false);
        try {
            CaseCountDataState caseCountDataState = new CaseCountDataState(this.m_state, "DATA_STEP_NAME", StepType.DATA_STEP);
            this.m_state.addStep(StepType.DATA_STEP, caseCountDataState);
            SplitNameState splitNameState = new SplitNameState(this.m_state, "VIEW_NAME_STEP_NAME", StepType.NAME_STEP);
            this.m_state.addStep(StepType.NAME_STEP, splitNameState);
            SplitSettingsState splitSettingsState = new SplitSettingsState(this.m_state, "SAMPLE_SETTINGS_STEP_NAME", StepType.SETTING_STEP);
            this.m_state.addStep(StepType.SETTING_STEP, splitSettingsState);
            FinishState finishState = new FinishState(this.m_state, "FINISH_STEP_NAME", StepType.FINISH_STEP);
            this.m_state.addStep(StepType.FINISH_STEP, finishState);
            caseCountDataState.load();
            caseCountDataState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            boolean bl = caseCountDataState.postValidate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            splitNameState.load();
            splitNameState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            splitSettingsState.load();
            splitSettingsState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            finishState.load();
            finishState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            this.m_state.constructCodGen();
            this.m_state.setWizardFinished();
        }
        catch (Exception exception) {
            exception.printStackTrace();
            try {
                vector.add(new StateValidation((ValidationType)GeneralError.ABNORMAL_FAILURE, exception));
                this.m_state.setValidations(vector);
            }
            catch (Exception exception2) {
                System.out.println("Error: " + exception2.getMessage());
                exception2.printStackTrace();
            }
        }
    }
}

