/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.transforms;

import java.awt.Cursor;
import java.awt.Dimension;
import java.util.Vector;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.DM4JWizardHelp;
import oracle.dmt.dm4j.wizard.dialogs.DM4JWizardDialog;
import oracle.dmt.dm4j.wizard.director.transforms.ExecuteTransformationProcess;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.ODMrTextState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ODMrTextContextIndexSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ODMrTextFeatureExtractionSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ODMrTextFinishState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ODMrTextNameState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TextCaseIdState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TextDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TextSettingsState;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.DM4JWelcomePage;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.ODMrTextContextIndexSettingsPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.ODMrTextFeatureExtractionSettingsPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.ODMrTextFinishPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.ODMrTextTableNamePage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.TextCaseIdPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.TextDataPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.TextSettingsPage;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.GeneralError;

public class ODMrTextWizard
extends DM4JWizard
implements Runnable {
    public static final String LEFT_IMAGE_OF_WIZARD = "transform_text.gif";
    ODMrTextState m_state;
    DM4JWizardDialog m_wDialog;
    ImageWizardPage m_currentPage;
    DM4JWelcomePage m_WelcomePage;
    ImageWizardPage m_DataPage;
    ImageWizardPage m_NamePage;
    ImageWizardPage m_TransformCaseIdPage;
    ImageWizardPage m_TransformSettingPage;
    ImageWizardPage m_TransformContextIndexSettingPage;
    ImageWizardPage m_TransformFeatureExtractionSettingPage;
    ImageWizardPage m_FinishPage;
    boolean m_displayUI = true;
    ProgressBar progressDlg;
    static final String g_skipNextTimeID = "TRANSFORMODMRTEXT";

    public ODMrTextWizard(ODMrTextState oDMrTextState) throws Exception {
        this(oDMrTextState, true);
    }

    public ODMrTextWizard(ODMrTextState oDMrTextState, boolean bl) throws Exception {
        super(oDMrTextState, LEFT_IMAGE_OF_WIZARD);
        this.m_displayUI = bl;
        this.buildWizard(oDMrTextState);
    }

    private void buildWizard(ODMrTextState oDMrTextState) throws Exception {
        this.m_state = oDMrTextState;
        if (this.m_displayUI) {
            this.init();
        } else {
            this.autoRun();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void autoRun() {
        BrowserContext browserContext = this.m_state.getBrowserContext();
        ComplexDataStructure complexDataStructure = browserContext.getInputDataDescriptor();
        Vector vector = browserContext.getValidations();
        try {
            TextDataState textDataState = new TextDataState(this.m_state, "DATA_STEP_NAME", StepType.DATA_STEP);
            this.m_state.addStep(StepType.DATA_STEP, textDataState);
            ODMrTextNameState oDMrTextNameState = new ODMrTextNameState(this.m_state, "VIEW_NAME_STEP_NAME", StepType.NAME_STEP);
            this.m_state.addStep(StepType.NAME_STEP, oDMrTextNameState);
            TextCaseIdState textCaseIdState = new TextCaseIdState(this.m_state, "SEQUENCEID_STEP_NAME", StepType.SETTING_STEP);
            this.m_state.addStep(StepType.SETTING_STEP, textCaseIdState);
            TextSettingsState textSettingsState = new TextSettingsState(this.m_state, "TEXT_SETTINGS_STEP_NAME", StepType.SETTING_STEP_1);
            this.m_state.addStep(StepType.SETTING_STEP_1, textSettingsState);
            ODMrTextContextIndexSettingsState oDMrTextContextIndexSettingsState = new ODMrTextContextIndexSettingsState(this.m_state, "ODMR_TEXT_CONTEXT_INDEX_SETTINGS_STEP_NAME", StepType.SETTING_STEP_2);
            this.m_state.addStep(StepType.SETTING_STEP_2, oDMrTextContextIndexSettingsState);
            ODMrTextFeatureExtractionSettingsState oDMrTextFeatureExtractionSettingsState = new ODMrTextFeatureExtractionSettingsState(this.m_state, "ODMR_TEXT_FEATURE_EXTRACTION_SETTINGS_STEP_NAME", StepType.SETTING_STEP_3);
            this.m_state.addStep(StepType.SETTING_STEP_3, oDMrTextFeatureExtractionSettingsState);
            ODMrTextFinishState oDMrTextFinishState = new ODMrTextFinishState(this.m_state, "FINISH_STEP_NAME", StepType.FINISH_STEP);
            this.m_state.addStep(StepType.FINISH_STEP, oDMrTextFinishState);
            textDataState.load();
            textDataState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            boolean bl = textDataState.postValidate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            oDMrTextNameState.load();
            oDMrTextNameState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            textCaseIdState.load();
            String string = null;
            if (browserContext.getActivity().getTextColumn() != null) {
                string = browserContext.getActivity().getTextColumn().getAlias();
                textSettingsState.setSelectedAttributes(new String[]{string});
            }
            textSettingsState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            oDMrTextContextIndexSettingsState.load();
            oDMrTextContextIndexSettingsState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            oDMrTextFeatureExtractionSettingsState.load();
            oDMrTextFeatureExtractionSettingsState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            oDMrTextFinishState.load();
            oDMrTextFinishState.validate(vector);
            if (ValidationUtil.validationsContainsErrors(vector)) {
                this.m_state.setValidations(vector);
                return;
            }
            this.m_state.construct();
            ExecuteTransformationProcess executeTransformationProcess = new ExecuteTransformationProcess(this.m_state.getConnection(), this.m_state);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), "", executeTransformationProcess, true, true);
            executeTransformationProcess.setProgressBar(progressBar);
            progressBar.start("", "");
            progressBar.waitUntilDone();
            if (executeTransformationProcess.getException() != null) {
                throw executeTransformationProcess.getException();
            }
            this.m_state.setValidations(vector);
            this.m_state.setWizardFinished();
        }
        catch (Exception exception) {
            try {
                vector.add(new StateValidation((ValidationType)GeneralError.ABNORMAL_FAILURE, exception));
                this.m_state.setValidations(vector);
            }
            catch (Exception exception2) {
                System.out.println("Error: " + exception2.getMessage());
                exception2.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            BrowserContext browserContext = this.m_state.getBrowserContext();
            ComplexDataStructure complexDataStructure = browserContext.getInputDataDescriptor();
            boolean bl = browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
            this.setCursor(new Cursor(3));
            this.m_wDialog = new DM4JWizardDialog((BaseWizard)this, BrowserFrame.getMainFrame(), new Dimension(800, 600));
            this.m_state.setDM4JWizardDialog(this.m_wDialog);
            this.setMustFinish(true);
            this.m_wDialog.setWizardTitle(ResourceUtilities.getUILabel("ODMR_TEXT_TRANSFORM_WIZARD_NAME"));
            this.m_wDialog.setFinishPageIncluded(true);
            this.addWizardListener(this);
            this.m_WelcomePage = this.createWelcomePage();
            this.addPage((WizardPage)this.m_WelcomePage);
            this.m_wDialog.setWelcomeWizardPage(this.m_WelcomePage);
            this.m_DataPage = new TextDataPage(this.m_state, StepType.DATA_STEP);
            this.m_DataPage.setEnabled(!bl);
            this.m_DataPage.setVisible(!bl);
            this.addPage((WizardPage)this.m_DataPage);
            this.m_NamePage = new ODMrTextTableNamePage(this.m_state, StepType.NAME_STEP);
            this.addPage((WizardPage)this.m_NamePage);
            this.m_TransformCaseIdPage = new TextCaseIdPage(this.m_state, StepType.SETTING_STEP);
            this.addPage((WizardPage)this.m_TransformCaseIdPage);
            this.m_TransformCaseIdPage.setEnabled(!bl);
            this.m_TransformCaseIdPage.setVisible(!bl);
            this.m_TransformSettingPage = new TextSettingsPage(this.m_state, StepType.SETTING_STEP_1);
            this.addPage((WizardPage)this.m_TransformSettingPage);
            this.m_TransformContextIndexSettingPage = new ODMrTextContextIndexSettingsPage(this.m_state, StepType.SETTING_STEP_2);
            this.addPage((WizardPage)this.m_TransformContextIndexSettingPage);
            this.m_TransformFeatureExtractionSettingPage = new ODMrTextFeatureExtractionSettingsPage(this.m_state, StepType.SETTING_STEP_3);
            this.addPage((WizardPage)this.m_TransformFeatureExtractionSettingPage);
            this.m_FinishPage = new ODMrTextFinishPage(this.m_state, StepType.FINISH_STEP);
            this.addPage((WizardPage)this.m_FinishPage);
            if (bl) {
                TextDataState textDataState = (TextDataState)((DM4JPage)this.m_DataPage).getWizardStepState();
                textDataState.setSelectedSchemaName(complexDataStructure.getCaseSchema());
                textDataState.setSelectedTableName(complexDataStructure.getCaseTable());
                Vector vector = new Vector();
                boolean bl2 = textDataState.postValidate(vector);
                String string = null;
                if (browserContext.getActivity().getTextColumn() != null) {
                    string = browserContext.getActivity().getTextColumn().getName();
                    TextSettingsState textSettingsState = (TextSettingsState)((DM4JPage)this.m_TransformSettingPage).getWizardStepState();
                    textSettingsState.setSelectedAttributes(new String[]{string});
                }
            } else {
                ((TextDataPage)this.m_DataPage).load();
            }
        }
        catch (Exception exception) {
            this.m_displayUI = false;
        }
        finally {
            this.progressDlg.setDoneStatus();
            this.setCursor(new Cursor(0));
        }
    }

    private void init() throws Exception {
        this.progressDlg = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("ODMR_TEXT_TRANSFORM_WIZARD_NAME"), this, true);
        this.progressDlg.setCancelable(false);
        this.progressDlg.start(ResourceUtilities.getUILabel("MODEL_REBUILD_UPPER_DESC"), "");
        this.progressDlg.waitUntilDone();
        if (this.m_displayUI) {
            this.m_wDialog.runDialog();
        }
    }

    private DM4JWelcomePage createWelcomePage() throws Exception {
        String string = ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_ODMR_TEXT_INTRO");
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append("\n");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_ODMR_TEXT_LINE1"));
        stringBuffer.append(" ");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_ODMR_TEXT_LINE2"));
        stringBuffer.append("\n\n");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_TRANSFORMATION_ODMR_TEXT_CLOSER"));
        stringBuffer.append("\n\n");
        stringBuffer.append(ResourceUtilities.getUILabel("CLICK_NEXT"));
        stringBuffer.append("\n");
        DM4JWelcomePage dM4JWelcomePage = new DM4JWelcomePage(this.m_state.getImage(), string, stringBuffer.toString(), g_skipNextTimeID);
        DM4JWizardHelp.registerTopic(dM4JWelcomePage.getContent(), "dm4j_xform_text_activity_welcome_html");
        return dM4JWelcomePage;
    }
}

