/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.transforms;

import java.awt.Cursor;
import java.awt.Dimension;
import java.util.Vector;
import javax.swing.JFrame;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.ImageWizardPage;
import oracle.bali.ewt.wizard.WelcomeWizardPage;
import oracle.bali.ewt.wizard.WizardEvent;
import oracle.bali.ewt.wizard.WizardPage;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.wizard.DM4JWizard;
import oracle.dmt.dm4j.wizard.DM4JWizardHelp;
import oracle.dmt.dm4j.wizard.dialogs.DM4JWizardDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.CodeGenState;
import oracle.dmt.dm4j.wizard.steps.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.DM4JWelcomePage;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.CodeGenActivityPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.CodeGenConnectionPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.CodeGenFinishPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.CodeGenResultsPage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.CodeGenTargetFilePage;
import oracle.dmt.dm4j.wizard.steps.transformsteps.CodeGenTargetPage;

public class CodeGenWizard
extends DM4JWizard
implements Runnable {
    public static String PACKAGE_SPEC = "PACKAGE {0} AS\n BEGIN\nEND {0};\n";
    public static String PACKAGE_BODY = "PACKAGE BODY {0} AS\n BEGIN\nEND {0};\n";
    public static String OBJECT_TYPE_SPEC = "TYPE {0} AS OBJECT ( a null );";
    public static String OBJECT_TYPE_BODY = "TYPE BODY {0} AS\nBEGIN\nEND;";
    public static final String LEFT_IMAGE_OF_WIZARD = "transform_discretize.gif";
    private CodeGenState m_state;
    private DM4JWizardDialog m_wDialog;
    private WelcomeWizardPage m_WelcomePage;
    private ImageWizardPage m_ConnectionPage;
    private ImageWizardPage m_ActivityPage;
    private CodeGenTargetPage m_TargetPage;
    private CodeGenResultsPage m_ResultsPage;
    private CodeGenTargetFilePage m_FilePage;
    private ImageWizardPage m_FinishPage;
    private ProgressBar m_progressDlg;
    private JFrame m_parent;
    private boolean m_bCancelled;
    static final String g_skipNextTimeID = "WelcomeCodeGenerator";

    public CodeGenWizard(CodeGenState codeGenState, JFrame jFrame) throws Exception {
        this(codeGenState, null, jFrame);
    }

    public CodeGenWizard(CodeGenState codeGenState, WelcomeWizardPage welcomeWizardPage, JFrame jFrame) throws Exception {
        super(codeGenState, LEFT_IMAGE_OF_WIZARD);
        this.m_state = codeGenState;
        this.m_WelcomePage = welcomeWizardPage;
        this.m_parent = jFrame;
        this.init();
    }

    public void enableWizardButtons() {
        this.enableButtons();
    }

    public CodeGenState getState() {
        return this.m_state;
    }

    public DM4JWizardDialog getParentDialog() {
        return this.m_wDialog;
    }

    private void init() throws Exception {
        if (!this.m_state.isDataMiner()) {
            this.execute();
            this.m_wDialog.runDialog();
            return;
        }
        this.m_progressDlg = new ProgressBar(this.m_parent, ResourceUtilities.getUILabel("CODE_GEN_WIZARD_NAME"), this, true, true);
        this.m_progressDlg.setCancelable(true);
        this.m_progressDlg.setEnableUserCancel(true);
        this.m_progressDlg.start(ResourceUtilities.getUILabel("MODEL_REBUILD_UPPER_DESC"), "");
        this.m_progressDlg.waitUntilDone();
        this.m_wDialog.runDialog();
    }

    private DM4JWelcomePage createWelcomePage() throws Exception {
        String string = ResourceUtilities.getUILabel("WELCOME_CODE_GEN_INTRO");
        StringBuffer stringBuffer = new StringBuffer("\n");
        stringBuffer.append("\n");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_CODE_GEN_LINE1"));
        stringBuffer.append(" ");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_CODE_GEN_LINE2"));
        stringBuffer.append("\n\n");
        stringBuffer.append(ResourceUtilities.getUILabel("WELCOME_CODE_GEN_ODMR_CLOSER"));
        stringBuffer.append("\n\n");
        stringBuffer.append(ResourceUtilities.getUILabel("CLICK_NEXT"));
        stringBuffer.append("\n");
        DM4JWelcomePage dM4JWelcomePage = new DM4JWelcomePage(this.m_state.getImage(), string, stringBuffer.toString(), g_skipNextTimeID);
        DM4JWizardHelp.registerTopic(dM4JWelcomePage.getContent(), "dm4j_xform_codegen_welcome_html");
        return dM4JWelcomePage;
    }

    public void wizardCanceled(WizardEvent wizardEvent) {
        super.wizardCanceled(wizardEvent);
        this.m_bCancelled = true;
    }

    public boolean isCancelled() {
        return this.m_bCancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        try {
            this.setCursor(new Cursor(3));
            this.execute();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            this.m_progressDlg.setDoneStatus();
            this.setCursor(new Cursor(0));
        }
    }

    private void execute() throws Exception {
        this.m_wDialog = new DM4JWizardDialog((BaseWizard)this, this.m_parent, new Dimension(700, 500));
        this.m_state.setDM4JWizardDialog(this.m_wDialog);
        this.setMustFinish(true);
        this.m_wDialog.setWizardTitle(ResourceUtilities.getUILabel("CODE_GEN_WIZARD_NAME"));
        this.m_wDialog.setFinishPageIncluded(true);
        this.addWizardListener(this);
        if (this.m_WelcomePage == null) {
            this.m_WelcomePage = this.createWelcomePage();
        }
        this.addPage((WizardPage)this.m_WelcomePage);
        this.m_wDialog.setWelcomeWizardPage(this.m_WelcomePage);
        if (!this.m_state.isDataMiner() && this.m_state.isShowConnectionPage()) {
            this.m_ConnectionPage = new CodeGenConnectionPage(this.m_state, this.m_state.getDataSource(), StepType.DATA_STEP);
            this.addPage((WizardPage)this.m_ConnectionPage);
        }
        this.m_ActivityPage = new CodeGenActivityPage(this.m_state, StepType.SETTING_STEP_1);
        this.addPage((WizardPage)this.m_ActivityPage);
        this.m_TargetPage = new CodeGenTargetPage(this.m_state, StepType.SETTING_STEP_2);
        this.addPage((WizardPage)this.m_TargetPage);
        this.m_ResultsPage = new CodeGenResultsPage(this.m_state, StepType.SETTING_STEP);
        this.addPage((WizardPage)this.m_ResultsPage);
        if (this.m_state.isDataMiner()) {
            this.m_FilePage = new CodeGenTargetFilePage(this.m_state, StepType.SETTING_STEP_3);
            this.addPage((WizardPage)this.m_FilePage);
        }
        String string = null;
        string = this.m_state.isDataMiner() ? "CG_ODMR_FINISH_STEP_DESCRIPTION" : (this.m_state.isJDevOffline() ? "CG_JDEV_OFF_FINISH_STEP_DESCRIPTION" : "CG_JDEV_ON_FINISH_STEP_DESCRIPTION");
        this.m_FinishPage = new CodeGenFinishPage(this.m_state, StepType.FINISH_STEP, string);
        this.addPage((WizardPage)this.m_FinishPage);
    }

    public String getTargetSchema() {
        String string = null;
        if (this.m_TargetPage != null) {
            string = this.m_TargetPage.getTargetSchema();
        }
        return string;
    }

    public String getTargetPackageName() {
        String string = null;
        if (this.m_TargetPage != null) {
            string = this.m_TargetPage.getTargetPackageName();
        }
        return string;
    }

    public Vector getProcedures() {
        Vector vector = new Vector();
        if (this.m_TargetPage != null) {
            vector = this.m_TargetPage.getProcedures();
        }
        return vector;
    }

    public String getFullFileName() {
        return this.m_FilePage.getFullFileName();
    }

    public String getRecordTypeName(String string) {
        String string2 = null;
        if (this.m_TargetPage != null) {
            string2 = this.m_TargetPage.getRecordTypeName(string);
        }
        return string2;
    }

    public String getTableTypeName(String string) {
        String string2 = null;
        if (this.m_TargetPage != null) {
            string2 = this.m_TargetPage.getTableTypeName(string);
        }
        return string2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wizardSelectionChanged(WizardEvent wizardEvent) {
        WizardPage wizardPage = wizardEvent.getPage();
        if (wizardPage == null) {
            return;
        }
        if (!(wizardPage instanceof DM4JPage)) {
            return;
        }
        try {
            this.m_state.getDM4JWizardDialog().setDialogBusy(true);
            DM4JPage dM4JPage = (DM4JPage)wizardPage;
            dM4JPage.prepareForDisplay();
        }
        catch (Exception exception) {
            this.m_state.getDM4JWizardDialog().setDialogBusy(false);
            if (this.m_state.isJDevOffline()) {
                this.selectPage((WizardPage)this.m_ConnectionPage, false);
            } else {
                this.selectPage((WizardPage)this.m_ConnectionPage, false);
            }
        }
        finally {
            this.m_state.getDM4JWizardDialog().setDialogBusy(false);
        }
    }
}

