/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.table;

import java.awt.Component;
import java.awt.event.MouseEvent;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.model.SortableTwoDModel;

public class SortInputHandler
implements HeaderItemInputHandler {
    private SortableTwoDModel _ds;
    private int _item = -1;
    private boolean _inside;
    private boolean[] _order;

    public SortInputHandler(SortableTwoDModel sortableTwoDModel) {
        this._ds = sortableTwoDModel;
        this._order = new boolean[sortableTwoDModel.getColumnCount()];
    }

    public void mousePressed(MouseEvent mouseEvent, Header header, int n) {
        this._inside = true;
        this._item = n;
    }

    public void sort(int n) {
        boolean bl = this._order[n];
        this._ds.sort(n, bl);
        this._order[n] = !bl;
    }

    public void mouseClicked(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseDragged(MouseEvent mouseEvent, Header header, int n) {
    }

    public void mouseReleased(MouseEvent mouseEvent, Header header, int n) {
        if (this._item == -1) {
            return;
        }
        if (this._inside && this._item == n) {
            this.sort(n);
            Component component = mouseEvent.getComponent();
            component.getParent().repaint();
        }
        this._item = -1;
    }

    public void mouseEntered(MouseEvent mouseEvent, Header header, int n) {
        if (n == this._item) {
            this._inside = true;
        }
    }

    public void mouseExited(MouseEvent mouseEvent, Header header, int n) {
        if (n == this._item) {
            this._inside = false;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent, Header header, int n) {
    }
}

