/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.transformsteps.DiscretizeSettingsStateError;

public class WinsorizeHistogramPanel
extends GriddedPanel {
    protected DM4JDialog m_parentDialog;
    protected MultiLineLabel mlblStepDescription = new MultiLineLabel();
    protected JPanel pnlNumberOfBins = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblNumberOfBins = new JLabel();
    protected NumberTextField txtNumberOfBins = new NumberTextField();
    protected JPanel pnlTailPercent = new JPanel(new GridLayout(1, 2, 5, 0));
    protected JLabel lblTailPercent = new JLabel();
    protected NumberTextField txtTailPercent = new NumberTextField();
    private int m_numberofBins;
    private double m_tailPercent;

    public WinsorizeHistogramPanel(DM4JDialog dM4JDialog, int n, double d) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_numberofBins = n;
        this.m_tailPercent = d;
        this.jbInit();
    }

    protected void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("WINSORIZE_BINNING_STRATEGY_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        this.addFilledComponent(this.pnlNumberOfBins, COL1_INDENTED1_LABEL, n++, 0, 1, 1, 1);
        this.lblNumberOfBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.lblNumberOfBins.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.txtNumberOfBins.setLocale(Locale.getDefault());
        this.txtNumberOfBins.setDataType(Integer.TYPE);
        this.txtNumberOfBins.setSigned(false);
        this.txtNumberOfBins.setColumns(10);
        this.lblNumberOfBins.setLabelFor((Component)this.txtNumberOfBins);
        this.pnlNumberOfBins.add(this.lblNumberOfBins);
        this.pnlNumberOfBins.add((Component)this.txtNumberOfBins);
        this.addFilledComponent(this.pnlTailPercent, COL1_INDENTED1_LABEL, n, 0, 1, 1, 1);
        this.lblTailPercent.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_TAIL_PERCENT"));
        this.txtTailPercent.setLocale(Locale.getDefault());
        this.txtTailPercent.setDataType(Double.TYPE);
        this.txtTailPercent.setSigned(false);
        this.txtTailPercent.setColumns(10);
        this.lblTailPercent.setLabelFor((Component)this.txtTailPercent);
        this.pnlTailPercent.add(this.lblTailPercent);
        this.pnlTailPercent.add((Component)this.txtTailPercent);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WinsorizeHistogramPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (vector.isEmpty()) {
                    this.processUserInput();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void loadState() throws Exception {
        this.txtNumberOfBins.setNumber((Number)new Integer(this.m_numberofBins));
        this.txtTailPercent.setNumber((Number)new Double(this.m_tailPercent));
    }

    protected int getCurrentNumberofBins() {
        Integer n = (Integer)this.txtNumberOfBins.getNumber();
        return n == null ? 0 : n;
    }

    protected double getCurrentTailPercent() {
        Double d = (Double)this.txtTailPercent.getNumber();
        return d == null ? 0.0 : d;
    }

    protected void validate(Vector vector) throws Exception {
        int n = this.getCurrentNumberofBins();
        try {
            if (n < 1) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_NUMBER));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_NUMBER));
        }
        double d = this.getCurrentTailPercent();
        try {
            if (d < 0.0 || d >= 100.0) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_TAIL_PERCENTAGE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_TAIL_PERCENTAGE));
        }
    }

    protected void processUserInput() {
        this.m_numberofBins = this.getCurrentNumberofBins();
        this.m_tailPercent = this.getCurrentTailPercent();
    }

    public int getNumberofBins() {
        return this.m_numberofBins;
    }

    public double getTailPercent() {
        return this.m_tailPercent;
    }
}

