/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.StratifiedState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedTargetState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.commonsteps.HistogramDialog;

public class StratifiedTargetPanel
extends DM4JStep {
    StratifiedTargetState m_state;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblTargetColumn = new JLabel();
    JComboBox cmbColumns = new JComboBox();
    JLabel lblFiller = new JLabel();
    JLabel lblTotalNumberOfCases = new JLabel();
    JLabel lblTotalCaseCountValue = new JLabel();
    JPanel pnlSamplingSettings = new JPanel(new GridLayout(2, 2));
    JRadioButton radioNumberOfCases = new JRadioButton(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_NUMBER_OF_CASES"));
    NumberTextField fldNumberOfCasess = new NumberTextField();
    JRadioButton radioPercentageOfCases = new JRadioButton(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES"));
    NumberTextField fldPercentageOfCasess = new NumberTextField();
    JButton btnHistogram = new JButton(ResourceUtilities.getUILabel("STRATIFIED_TARGET_HISTOGRAM"));

    public StratifiedTargetPanel(StratifiedTargetState stratifiedTargetState) throws Exception {
        super(stratifiedTargetState);
        this.m_state = stratifiedTargetState;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("STRATIFIED_TARGET_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(1);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblTargetColumn.setText(ResourceUtilities.getUILabel("STRATIFIED_TARGET_COLUMN"));
        this.lblTargetColumn.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("STRATIFIED_TARGET_COLUMN"));
        this.lblTargetColumn.setLabelFor(this.cmbColumns);
        this.addComponent(this.lblTargetColumn, COL1_LABEL, n, 0);
        this.addFilledComponent(this.cmbColumns, COL_VALUE, n++, 1, 2, 1, 1);
        this.btnHistogram.setMnemonic(ResourceUtilities.getUILabel("STRATIFIED_TARGET_HISTOGRAM").charAt(0));
        this.btnHistogram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StratifiedTargetPanel.this.butHistogram_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.btnHistogram, COL1_CONTROL, n++, 2);
        this.lblTotalNumberOfCases.setText(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_TOTAL_NUMBER_OF_CASES"));
        this.addComponent(this.lblTotalNumberOfCases, COL1_LABEL, n, 0);
        this.addComponent(this.lblTotalCaseCountValue, COL_VALUE, n++, 1);
        this.pnlSamplingSettings.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_BOX_TITLE")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.addFilledComponent(this.pnlSamplingSettings, COL1_LABEL, n++, 0, 4, 1, 1);
        ButtonGroup buttonGroup = new ButtonGroup();
        this.radioNumberOfCases.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_NUMBER_OF_CASES"));
        this.radioPercentageOfCases.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES"));
        this.radioNumberOfCases.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StratifiedTargetPanel.this.samplingMethod_actionPerformed(actionEvent);
            }
        });
        this.radioPercentageOfCases.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StratifiedTargetPanel.this.samplingMethod_actionPerformed(actionEvent);
            }
        });
        buttonGroup.add(this.radioNumberOfCases);
        buttonGroup.add(this.radioPercentageOfCases);
        this.pnlSamplingSettings.add(this.radioNumberOfCases);
        this.fldNumberOfCasess.setLocale(Locale.getDefault());
        this.fldNumberOfCasess.setDataType(Long.TYPE);
        this.fldNumberOfCasess.setSigned(false);
        this.pnlSamplingSettings.add((Component)this.fldNumberOfCasess);
        this.pnlSamplingSettings.add(this.radioPercentageOfCases);
        this.fldPercentageOfCasess.setLocale(Locale.getDefault());
        this.fldPercentageOfCasess.setDataType(Double.TYPE);
        this.fldPercentageOfCasess.setSigned(false);
        this.fldPercentageOfCasess.setDecimal(true, 2);
        this.pnlSamplingSettings.add((Component)this.fldPercentageOfCasess);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 2, 1);
        if (this.m_state.isActivity()) {
            this.cmbColumns.setEnabled(false);
        } else {
            this.cmbColumns.setEnabled(true);
        }
    }

    protected void processUserInput() {
        if (this.m_state != null) {
            this.m_state.setTargetColumnName((String)this.cmbColumns.getSelectedItem());
            this.m_state.setSampleByNumberOfCases(this.radioNumberOfCases.isSelected());
            if (this.radioNumberOfCases.isSelected()) {
                this.m_state.setSampleNumberOfCases((Long)this.fldNumberOfCasess.getNumber());
            } else {
                this.m_state.setSamplePercentageOfCases((Double)this.fldPercentageOfCasess.getNumber());
            }
        }
    }

    public void init() throws Exception {
        this.loadValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    protected void loadValues() throws Exception {
        if (this.m_state == null) {
            return;
        }
        Vector vector = this.m_state.getColumnNames();
        if (vector == null) {
            return;
        }
        Vector vector2 = null;
        if (this.m_state.getLDSDataSource().isSingleMetric()) {
            vector2 = new Vector();
            vector2.add(this.m_state.getLDSDataSource().getData(1, 0));
        }
        this.cmbColumns.setModel(new DefaultComboBoxModel(this.m_state.getLDSDataSource().isSingleMetric() ? vector2 : vector));
        this.cmbColumns.setEditable(false);
        String string = this.m_state.getTargetColumnName();
        if (string != null && string.length() > 0) {
            this.cmbColumns.setSelectedItem(string);
        }
        this.lblTotalCaseCountValue.setText(this.m_state.getDataState().getCaseCountString());
        this.chooseSamplingMethod();
    }

    private void chooseSamplingMethod() {
        if (this.m_state != null) {
            boolean bl = this.m_state.isSampleByNumOfCases();
            this.fldNumberOfCasess.setNumber((Number)this.m_state.getSampleNumberOfCases());
            this.fldPercentageOfCasess.setNumber((Number)this.m_state.getSamplePercentageOfCases());
            this.fldNumberOfCasess.setEnabled(bl);
            this.fldPercentageOfCasess.setEnabled(!bl);
            this.radioNumberOfCases.setSelected(bl);
            this.radioPercentageOfCases.setSelected(!bl);
        }
    }

    protected void samplingMethod_actionPerformed(ActionEvent actionEvent) {
        JRadioButton jRadioButton = (JRadioButton)actionEvent.getSource();
        boolean bl = !jRadioButton.equals(this.radioPercentageOfCases);
        this.m_state.setSampleByNumberOfCases(bl);
        if (!bl) {
            Number number = this.fldNumberOfCasess.getNumber();
            this.m_state.setSampleNumberOfCases(new Long(number.longValue()));
        } else {
            Number number = this.fldPercentageOfCasess.getNumber();
            this.m_state.setSamplePercentageOfCases(new Double(number.doubleValue()));
        }
        this.chooseSamplingMethod();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void butHistogram_actionPerformed(ActionEvent actionEvent) {
        try {
            StratifiedState stratifiedState = (StratifiedState)this.m_state.getparentWizardState();
            HistogramDialog histogramDialog = new HistogramDialog(this.getparentWizardState().getDialog(), this.m_state.getparentWizardState(), this.m_state.getLDSDataSource(), stratifiedState.getGraph(), (String)this.cmbColumns.getSelectedItem());
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
            try {
                this.m_state.getLDSDataSource().abortCleanUp();
            }
            catch (Exception exception2) {}
        }
    }

    private String getColumnName(String string) {
        return this.m_state.getLDSDataSource().getColumnName(string);
    }
}

