/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.GridLayout;
import java.util.Locale;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.AttrValCountsTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.CaseCountDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.StratifiedDefaultsDialog;

public class StratifiedDefaultsPanel
extends GriddedPanel {
    private StratifiedSettingsState m_state;
    private StratifiedDefaultsDialog m_parentDialog;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblTotalNumberOfCases = new JLabel();
    JLabel lblTotalCaseCountValue = new JLabel();
    JPanel pnlSamplingSettings = new JPanel(new GridLayout(2, 2));
    JPanel pnlLowestDistinct = new JPanel(new GridLayout(1, 2));
    JRadioButton radioNumberOfCases = new JRadioButton(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_NUMBER_OF_CASES"));
    NumberTextField fldNumberOfCasess = new NumberTextField();
    JRadioButton radioPercentageOfCases = new JRadioButton(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES"));
    NumberTextField fldPercentageOfCasess = new NumberTextField();
    JRadioButton radioLowestDistinct = new JRadioButton("Lowest distinct count");
    JLabel lblFiller = new JLabel();
    int[] m_selectedRows;

    public StratifiedDefaultsPanel(StratifiedDefaultsDialog stratifiedDefaultsDialog, StratifiedSettingsState stratifiedSettingsState, int[] nArray) throws Exception {
        this.m_state = stratifiedSettingsState;
        this.m_parentDialog = stratifiedDefaultsDialog;
        this.m_selectedRows = nArray;
        this.init();
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblTotalNumberOfCases.setText(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_TOTAL_NUMBER_OF_CASES"));
        this.addComponent(this.lblTotalNumberOfCases, COL1_LABEL, n, 0);
        this.addComponent(this.lblTotalCaseCountValue, COL_VALUE, n++, 1);
        this.pnlSamplingSettings.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_BOX_TITLE")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.addFilledComponent(this.pnlSamplingSettings, COL1_LABEL, n++, 0, 4, 1, 1);
        this.radioNumberOfCases.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_NUMBER_OF_CASES"));
        this.radioPercentageOfCases.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES"));
        this.radioLowestDistinct.setMnemonic(1);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioNumberOfCases);
        buttonGroup.add(this.radioPercentageOfCases);
        buttonGroup.add(this.radioLowestDistinct);
        this.pnlSamplingSettings.add(this.radioNumberOfCases);
        this.fldNumberOfCasess.setLocale(Locale.getDefault());
        this.fldNumberOfCasess.setDataType(Long.TYPE);
        this.fldNumberOfCasess.setSigned(false);
        this.pnlSamplingSettings.add((Component)this.fldNumberOfCasess);
        this.pnlSamplingSettings.add(this.radioPercentageOfCases);
        this.fldPercentageOfCasess.setLocale(Locale.getDefault());
        this.fldPercentageOfCasess.setDataType(Double.TYPE);
        this.fldPercentageOfCasess.setSigned(false);
        this.pnlSamplingSettings.add((Component)this.fldPercentageOfCasess);
        this.pnlLowestDistinct.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder("Lowest Distinct Count"), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.addFilledComponent(this.pnlLowestDistinct, COL1_LABEL, n++, 0, 4, 1, 1);
        this.pnlLowestDistinct.add(this.radioLowestDistinct);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 3, 1);
    }

    public void init() {
        this.loadValues();
    }

    public void reinit() {
        this.init();
    }

    protected void loadValues() {
        if (this.m_state != null) {
            CaseCountDataState caseCountDataState = (CaseCountDataState)this.m_state.getparentWizardState().getStep(StepType.DATA_STEP);
            this.lblTotalCaseCountValue.setText(caseCountDataState.getCaseCountString());
            AttrValCountsTableModel attrValCountsTableModel = this.m_state.getTableModel();
            Long l = (Long)attrValCountsTableModel.getValueAt(this.m_selectedRows[0], 4);
            Double d = new Double(0.0);
            if (this.m_selectedRows != null && this.m_selectedRows.length > 0) {
                for (int i = 1; i < this.m_selectedRows.length; ++i) {
                    Long l2 = (Long)attrValCountsTableModel.getValueAt(this.m_selectedRows[i], 4);
                    if (l.longValue() == l2.longValue()) continue;
                    d = new Double(100.0);
                    l = null;
                    break;
                }
            }
            if (l != null) {
                this.fldNumberOfCasess.setNumber((Number)l);
            }
            this.fldPercentageOfCasess.setNumber((Number)d);
        }
    }
}

