/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.SampleSettingsState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.transformsteps.AdvancedStratifiedSettingsDialog;

public class SampleSettingsPanel
extends DM4JStep {
    SampleSettingsState m_state;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblTotalNumberOfCases = new JLabel();
    JLabel lblTotalCaseCountValue = new JLabel();
    JPanel pnlSamplingSettings = new JPanel(new GridLayout(2, 2));
    JRadioButton radioNumberOfCases = new JRadioButton(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_NUMBER_OF_CASES"));
    NumberTextField fldNumberOfCasess = new NumberTextField();
    JRadioButton radioPercentageOfCases = new JRadioButton(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES"));
    NumberTextField fldPercentageOfCasess = new NumberTextField();
    JButton butAdvStratifSettings = new JButton();
    JLabel lblFiller = new JLabel();

    public SampleSettingsPanel(SampleSettingsState sampleSettingsState) throws Exception {
        super(sampleSettingsState);
        this.m_state = sampleSettingsState;
        this.init();
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblTotalNumberOfCases.setText(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_TOTAL_NUMBER_OF_CASES"));
        this.addComponent(this.lblTotalNumberOfCases, COL1_LABEL, n, 0);
        this.addComponent(this.lblTotalCaseCountValue, COL_VALUE, n++, 1);
        this.pnlSamplingSettings.setBorder(BorderFactory.createCompoundBorder(BorderFactory.createTitledBorder(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_BOX_TITLE")), BorderFactory.createEmptyBorder(5, 5, 5, 5)));
        this.addFilledComponent(this.pnlSamplingSettings, COL1_LABEL, n++, 0, 4, 1, 1);
        this.radioNumberOfCases.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_NUMBER_OF_CASES"));
        this.radioPercentageOfCases.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.radioNumberOfCases);
        buttonGroup.add(this.radioPercentageOfCases);
        this.pnlSamplingSettings.add(this.radioNumberOfCases);
        this.fldNumberOfCasess.setLocale(Locale.getDefault());
        this.fldNumberOfCasess.setDataType(Long.TYPE);
        this.fldNumberOfCasess.setSigned(false);
        this.pnlSamplingSettings.add((Component)this.fldNumberOfCasess);
        this.pnlSamplingSettings.add(this.radioPercentageOfCases);
        this.fldPercentageOfCasess.setLocale(Locale.getDefault());
        this.fldPercentageOfCasess.setDataType(Double.TYPE);
        this.fldPercentageOfCasess.setSigned(false);
        this.pnlSamplingSettings.add((Component)this.fldPercentageOfCasess);
        this.butAdvStratifSettings.setText(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_ADVANCED"));
        this.butAdvStratifSettings.setMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_ADVANCED"));
        this.butAdvStratifSettings.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                SampleSettingsPanel.this.butAdvStratifSettings_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.butAdvStratifSettings, COL1_LABEL, n, 0);
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 3, 1);
    }

    public void focusOnErrorField(Vector vector) {
    }

    public void init() {
        this.loadValues();
    }

    public void reinit() {
        this.init();
    }

    protected void loadValues() {
        if (this.m_state != null) {
            this.lblTotalCaseCountValue.setText(this.m_state.getDataState().getCaseCountString());
            this.fldNumberOfCasess.setNumber((Number)this.m_state.getSampleNumberOfCases());
            this.fldPercentageOfCasess.setNumber((Number)this.m_state.getSamplePercentageOfCases());
            this.radioNumberOfCases.setSelected(this.m_state.isSampleByNumOfCases());
            this.radioPercentageOfCases.setSelected(!this.m_state.isSampleByNumOfCases());
            this.butAdvStratifSettings.setEnabled(true);
        }
    }

    public void clear() {
        this.loadValues();
    }

    protected void processUserInput() {
        try {
            if (this.m_state != null) {
                this.m_state.setSampleByNumberOfCases(this.radioNumberOfCases.isSelected());
                if (this.radioNumberOfCases.isSelected()) {
                    this.m_state.setSampleByNumberOfCases(true);
                    this.m_state.setSampleNumberOfCases((Long)this.fldNumberOfCasess.getNumber());
                } else {
                    this.m_state.setSamplePercentageOfCases((Double)this.fldPercentageOfCasess.getNumber());
                }
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    protected void butAdvStratifSettings_actionPerformed(ActionEvent actionEvent) {
        try {
            Integer n = this.m_state.getRandomSeed();
            AdvancedStratifiedSettingsDialog advancedStratifiedSettingsDialog = new AdvancedStratifiedSettingsDialog(this.getparentWizardState().getDialog(), this.m_state);
            if (advancedStratifiedSettingsDialog.isCancelled()) {
                this.m_state.setRandomSeed(n);
            }
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }
}

