/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.ArrayList;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.RecodeScheme;
import oracle.dmt.dm4j.wizard.state.transformsteps.RecodeState;
import oracle.dmt.dm4j.wizard.steps.transformsteps.RecodeDialog;

public class RecodePanel
extends GriddedPanel {
    private static int DB_LIMIT = 126;
    private static String CHAR_TYPE = "CHAR";
    private static String VARCHAR_TYPE = "VARCHAR";
    private static String VARCHAR2_TYPE = "VARCHAR2";
    private static String NUMBER_TYPE = "NUMBER";
    private static String NULL_TYPE = "NULL";
    RecodeDialog m_parentDialog;
    RecodeState m_state;
    DefaultListModel m_model;
    String m_tgtType = null;
    int m_numRecode = 0;
    JLabel lblRangeValue = new JLabel();
    JLabel lblRecodeValue = new JLabel();
    JRadioButton btnValue = new JRadioButton();
    JRadioButton btnRange = new JRadioButton();
    JRadioButton btnNULL = new JRadioButton();
    JRadioButton btnOthers = new JRadioButton();
    ButtonGroup replaceGroup = new ButtonGroup();
    JComboBox comboOperators = new JComboBox();
    JComboBox comboValues = new JComboBox();
    JComboBox comboMinValues = new JComboBox();
    JComboBox comboMaxValues = new JComboBox();
    JTextField txtRecodeValue = new JTextField();
    JButton btnAdd = new JButton();
    JButton btnDel = new JButton();
    JList listRecodeSchemes = new JList();
    JLabel lblFiller = new JLabel(" ");
    DecimalFormat m_df = new DecimalFormat();

    public RecodePanel(RecodeDialog recodeDialog, RecodeState recodeState) throws Exception {
        this.m_state = recodeState;
        this.m_parentDialog = recodeDialog;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        GriddedPanel griddedPanel = new GriddedPanel();
        griddedPanel.setBorder(BorderFactory.createTitledBorder(ResourceUtilities.getUILabel("RECODE_SCHEME_REPLACE")));
        this.btnValue.setText(ResourceUtilities.getUILabel("RECODE_SCHEME_VALUE"));
        this.btnValue.setMnemonic(ResourceUtilities.getUIMnemonic("RECODE_SCHEME_VALUE"));
        GriddedPanel griddedPanel2 = new GriddedPanel();
        griddedPanel2.addComponent(this.btnValue, new Insets(5, 0, 0, 0), 0, 0);
        griddedPanel2.addComponent(this.comboOperators, COL1_CONTROL, 0, 1);
        griddedPanel2.addFilledComponent(this.comboValues, new Insets(5, 10, 0, 10), 0, 2, 2, 1, 2);
        this.btnValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecodePanel.this.opReplace_actionPerformed(actionEvent);
            }
        });
        griddedPanel.addFilledComponent(griddedPanel2, COL1_CONTROL, n++, 0, 6, 1, 2);
        JComponent[] jComponentArray = new JComponent[]{this.comboOperators};
        RecodePanel.setPreferredSize(jComponentArray, 40, 20);
        this.comboValues.setEditable(true);
        this.btnRange.setText(ResourceUtilities.getUILabel("RECODE_SCHEME_RANGE"));
        this.btnRange.setMnemonic(ResourceUtilities.getUIMnemonic("RECODE_SCHEME_RANGE"));
        griddedPanel.addComponent(this.btnRange, COL1_CONTROL, n++, 0);
        GriddedPanel griddedPanel3 = new GriddedPanel();
        griddedPanel3.addFilledComponent(this.comboMinValues, COL1_CONTROL, 0, 0, 2, 1, 2);
        this.lblRangeValue.setText("<= " + ResourceUtilities.getUILabel("RECODE_SCHEME_VALUE") + " <");
        griddedPanel3.addComponent(this.lblRangeValue, COL1_CONTROL, 0, 2);
        griddedPanel3.addFilledComponent(this.comboMaxValues, new Insets(5, 10, 0, 10), 0, 3, 2, 1, 2);
        this.btnRange.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecodePanel.this.opReplace_actionPerformed(actionEvent);
            }
        });
        griddedPanel.addFilledComponent(griddedPanel3, COL1_CONTROL, n++, 0, 6, 1, 2);
        this.comboMinValues.setEditable(true);
        this.comboMaxValues.setEditable(true);
        this.btnNULL.setText(ResourceUtilities.getUILabel("RECODE_SCHEME_NULL"));
        this.btnNULL.setMnemonic(ResourceUtilities.getUIMnemonic("RECODE_SCHEME_NULL"));
        this.btnNULL.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecodePanel.this.opReplace_actionPerformed(actionEvent);
            }
        });
        griddedPanel.addComponent(this.btnNULL, COL1_CONTROL, n++, 0);
        this.btnOthers.setText(ResourceUtilities.getUILabel("RECODE_SCHEME_OTHERS"));
        this.btnOthers.setMnemonic(ResourceUtilities.getUIMnemonic("RECODE_SCHEME_OTHERS"));
        this.btnOthers.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecodePanel.this.opReplace_actionPerformed(actionEvent);
            }
        });
        griddedPanel.addComponent(this.btnOthers, COL1_CONTROL, n++, 0);
        this.replaceGroup.add(this.btnValue);
        this.replaceGroup.add(this.btnRange);
        this.replaceGroup.add(this.btnNULL);
        this.replaceGroup.add(this.btnOthers);
        this.btnValue.setSelected(true);
        this.enableButtons();
        n = 0;
        GriddedPanel griddedPanel4 = new GriddedPanel();
        griddedPanel4.setBorder(BorderFactory.createTitledBorder(ResourceUtilities.getUILabel("RECODE_SCHEME_WITH")));
        this.lblRecodeValue.setText(ResourceUtilities.getUILabel("RECODE_SCHEME_VALUE"));
        this.lblRecodeValue.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("RECODE_SCHEME_VALUE2"));
        this.lblRecodeValue.setLabelFor(this.txtRecodeValue);
        this.txtRecodeValue.getDocument().addDocumentListener(new RecodeDocListener());
        griddedPanel4.addComponent(this.lblRecodeValue, COL1_LABEL, n, 0);
        griddedPanel4.addFilledComponent(this.txtRecodeValue, new Insets(5, 12, 0, 10), n++, 1, 5, 1, 2);
        griddedPanel4.addFilledComponent(this.lblFiller, COL_VALUE, n++, 0, 6, 1, 2);
        this.btnAdd.setText(ResourceUtilities.getUILabel("RECODE_SCHEME_ADD"));
        this.btnAdd.setMnemonic(ResourceUtilities.getUIMnemonic("RECODE_SCHEME_ADD"));
        this.btnAdd.setActionCommand("Add");
        this.btnDel.setText(ResourceUtilities.getUILabel("RECODE_SCHEME_DEL"));
        this.btnDel.setMnemonic(ResourceUtilities.getUIMnemonic("RECODE_SCHEME_DEL"));
        this.btnDel.setActionCommand("Del");
        this.btnDel.setEnabled(false);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecodePanel.this.opWith_actionPerformed(actionEvent);
            }
        });
        this.btnDel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecodePanel.this.opWith_actionPerformed(actionEvent);
            }
        });
        this.listRecodeSchemes.setSelectionMode(2);
        this.listRecodeSchemes.setVisibleRowCount(5);
        this.listRecodeSchemes.addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                RecodePanel.this.lstScheme_valueChanged(listSelectionEvent);
            }
        });
        JScrollPane jScrollPane = new JScrollPane(this.listRecodeSchemes);
        JComponent[] jComponentArray2 = new JComponent[]{this.txtRecodeValue};
        RecodePanel.setPreferredSize(jComponentArray2, 260, 20);
        this.addFilledComponent(griddedPanel, new Insets(10, 0, 0, 0), 0, 0, 6, 5, 2);
        this.addFilledComponent(griddedPanel4, new Insets(5, 0, 0, 0), 5, 0, 6, 1, 2);
        this.addFilledComponent(this.lblFiller, new Insets(5, 0, 0, 0), 6, 0, 4, 1, 2);
        this.addComponent(this.btnAdd, COL1_CONTROL, 6, 4, 1, 1, 13, 0);
        this.addComponent(this.btnDel, COL1_CONTROL, 6, 5, 1, 1, 13, 0);
        this.addFilledComponent(jScrollPane, new Insets(5, 0, 0, 0), 7, 0, 6, 3, 1);
        this.addOKHelpCancelListeners();
        this.loadDefaultValues();
    }

    protected void loadDefaultValues() throws Exception {
        Object object;
        if (this.m_state != null) {
            this.comboOperators.addItem("=");
            this.comboOperators.addItem(">=");
            this.comboOperators.addItem("<=");
            object = null;
            ArrayList arrayList = this.m_state.getAttrValues();
            for (int i = 0; i < arrayList.size(); ++i) {
                object = this.m_state.getType().compareTo(NUMBER_TYPE) == 0 ? this.m_df.format(((Float)arrayList.get(i)).floatValue()) : (String)arrayList.get(i);
                this.comboValues.addItem(object);
                this.comboMinValues.addItem(object);
                this.comboMaxValues.addItem(object);
            }
        }
        this.m_model = new DefaultListModel();
        object = this.m_state.getSchemes();
        for (int i = 0; i < ((ArrayList)object).size(); ++i) {
            RecodeScheme recodeScheme = (RecodeScheme)((ArrayList)object).get(i);
            this.m_model.addElement(recodeScheme);
            this.m_tgtType = this.getValueType(recodeScheme.getRecodeValue());
        }
        this.listRecodeSchemes.setModel(this.m_model);
    }

    protected void processUserInput() {
        if (this.m_state != null) {
            // empty if block
        }
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                RecodePanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.processUserInput();
                this.m_state.validate(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                this.m_state.setSave(true);
            }
            catch (Exception exception) {}
        } else if ("cancel" == string) {
            this.m_state.setSave(false);
        }
    }

    private void enableButtons() {
        this.comboOperators.setEnabled(this.btnValue.isSelected());
        this.comboValues.setEnabled(this.btnValue.isSelected());
        this.comboMinValues.setEnabled(this.btnRange.isSelected());
        this.comboMaxValues.setEnabled(this.btnRange.isSelected());
        String string = this.txtRecodeValue.getText();
        this.btnAdd.setEnabled(this.txtRecodeValue.getText().length() > 0 && this.m_numRecode < DB_LIMIT);
        int[] nArray = this.listRecodeSchemes.getSelectedIndices();
        this.btnDel.setEnabled(nArray != null && nArray.length > 0);
    }

    private void opReplace_actionPerformed(ActionEvent actionEvent) {
        this.enableButtons();
    }

    private String quotedSrcValue(String string) {
        string.trim();
        String string2 = this.m_state.getType();
        if (string2.equals(VARCHAR2_TYPE) || string2.equals(VARCHAR_TYPE) || string2.equals(CHAR_TYPE)) {
            return "'" + string + "'";
        }
        return string;
    }

    private String getValueType(String string) {
        try {
            string.trim();
            if (string.equalsIgnoreCase(NULL_TYPE)) {
                return this.m_tgtType == null ? this.m_state.getType() : this.m_tgtType;
            }
            if (string.startsWith("'") && string.endsWith("'")) {
                return CHAR_TYPE;
            }
            if (string.startsWith("\"") && string.endsWith("\"")) {
                return VARCHAR2_TYPE;
            }
            ParsePosition parsePosition = new ParsePosition(0);
            Number number = this.m_df.parse(string, parsePosition);
            int n = parsePosition.getIndex();
            if (number != null && n == string.length()) {
                return NUMBER_TYPE;
            }
            return VARCHAR2_TYPE;
        }
        catch (NumberFormatException numberFormatException) {
            return VARCHAR2_TYPE;
        }
    }

    private String quotedTgtValue(String string) {
        try {
            string.trim();
            if (string.equalsIgnoreCase(NULL_TYPE)) {
                return string;
            }
            if (string.startsWith("'") && string.endsWith("'")) {
                return string;
            }
            if (string.startsWith("\"") && string.endsWith("\"")) {
                return string.replace('\"', '\'');
            }
            Number number = this.m_df.parse(string);
            if (number != null) {
                return string;
            }
            return "'" + string + "'";
        }
        catch (ParseException parseException) {
            return "'" + string + "'";
        }
    }

    private boolean isSchemeTypeFound(int n) {
        int n2 = this.m_model.size();
        for (int i = 0; i < n2; ++i) {
            RecodeScheme recodeScheme = (RecodeScheme)this.m_model.getElementAt(i);
            if (n != recodeScheme.getType()) continue;
            return true;
        }
        return false;
    }

    private void addToSchemeList(RecodeScheme recodeScheme) {
        int n = this.m_model.size();
        int n2 = 0;
        boolean bl = false;
        for (n2 = 0; n2 < n; ++n2) {
            int n3 = 0;
            int n4 = 999;
            RecodeScheme recodeScheme2 = (RecodeScheme)this.m_model.getElementAt(n2);
            n3 = recodeScheme2.getType();
            if (n2 < n - 1) {
                RecodeScheme recodeScheme3 = (RecodeScheme)this.m_model.getElementAt(n2 + 1);
                n4 = recodeScheme3.getType();
            }
            if (recodeScheme.getType() + 1 <= n3 || recodeScheme.getType() + 1 > n4) continue;
            bl = true;
            break;
        }
        if (n > 0) {
            if (bl) {
                this.m_model.add(n2 + 1, recodeScheme);
            } else {
                this.m_model.add(0, recodeScheme);
            }
        } else {
            this.m_model.addElement(recodeScheme);
        }
    }

    private void opWith_actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("Add")) {
            String string;
            String string2 = this.txtRecodeValue.getText();
            String string3 = this.getValueType(string2);
            if (this.m_state.getValueNameMapping() != null && string3.indexOf(this.m_state.getType()) == -1) {
                String string4 = MessageFormat.format(ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_INCOMP_TARGET_DATATYPE"), this.m_state.getType());
                JOptionPane.showMessageDialog(this, string4, ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                return;
            }
            if (this.m_tgtType != null && !string3.equals(this.m_tgtType)) {
                JOptionPane.showMessageDialog(this, ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_DIFF_TARGET_DATATYPE"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                return;
            }
            String string5 = string = this.quotedTgtValue(string2);
            if (string3.compareTo(NUMBER_TYPE) == 0) {
                try {
                    string5 = this.m_df.parse(string2).floatValue() + "";
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            RecodeScheme recodeScheme = null;
            if (this.btnValue.isSelected()) {
                String string6;
                string2 = (String)this.comboValues.getSelectedItem();
                if (string2 == null || string2.length() == 0) {
                    JOptionPane.showMessageDialog(this, ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_EMPTY_SINGLE_SOURCE_VALUE"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                    return;
                }
                String string7 = string6 = this.quotedSrcValue(string2);
                String string8 = this.getValueType(string2);
                if (string8.compareTo(NUMBER_TYPE) == 0) {
                    try {
                        string7 = this.m_df.parse(string2).floatValue() + "";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string8.compareTo(NUMBER_TYPE) != 0 && string8.indexOf(this.m_state.getType()) == -1) {
                    String string9 = MessageFormat.format(ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_INCOMP_SINGLE_DATATYPE"), this.m_state.getType());
                    JOptionPane.showMessageDialog(this, string9, ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                    return;
                }
                if (((String)this.comboOperators.getSelectedItem()).equals("=")) {
                    recodeScheme = new RecodeScheme(3, string6, string7, null, null, string, string5, string3);
                    if (this.m_state.alreadyInList(recodeScheme)) {
                        JOptionPane.showMessageDialog(this, ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_OPTION_ALREADY_DEFINED"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                        recodeScheme = null;
                        return;
                    }
                } else if (((String)this.comboOperators.getSelectedItem()).equals(">=")) {
                    if (this.isSchemeTypeFound(2)) {
                        JOptionPane.showMessageDialog(this, ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_ONLY_ONE_INSTANCE"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                        return;
                    }
                    recodeScheme = new RecodeScheme(2, string6, string7, null, null, string, string5, string3);
                } else if (((String)this.comboOperators.getSelectedItem()).equals("<=")) {
                    if (this.isSchemeTypeFound(1)) {
                        JOptionPane.showMessageDialog(this, ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_ONLY_ONE_INSTANCE"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                        return;
                    }
                    recodeScheme = new RecodeScheme(1, string6, string7, null, null, string, string5, string3);
                }
            } else if (this.btnRange.isSelected()) {
                String string10;
                String string11;
                String string12 = (String)this.comboMinValues.getSelectedItem();
                if (string12 == null || string12.length() == 0) {
                    JOptionPane.showMessageDialog(this, ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_EMPTY_LBOUND_SOURCE_VALUE"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                    return;
                }
                String string13 = string11 = this.quotedSrcValue(string12);
                String string14 = this.getValueType(string12);
                if (string14.compareTo(NUMBER_TYPE) == 0) {
                    try {
                        string13 = this.m_df.parse(string12).floatValue() + "";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string14.compareTo(NUMBER_TYPE) != 0 && string14.indexOf(this.m_state.getType()) == -1) {
                    String string15 = MessageFormat.format(ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_INCOMP_LBOUND_DATATYPE"), this.m_state.getType());
                    JOptionPane.showMessageDialog(this, string15, ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                    return;
                }
                String string16 = (String)this.comboMaxValues.getSelectedItem();
                if (string16 == null || string16.length() == 0) {
                    JOptionPane.showMessageDialog(this, ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_EMPTY_UBOUND_SOURCE_VALUE"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                    return;
                }
                String string17 = string10 = this.quotedSrcValue(string16);
                String string18 = this.getValueType(string16);
                if (string18.compareTo(NUMBER_TYPE) == 0) {
                    try {
                        string17 = this.m_df.parse(string16).floatValue() + "";
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (string18.compareTo(NUMBER_TYPE) != 0 && string18.indexOf(this.m_state.getType()) == -1) {
                    String string19 = MessageFormat.format(ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_INCOMP_UBOUND_DATATYPE"), this.m_state.getType());
                    JOptionPane.showMessageDialog(this, string19, ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                    return;
                }
                recodeScheme = new RecodeScheme(4, string11, string13, string10, string17, string, string5, string3);
                if (this.m_state.alreadyInList(recodeScheme)) {
                    JOptionPane.showMessageDialog(this, ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_OPTION_ALREADY_DEFINED"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                    recodeScheme = null;
                    return;
                }
            } else if (this.btnNULL.isSelected()) {
                if (this.isSchemeTypeFound(0)) {
                    JOptionPane.showMessageDialog(this, ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_ONLY_ONE_INSTANCE"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                    return;
                }
                recodeScheme = new RecodeScheme(0, null, null, null, null, string, string5, string3);
            } else if (this.btnOthers.isSelected()) {
                if (this.m_model.isEmpty()) {
                    JOptionPane.showMessageDialog(this, ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_NEED_OTHER_OPTIONS"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                    return;
                }
                if (this.isSchemeTypeFound(5)) {
                    JOptionPane.showMessageDialog(this, ResourceUtilities.getstateExceptionMessage("RECODE_SCHEME_ONLY_ONE_INSTANCE"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), 0);
                    return;
                }
                recodeScheme = new RecodeScheme(5, null, null, null, null, string, string5, string3);
            }
            if (recodeScheme != null) {
                this.m_state.addScheme(recodeScheme);
                this.addToSchemeList(recodeScheme);
                this.txtRecodeValue.requestFocus();
                this.txtRecodeValue.setText("");
                ++this.m_numRecode;
                if (this.m_tgtType == null) {
                    this.m_tgtType = string3;
                }
            }
        } else if (actionEvent.getActionCommand().equals("Del")) {
            Object[] objectArray = this.listRecodeSchemes.getSelectedValues();
            for (int i = 0; i < objectArray.length; ++i) {
                this.m_model.removeElement(objectArray[i]);
                this.m_state.deleteScheme((RecodeScheme)objectArray[i]);
                --this.m_numRecode;
            }
            if (this.m_model.isEmpty()) {
                this.m_tgtType = null;
            }
        }
        this.enableButtons();
    }

    private void lstScheme_valueChanged(ListSelectionEvent listSelectionEvent) {
        this.enableButtons();
    }

    private class RecodeDocListener
    implements DocumentListener {
        private RecodeDocListener() {
        }

        public void insertUpdate(DocumentEvent documentEvent) {
            RecodePanel.this.enableButtons();
        }

        public void removeUpdate(DocumentEvent documentEvent) {
            RecodePanel.this.enableButtons();
        }

        public void changedUpdate(DocumentEvent documentEvent) {
        }
    }
}

