/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.text.MessageFormat;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JOptionPane;
import oracle.bali.ewt.table.SpreadTable;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.DiscretizeQtileArray;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.steps.transformsteps.EqualBinningSettingsPanel;
import oracle.dmt.odm.binning.BackupData;
import oracle.dmt.odm.binning.BinningType;

public class QtileBinningSettingsPanel
extends EqualBinningSettingsPanel {
    public QtileBinningSettingsPanel(DM4JDialog dM4JDialog, WizardState wizardState, SpreadTable spreadTable) throws Exception {
        super(dM4JDialog, wizardState, spreadTable);
    }

    protected void jbInit() throws Exception {
        super.jbInit();
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("QUANTILE_BINNING_STRATEGY_DIALOG_DESCRIPTION"));
        this.lblNumberOfBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.lblNumberOfBins.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
    }

    protected void processUserInput() {
        int n;
        Object object;
        Object object2;
        int n2 = this.m_settingsState.getCurrentNumberOfBins();
        this.m_backupData.clear();
        Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
        for (int i = 0; i < this.m_range.length; ++i) {
            int n3 = this.m_range[i].getLowerLimit();
            int n4 = this.m_range[i].getUpperLimit();
            for (int j = n3; j <= n4; ++j) {
                object2 = new BackupData(this.m_dataSourcemodel, j);
                this.m_dataSourcemodel.setNumberOfBins(j, n2);
                String string = this.m_dataSourcemodel.getAttributeName(j);
                hashtable.put(string, new Integer(j));
                this.m_dataSourcemodel.markAttributeBinned(j, BinningType.QTILE, n2);
                this.m_dataSourcemodel.setTailPercent(j, 0.0);
                this.m_backupData.put(new Integer(j), object2);
            }
        }
        this.getQtileWidthBounds(hashtable, n2);
        Vector<Object> vector = new Vector<Object>();
        Enumeration enumeration = hashtable.keys();
        Hashtable<String, Integer> hashtable2 = new Hashtable<String, Integer>();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            object2 = (Integer)hashtable.get(string);
            int n5 = (Integer)object2;
            object = this.m_dataSourcemodel.getBinBounds(n5);
            int n6 = n = object != null ? ((Vector)object).size() : 0;
            if (n != 0) {
                if (n == n2) continue;
                hashtable2.put(string, new Integer(n));
                this.m_dataSourcemodel.setNumberOfBins(n5, n);
                this.m_dataSourcemodel.markAttributeBinned(n5, BinningType.QTILE, n);
                continue;
            }
            vector.add(object2);
            this.m_dataSourcemodel.setViewDefinition(n5, null);
            this.m_dataSourcemodel.setBinTypeNONE(n5);
            this.m_dataSourcemodel.setNumberOfBins(n5, 0);
            this.m_dataSourcemodel.setBinBounds(n5, null);
        }
        int n7 = hashtable2.size();
        if (n7 != 0) {
            object2 = null;
            if (n7 <= 5) {
                StringBuffer stringBuffer = new StringBuffer();
                enumeration = hashtable2.keys();
                while (enumeration.hasMoreElements()) {
                    object = (String)enumeration.nextElement();
                    stringBuffer.append("\"" + (String)object + "\": " + hashtable2.get(object).toString());
                    stringBuffer.append("\n");
                }
                object2 = vector.isEmpty() ? MessageFormat.format(ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_WARNING"), stringBuffer.toString()) : MessageFormat.format(ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_WARNING_UNBINNED"), stringBuffer.toString());
            } else {
                object2 = vector.isEmpty() ? ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_WARNING_DETAILS") : ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_WARNING_DETAILS_UNBINNED");
            }
            JOptionPane.showMessageDialog(null, object2, ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 1);
        } else {
            int n8 = vector.size();
            if (n8 > 0) {
                String string = null;
                if (n8 <= 5) {
                    object = new StringBuffer();
                    for (n = 0; n < vector.size(); ++n) {
                        Integer n9 = (Integer)vector.elementAt(n);
                        ((StringBuffer)object).append("\"" + this.m_dataSourcemodel.getAttributeName(n9) + "\"\n");
                    }
                    string = MessageFormat.format(ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_UNBINNED_DETAILS"), ((StringBuffer)object).toString());
                } else {
                    string = ResourceUtilities.getUILabel("QTILE_BINNING_STRATEGY_DIALOG_UNBINNED_LIST");
                }
                JOptionPane.showMessageDialog(null, string, ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 1);
            }
        }
        this.m_settingsState.invalidate();
    }

    protected boolean isSameTypeBinning(int n) {
        return this.m_dataSourcemodel.isQtileBinning(n);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getQtileWidthBounds(Hashtable hashtable, int n) {
        try {
            DiscretizeQtileArray discretizeQtileArray = new DiscretizeQtileArray(this.m_dataSourcemodel, hashtable, n);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeQtileArray, true);
            discretizeQtileArray.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
            if (discretizeQtileArray.getException() != null) {
                this.restoreAttrubuteValues(hashtable);
            } else if (progressBar.hasUserCancelled()) {
                this.restoreAttrubuteValues(hashtable);
            }
        }
        catch (Exception exception) {}
    }
}

