/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.Collator;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.dbUI.columnPropertyEditor.ColumnWrapper;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.Database;
import oracle.bali.dbUI.db.Schema;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.impl.ColumnImpl;
import oracle.bali.dbUI.resultsTable.ModelFactory;
import oracle.bali.dbUI.resultsTable.ResultsTable;
import oracle.bali.dbUI.resultsTable.ResultsTableCustomizer;
import oracle.bali.dbUI.util.jdbc.JDBCDatabase;
import oracle.bali.dbUI.util.jdbc.JDBCSchema;
import oracle.bali.dbUI.util.jdbc.JDBCTable;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.querybuilder.DM4JJDBCModelFactory;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class PreviewPanel
extends GriddedPanel {
    private static int WIDTH = 450;
    private static int HEIGHT = 400;
    DM4JDialog m_parentDialog;
    WizardState m_state = null;
    Connection m_conn = null;
    boolean m_isSQL = true;
    String m_previewSrc = null;
    String m_tmpViewName = null;
    String m_schemaName = null;
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JScrollPane scrollSQLGenerated = new JScrollPane();
    JLabel lblFiller = new JLabel();
    JTextArea textArea = null;
    ResultsTable result = null;

    public PreviewPanel(DM4JDialog dM4JDialog, WizardState wizardState, boolean bl, String string) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = wizardState;
        this.m_conn = wizardState.getConnection();
        this.m_isSQL = bl;
        this.m_previewSrc = string;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("SHOW_PREVIEW_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 3, 1, 1);
        if (this.m_isSQL) {
            DataState dataState = (DataState)this.m_state.getStep(StepType.DATA_STEP);
            this.m_schemaName = this.m_conn.getMetaData().getUserName();
            this.createTempView();
            JDBCDatabase jDBCDatabase = new JDBCDatabase(this.m_conn);
            JDBCSchema jDBCSchema = new JDBCSchema(this.m_conn, (Database)jDBCDatabase, this.m_schemaName);
            JDBCTable jDBCTable = new JDBCTable(this.m_conn, (Schema)jDBCSchema, this.m_tmpViewName);
            int n2 = jDBCTable.getColumnCount();
            Column[] columnArray = new Column[n2];
            for (int i = 0; i < n2; ++i) {
                columnArray[i] = jDBCTable.getColumn(i);
            }
            String string = "SELECT * FROM \"" + this.m_schemaName + "\".\"" + this.m_tmpViewName + "\"";
            ColumnWrapper[] columnWrapperArray = ColumnWrapper.getColumnWrappers((Column[])columnArray);
            this.result = new ResultsTable((ModelFactory)new DM4JJDBCModelFactory(this.m_conn), columnWrapperArray);
            this.result.setCustomizer((ResultsTableCustomizer)new Customizer());
            this.result.updateResults();
            this.addFilledComponent((JComponent)this.result, COL_VALUE, n++, 0, 4, 2, 1);
        } else {
            this.textArea = new JTextArea(this.m_previewSrc);
            this.textArea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(this.textArea);
            jScrollPane.setVerticalScrollBarPolicy(20);
            jScrollPane.setHorizontalScrollBarPolicy(30);
            this.addFilledComponent(jScrollPane, COL_VALUE, n++, 0, 4, 2, 1);
        }
        this.addOKHelpCancelListeners();
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                if (PreviewPanel.this.m_isSQL) {
                    PreviewPanel.this.dropTempView();
                }
            }
        });
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if ("ok" == actionEvent.getActionCommand() && PreviewPanel.this.m_isSQL) {
                    PreviewPanel.this.dropTempView();
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createTempView() {
        try {
            this.m_tmpViewName = ValidationUtil.createUniqueTableName("DM4J$T", this.m_conn, "");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        Statement statement = null;
        try {
            String string = "CREATE VIEW \"" + this.m_schemaName + "\".\"" + this.m_tmpViewName + "\" AS " + this.m_previewSrc;
            statement = this.m_conn.createStatement();
            statement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            sQLException.getLocalizedMessage();
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dropTempView() {
        Statement statement = null;
        try {
            String string = "DROP VIEW \"" + this.m_schemaName + "\".\"" + this.m_tmpViewName + "\"";
            statement = this.m_conn.createStatement();
            statement.executeQuery(string);
        }
        catch (SQLException sQLException) {
            sQLException.getLocalizedMessage();
        }
        finally {
            try {
                statement.close();
            }
            catch (SQLException sQLException) {}
        }
    }

    class Customizer
    extends ResultsTableCustomizer {
        public Comparator getComparator(Column column) {
            if (column.getDataType() == Long.class || column.getDataType() == Float.class || column.getDataType() == Double.class) {
                return NumberComparator.getComparator();
            }
            if (column.getDataType() == String.class || column.getDataType() == Character.class) {
                return new StringComparator(Collator.getInstance());
            }
            return super.getComparator(column);
        }

        public Painter getPainter(Column column) {
            DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance(true, 10));
            if (column.getDataType() == Long.class || column.getDataType() == Float.class || column.getDataType() == Double.class) {
                return dM4JTruncatingNumberFormatPainter;
            }
            return super.getPainter(column);
        }
    }

    class JDBCTable2
    extends JDBCTable {
        private final Object _RESULTS_OBJECT;

        public JDBCTable2(Connection connection, Schema schema, String string) {
            super(connection, schema, string);
            this._RESULTS_OBJECT = new Object();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Column[] createColumns() {
            Object[] objectArray = null;
            Statement statement = null;
            ResultSet resultSet = null;
            try {
                statement = this.getConnection().createStatement();
                StringBuffer stringBuffer = new StringBuffer(1000);
                stringBuffer.append("SELECT * FROM \"" + this.getSchema() + "\".\"" + this.getName() + "\"");
                stringBuffer.append(" WHERE 1 != 1");
                resultSet = statement.executeQuery(stringBuffer.toString());
                ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
                Vector<ColumnImpl> vector = new Vector<ColumnImpl>();
                int n = 0;
                Object var16_11 = null;
                Object object = this._RESULTS_OBJECT;
                synchronized (object) {
                    for (int i = 1; i <= resultSetMetaData.getColumnCount(); ++i) {
                        String string;
                        String string2 = string = resultSetMetaData.getColumnName(i);
                        n = resultSetMetaData.getColumnType(i);
                        int n2 = resultSetMetaData.getScale(i);
                        int n3 = resultSetMetaData.getPrecision(i);
                        Class clazz = this._getClass(n, n2);
                        int n4 = resultSetMetaData.isNullable(i);
                        boolean bl = n4 == 1;
                        ColumnImpl columnImpl = new ColumnImpl(string, string2, clazz, bl, var16_11, (Table)this);
                        vector.addElement(columnImpl);
                    }
                }
                objectArray = new Column[vector.size()];
                if (vector.size() != 0) {
                    vector.copyInto(objectArray);
                }
            }
            catch (SQLException sQLException) {
                System.err.println("A SQLException occured " + sQLException);
            }
            finally {
                try {
                    resultSet.close();
                    statement.close();
                }
                catch (SQLException sQLException) {}
            }
            return objectArray;
        }

        private Class _getClass(int n, int n2) {
            Class clazz;
            switch (n) {
                case -6: 
                case -5: 
                case 4: 
                case 5: {
                    clazz = Long.class;
                    break;
                }
                case -4: 
                case -3: 
                case -2: 
                case 1111: {
                    clazz = Object.class;
                    break;
                }
                case -7: {
                    clazz = Boolean.class;
                    break;
                }
                case 91: {
                    clazz = Date.class;
                    break;
                }
                case 92: {
                    clazz = Time.class;
                    break;
                }
                case 93: {
                    clazz = Timestamp.class;
                    break;
                }
                case 2: 
                case 3: 
                case 7: 
                case 8: {
                    if (n2 == 0) {
                        clazz = Long.class;
                        break;
                    }
                    clazz = Double.class;
                    break;
                }
                case 6: {
                    clazz = Float.class;
                    break;
                }
                case 1: {
                    clazz = Character.class;
                    break;
                }
                case -1: 
                case 12: {
                    clazz = String.class;
                    break;
                }
                default: {
                    clazz = null;
                }
            }
            return clazz;
        }
    }
}

