/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.border.CompoundBorder;
import javax.swing.border.TitledBorder;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.OutlierDiscretizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierDataUsageState;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.OutlierSigmaSettingsPanel;
import oracle.dmt.dm4j.wizard.uicontrols.CustomNumberTextField;

public class OutlierValueSettingsPanel
extends OutlierSigmaSettingsPanel {
    protected JLabel lblLowerValue;
    protected CustomNumberTextField txtLowerValue;
    protected JLabel lblUpperValue;
    protected CustomNumberTextField txtUpperValue;

    public OutlierValueSettingsPanel(DM4JDialog dM4JDialog, OutlierSettingsState outlierSettingsState, SpreadTable spreadTable) throws Exception {
        super(dM4JDialog, outlierSettingsState, spreadTable);
    }

    protected String getStepDescription() {
        return ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE_DIALOG_DESCRIPTION");
    }

    private void createTopPanel() {
        this.m_TopPanel = new GriddedPanel();
        this.m_TopPanel.setBorder(new CompoundBorder(new TitledBorder(null, ResourceUtilities.getUILabel("OUTLIER_STRATEGY_CUSTOM_CUTOFF_POINTS"), 1, 2), this.border5));
        int n = 0;
        this.lblLowerValue = new JLabel();
        this.txtLowerValue = new CustomNumberTextField(this, LOWER_TAIL_VALUE);
        this.lblLowerValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE_LOWER_TAIL"));
        this.lblLowerValue.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_VALUE_LOWER_TAIL"));
        this.txtLowerValue.setColumns(TEXT_FIELD_WIDTH);
        this.txtLowerValue.setDataType(Double.TYPE);
        this.lblLowerValue.setLabelFor((Component)((Object)this.txtLowerValue));
        this.m_TopPanel.addComponent(this.lblLowerValue, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent((JComponent)((Object)this.txtLowerValue), TEXT_OFFSET, n++, 2, 2, 1, 1);
        this.lblUpperValue = new JLabel();
        this.txtUpperValue = new CustomNumberTextField(this, UPPER_TAIL_VALUE);
        this.lblUpperValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE_UPPER_TAIL"));
        this.lblUpperValue.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_VALUE_UPPER_TAIL"));
        this.txtUpperValue.setColumns(TEXT_FIELD_WIDTH);
        this.txtUpperValue.setDataType(Double.TYPE);
        this.lblUpperValue.setLabelFor((Component)((Object)this.txtUpperValue));
        this.m_TopPanel.addComponent(this.lblUpperValue, COL1_INDENTED2_CONTROL, n, 0, 2, 1, 12, 1);
        this.m_TopPanel.addFilledComponent((JComponent)((Object)this.txtUpperValue), TEXT_OFFSET, n++, 2, 2, 1, 1);
    }

    protected void validate(Vector vector) throws Exception {
        this.m_state.setValueValidation();
        this.m_state.validate(vector);
    }

    protected void jbInit() throws Exception {
        boolean bl = false;
        this.m_mlblStepDescription.setText(this.getStepDescription());
        this.m_mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_mlblStepDescription.setPreferredRows(3);
        this.m_mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent((JComponent)this.m_mlblStepDescription, TOP_DESC, 0, 0, 4, 1, 1);
        this.createTopPanel();
        this.addFilledComponent(this.m_TopPanel, COL1_LABEL, 1, 0, 2, 3, 1);
        this.createBottomPanel();
        this.addFilledComponent(this.m_BottomPanel, COL1_LABEL, 5, 0, 2, 2, 1);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 8, 0, 5, 1, 1);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void processUserInput() {
        this.doValueTreatment((Double)this.txtLowerValue.getNumber(), (Double)this.txtUpperValue.getNumber());
    }

    protected void loadState() throws Exception {
        OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)this.m_state.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
        OutlierDiscretizeDataSource outlierDiscretizeDataSource = outlierDataUsageState.getNumericModel();
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        Range[] rangeArray = oneDSelection.getRanges();
        Boolean bl = null;
        boolean bl2 = true;
        boolean bl3 = true;
        boolean bl4 = true;
        Double d = null;
        Double d2 = null;
        block0: for (int i = 0; i < rangeArray.length; ++i) {
            int n = rangeArray[i].getLowerLimit();
            int n2 = rangeArray[i].getUpperLimit();
            for (int j = n; j <= n2; ++j) {
                OutlierDiscretizeDataSource.OutlierCutoffRange outlierCutoffRange = outlierDiscretizeDataSource.getCutoffRange(j);
                if (outlierCutoffRange == null || !outlierCutoffRange.isValueTreatment()) {
                    bl4 = false;
                    bl2 = false;
                    bl3 = false;
                    continue block0;
                }
                if (d == null && d2 == null && bl == null) {
                    d = outlierCutoffRange.getLowerValue();
                    d2 = outlierCutoffRange.getUpperValue();
                    bl = new Boolean(outlierCutoffRange.isEdges());
                } else {
                    if (d.doubleValue() != outlierCutoffRange.getLowerValue().doubleValue()) {
                        bl3 = false;
                    }
                    if (d2.doubleValue() != outlierCutoffRange.getUpperValue().doubleValue()) {
                        bl3 = false;
                    }
                    if (bl.booleanValue() != outlierCutoffRange.isEdges()) {
                        bl4 = false;
                    }
                }
                if (bl3 && bl4) continue;
                bl4 = false;
                bl2 = false;
                bl3 = false;
                continue block0;
            }
        }
        if (bl2 && bl3 && bl4) {
            this.txtLowerValue.setNumber(d);
            this.txtUpperValue.setNumber(d2);
            this.m_edges.setSelected(bl == true);
            this.m_nulls.setSelected(bl == false);
        } else {
            if (rangeArray.length == 1 && rangeArray[0].getLowerLimit() == rangeArray[0].getUpperLimit()) {
                Double d3 = outlierDiscretizeDataSource.getAverage(rangeArray[0].getLowerLimit());
                Double d4 = outlierDiscretizeDataSource.getSigma(rangeArray[0].getLowerLimit());
                double d5 = d3 - 3.0 * d4;
                double d6 = d3 + 3.0 * d4;
                this.txtLowerValue.setNumber(new Double(d5));
                this.txtUpperValue.setNumber(new Double(d6));
                this.m_state.setLowerTailValue(d5);
                this.m_state.setUpperTailValue(d6);
            } else {
                double d7 = 0.0;
                this.txtLowerValue.setNumber(new Double(d7));
                this.txtUpperValue.setNumber(new Double(d7));
                this.m_state.setLowerTailValue(d7);
                this.m_state.setUpperTailValue(d7);
            }
            this.m_edges.setSelected(false);
            this.m_nulls.setSelected(true);
        }
    }
}

