/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.CDSOutlierDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.OutlierDiscretizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.OutlierDiscretizeState;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierDataUsageState;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierSettingsState;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.commonsteps.GenerateDefaultsDialog;
import oracle.dmt.dm4j.wizard.steps.commonsteps.HistogramDialog;
import oracle.dmt.dm4j.wizard.steps.transformsteps.OutlierStrategyDialog;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;

public class OutlierSettingsPanel
extends DM4JStep
implements ItemListener,
PropertyChangeListener {
    OutlierSettingsState m_state;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JScrollPane paneSpread = new JScrollPane();
    SpreadTable spreadTable = new SpreadTable();
    JButton butCustom = new JButton();
    JButton butStdev = new JButton();
    JButton butPercent = new JButton();
    JButton butValue = new JButton();
    JButton butHistogram = new JButton();
    JButton butRestore = new JButton();
    JButton butClear = new JButton();
    private OutlierDiscretizeDataSource m_model = null;
    private ComponentAdapter m_componentListener = null;
    JLabel lblFiller = new JLabel();
    private int[] m_columnWidths = new int[]{29, 0, 0, 0, 0, 0, 12, 12, 12, 0, 0, 0, 0, 0, 0, 12, 0, 0, 0, 0, 23, 0, 0, 0, 0, 0, 0, 0, 0};
    private ArrayOneDModel m_colModel = null;
    private int[] m_columnWidthsPercent = null;
    private boolean m_isWidthsPercent = false;
    private UserPreferences m_preferences = null;
    private static String SHOW_WINSORIZE_WARNING = "SHOW_WINSORIZE_WARNING";

    public OutlierSettingsPanel(OutlierSettingsState outlierSettingsState) throws Exception {
        super(outlierSettingsState);
        this.m_state = outlierSettingsState;
        this.jbInit();
        this.m_preferences = UserPreferences.getInstance();
    }

    private void jbInit() throws Exception {
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("OUTLIER_STEP_DESCRIPTION"));
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        int n = 0;
        int n2 = 0;
        int n3 = 6;
        int n4 = 1;
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n, n2, n3, n4, 1);
        BrowserContext browserContext = this.m_state.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint() == LaunchPoint.ACTIVITY_GUIDE) {
            this.butRestore.setText(ResourceUtilities.getUILabel("RESTORE_BUTTON"));
            this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("RESTORE_BUTTON"));
            this.butRestore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OutlierSettingsPanel.this.butRestore_actionPerformed(actionEvent);
                }
            });
        } else {
            this.butRestore.setText(ResourceUtilities.getUILabel("GENERATE_DEFAULTS"));
            this.butRestore.setMnemonic(ResourceUtilities.getUIMnemonic("GENERATE_DEFAULTS"));
            this.butRestore.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    OutlierSettingsPanel.this.butGenerateDefaults_actionPerformed(actionEvent);
                }
            });
        }
        n = 1;
        n2 = 4;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butRestore, COL1_CONTROL, n, n2, n3, n4, 13, 0);
        this.paneSpread.getViewport().add((Component)this.spreadTable, null);
        n = 2;
        n2 = 0;
        n3 = 5;
        n4 = 7;
        this.addComponent(this.paneSpread, COL1_CONTROL, n, n2, n3, n4, 17, 1);
        this.butCustom.setText(ResourceUtilities.getUILabel("DEFINE_BUTTON"));
        this.butCustom.setEnabled(false);
        this.butCustom.setMnemonic(ResourceUtilities.getUIMnemonic("DEFINE_BUTTON"));
        this.butCustom.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierSettingsPanel.this.butCustom_actionPerformed(actionEvent);
            }
        });
        n = 2;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butCustom, COL1_CONTROL, n, n2, n3, n4, 11, 0);
        this.butStdev.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_STDEV"));
        this.butStdev.setEnabled(false);
        this.butStdev.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_STDEV"));
        n = 3;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butStdev, COL1_CONTROL, n, n2, n3, n4, 11, 0);
        this.butStdev.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierSettingsPanel.this.butStdev_actionPerformed(actionEvent);
            }
        });
        this.butPercent.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_PERCENT"));
        this.butPercent.setEnabled(false);
        this.butPercent.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_PERCENT"));
        n = 4;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butPercent, COL1_CONTROL, n, n2, n3, n4, 11, 0);
        this.butPercent.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierSettingsPanel.this.butPercent_actionPerformed(actionEvent);
            }
        });
        this.butValue.setText(ResourceUtilities.getUILabel("OUTLIER_STRATEGY_BY_VALUE"));
        this.butValue.setEnabled(false);
        this.butValue.setMnemonic(ResourceUtilities.getUIMnemonic("OUTLIER_STRATEGY_BY_VALUE"));
        n = 5;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butValue, COL1_CONTROL, n, n2, n3, n4, 11, 0);
        this.butValue.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierSettingsPanel.this.butValue_actionPerformed(actionEvent);
            }
        });
        this.butClear.setText(ResourceUtilities.getUILabel("CLEAR_BUTTON"));
        this.butClear.setMnemonic(ResourceUtilities.getUIMnemonic("CLEAR_BUTTON"));
        n = 6;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butClear, COL1_CONTROL, n, n2, n3, n4, 11, 0);
        this.butClear.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierSettingsPanel.this.butClearAll_actionPerformed(actionEvent);
            }
        });
        this.butHistogram.setText(ResourceUtilities.getUILabel("DISCRETIZATION_HISTOGRAM"));
        this.butHistogram.setEnabled(false);
        this.butHistogram.setMnemonic(ResourceUtilities.getUIMnemonic("DISCRETIZATION_HISTOGRAM"));
        n = 7;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butHistogram, COL1_CONTROL, n, n2, n3, n4, 11, 0);
        this.butHistogram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                OutlierSettingsPanel.this.butHistogram_actionPerformed(actionEvent);
            }
        });
        n = 8;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, n2, n3, n4, 3);
        JButton[] jButtonArray = new JButton[]{this.butCustom, this.butHistogram, this.butRestore, this.butStdev, this.butClear, this.butPercent, this.butValue};
        DM4JResourceUtilities.setPreferredSize(jButtonArray);
    }

    public void init() throws Exception {
        this.loadDefaultValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    protected void loadDefaultValues() throws Exception {
        if (this.m_state != null) {
            OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)this.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
            this.m_model = outlierDataUsageState.getNumericModel();
            this.m_colModel = this.m_model.getColumnDataSource();
            this.spreadTable.setModels((TwoDModel)this.m_model, (OneDModel)this.m_model.getColumnDataSource(), null);
            TwoDSelection twoDSelection = this.getOldSelection();
            this.setSpread();
            this.restoreSelection(twoDSelection);
        }
    }

    private TwoDSelection getOldSelection() {
        return this.spreadTable.getSelection();
    }

    private void restoreSelection(TwoDSelection twoDSelection) {
        boolean bl = false;
        boolean bl2 = false;
        Range[] rangeArray = null;
        if (twoDSelection != null) {
            OneDSelection oneDSelection = twoDSelection.getRowSelection();
            if (oneDSelection == null) {
                return;
            }
            rangeArray = oneDSelection.getRanges();
            if (rangeArray != null) {
                bl2 = true;
                if (rangeArray.length == 1 && rangeArray[0].getLowerLimit() == rangeArray[0].getUpperLimit()) {
                    bl = true;
                }
            }
            try {
                this.spreadTable.setSelection(twoDSelection);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.butHistogram.setEnabled(bl);
        this.butCustom.setEnabled(bl2);
        this.butStdev.setEnabled(bl2);
        this.butPercent.setEnabled(bl2);
        this.butValue.setEnabled(bl2);
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        boolean bl = false;
        boolean bl2 = false;
        Range[] rangeArray = null;
        TwoDSelection twoDSelection = this.spreadTable.getSelection();
        if (twoDSelection != null) {
            OneDSelection oneDSelection = twoDSelection.getRowSelection();
            if (oneDSelection == null) {
                return;
            }
            rangeArray = oneDSelection.getRanges();
        }
        if (rangeArray != null) {
            bl2 = true;
            if (rangeArray.length == 1 && rangeArray[0].getLowerLimit() == rangeArray[0].getUpperLimit()) {
                bl = true;
            }
        }
        this.butHistogram.setEnabled(bl);
        this.butCustom.setEnabled(bl2);
        this.butStdev.setEnabled(bl2);
        this.butPercent.setEnabled(bl2);
        this.butValue.setEnabled(bl2);
    }

    protected void processUserInput() {
        if (this.m_state != null) {
            // empty if block
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        System.out.println(itemEvent.toString());
    }

    protected void setSpread() throws Exception {
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance());
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.AVG, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.KURT, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.MAX, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.MIN, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.SKEW, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.STDDEV, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.MTYPE, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.DTYPE, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.BINNUMBER, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.TAILPERCENT, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.BINBOUNDS, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.VIEW_DEFN, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.DISPLAY_NAMES, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.TOTAL, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.VAR, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.BINTYPE, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.SKEW, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.KURT, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.MISSING_PERCENT, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.DISTINCT, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.DROP_ATTRIBUTE, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_2, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_3, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_4, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_5, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.DEFAULT_ALGORITHM, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.COMPLEX_ATTRIBUTE, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.SPARSITY_FLAG, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_6, false);
        Header header = this.spreadTable.getColumnHeader();
        if (header != null) {
            header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
            header.setCanMoveItems(false);
            header.setHeaderKeyHandler((HeaderKeyHandler)new KeyHandler());
        }
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        generalGridSelectionManager.addPropertyChangeListener((PropertyChangeListener)this);
        this.spreadTable.getGrid().setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        Header header2 = this.spreadTable.getRowHeader();
        if (header2 != null) {
            header2.setCanMoveItems(false);
            header2.setCanResizeItems(false);
            header2.setHeaderSelectionManager((HeaderSelectionManager)new GeneralHeaderSelectionManager(2));
            this.spreadTable.setRowHeaderWidth(50);
        }
        this.m_state.getparentWizardState().getDialog().pack();
        if (this.m_isWidthsPercent) {
            this.setColumnWidthsPercent(this.m_columnWidthsPercent);
        } else {
            this.setColumnWidths(this.m_columnWidths, true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void butRestore_actionPerformed(ActionEvent actionEvent) {
        if (this.m_model.getRowCount() == 0) {
            return;
        }
        if (!this.warningAccepted()) {
            return;
        }
        try {
            this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(true);
            this.m_model.restoreDefaultTreatment();
        }
        finally {
            this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(false);
        }
    }

    protected void butGenerateDefaults_actionPerformed(ActionEvent actionEvent) {
        block2: {
            try {
                GenerateDefaultsDialog generateDefaultsDialog = GenerateDefaultsDialog.createNumericOutlierDefaultsDialog(this.getparentWizardState().getDialog(), this.m_state.getparentWizardState(), this.spreadTable, this.m_model);
                this.m_state.invalidate();
            }
            catch (Exception exception) {
                if (!OutlierDiscretizeDataSource.isDebug()) break block2;
                exception.printStackTrace();
            }
        }
    }

    protected void butClearAll_actionPerformed(ActionEvent actionEvent) {
        try {
            OneDSelection oneDSelection;
            this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(true);
            Vector<String> vector = new Vector<String>();
            Hashtable<String, Integer> hashtable = new Hashtable<String, Integer>();
            TwoDSelection twoDSelection = this.spreadTable.getSelection();
            if (twoDSelection != null && (oneDSelection = twoDSelection.getRowSelection()) != null) {
                Range[] rangeArray = oneDSelection.getRanges();
                if (rangeArray != null) {
                    int n;
                    Vector<Integer> vector2 = new Vector<Integer>();
                    for (n = 0; n < rangeArray.length; ++n) {
                        int n2 = rangeArray[n].getLowerLimit();
                        int n3 = rangeArray[n].getUpperLimit();
                        for (int i = n2; i <= n3; ++i) {
                            if (null == this.m_model.getCutoffRange(i)) continue;
                            vector2.add(new Integer(i));
                        }
                    }
                    if (vector2.isEmpty()) {
                        this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(false);
                        this.spreadTable.deselectAll();
                        return;
                    }
                    if (!this.warningAccepted()) {
                        this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(false);
                        this.spreadTable.deselectAll();
                        return;
                    }
                    for (n = 0; n < vector2.size(); ++n) {
                        Integer n4 = (Integer)vector2.elementAt(n);
                        this.m_model.clearCutoffRange(n4);
                        String string = this.m_model.getAttributeName(n4);
                        string = this.m_model.getColumnName(string);
                        vector.add(string);
                        hashtable.put(string, n4);
                    }
                } else {
                    DialogUtilities.createUIErrorDialog(this.getparentWizardState().getDialog(), "ATTRIBUTE_SELECTION_REQUIRED");
                }
                this.m_state.invalidate();
            }
            if (this.m_model instanceof CDSOutlierDiscretizeDataSource) {
                ((CDSOutlierDiscretizeDataSource)this.m_model).addNumericStatsComplexData(vector);
            } else {
                this.m_model.addNumericStats(vector, hashtable, null);
            }
            this.spreadTable.deselectAll();
        }
        catch (PropertyVetoException propertyVetoException) {
            // empty catch block
        }
        this.m_state.getparentWizardState().getDM4JWizardDialog().setDialogBusy(false);
    }

    protected void butCustom_actionPerformed(ActionEvent actionEvent) {
        this.outlierStrategyDialog(actionEvent, 3);
    }

    protected boolean warningAccepted() {
        int n = JOptionPane.showOptionDialog(this, ResourceUtilities.getUILabel("OUTLIER_SETTINGS_RESTORE"), ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 0, 2, null, null, null);
        return n != 1 && n != -1;
    }

    protected void butStdev_actionPerformed(ActionEvent actionEvent) {
        this.outlierStrategyDialog(actionEvent, 0);
    }

    protected void butValue_actionPerformed(ActionEvent actionEvent) {
        this.outlierStrategyDialog(actionEvent, 2);
    }

    protected void butPercent_actionPerformed(ActionEvent actionEvent) {
        this.outlierStrategyDialog(actionEvent, 1);
    }

    private void outlierStrategyDialog(ActionEvent actionEvent, int n) {
        block2: {
            try {
                OutlierStrategyDialog outlierStrategyDialog = new OutlierStrategyDialog(this.getparentWizardState().getDialog(), this.m_state, this.spreadTable, n);
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
                if (!OutlierDiscretizeDataSource.isDebug()) break block2;
                exception.printStackTrace();
            }
        }
    }

    private void butHistogram_actionPerformed(ActionEvent actionEvent) {
        block2: {
            try {
                OutlierDiscretizeState outlierDiscretizeState = (OutlierDiscretizeState)this.m_state.getparentWizardState();
                OutlierDataUsageState outlierDataUsageState = (OutlierDataUsageState)this.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
                HistogramDialog histogramDialog = new HistogramDialog(this.getparentWizardState().getDialog(), this.m_state.getparentWizardState(), this.spreadTable, outlierDiscretizeState.getGraph());
            }
            catch (Exception exception) {
                this.m_state.getparentWizardState().doAbortCancel(exception);
                if (!OutlierDiscretizeDataSource.isDebug()) break block2;
                exception.printStackTrace();
            }
        }
    }

    private void validatePercentageAllocation(int[] nArray) throws Exception {
        int n = this.m_colModel.getItemCount();
        if (nArray.length != n) {
            throw new Exception("Number of columns does not match the number of percentage items");
        }
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n2 += nArray[i];
        }
        if (n2 > 100) {
            throw new Exception("Total percentage exceeds 100 percent - check percentages");
        }
    }

    public void setColumnWidths(int[] nArray, boolean bl) throws Exception {
        if (bl && null != nArray) {
            this.validatePercentageAllocation(nArray);
            this.setColumnWidthsPercent(nArray);
        } else {
            this.resizeColumns(nArray);
        }
        if (null != this.m_componentListener) {
            this.spreadTable.getGrid().removeComponentListener((ComponentListener)this.m_componentListener);
            this.m_componentListener = null;
        }
        this.m_componentListener = new Resizer(this.spreadTable);
        Container container = this.getParent().getParent();
        container.addComponentListener(this.m_componentListener);
    }

    private void setColumnWidthsPercent(int[] nArray) {
        int n = this.m_colModel.getItemCount();
        JViewport jViewport = this.spreadTable.getViewport();
        if (jViewport == null) {
            return;
        }
        int n2 = jViewport.getExtentSize().width;
        this.m_columnWidthsPercent = new int[nArray.length];
        System.arraycopy(nArray, 0, this.m_columnWidthsPercent, 0, nArray.length);
        this.m_columnWidths = new int[nArray.length];
        int n3 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n4 = (int)((float)n2 / 100.0f * (float)nArray[i]);
            if (i == n - 1) {
                n4 = n2 < n3 + n4 ? n4 : n2 - n3 - this.m_colModel.getItemCount();
            }
            n3 += n4;
            this.m_columnWidths[i] = n4;
        }
        this.m_isWidthsPercent = true;
        this.resizeColumns(this.m_columnWidths);
    }

    private void resizeColumns(int[] nArray) {
        this.m_columnWidths = nArray;
        if (null == nArray) {
            int n = this.m_colModel.getItemCount();
            JViewport jViewport = this.spreadTable.getViewport();
            int n2 = jViewport.getExtentSize().width;
            if (0 == n2) {
                return;
            }
            int n3 = n2 / n;
            int n4 = n2 % n;
            for (int i = 0; i < n; ++i) {
                this.spreadTable.setColumnWidth(i, i == n - 1 ? n3 + n4 - this.m_colModel.getItemCount() : n3);
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.spreadTable.setColumnWidth(i, this.m_columnWidths[i]);
            }
        }
    }

    class Resizer
    extends ComponentAdapter {
        private SpreadTable _spreadTable;

        public Resizer(SpreadTable spreadTable) {
            this._spreadTable = spreadTable;
        }

        public void componentResized(ComponentEvent componentEvent) {
            this._spreadTable.invalidate();
            if (OutlierSettingsPanel.this.m_isWidthsPercent) {
                OutlierSettingsPanel.this.setColumnWidthsPercent(OutlierSettingsPanel.this.m_columnWidthsPercent);
            } else {
                OutlierSettingsPanel.this.resizeColumns(null);
            }
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 32) {
                SortInputHandler sortInputHandler = (SortInputHandler)header.getItemInputHandler();
                sortInputHandler.sort(header.getFocusItem());
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }
}

