/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.Locale;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.table.DefaultDm4jSpreadTable;
import oracle.dmt.dm4j.datasources.CDSNormalizeDataSource;
import oracle.dmt.dm4j.datasources.NormalizeDataSource;
import oracle.dmt.dm4j.datasources.NormalizeScheme;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.NormalizeDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.NormalizeSchemeStat;
import oracle.dmt.dm4j.wizard.state.transformsteps.NormalizeState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.commonsteps.HistogramDialog;
import oracle.dmt.dm4j.wizard.steps.transformsteps.NormalizeDialog;

public class NormalizePanel
extends GriddedPanel {
    NormalizeDialog m_parentDialog;
    NormalizeState m_state;
    WizardState m_wizState;
    GriddedPanel formulaPanel = new GriddedPanel();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JComboBox comboFormula = new JComboBox();
    JButton butHistogram = new JButton();
    JButton butUpdate = new JButton();
    JScrollPane paneSpread = new JScrollPane();
    JLabel lblFormula = new JLabel();
    JLabel lblConstantValue1 = new JLabel();
    JLabel lblConstantValue2 = new JLabel();
    NumberTextField txtConstantValue1 = new NumberTextField();
    NumberTextField txtConstantValue2 = new NumberTextField();
    JLabel lblFiller = new JLabel(" ");
    JLabel lblFiller2 = new JLabel(" ");
    JLabel lblFiller3 = new JLabel(" ");
    private int[] m_colWidths = new int[]{40, 30, 30};
    DefaultDm4jSpreadTable m_spreadTable = new DefaultDm4jSpreadTable(null);
    private float m_arg1;
    private float m_arg2;

    public NormalizePanel(NormalizeDialog normalizeDialog, WizardState wizardState, NormalizeState normalizeState) throws Exception {
        this.m_wizState = wizardState;
        this.m_state = normalizeState;
        this.m_parentDialog = normalizeDialog;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.txtConstantValue1.setLocale(Locale.getDefault());
        this.txtConstantValue1.setDataType(Float.TYPE);
        this.txtConstantValue2.setLocale(Locale.getDefault());
        this.txtConstantValue2.setDataType(Float.TYPE);
        this.formulaPanel.setBorder(BorderFactory.createTitledBorder(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_TITLE")));
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_SEL_DESC"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(3);
        this.mlblStepDescription.setMinimumRows(3);
        this.formulaPanel.addFilledComponent((JComponent)this.mlblStepDescription, new Insets(10, 10, 10, 10), 0, 0, 6, 1, 2);
        this.lblFormula.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_FORMULA"));
        this.lblFormula.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("NORMALIZE_SCHEME_FORMULA"));
        this.formulaPanel.addFilledComponent(this.lblFormula, new Insets(0, 10, 0, 0), 1, 0, 6, 1, 2);
        this.formulaPanel.addFilledComponent(this.comboFormula, new Insets(5, 12, 0, 10), 2, 0, 6, 1, 2);
        this.lblFormula.setLabelFor(this.comboFormula);
        this.comboFormula.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NormalizePanel.this.opFormula_actionPerformed(actionEvent);
            }
        });
        this.m_parentDialog.setInitialFocus(this.comboFormula);
        this.formulaPanel.addFilledComponent(this.lblFiller, COL_VALUE, 3, 0, 6, 1, 2);
        this.formulaPanel.addFilledComponent(this.lblFiller2, COL_VALUE, 4, 0, 6, 1, 2);
        this.addFilledComponent(this.formulaPanel, new Insets(10, 0, 0, 0), n, 0, 6, 3, 2);
        n += 5;
        this.butUpdate.setText(ResourceUtilities.getUILabel("REFRESH_BUTTON"));
        this.butUpdate.setMnemonic(ResourceUtilities.getUIMnemonic("REFRESH_BUTTON"));
        this.butUpdate.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NormalizePanel.this.butUpdate_actionPerformed(actionEvent);
            }
        });
        this.butHistogram.setText(ResourceUtilities.getUILabel("NORMALIZE_HISTOGRAM"));
        this.butHistogram.setMnemonic(ResourceUtilities.getUIMnemonic("NORMALIZE_HISTOGRAM"));
        this.butHistogram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NormalizePanel.this.butHistogram_actionPerformed(actionEvent);
            }
        });
        this.addFilledComponent(this.lblFiller3, new Insets(5, 0, 0, 0), n, 0, 2, 1, 2);
        this.addComponent(this.butUpdate, COL1_CONTROL, n, 2, 2, 1, 13, 0);
        this.addComponent(this.butHistogram, COL1_CONTROL, n++, 4, 2, 1, 13, 0);
        this.butHistogram.setEnabled(!this.m_state.isTransactional());
        this.paneSpread.getViewport().add((Component)((Object)this.m_spreadTable), null);
        this.addFilledComponent(this.paneSpread, new Insets(10, 0, 0, 0), n, 0, 6, 3, 1);
        this.addOKHelpCancelListeners();
        this.loadDefaultValues();
    }

    protected void loadDefaultValues() throws Exception {
        if (this.m_state != null) {
            int[] nArray = NormalizeScheme.getSchemes(this.m_state.isNormalized());
            for (int i = 0; i < nArray.length; ++i) {
                this.comboFormula.addItem(this.getSchemeString(nArray[i]));
            }
            this.comboFormula.setSelectedItem(this.getSchemeString(this.m_state.getSchemeType()));
            this.setSpread();
        }
    }

    protected void setSpread() throws Exception {
        NormalizeState.PreviewDataSource previewDataSource = this.m_state.getModel();
        this.m_spreadTable.setModels((TwoDModel)previewDataSource, previewDataSource.getColumnDataSource(), null);
        this.m_spreadTable.setColumnWidths(this.m_colWidths, true);
        Header header = this.m_spreadTable.getColumnHeader();
        header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
        header.setCanMoveItems(false);
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance());
        this.m_spreadTable.getGrid().setColumnPainter(previewDataSource.ORG_VALUE_IDX, (Painter)dM4JTruncatingNumberFormatPainter);
        this.m_spreadTable.getGrid().setColumnPainter(previewDataSource.NEW_VALUE_IDX, (Painter)dM4JTruncatingNumberFormatPainter);
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 0, 0);
        this.m_spreadTable.getGrid().setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
    }

    protected void processUserInput() throws Exception {
        if (this.m_state != null) {
            String string = (String)this.comboFormula.getSelectedItem();
            Float f = (Float)this.txtConstantValue1.getNumber();
            this.m_arg1 = f != null ? f.floatValue() : 0.0f;
            Float f2 = (Float)this.txtConstantValue2.getNumber();
            this.m_arg2 = f2 != null ? f2.floatValue() : 0.0f;
            int n = this.getSchemeType(string);
            if (n != 0) {
                this.m_state.getPreviewData(this.getSchemeType(string), this.m_arg1, this.m_arg2);
                this.m_state.setSave(true);
            }
        }
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NormalizePanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
            try {
                this.processUserInput();
            }
            catch (Exception exception) {
                String string2 = MessageFormat.format(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_PREVIEW_FAILED"), exception.getLocalizedMessage());
                JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), string2, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_ERR_DIALOG_TITLE"), 0);
                if (dM4JEvent != null) {
                    dM4JEvent.cancel();
                }
            }
        } else if ("cancel" == string) {
            this.m_state.setSave(false);
        }
    }

    private int getSchemeType(String string) {
        if (string.equals(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_EXP"))) {
            return 1;
        }
        if (string.equals(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_EXP2"))) {
            return 6;
        }
        if (string.equals(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_LN"))) {
            return 2;
        }
        if (string.equals(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_LN2"))) {
            return 3;
        }
        if (string.equals(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_LOG"))) {
            return 4;
        }
        if (string.equals(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_SQRT"))) {
            return 5;
        }
        if (string.equals(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_MEAN"))) {
            return 7;
        }
        if (string.equals(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_SCALE"))) {
            return 8;
        }
        if (string.equals(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_ZSCORE"))) {
            return 9;
        }
        if (string.equals(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_SPARSE_SCALE"))) {
            return 10;
        }
        return 0;
    }

    private String getSchemeString(int n) {
        if (n == 1) {
            return ResourceUtilities.getUILabel("NORMALIZE_SCHEME_EXP");
        }
        if (n == 6) {
            return ResourceUtilities.getUILabel("NORMALIZE_SCHEME_EXP2");
        }
        if (n == 2) {
            return ResourceUtilities.getUILabel("NORMALIZE_SCHEME_LN");
        }
        if (n == 3) {
            return ResourceUtilities.getUILabel("NORMALIZE_SCHEME_LN2");
        }
        if (n == 4) {
            return ResourceUtilities.getUILabel("NORMALIZE_SCHEME_LOG");
        }
        if (n == 5) {
            return ResourceUtilities.getUILabel("NORMALIZE_SCHEME_SQRT");
        }
        if (n == 7) {
            return ResourceUtilities.getUILabel("NORMALIZE_SCHEME_MEAN");
        }
        if (n == 8) {
            return ResourceUtilities.getUILabel("NORMALIZE_SCHEME_SCALE");
        }
        if (n == 9) {
            return ResourceUtilities.getUILabel("NORMALIZE_SCHEME_ZSCORE");
        }
        if (n == 10) {
            return ResourceUtilities.getUILabel("NORMALIZE_SCHEME_SPARSE_SCALE");
        }
        return ResourceUtilities.getUILabel("NORMALIZE_SCHEME_NO_SELECTION");
    }

    private void opFormula_actionPerformed(ActionEvent actionEvent) {
        String string = (String)this.comboFormula.getSelectedItem();
        int n = this.getSchemeType(string);
        boolean bl = false;
        boolean bl2 = false;
        if (n == 1 || n == 6) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_EXP_DESC"));
        } else if (n == 5) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_SQRT_DESC"));
        } else if (n == 2) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_LN_DESC"));
            bl = true;
            this.lblConstantValue1.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_VAR1"));
            this.txtConstantValue1.setNumber((Number)new Float(this.m_state.getArg1(n) + ""));
        } else if (n == 3) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_LN_DESC"));
            bl = true;
            bl2 = true;
            this.lblConstantValue1.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_VAR1"));
            this.lblConstantValue2.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_VAR2"));
            this.txtConstantValue1.setNumber((Number)new Float(this.m_state.getArg1(n) + ""));
            this.txtConstantValue2.setNumber((Number)new Float(this.m_state.getArg2(n) + ""));
        } else if (n == 4) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_LN_DESC"));
            bl = true;
            this.lblConstantValue1.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_VAR1"));
            this.txtConstantValue1.setNumber((Number)new Float(this.m_state.getArg1(n) + ""));
        } else if (n == 7) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_MEAN_DESC"));
            bl = true;
            bl2 = true;
            this.lblConstantValue1.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_NEW_VAR"));
            this.lblConstantValue2.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_NEW_MEAN"));
            this.txtConstantValue1.setNumber((Number)new Float(this.m_state.getArg1(n) + ""));
            this.txtConstantValue2.setNumber((Number)new Float(this.m_state.getArg2(n) + ""));
        } else if (n == 8) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_SCALE_DESC"));
            bl = true;
            bl2 = true;
            this.lblConstantValue1.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_NEW_MIN"));
            this.lblConstantValue2.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_NEW_MAX"));
            this.txtConstantValue1.setNumber((Number)new Float(this.m_state.getArg1(n) + ""));
            this.txtConstantValue2.setNumber((Number)new Float(this.m_state.getArg2(n) + ""));
        } else if (n == 9) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_ZSCORE_DESC"));
        } else if (n == 10) {
            this.mlblStepDescription.setText(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_SPARSE_SCALE_DESC"));
        }
        this.formulaPanel.remove(this.lblFiller);
        this.formulaPanel.remove(this.lblConstantValue1);
        this.formulaPanel.remove(this.lblConstantValue2);
        this.formulaPanel.remove((Component)this.txtConstantValue1);
        this.formulaPanel.remove((Component)this.txtConstantValue2);
        if (bl) {
            this.formulaPanel.addComponent(this.lblConstantValue1, COL_VALUE, 3, 0);
            this.formulaPanel.addFilledComponent((JComponent)this.txtConstantValue1, new Insets(5, 10, 0, 10), 3, 1, 2, 1, 2);
            this.lblConstantValue1.setLabelFor((Component)this.txtConstantValue1);
            if (bl2) {
                this.formulaPanel.addComponent(this.lblConstantValue2, new Insets(5, 10, 0, 0), 3, 3);
                this.formulaPanel.addFilledComponent((JComponent)this.txtConstantValue2, new Insets(5, 10, 0, 10), 3, 4, 2, 1, 2);
                this.lblConstantValue2.setLabelFor((Component)this.txtConstantValue2);
            }
        } else {
            this.formulaPanel.addFilledComponent(this.lblFiller, COL1_LABEL, 3, 0, 6, 1, 2);
        }
        this.formulaPanel.revalidate();
    }

    private void butUpdate_actionPerformed(ActionEvent actionEvent) {
        try {
            String string = (String)this.comboFormula.getSelectedItem();
            Float f = (Float)this.txtConstantValue1.getNumber();
            this.m_arg1 = f != null ? f.floatValue() : 0.0f;
            Float f2 = (Float)this.txtConstantValue2.getNumber();
            this.m_arg2 = f2 != null ? f2.floatValue() : 0.0f;
            NormalizeState.PreviewDataSource previewDataSource = this.m_state.getPreviewData(this.getSchemeType(string), this.m_arg1, this.m_arg2);
            if (previewDataSource != null) {
                this.setSpread();
            }
        }
        catch (Exception exception) {
            String string = MessageFormat.format(ResourceUtilities.getUILabel("NORMALIZE_SCHEME_PREVIEW_FAILED"), exception.getLocalizedMessage());
            JOptionPane.showMessageDialog(BrowserFrame.getMainFrame(), string, ResourceUtilities.getUILabel("NORMALIZE_SCHEME_ERR_DIALOG_TITLE"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void butHistogram_actionPerformed(ActionEvent actionEvent) {
        Connection connection = null;
        try {
            Serializable serializable;
            String[] stringArray;
            NormalizeDataState normalizeDataState = (NormalizeDataState)this.m_wizState.getStep(StepType.DATA_STEP);
            NormalizeDataSource normalizeDataSource = normalizeDataState.getModel();
            String string = this.m_state.getAttribute();
            int n = normalizeDataSource.getAttributeRow(string);
            String string2 = normalizeDataSource.getComplexAttribute(n);
            String[] stringArray2 = null;
            if (string2 == null) {
                stringArray2 = new String[]{NormalizeSchemeStat.get2DSchemeFormula(string, this.m_state.getSchemeType(), this.m_state.getArg1(), this.m_state.getArg2())};
            } else {
                stringArray = (String[])normalizeDataSource;
                serializable = stringArray.getSampledInputCDS().getTXColumn(string2);
                stringArray2 = new String[]{NormalizeSchemeStat.get2DSchemeFormula(serializable.getValueColumn(), this.m_state.getSchemeType(), this.m_state.getArg1(), this.m_state.getArg2())};
            }
            stringArray = new String[]{string};
            connection = DM4JConnectionManager.getDbConnection();
            serializable = null;
            serializable = normalizeDataSource instanceof CDSNormalizeDataSource ? new HistogramDialog(this.m_parentDialog, DM4JConnectionManager.getDbConnection(), false, string, stringArray, stringArray2, ((CDSNormalizeDataSource)normalizeDataSource).getSampledInputCDS(), (CDSNormalizeDataSource)normalizeDataSource, normalizeDataState.getAttributeNameMapping(), normalizeDataState.getValueMapping(), normalizeDataState.getSequenceIDMapping()) : new HistogramDialog(this.m_parentDialog, connection, false, string, stringArray, stringArray2, this.m_state.getSchema(), this.m_state.getTable(), null, null, null, false);
        }
        catch (Exception exception) {
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }
}

