/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.activity.steps.MissingValuesStepOptions;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.MissingValuesCategoricalDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.MissingValuesCategoricalSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.MissingValuesDataUsageState;
import oracle.dmt.dm4j.wizard.steps.StepType;

public class MissingValuesCategoricalStrategyPanel
extends GriddedPanel {
    MultiLineLabel m_mlblStepDescription = new MultiLineLabel();
    DM4JDialog m_parentDialog;
    MissingValuesCategoricalSettingsState m_state = null;
    SpreadTable m_spreadTable;
    ButtonGroup m_choices = new ButtonGroup();
    public static String YES = ResourceUtilities.getUILabel("YES");
    public static String NO = ResourceUtilities.getUILabel("NO");
    public static String MODE = ResourceUtilities.getUILabel("MODE");
    public static String NONE = ResourceUtilities.getUILabel("NONE");
    public static String SPARSE = ResourceUtilities.getUILabel("SPARSE");
    JRadioButton m_replaceWith = new JRadioButton();
    JComboBox comboReplaceWith = new JComboBox();
    JRadioButton m_replaceWithCustomValue = new JRadioButton();
    JTextField txtReplaceWithCustomValue = new JTextField();
    JRadioButton m_dropAttribute = new JRadioButton();

    public MissingValuesCategoricalStrategyPanel(DM4JDialog dM4JDialog, MissingValuesCategoricalSettingsState missingValuesCategoricalSettingsState, SpreadTable spreadTable) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = missingValuesCategoricalSettingsState;
        this.m_spreadTable = spreadTable;
        this.jbInit();
    }

    protected void jbInit() throws Exception {
        int n = 0;
        this.m_mlblStepDescription.setText(ResourceUtilities.getUILabel("MISSING_VALUES_CATEGORICAL_STRATEGY_DIALOG_DESCRIPTION"));
        this.m_mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.m_mlblStepDescription.setPreferredRows(1);
        this.m_mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent((JComponent)this.m_mlblStepDescription, TOP_DESC, n++, 0, 5, 1, 1);
        this.m_replaceWith.setText(ResourceUtilities.getUILabel("MISSING_VALUES_CATEGORICAL_STRATEGY_REPLACE_WITH"));
        this.m_replaceWith.setSelected(true);
        this.m_choices.add(this.m_replaceWith);
        this.m_replaceWith.setMnemonic(ResourceUtilities.getUIMnemonic("MISSING_VALUES_CATEGORICAL_STRATEGY_REPLACE_WITH"));
        String[] stringArray = new String[]{MODE, NONE};
        this.comboReplaceWith = new JComboBox<String>(stringArray);
        this.addComponent(this.m_replaceWith, COL1_INDENTED1_LABEL, n, 0);
        this.addFilledComponent(this.comboReplaceWith, COL_VALUE, n++, 1);
        this.m_replaceWithCustomValue.setText(ResourceUtilities.getUILabel("MISSING_VALUES_CATEGORICAL_STRATEGY_REPLACE_WITH_CUSTOM_VALUE"));
        this.m_replaceWithCustomValue.setSelected(false);
        this.m_choices.add(this.m_replaceWithCustomValue);
        this.m_replaceWithCustomValue.setMnemonic(ResourceUtilities.getUIMnemonic("MISSING_VALUES_CATEGORICAL_STRATEGY_REPLACE_WITH_CUSTOM_VALUE"));
        this.txtReplaceWithCustomValue.setText("");
        this.addComponent(this.m_replaceWithCustomValue, COL1_INDENTED1_LABEL, n, 0);
        this.addFilledComponent(this.txtReplaceWithCustomValue, COL_VALUE, n++, 1);
        this.m_dropAttribute.setText(ResourceUtilities.getUILabel("MISSING_VALUES_CATEGORICAL_STRATEGY_DROP_ATTRIBUTE"));
        this.m_dropAttribute.setSelected(false);
        this.m_choices.add(this.m_dropAttribute);
        this.m_dropAttribute.setMnemonic(ResourceUtilities.getUIMnemonic("MISSING_VALUES_CATEGORICAL_STRATEGY_DROP_ATTRIBUTE"));
        this.addComponent(this.m_dropAttribute, COL1_INDENTED1_LABEL, n, 0);
        this.addFilledComponent(new JLabel(), TOPLABELITEMINSETS, 8, 0, 5, 1, 1);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    protected void loadState() throws Exception {
        if (this.m_state != null) {
            MissingValuesDataUsageState missingValuesDataUsageState = (MissingValuesDataUsageState)this.m_state.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
            MissingValuesCategoricalDataSource missingValuesCategoricalDataSource = (MissingValuesCategoricalDataSource)missingValuesDataUsageState.getCategoricModel();
            TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
            OneDSelection oneDSelection = twoDSelection.getRowSelection();
            Range[] rangeArray = oneDSelection.getRanges();
            Integer n = null;
            String string = null;
            String string2 = null;
            for (int i = 0; i < rangeArray.length; ++i) {
                int n2 = rangeArray[i].getLowerLimit();
                int n3 = rangeArray[i].getUpperLimit();
                for (int j = n2; j <= n3; ++j) {
                    n = missingValuesCategoricalDataSource.getDistinctCount(j);
                    string = missingValuesCategoricalDataSource.getDropAttribute(j);
                    string2 = missingValuesCategoricalDataSource.getTransformation(j);
                    if (string.equalsIgnoreCase("Yes")) {
                        this.m_dropAttribute.setSelected(true);
                        continue;
                    }
                    if (string2.equalsIgnoreCase(MODE) || string2.equalsIgnoreCase(NONE)) {
                        this.m_replaceWith.setSelected(true);
                        this.comboReplaceWith.setSelectedItem(string2);
                        continue;
                    }
                    this.m_replaceWithCustomValue.setSelected(true);
                    this.txtReplaceWithCustomValue.setText(string2);
                }
            }
        }
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MissingValuesCategoricalStrategyPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                if (this.m_replaceWithCustomValue.isSelected()) {
                    this.m_state.validateCustomValues(vector, this.txtReplaceWithCustomValue.getText(), this.m_spreadTable);
                }
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (vector.isEmpty()) {
                    this.processUserInput();
                    this.m_state.validateState();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void processUserInput() {
        MissingValuesDataUsageState missingValuesDataUsageState = (MissingValuesDataUsageState)this.m_state.getparentWizardState().getStep(StepType.DATA_USAGE_STEP);
        MissingValuesCategoricalDataSource missingValuesCategoricalDataSource = (MissingValuesCategoricalDataSource)missingValuesDataUsageState.getCategoricModel();
        MissingValuesStepOptions missingValuesStepOptions = missingValuesCategoricalDataSource.getOptions();
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        Range[] rangeArray = oneDSelection.getRanges();
        for (int i = 0; i < rangeArray.length; ++i) {
            int n = rangeArray[i].getLowerLimit();
            int n2 = rangeArray[i].getUpperLimit();
            for (int j = n; j <= n2; ++j) {
                if (this.m_dropAttribute.isSelected()) {
                    missingValuesCategoricalDataSource.setDropAttribute(j, YES);
                    missingValuesCategoricalDataSource.setTransformation(j, NONE);
                    if (missingValuesStepOptions == null) continue;
                    missingValuesStepOptions.setCategoricalMissingValueOption(3);
                    continue;
                }
                if (this.m_replaceWith.isSelected()) {
                    missingValuesCategoricalDataSource.setDropAttribute(j, NO);
                    missingValuesCategoricalDataSource.setTransformation(j, (String)this.comboReplaceWith.getSelectedItem());
                    if (missingValuesStepOptions == null) continue;
                    missingValuesStepOptions.setCategoricalMissingValueOption(1);
                    missingValuesStepOptions.setCategoricalMissingValueTreatment((String)this.comboReplaceWith.getSelectedItem());
                    continue;
                }
                if (!this.m_replaceWithCustomValue.isSelected()) continue;
                missingValuesCategoricalDataSource.setDropAttribute(j, NO);
                missingValuesCategoricalDataSource.setTransformation(j, this.txtReplaceWithCustomValue.getText());
                if (missingValuesStepOptions == null) continue;
                missingValuesStepOptions.setCategoricalMissingValueOption(2);
                missingValuesStepOptions.setCategoricalMissingValueCustomValue(this.txtReplaceWithCustomValue.getText());
            }
        }
    }
}

