/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.Container;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import oracle.bali.ewt.grid.CellInputHandler;
import oracle.bali.ewt.grid.GeneralGridSelectionManager;
import oracle.bali.ewt.grid.GridSelectionManager;
import oracle.bali.ewt.header.GeneralHeaderSelectionManager;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.header.HeaderItemInputHandler;
import oracle.bali.ewt.header.HeaderKeyHandler;
import oracle.bali.ewt.header.HeaderSelectionManager;
import oracle.bali.ewt.header.StandardHeaderKeyHandler;
import oracle.bali.ewt.model.ArrayOneDModel;
import oracle.bali.ewt.model.OneDModel;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.painter.Painter;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.table.TableEditListener;
import oracle.bali.ewt.table.TableEvent;
import oracle.bali.ewt.util.WindowUtils;
import oracle.bali.share.collection.Range;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.NumberComparator;
import oracle.bali.share.sort.StringComparator;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.DM4JResourceUtilities;
import oracle.dmt.dm4j.DM4JTruncatingNumberFormatPainter;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.viewer.summarization.DataSummarizationCommonViewer;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.SummarizeDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.steps.commonsteps.HistogramFrame;
import oracle.dmt.dm4j.wizard.steps.transformsteps.DataSummarizarionPreferencesDialog;
import oracle.dmt.dm4j.wizard.table.MiningTypeInputHandler;
import oracle.dmt.dm4j.wizard.table.SortInputHandler;

public class DataSummarizationPanel
extends GriddedPanel {
    CellAdaptor cellAction = new CellAdaptor();
    protected JLabel lblAttributeCount = new JLabel();
    protected JLabel lblSampleSize = new JLabel();
    JScrollPane paneSpread = new JScrollPane();
    SpreadTable spreadTable = new SpreadTable();
    JButton selectAll = new JButton();
    JButton butPreference = new JButton();
    JButton butHistogram = new JButton();
    private SummarizeDataSource m_model = null;
    private ComponentAdapter m_componentListener = null;
    JLabel lblFiller = new JLabel();
    protected GriddedPanel m_tableTitlePanel = new GriddedPanel();
    private int[] m_columnWidths = new int[]{30, 10, 10, 0, 0, 0, 10, 10, 10, 0, 10, 0, 0, 0, 10, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    private ArrayOneDModel m_colModel = null;
    private int[] m_columnWidthsPercent = null;
    private boolean m_isWidthsPercent = false;
    private DataSummarizationCommonViewer m_parentFrame;

    private void set2DDisplay() {
        this.m_columnWidths[0] = 30;
        this.m_columnWidths[10] = 0;
        this.m_columnWidths[20] = 10;
    }

    public DataSummarizationPanel(DataSummarizationCommonViewer dataSummarizationCommonViewer, SummarizeDataSource summarizeDataSource) throws Exception {
        this.m_parentFrame = dataSummarizationCommonViewer;
        this.m_model = summarizeDataSource;
        if (!summarizeDataSource.isTransactional()) {
            this.set2DDisplay();
        }
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        int n2 = 0;
        int n3 = 5;
        int n4 = 1;
        this.lblAttributeCount.setText(ResourceUtilities.getUILabel("DATA_SUMMARIZATION_ATTRIBUTE_COUNT") + this.m_model.getRowCount());
        this.lblSampleSize.setText(ResourceUtilities.getUILabel("DATA_SUMMARIZATION_SAMPLE_COUNT") + this.m_model.getSampledTableRowCount());
        this.m_tableTitlePanel.addFilledComponent(this.lblSampleSize, new Insets(5, 0, 0, 0), 0, 0, 2, 1, 1);
        this.m_tableTitlePanel.addFilledComponent(this.lblAttributeCount, new Insets(5, 0, 0, 0), 1, 0, 2, 1, 1);
        this.addFilledComponent(this.m_tableTitlePanel, COL1_CONTROL, n, n2, n3, n4, 1);
        this.selectAll.setText(ResourceUtilities.getUILabel("DATA_SUMMARIZATION_SELECT_ALL"));
        this.selectAll.setEnabled(true);
        this.selectAll.setMnemonic(ResourceUtilities.getUIMnemonic("DATA_SUMMARIZATION_SELECT_ALL"));
        this.selectAll.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSummarizationPanel.this.butSelectAll_actionPerformed(actionEvent);
            }
        });
        n = 0;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.selectAll, COL1_CONTROL, n, n2, n3, n4, 17, 0);
        this.paneSpread.getViewport().add((Component)this.spreadTable, null);
        n = 1;
        n2 = 0;
        n3 = 5;
        n4 = 4;
        this.addComponent(this.paneSpread, COL1_CONTROL, n, n2, n3, n4, 17, 1);
        this.butPreference.setText(ResourceUtilities.getUILabel("SUMMARIZATION_PREFERENCE"));
        this.butPreference.setEnabled(false);
        this.butPreference.setMnemonic(ResourceUtilities.getUIMnemonic("SUMMARIZATION_PREFERENCE"));
        this.butPreference.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSummarizationPanel.this.butPreference_actionPerformed(actionEvent);
            }
        });
        n = 1;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butPreference, COL1_CONTROL, n, n2, n3, n4, 17, 0);
        this.butHistogram.setText(ResourceUtilities.getUILabel("DISCRETIZATION_HISTOGRAM"));
        this.butHistogram.setEnabled(false);
        this.butHistogram.setMnemonic(ResourceUtilities.getUIMnemonic("DISCRETIZATION_HISTOGRAM"));
        n = 2;
        n2 = 5;
        n3 = 1;
        n4 = 1;
        this.addComponent(this.butHistogram, COL1_CONTROL, n, n2, n3, n4, 17, 0);
        this.butHistogram.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSummarizationPanel.this.butHistogram_actionPerformed(actionEvent);
            }
        });
        n = 5;
        n2 = 0;
        n3 = 6;
        n4 = 1;
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, n2, n3, n4, 1);
        JButton[] jButtonArray = new JButton[]{this.butPreference, this.butHistogram, this.selectAll};
        DM4JResourceUtilities.setPreferredSize(jButtonArray);
    }

    private void butHistogram_actionPerformed(ActionEvent actionEvent) {
        try {
            HistogramFrame histogramFrame = new HistogramFrame(this.m_parentFrame, this.m_model, this.spreadTable, this.m_model.getSampledDataLocation());
            if (!histogramFrame.isUserCancelled()) {
                WindowUtils.centerWindow((Window)histogramFrame);
                histogramFrame.setVisible(true);
                this.m_parentFrame.addHistogram(histogramFrame);
            }
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void butSelectAll_actionPerformed(ActionEvent actionEvent) {
        try {
            this.spreadTable.selectAll();
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    private void butPreference_actionPerformed(ActionEvent actionEvent) {
        try {
            DataSummarizarionPreferencesDialog dataSummarizarionPreferencesDialog = new DataSummarizarionPreferencesDialog(this.m_parentFrame, this.m_model, this.spreadTable);
        }
        catch (Exception exception) {
            System.out.println(exception);
        }
    }

    public void loadDefaultValues() throws Exception {
        this.m_colModel = this.m_model.getColumnDataSource();
        this.spreadTable.setModels((TwoDModel)this.m_model, (OneDModel)this.m_model.getColumnDataSource(), null);
        this.setSpread();
    }

    protected void setSpread() throws Exception {
        this.spreadTable.addEditListener((TableEditListener)this.cellAction);
        DM4JTruncatingNumberFormatPainter dM4JTruncatingNumberFormatPainter = new DM4JTruncatingNumberFormatPainter(DM4JNumericFormat.getInstance());
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.AVG, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.KURT, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.MAX, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.MIN, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.SKEW, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnPainter(DiscretizeDataSource.COLUMN_NAMES.VAR, (Painter)dM4JTruncatingNumberFormatPainter);
        this.spreadTable.getGrid().setColumnCellInputHandler(DiscretizeDataSource.COLUMN_NAMES.MTYPE, (CellInputHandler)new MiningTypeInputHandler());
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.BINTYPE, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.BINNUMBER, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.TAILPERCENT, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.BINBOUNDS, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.STDDEV, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.SKEW, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.KURT, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.VIEW_DEFN, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.TOTAL, this.m_model.isTransactional());
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.DISPLAY_NAMES, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.MISSING_PERCENT, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.DISTINCT, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.DROP_ATTRIBUTE, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_1, !this.m_model.isTransactional());
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_2, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_3, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_4, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_5, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.DEFAULT_ALGORITHM, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.COMPLEX_ATTRIBUTE, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.SPARSITY_FLAG, false);
        this.spreadTable.setColumnVisible(DiscretizeDataSource.COLUMN_NAMES.EXTRA_DATA_6, false);
        Header header = this.spreadTable.getColumnHeader();
        if (header != null) {
            header.setHeaderSelectionManager(GeneralHeaderSelectionManager.getNullHeaderSelectionManager());
            header.setCanMoveItems(false);
            header.setHeaderKeyHandler((HeaderKeyHandler)new KeyHandler());
            header.setItemInputHandler((HeaderItemInputHandler)new SortInputHandler(this.m_model));
            this.m_model.setColumnComparator(DiscretizeDataSource.COLUMN_NAMES.NAME, (Comparator)new StringComparator(Collator.getInstance()));
            this.m_model.setColumnComparator(DiscretizeDataSource.COLUMN_NAMES.MTYPE, (Comparator)new StringComparator(Collator.getInstance()));
            this.m_model.setColumnComparator(DiscretizeDataSource.COLUMN_NAMES.DTYPE, (Comparator)new StringComparator(Collator.getInstance()));
            this.m_model.setColumnComparator(DiscretizeDataSource.COLUMN_NAMES.AVG, NumberComparator.getComparator());
            this.m_model.setColumnComparator(DiscretizeDataSource.COLUMN_NAMES.MAX, NumberComparator.getComparator());
            this.m_model.setColumnComparator(DiscretizeDataSource.COLUMN_NAMES.MIN, NumberComparator.getComparator());
            this.m_model.setColumnComparator(DiscretizeDataSource.COLUMN_NAMES.TOTAL, NumberComparator.getComparator());
            this.m_model.setColumnComparator(DiscretizeDataSource.COLUMN_NAMES.VAR, NumberComparator.getComparator());
        }
        GeneralGridSelectionManager generalGridSelectionManager = new GeneralGridSelectionManager(0, 2, 0);
        generalGridSelectionManager.addPropertyChangeListener((PropertyChangeListener)new SelectionListener());
        this.spreadTable.getGrid().setGridSelectionManager((GridSelectionManager)generalGridSelectionManager);
        Header header2 = this.spreadTable.getRowHeader();
        if (header2 != null) {
            header2.setCanMoveItems(false);
            header2.setCanResizeItems(false);
            header2.setHeaderSelectionManager((HeaderSelectionManager)new GeneralHeaderSelectionManager(2));
            this.spreadTable.setRowHeaderWidth(50);
        }
        if (this.m_isWidthsPercent) {
            this.setColumnWidthsPercent(this.m_columnWidthsPercent);
        } else {
            this.setColumnWidths(this.m_columnWidths, true);
        }
    }

    private void validatePercentageAllocation(int[] nArray) throws Exception {
        int n = this.m_colModel.getItemCount();
        if (nArray.length != n) {
            throw new Exception("Number of columns does not match the number of percentage items");
        }
        int n2 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            n2 += nArray[i];
        }
        if (n2 > 100) {
            throw new Exception("Total percentage exceeds 100 percent - check percentages");
        }
    }

    public void setColumnWidths(int[] nArray, boolean bl) throws Exception {
        if (bl && null != nArray) {
            this.validatePercentageAllocation(nArray);
            this.setColumnWidthsPercent(nArray);
        } else {
            this.resizeColumns(nArray);
        }
        if (null != this.m_componentListener) {
            this.spreadTable.getGrid().removeComponentListener((ComponentListener)this.m_componentListener);
            this.m_componentListener = null;
        }
        this.m_componentListener = new Resizer(this.spreadTable);
        Container container = this.getParent().getParent();
        container.addComponentListener(this.m_componentListener);
    }

    private void setColumnWidthsPercent(int[] nArray) {
        int n = this.m_colModel.getItemCount();
        int n2 = this.paneSpread.getViewport().getViewRect().width;
        this.m_columnWidthsPercent = new int[nArray.length];
        int n3 = 0;
        System.arraycopy(nArray, 0, this.m_columnWidthsPercent, 0, nArray.length);
        this.m_columnWidths = new int[nArray.length];
        int n4 = 0;
        for (int i = 0; i < nArray.length; ++i) {
            int n5 = (int)((float)n2 / 100.0f * (float)nArray[i]);
            if (nArray[i] != 0) {
                ++n3;
            }
            if (i == n - 1) {
                n5 = n2 < n4 + n5 ? n5 : n2 - n4 - ++n3;
            }
            n4 += n5;
            this.m_columnWidths[i] = n5;
        }
        this.m_isWidthsPercent = true;
        this.resizeColumns(this.m_columnWidths);
    }

    private void resizeColumns(int[] nArray) {
        this.m_columnWidths = nArray;
        if (null == nArray) {
            int n = this.m_colModel.getItemCount();
            int n2 = this.paneSpread.getViewport().getViewRect().width;
            if (0 == n2) {
                return;
            }
            int n3 = n2 / n;
            int n4 = n2 % n;
            for (int i = 0; i < n; ++i) {
                this.spreadTable.setColumnWidth(i, i == n - 1 ? n3 + n4 - this.m_colModel.getItemCount() : n3);
            }
        } else {
            for (int i = 0; i < nArray.length; ++i) {
                this.spreadTable.setColumnWidth(i, this.m_columnWidths[i]);
            }
        }
    }

    class Resizer
    extends ComponentAdapter {
        private SpreadTable _spreadTable;

        public Resizer(SpreadTable spreadTable) {
            this._spreadTable = spreadTable;
        }

        public void componentResized(ComponentEvent componentEvent) {
            this._spreadTable.invalidate();
            if (DataSummarizationPanel.this.m_isWidthsPercent) {
                DataSummarizationPanel.this.setColumnWidthsPercent(DataSummarizationPanel.this.m_columnWidthsPercent);
            } else {
                DataSummarizationPanel.this.resizeColumns(null);
            }
        }
    }

    private class SelectionListener
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            boolean bl = true;
            boolean bl2 = true;
            TwoDSelection twoDSelection = (TwoDSelection)propertyChangeEvent.getNewValue();
            OneDSelection oneDSelection = twoDSelection.getRowSelection();
            Range[] rangeArray = oneDSelection.getRanges();
            bl2 = rangeArray != null && rangeArray.length == 1 && rangeArray[0].getLowerLimit() == rangeArray[0].getUpperLimit();
            bl = rangeArray != null;
            DataSummarizationPanel.this.butPreference.setEnabled(bl);
            DataSummarizationPanel.this.butHistogram.setEnabled(bl2);
        }
    }

    private class KeyHandler
    extends StandardHeaderKeyHandler {
        private KeyHandler() {
        }

        public void handleKeyEvent(Header header, KeyEvent keyEvent) {
            if (keyEvent.getID() == 402 && keyEvent.getKeyCode() == 32) {
                SortInputHandler sortInputHandler = (SortInputHandler)header.getItemInputHandler();
                sortInputHandler.sort(header.getFocusItem());
            }
            super.handleKeyEvent(header, keyEvent);
        }
    }

    private class CellAdaptor
    implements TableEditListener {
        private CellAdaptor() {
        }

        public void cellEditing(TableEvent tableEvent) {
        }

        public void cellEdited(TableEvent tableEvent) {
        }
    }
}

