/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.DM4JNumberTextField;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.datasources.SummarizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.transformsteps.DiscretizeSettingsStateError;

public class DataSummarizarionPreferencesPanel
extends GriddedPanel {
    GridBagLayout gridBagLayout = new GridBagLayout();
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JPanel pnlNumberOfBins = new JPanel(new GridLayout(1, 2, 5, 0));
    JLabel lblNumberOfBins = new JLabel();
    DM4JNumberTextField txtNumberOfBins = new DM4JNumberTextField();
    JPanel pnlSamplingPercent = new JPanel(new GridLayout(1, 2, 5, 0));
    JLabel lblSamplingPercent = new JLabel();
    JLabel txtSamplingPercent = new JLabel();
    DM4JDialog m_parentDialog = null;
    private Vector<Integer> _selectedRows;
    SummarizeDataSource m_dataSourcemodel = null;
    SpreadTable m_spreadTable;
    private static final int _DEFAULT_BIN_NUMBER = 10;
    private Vector<Integer> _defaultBinNumbers;
    private Integer _displayedBinNumber = null;

    public DataSummarizarionPreferencesPanel(DM4JDialog dM4JDialog, SummarizeDataSource summarizeDataSource, SpreadTable spreadTable) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_dataSourcemodel = summarizeDataSource;
        this.m_spreadTable = spreadTable;
        this.jbInit();
    }

    private void loadState() {
        if (this.m_dataSourcemodel == null) {
            return;
        }
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        if (twoDSelection == null) {
            return;
        }
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        if (oneDSelection == null) {
            return;
        }
        Range[] rangeArray = oneDSelection.getRanges();
        if (rangeArray == null || 0 == rangeArray.length) {
            return;
        }
        this._selectedRows = new Vector();
        this._defaultBinNumbers = new Vector();
        for (Range range : rangeArray) {
            for (int i = range.getLowerLimit(); i <= range.getUpperLimit(); ++i) {
                this._selectedRows.add(i);
                int n = this.m_dataSourcemodel.getNumberOfBins(i);
                if (this._displayedBinNumber == null) {
                    this._displayedBinNumber = n;
                } else if (n != this._displayedBinNumber) {
                    this._displayedBinNumber = 10;
                }
                this._defaultBinNumbers.add((int)this.m_dataSourcemodel.getNumberOfBins(i));
            }
        }
        if (this._displayedBinNumber == null) {
            this._displayedBinNumber = 10;
        }
        this.txtNumberOfBins.setText(String.valueOf(this._displayedBinNumber));
        this.txtNumberOfBins.setDataType(Integer.class);
        this.txtNumberOfBins.setSigned(false);
        this.txtNumberOfBins.addKeyListener(new KeyAdapter(){

            public void keyReleased(KeyEvent keyEvent) {
                Number number = DataSummarizarionPreferencesPanel.this.txtNumberOfBins.getNumber();
                DataSummarizarionPreferencesPanel.this.setCurrentNumberOfBins(number != null ? number.intValue() : 0);
            }
        });
        this.txtSamplingPercent.setText(String.valueOf(this.m_dataSourcemodel.getSampleSize()));
        this.addOKHelpCancelListeners();
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataSummarizarionPreferencesPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                this.validateValues(vector);
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (vector.isEmpty()) {
                    this.processUserInput();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        } else if ("cancel" == string) {
            // empty if block
        }
    }

    protected void processUserInput() {
        for (Integer n : this._selectedRows) {
            this.m_dataSourcemodel.setNumberOfBins(n, this._displayedBinNumber);
            if (this.m_dataSourcemodel.isNumeric(n)) {
                Double d = this.m_dataSourcemodel.getMin(n);
                Double d2 = this.m_dataSourcemodel.getMax(n);
                Vector vector = this.m_dataSourcemodel.getEqualWidthBounds(d, d2, this._displayedBinNumber);
                this.m_dataSourcemodel.setBinBounds(n, vector);
            }
            this.m_dataSourcemodel.clearViewDefiniton(n);
        }
    }

    private void setCurrentNumberOfBins(int n) {
        if (n != this._displayedBinNumber) {
            this._displayedBinNumber = n;
        }
    }

    private void validateValues(Vector vector) throws Exception {
        block6: {
            try {
                if (this._displayedBinNumber < 1) {
                    vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_NUMBER));
                    break block6;
                }
                for (Integer n : this._selectedRows) {
                    if (this.m_dataSourcemodel.isNumeric(n)) {
                        if (this._displayedBinNumber <= 127) continue;
                        vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_NUMBER));
                    } else {
                        if (this._displayedBinNumber <= 125) continue;
                        vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_CATEGORICAL_BIN_NUMBER));
                    }
                    break;
                }
            }
            catch (Exception exception) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_NUMBER));
            }
        }
    }

    private void jbInit() throws Exception {
        this.loadState();
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("SUMMARIZATION_PREFRENCES_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 1, 1, 1);
        this.addFilledComponent(this.pnlNumberOfBins, COL1_INDENTED1_LABEL, n++, 0, 1, 1, 1);
        this.lblNumberOfBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.lblNumberOfBins.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_NUMBER_OF_BINS_SPECIFY"));
        this.txtNumberOfBins.setColumns(10);
        this.lblNumberOfBins.setLabelFor((Component)((Object)this.txtNumberOfBins));
        this.pnlNumberOfBins.add(this.lblNumberOfBins);
        this.pnlNumberOfBins.add((Component)((Object)this.txtNumberOfBins));
        this.addFilledComponent(this.pnlSamplingPercent, COL1_INDENTED1_LABEL, n, 0, 1, 1, 1);
        this.lblSamplingPercent.setText(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_NUMBER_OF_CASES"));
        this.lblSamplingPercent.setLabelFor(this.txtSamplingPercent);
        this.pnlSamplingPercent.add(this.lblSamplingPercent);
        this.pnlSamplingPercent.add(this.txtSamplingPercent);
    }

    class DoubleNumberField
    extends JTextField {
        private NumberFormat cellFormatter;

        public DoubleNumberField() {
            this.cellFormatter = DM4JNumericFormat.getInstance();
        }

        public DoubleNumberField(double d, int n) {
            super(n);
            this.cellFormatter = DM4JNumericFormat.getInstance();
            this.setValue(d);
        }

        public void validateField() {
        }

        public double getValue() {
            double d = 0.0;
            try {
                d = this.cellFormatter.parse(this.getText()).doubleValue();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return d;
        }

        public void setValue(double d) {
            this.setText(this.cellFormatter.format(d));
        }

        protected Document createDefaultModel() {
            return new DoubleNumberDocument();
        }

        protected class DoubleNumberDocument
        extends PlainDocument {
            protected DoubleNumberDocument() {
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                char[] cArray = string.toCharArray();
                char[] cArray2 = new char[cArray.length];
                int n2 = 0;
                for (int i = 0; i < cArray2.length; ++i) {
                    if (!Character.isDigit(cArray[i]) && Character.getType(cArray[i]) != 24) continue;
                    cArray2[n2++] = cArray[i];
                }
                super.insertString(n, new String(cArray2, 0, n2), attributeSet);
            }
        }
    }

    class BinNumberField
    extends DoubleNumberField {
        BinNumberField() {
        }

        public void validateField() {
            String string = this.getText();
            int n = 0;
            if (string != null && 0 != string.length()) {
                n = Integer.parseInt(string);
            }
            DataSummarizarionPreferencesPanel.this.setCurrentNumberOfBins(n);
        }
    }

    class DoubleNumberKeyAdaper
    extends KeyAdapter {
        DoubleNumberField m_textField;

        DoubleNumberKeyAdaper(DoubleNumberField doubleNumberField) {
            this.m_textField = doubleNumberField;
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.m_textField.validateField();
        }
    }
}

