/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CategoricDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeCategoricCustomStats;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeTopNBounds;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricBinBoundary;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricBinBoundaryTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricalDiscretizationSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationDataUsageState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.BinningStrategyDialog;
import oracle.dmt.dm4j.wizard.steps.transformsteps.CustomCategoricalEditBinsDialog;
import oracle.dmt.dm4j.wizard.uicontrols.RowEditorModel;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricBin;
import oracle.dmt.odm.binning.CategoricalBackupData;

public class CustomCategoricalBinningPanel
extends GriddedPanel {
    private DM4JDialog m_parentDialog;
    private WizardState m_state = null;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private CategoricTable tblBinBounds = new CategoricTable();
    private RowEditorModel rm = new RowEditorModel();
    private CategoricBinBoundaryTableModel m_tableModel = new CategoricBinBoundaryTableModel();
    private JScrollPane scrTablePane = new JScrollPane();
    private JButton butGenerateBins = new JButton();
    private JButton butAdd = new JButton();
    private JButton butEdit = new JButton();
    private JButton butDelete = new JButton();
    private SpreadTable m_spreadTable;
    private Range[] m_range = null;
    private CategoricDiscretizeDataSource m_dataSourcemodel = null;
    private CategoricalDiscretizationSettingsState m_settingsState;
    private int m_selectedRow = -1;
    private Integer m_prevNumberBins = null;
    private Vector m_prevBinBounds = null;
    private double[] m_prevStats = null;
    private BinningType m_prevBinningType = null;
    private CategoricalBackupData m_backupData = null;
    private Vector m_vAllDistinctValues;

    public CustomCategoricalBinningPanel(DM4JDialog dM4JDialog, WizardState wizardState, SpreadTable spreadTable) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = wizardState;
        this.m_spreadTable = spreadTable;
        this.jbInit();
    }

    public void init() {
        this.loadDefaultValues();
    }

    protected void loadDefaultValues() {
        if (this.m_state != null) {
            // empty if block
        }
    }

    public void reinit() {
        this.init();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 6, 1, 1);
        this.butGenerateBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_BIN_BOUNDARIES"));
        this.butGenerateBins.setMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_BIN_BOUNDARIES"));
        this.butGenerateBins.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomCategoricalBinningPanel.this.butGenerateBins_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.butGenerateBins, COL2_CONTROL, n++, 4, 1, 1, 13, 0);
        this.tblBinBounds.setAutoCreateColumnsFromModel(false);
        this.tblBinBounds.setModel(this.m_tableModel);
        int n2 = this.m_tableModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setHorizontalAlignment(2);
            TableColumn tableColumn = new TableColumn(i, 40);
            tableColumn.setCellRenderer(defaultTableCellRenderer);
            this.tblBinBounds.addColumn(tableColumn);
        }
        this.tblBinBounds.setRowSelectionAllowed(true);
        this.scrTablePane.getViewport().add(this.tblBinBounds);
        this.addFilledComponent(this.scrTablePane, COL_VALUE, n, 0, 5, 3, 1);
        this.butAdd.setText(ResourceUtilities.getUILabel("ADD_BUTTON"));
        this.butAdd.setMnemonic(ResourceUtilities.getUIMnemonic("ADD_BUTTON"));
        this.butAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomCategoricalBinningPanel.this.butAdd_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.butAdd, COL2_CONTROL, n++, 6);
        this.butEdit.setText(ResourceUtilities.getUILabel("EDIT_BUTTON"));
        this.butEdit.setMnemonic(ResourceUtilities.getUIMnemonic("EDIT_BUTTON"));
        this.butEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomCategoricalBinningPanel.this.butEdit_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.butEdit, COL2_CONTROL, n++, 6);
        this.butEdit.setEnabled(false);
        this.butDelete.setText(ResourceUtilities.getUILabel("DELETE_BUTTON"));
        this.butDelete.setMnemonic(ResourceUtilities.getUIMnemonic("DELETE_BUTTON"));
        this.butDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomCategoricalBinningPanel.this.butDelete_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.butDelete, COL2_CONTROL, n++, 6);
        this.butDelete.setEnabled(false);
        JButton[] jButtonArray = new JButton[]{this.butAdd, this.butEdit, this.butDelete};
        CustomCategoricalBinningPanel.setPreferredSize(jButtonArray, 100, 25);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    private void loadState() throws Exception {
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        if (twoDSelection == null) {
            return;
        }
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        if (oneDSelection == null) {
            return;
        }
        Range[] rangeArray = oneDSelection.getRanges();
        if (rangeArray == null) {
            return;
        }
        this.m_range = rangeArray;
        if (this.m_state == null) {
            throw new Exception();
        }
        this.m_settingsState = (CategoricalDiscretizationSettingsState)this.m_state.getStep(StepType.SETTING_STEP_2);
        DiscretizationDataUsageState discretizationDataUsageState = (DiscretizationDataUsageState)this.m_state.getStep(StepType.DATA_USAGE_STEP);
        this.m_dataSourcemodel = discretizationDataUsageState.getCategoricModel();
        if (this.m_dataSourcemodel == null) {
            throw new Exception();
        }
        this.m_selectedRow = this.m_range[0].getLowerLimit();
        if (this.m_dataSourcemodel.isNumeric(this.m_selectedRow)) {
            return;
        }
        boolean bl = this.m_dataSourcemodel.isAttributeBinned(this.m_selectedRow);
        this.m_settingsState.setBinned(bl);
        Integer n = bl ? this.m_dataSourcemodel.getNumberOfBins(this.m_selectedRow) : new Integer(DiscretizeDataSource.DEFAULT_BIN_NUMBER);
        this.m_settingsState.setCurrentNumberOfBins(n);
        this.fillTable();
        this.m_settingsState.setCurrentBinBoundaries(this.m_tableModel);
        this.m_vAllDistinctValues = this.m_dataSourcemodel.getDistinctValues(this.m_selectedRow);
        this.enableAdd();
        this.m_prevNumberBins = n;
        this.m_prevBinBounds = new Vector();
        Vector vector = this.m_dataSourcemodel.getBinBounds(this.m_selectedRow);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.m_prevBinBounds.add(vector.get(i));
            }
        }
        this.m_prevBinningType = this.m_dataSourcemodel.getBinningType(this.m_selectedRow);
    }

    private void enableAdd() {
        Vector vector = this.getUnbinnedDistictValues();
        this.butAdd.setEnabled(!vector.isEmpty());
    }

    private Vector getUnbinnedDistictValues() {
        return this.m_tableModel.getUnAssignedDistictValues(this.m_vAllDistinctValues);
    }

    private void fillTable() {
        Vector vector = this.m_dataSourcemodel.getBinBounds(this.m_selectedRow);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            CategoricBin categoricBin = (CategoricBin)vector.elementAt(i);
            CategoricBinBoundary categoricBinBoundary = new CategoricBinBoundary(categoricBin.category, categoricBin.values);
            this.m_tableModel.addEntry(categoricBinBoundary);
        }
    }

    private void butAdd_actionPerformed(ActionEvent actionEvent) {
        try {
            CustomCategoricalEditBinsDialog customCategoricalEditBinsDialog = new CustomCategoricalEditBinsDialog(this.m_parentDialog, this.m_state, this.tblBinBounds, -1, this.m_vAllDistinctValues, this.m_dataSourcemodel.isTransactional());
            if (!customCategoricalEditBinsDialog.isCancelled()) {
                int n = this.tblBinBounds.getRowCount();
                this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, n);
                this.m_settingsState.setCurrentNumberOfBins(n);
                this.enableAdd();
            }
        }
        catch (Exception exception) {
            this.m_state.doAbortCancel(exception);
        }
    }

    private void butEdit_actionPerformed(ActionEvent actionEvent) {
        try {
            int[] nArray = this.tblBinBounds.getSelectedRows();
            CustomCategoricalEditBinsDialog customCategoricalEditBinsDialog = new CustomCategoricalEditBinsDialog(this.m_parentDialog, this.m_state, this.tblBinBounds, nArray[0], this.m_vAllDistinctValues, this.m_dataSourcemodel.isTransactional());
            if (!customCategoricalEditBinsDialog.isCancelled()) {
                this.sortBins();
                int n = this.tblBinBounds.getRowCount();
                this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, n);
                this.m_settingsState.setCurrentNumberOfBins(n);
                this.enableAdd();
            }
        }
        catch (Exception exception) {
            this.m_state.doAbortCancel(exception);
        }
    }

    private void sortBins() {
        block8: {
            CategoricBinBoundary categoricBinBoundary;
            int n;
            Vector<CategoricBinBoundary> vector = new Vector<CategoricBinBoundary>();
            NumberFormat numberFormat = NumberFormat.getInstance();
            try {
                for (n = 0; n < this.m_tableModel.getRowCount(); ++n) {
                    categoricBinBoundary = this.m_tableModel.getFieldEntry(n);
                    numberFormat.parse(categoricBinBoundary.getBinCategory());
                    vector.add(categoricBinBoundary);
                }
            }
            catch (Exception exception) {
                vector.clear();
            }
            if (vector.isEmpty()) {
                return;
            }
            this.m_tableModel.deleteAllEntries();
            this.m_tableModel.addEntry((CategoricBinBoundary)vector.elementAt(0));
            try {
                for (n = 1; n < vector.size(); ++n) {
                    categoricBinBoundary = (CategoricBinBoundary)vector.elementAt(n);
                    Number number = numberFormat.parse(categoricBinBoundary.getBinCategory());
                    boolean bl = false;
                    for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
                        CategoricBinBoundary categoricBinBoundary2 = this.m_tableModel.getFieldEntry(i);
                        Number number2 = numberFormat.parse(categoricBinBoundary2.getBinCategory());
                        if (number.intValue() >= number2.intValue()) continue;
                        this.m_tableModel.addEntry(i, categoricBinBoundary);
                        bl = true;
                        break;
                    }
                    if (bl) continue;
                    this.m_tableModel.addEntry(categoricBinBoundary);
                }
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) break block8;
                exception.printStackTrace();
            }
        }
    }

    private void butDelete_actionPerformed(ActionEvent actionEvent) {
        int n;
        int[] nArray = this.tblBinBounds.getSelectedRows();
        if (nArray != null && nArray.length != 0 && ((n = JOptionPane.showOptionDialog(this, ResourceUtilities.getUILabel("CUSTOM_CATEGORIC_REMOVE_CATEGORY_WARNING"), ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 0, 2, null, null, null)) == 1 || n == -1)) {
            return;
        }
        n = nArray == null ? 0 : nArray[0];
        this.m_tableModel.deleteEntries(nArray);
        this.tblBinBounds.changeSelection(n, 0, true, false);
        this.sortBins();
        int n2 = this.tblBinBounds.getRowCount();
        this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, n2);
        this.m_settingsState.setCurrentNumberOfBins(n2);
        this.enableAdd();
    }

    private void butGenerateBins_actionPerformed(ActionEvent actionEvent) {
        try {
            this.collectBackupData();
            BinningStrategyDialog binningStrategyDialog = new BinningStrategyDialog(this.m_parentDialog, this.m_state, this.m_spreadTable, BinningType.CUSTOM);
            if (!binningStrategyDialog.isCancelled()) {
                this.recalulateTable();
                this.enableAdd();
            }
        }
        catch (Exception exception) {
            this.m_state.doAbortCancel(exception);
        }
    }

    private void recalulateTable() {
        String string;
        int n;
        int n2;
        int n3 = this.m_settingsState.getCurrentNumberOfBins();
        if (this.m_dataSourcemodel.isAttributeBinned(this.m_selectedRow) && !this.m_settingsState.isRecalculate() && (n2 = this.m_dataSourcemodel.getNumberOfBins(this.m_selectedRow).intValue()) == n3) {
            return;
        }
        String string2 = this.m_dataSourcemodel.getAttributeName(this.m_selectedRow);
        Integer n4 = this.m_dataSourcemodel.getDistinctValue(this.m_selectedRow);
        if (n4 < n3 && ((n = JOptionPane.showOptionDialog(this, string = MessageFormat.format(ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_WARNING"), "\"" + string2 + "\""), ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 0, 2, null, null, null)) == 1 || n == -1)) {
            return;
        }
        int n5 = 0;
        n5 = n4 == null ? n3 : Math.min(n3, n4);
        this.m_tableModel.deleteAllEntries();
        this.setTopNBounds(string2, this.m_selectedRow, n5);
        this.fillTable();
        this.m_settingsState.setCurrentNumberOfBins(this.m_tableModel.getRowCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setTopNBounds(String string, int n, int n2) {
        Object var4_4 = null;
        DiscretizeCategoricCustomStats discretizeCategoricCustomStats = null;
        try {
            discretizeCategoricCustomStats = new DiscretizeCategoricCustomStats(this.m_dataSourcemodel, n, n2);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeCategoricCustomStats, true);
            discretizeCategoricCustomStats.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
            if (discretizeCategoricCustomStats.getException() != null) {
                this.restoreAttrubuteValues();
                if (DiscretizeDataSource.isDebug()) {
                    discretizeCategoricCustomStats.getException().printStackTrace();
                }
            } else if (progressBar.hasUserCancelled()) {
                this.restoreAttrubuteValues();
            }
        }
        catch (Exception exception) {
            this.restoreAttrubuteValues();
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
    }

    private void collectBackupData() {
        this.m_backupData = new CategoricalBackupData(this.m_dataSourcemodel, this.m_selectedRow);
    }

    protected void restoreAttrubuteValues() {
        this.m_backupData.restoreBackupData(this.m_dataSourcemodel);
    }

    protected void processUserInput() {
        CategoricBin categoricBin;
        Object object;
        int n = this.m_tableModel.getRowCount();
        if (n == 0) {
            return;
        }
        Vector<CategoricBin> vector = new Vector<CategoricBin>();
        String string = this.m_dataSourcemodel.getAttributeName(this.m_selectedRow);
        for (int i = 0; i < this.m_tableModel.getRowCount(); ++i) {
            CategoricBinBoundary categoricBinBoundary = this.m_tableModel.getFieldEntry(i);
            Vector vector2 = categoricBinBoundary.getBinVectorValues();
            object = categoricBinBoundary.getBinCategory();
            categoricBin = new CategoricBin((String)object, vector2);
            vector.add(categoricBin);
        }
        if (!vector.isEmpty()) {
            Vector vector3 = this.m_settingsState.getCurrentBinBoundaries();
            if (vector3 != null && !vector3.isEmpty() && vector.size() == vector3.size()) {
                boolean bl = false;
                for (int i = 0; i < vector3.size(); ++i) {
                    object = (CategoricBin)vector.get(i);
                    if (((CategoricBin)object).equals(categoricBin = (CategoricBin)vector3.get(i))) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return;
                }
            }
            this.m_dataSourcemodel.setBinBounds(this.m_selectedRow, vector);
            this.m_dataSourcemodel.markAttributeBinned(this.m_selectedRow, BinningType.TOPN, this.m_settingsState.getCurrentNumberOfBins());
            this.getNewViewDefiniiton(this.m_selectedRow);
            this.m_dataSourcemodel.markAttributeBinned(this.m_selectedRow, BinningType.CUSTOM, this.m_settingsState.getCurrentNumberOfBins());
            this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, this.m_settingsState.getCurrentNumberOfBins());
            this.m_settingsState.invalidate();
        }
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomCategoricalBinningPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        block6: {
            String string = actionEvent.getActionCommand();
            if ("ok" == string) {
                Vector vector = new Vector();
                try {
                    this.m_settingsState.validateBinNumberValue(vector);
                    DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                    DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                    if (vector.isEmpty()) {
                        this.processUserInput();
                    }
                    break block6;
                }
                catch (Exception exception) {
                    if (DiscretizeDataSource.isDebug()) {
                        exception.printStackTrace();
                    }
                    break block6;
                }
            }
            if ("cancel" == string) {
                this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, this.m_prevNumberBins);
                this.m_dataSourcemodel.setBinBounds(this.m_selectedRow, this.m_prevBinBounds);
                this.m_dataSourcemodel.markAttributeBinned(this.m_selectedRow, this.m_prevBinningType, this.m_prevNumberBins);
                this.m_settingsState.load();
            }
        }
    }

    public void selectionChanged() {
        int n;
        int n2 = this.tblBinBounds != null ? this.tblBinBounds.getRowCount() : 0;
        int n3 = n = this.tblBinBounds != null ? this.tblBinBounds.getSelectedRowCount() : 0;
        if (this.butDelete != null) {
            this.butDelete.setEnabled(n > 0 && n2 > n);
        }
        if (this.butEdit != null) {
            this.butEdit.setEnabled(n == 1);
        }
    }

    private void getNewViewDefiniiton(int n) {
        block6: {
            DiscretizeTopNBounds discretizeTopNBounds = null;
            try {
                discretizeTopNBounds = new DiscretizeTopNBounds(this.m_dataSourcemodel, n);
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeTopNBounds, true);
                discretizeTopNBounds.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
                if (discretizeTopNBounds.getException() != null) {
                    this.restoreAttrubuteValues();
                    if (DiscretizeDataSource.isDebug()) {
                        discretizeTopNBounds.getException().printStackTrace();
                    }
                } else if (progressBar.hasUserCancelled()) {
                    this.restoreAttrubuteValues();
                }
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) break block6;
                exception.printStackTrace();
            }
        }
    }

    class CategoricTable
    extends JTable {
        CategoricTable() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            super.valueChanged(listSelectionEvent);
            if (CustomCategoricalBinningPanel.this != null) {
                CustomCategoricalBinningPanel.this.selectionChanged();
            }
        }
    }
}

