/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.DefaultCellEditor;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.PlainDocument;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.selection.TwoDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.DM4JNumericFormat;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.DiscretizeCustomStats;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeEqualWidthBounds;
import oracle.dmt.dm4j.datasources.DiscretizeQtileBounds;
import oracle.dmt.dm4j.datasources.DiscretizeWinsorizeBounds;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.BinBoundary;
import oracle.dmt.dm4j.wizard.state.transformsteps.BinBoundaryTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationDataUsageState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.AddNewBinDialog;
import oracle.dmt.dm4j.wizard.steps.transformsteps.BinningStrategyDialog;
import oracle.dmt.dm4j.wizard.uicontrols.CustomTable;
import oracle.dmt.dm4j.wizard.uicontrols.RowEditorModel;
import oracle.dmt.dm4j.wizard.uicontrols.SelectionChangeListener;
import oracle.dmt.odm.binning.BackupData;
import oracle.dmt.odm.binning.Bin;
import oracle.dmt.odm.binning.BinningType;

public class CustomBinningSettingsPanel
extends GriddedPanel
implements SelectionChangeListener {
    private static final int m_nLowerBoundComboRow = 0;
    private static final int m_nLowerBoundComboCol = 1;
    private DM4JDialog m_parentDialog;
    private WizardState m_state = null;
    private GridBagLayout gridBagLayout = new GridBagLayout();
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private MultiLineLabel mlblUpperBoundWarning = new MultiLineLabel();
    private CustomTable tblBinBounds = new CustomTable();
    private RowEditorModel rm = new RowEditorModel();
    private BinBoundaryTableModel tableModel = new BinBoundaryTableModel(new String[]{ResourceUtilities.getUILabel("CUSTOM_NUM_BINNING_BIN_NUMBER"), ResourceUtilities.getUILabel("CUSTOM_NUM_LOWER_BOUND")});
    private JScrollPane scrTablePane = new JScrollPane();
    private JButton butGenerateBins = new JButton();
    private JButton butAdd = new JButton();
    private JButton butDelete = new JButton();
    private JLabel m_LowerBoundTxt;
    private static String m_lowerBoundText;
    private SpreadTable m_spreadTable;
    private Range[] m_range = null;
    private DiscretizeDataSource m_dataSourcemodel = null;
    private DiscretizationSettingsState m_settingsState;
    private int m_selectedRow = -1;
    private Integer m_prevNumberBins = null;
    private Vector m_prevBinBounds = null;
    private double[] m_prevStats = null;
    private BinningType m_prevBinningType = null;
    private BackupData m_backupData = null;

    public CustomBinningSettingsPanel(DM4JDialog dM4JDialog, WizardState wizardState, SpreadTable spreadTable) throws Exception {
        m_lowerBoundText = ResourceUtilities.getUILabel("BINNING_STRATEGY_NO_UPPER_BOUND");
        this.m_parentDialog = dM4JDialog;
        this.m_state = wizardState;
        this.m_spreadTable = spreadTable;
        this.jbInit();
    }

    public void init() {
        this.loadDefaultValues();
    }

    protected void loadDefaultValues() {
        if (this.m_state != null) {
            // empty if block
        }
    }

    public void reinit() {
        this.init();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 6, 1, 1);
        this.butGenerateBins.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_BIN_BOUNDARIES"));
        this.butGenerateBins.setMnemonic(ResourceUtilities.getUIMnemonic("BINNING_STRATEGY_BIN_BOUNDARIES"));
        this.butGenerateBins.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomBinningSettingsPanel.this.butGenerateBins_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.butGenerateBins, COL2_CONTROL, n++, 4, 1, 1, 13, 0);
        this.tblBinBounds.setAutoCreateColumnsFromModel(false);
        this.tblBinBounds.setModel(this.tableModel);
        this.tblBinBounds.addSelectionChangeListener(this);
        int n2 = this.tableModel.getColumnCount();
        for (int i = 0; i < n2; ++i) {
            DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
            defaultTableCellRenderer.setHorizontalAlignment(2);
            TableColumn tableColumn = new TableColumn(i, 40, defaultTableCellRenderer, this.getDoubleEditor());
            this.tblBinBounds.addColumn(tableColumn);
        }
        this.tblBinBounds.setRowSelectionAllowed(true);
        this.tblBinBounds.setRowEditorModel(this.rm);
        this.m_LowerBoundTxt = new JLabel(m_lowerBoundText);
        this.rm.addEditorForRow(0, new LowerBoundCellEditor());
        this.scrTablePane.getViewport().add(this.tblBinBounds);
        this.addFilledComponent(this.scrTablePane, COL_VALUE, n, 0, 5, 3, 1);
        this.butAdd.setText(ResourceUtilities.getUILabel("ADD_BUTTON"));
        this.butAdd.setMnemonic(ResourceUtilities.getUIMnemonic("ADD_BUTTON"));
        this.butAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomBinningSettingsPanel.this.butAdd_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.butAdd, COL2_CONTROL, n++, 6);
        this.butDelete.setText(ResourceUtilities.getUILabel("DELETE_BUTTON"));
        this.butDelete.setMnemonic(ResourceUtilities.getUIMnemonic("DELETE_BUTTON"));
        this.butDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomBinningSettingsPanel.this.butDelete_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.butDelete, COL2_CONTROL, n++, 6);
        this.butDelete.setEnabled(false);
        this.mlblUpperBoundWarning.setText(ResourceUtilities.getUILabel("BINNING_STRATEGY_UPPER_BOUND"));
        this.mlblUpperBoundWarning.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblUpperBoundWarning.setPreferredRows(2);
        this.mlblUpperBoundWarning.setMinimumRows(2);
        this.addFilledComponent((JComponent)this.mlblUpperBoundWarning, BOTTOM_RELATED_CONTROL, 7, 1, 7, 1, 1);
        JButton[] jButtonArray = new JButton[]{this.butAdd, this.butDelete};
        CustomBinningSettingsPanel.setPreferredSize(jButtonArray, 100, 25);
        this.addOKHelpCancelListeners();
        this.loadState();
    }

    private void loadState() throws Exception {
        double[] dArray;
        TwoDSelection twoDSelection = this.m_spreadTable.getSelection();
        if (twoDSelection == null) {
            return;
        }
        OneDSelection oneDSelection = twoDSelection.getRowSelection();
        if (oneDSelection == null) {
            return;
        }
        Range[] rangeArray = oneDSelection.getRanges();
        if (rangeArray == null) {
            return;
        }
        this.m_range = rangeArray;
        if (this.m_state == null) {
            throw new Exception();
        }
        this.m_settingsState = (DiscretizationSettingsState)this.m_state.getStep(StepType.SETTING_STEP_1);
        DiscretizationDataUsageState discretizationDataUsageState = (DiscretizationDataUsageState)this.m_state.getStep(StepType.DATA_USAGE_STEP);
        this.m_dataSourcemodel = discretizationDataUsageState.getNumericModel();
        if (this.m_dataSourcemodel == null) {
            throw new Exception();
        }
        this.m_selectedRow = this.m_range[0].getLowerLimit();
        if (!this.m_dataSourcemodel.isNumeric(this.m_selectedRow)) {
            return;
        }
        boolean bl = this.m_dataSourcemodel.isAttributeBinned(this.m_selectedRow);
        this.m_settingsState.setBinned(bl);
        Integer n = bl ? this.m_dataSourcemodel.getNumberOfBins(this.m_selectedRow) : new Integer(DiscretizeDataSource.DEFAULT_BIN_NUMBER);
        this.m_settingsState.setCurrentNumberOfBins(n);
        this.fillTable();
        this.m_settingsState.setCurrentBinBoundaries(this.tableModel, 3.4028234663852886E38);
        this.m_prevNumberBins = n;
        this.m_prevBinBounds = new Vector();
        Vector vector = this.m_dataSourcemodel.getBinBounds(this.m_selectedRow);
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                this.m_prevBinBounds.add(vector.get(i));
            }
        }
        if ((dArray = this.m_dataSourcemodel.getStats(this.m_selectedRow)) != null) {
            this.m_prevStats = new double[dArray.length];
            System.arraycopy(dArray, 0, this.m_prevStats, 0, dArray.length);
        }
        this.m_prevBinningType = this.m_dataSourcemodel.getBinningType(this.m_selectedRow);
    }

    private void fillTable() {
        Vector vector = this.m_dataSourcemodel.getBinBounds(this.m_selectedRow);
        if (vector == null) {
            return;
        }
        for (int i = 0; i < vector.size(); ++i) {
            Bin bin = (Bin)vector.elementAt(i);
            BinBoundary binBoundary = new BinBoundary(new Integer(i), new Double(bin.getLowerBound()));
            this.tableModel.addEntry(binBoundary);
            if (i != 0) continue;
            this.fillLowerCombo();
        }
    }

    private void fillLowerCombo() {
        this.m_LowerBoundTxt.setText(m_lowerBoundText);
    }

    private void butAdd_actionPerformed(ActionEvent actionEvent) {
        try {
            AddNewBinDialog addNewBinDialog = new AddNewBinDialog(this.m_parentDialog, this.m_state, this.tableModel, this.m_dataSourcemodel.getMin(this.m_selectedRow).intValue(), this.m_dataSourcemodel.getMax(this.m_selectedRow).intValue());
            if (!addNewBinDialog.isCancelled()) {
                this.orderBins();
                int n = this.tblBinBounds.getRowCount();
                this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, n);
                this.m_settingsState.setCurrentNumberOfBins(n);
            }
        }
        catch (Exception exception) {
            this.m_state.doAbortCancel(exception);
        }
    }

    private void orderBins() {
        for (int i = 0; i < this.tableModel.getRowCount(); ++i) {
            BinBoundary binBoundary = this.tableModel.getFieldEntry(i);
            binBoundary.setBinNumber(new Integer(i));
        }
    }

    private void butDelete_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.tblBinBounds.getSelectedRows();
        int n = nArray == null ? 0 : nArray[0];
        this.tableModel.deleteEntries(nArray);
        this.tblBinBounds.changeSelection(n, 0, true, false);
        this.orderBins();
        int n2 = this.tblBinBounds.getRowCount();
        this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, n2);
        this.m_settingsState.setCurrentNumberOfBins(n2 > 0 ? n2 : DiscretizeDataSource.DEFAULT_BIN_NUMBER);
    }

    private void butGenerateBins_actionPerformed(ActionEvent actionEvent) {
        try {
            this.collectBackupData();
            BinningStrategyDialog binningStrategyDialog = new BinningStrategyDialog(this.m_parentDialog, this.m_state, this.m_spreadTable, BinningType.CUSTOM);
            if (!binningStrategyDialog.isCancelled()) {
                this.recalulateTable();
                this.fillLowerCombo();
                if (!this.m_settingsState.isQtileBinning()) {
                    return;
                }
                int n = this.tableModel.getRowCount();
                if (n > 0) {
                    Object object;
                    Object object2;
                    int n2;
                    Vector<Bin> vector = new Vector<Bin>();
                    double d = 0.0;
                    double d2 = 3.4028234663852886E38;
                    for (n2 = 0; n2 < n; ++n2) {
                        object2 = this.tableModel.getFieldEntry(n2);
                        object = null;
                        if (n2 < n - 1) {
                            BinBoundary binBoundary = this.tableModel.getFieldEntry(n2 + 1);
                            object = new Bin(((BinBoundary)object2).getBinNumber(), ((BinBoundary)object2).getLowerBound(), binBoundary.getLowerBound());
                            if (n2 == 0) {
                                d = ((BinBoundary)object2).getLowerBound();
                            }
                        } else {
                            object = new Bin(((BinBoundary)object2).getBinNumber(), ((BinBoundary)object2).getLowerBound(), d2);
                        }
                        vector.add((Bin)object);
                    }
                    n2 = vector.size() - 1;
                    if (n2 != this.m_settingsState.getCurrentNumberOfBins()) {
                        this.m_settingsState.setCurrentNumberOfBins(n2);
                        object2 = this.m_dataSourcemodel.getAttributeName(this.m_selectedRow);
                        object = MessageFormat.format(ResourceUtilities.getUILabel("CUSTOM_QTILE_BINNING_STRATEGY_DIALOG_WARNING"), String.valueOf(n2), object2);
                        JOptionPane.showMessageDialog(null, object, ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 1);
                    }
                }
            }
        }
        catch (Exception exception) {
            this.m_state.doAbortCancel(exception);
        }
    }

    private void recalulateTable() {
        int n;
        int n2 = this.m_settingsState.getCurrentNumberOfBins();
        if (this.m_dataSourcemodel.isAttributeBinned(this.m_selectedRow) && !this.m_settingsState.isRecalculate() && (n = this.m_dataSourcemodel.getNumberOfBins(this.m_selectedRow).intValue()) == n2) {
            return;
        }
        String string = this.m_dataSourcemodel.getAttributeName(this.m_selectedRow);
        if (this.m_settingsState.isQtileBinning()) {
            this.setQtileBounds(string, this.m_selectedRow, n2);
        } else {
            this.setEqualWidthBounds(string, this.m_selectedRow, n2);
        }
    }

    private void collectBackupData() {
        this.m_backupData = new BackupData(this.m_dataSourcemodel, this.m_selectedRow);
    }

    protected void restoreAttrubuteValues() {
        this.m_backupData.restoreBackupData(this.m_dataSourcemodel);
    }

    protected void processUserInput() {
        Object object;
        int n = this.tableModel.getRowCount();
        if (n == 0) {
            return;
        }
        String string = this.m_dataSourcemodel.getAttributeName(this.m_selectedRow);
        Vector<Bin> vector = new Vector<Bin>();
        double d = 0.0;
        double d2 = 3.4028234663852886E38;
        for (int i = 0; i < n; ++i) {
            BinBoundary binBoundary = this.tableModel.getFieldEntry(i);
            Bin bin = null;
            if (i < n - 1) {
                object = this.tableModel.getFieldEntry(i + 1);
                bin = new Bin(binBoundary.getBinNumber(), binBoundary.getLowerBound(), ((BinBoundary)object).getLowerBound());
                if (i == 0) {
                    d = binBoundary.getLowerBound();
                }
            } else {
                bin = new Bin(binBoundary.getBinNumber(), binBoundary.getLowerBound(), d2);
            }
            vector.add(bin);
        }
        if (!vector.isEmpty()) {
            Vector vector2 = this.m_settingsState.getCurrentBinBoundaries();
            if (vector2 != null && !vector2.isEmpty() && vector.size() == vector2.size()) {
                boolean bl = false;
                for (int i = 0; i < vector2.size(); ++i) {
                    Bin bin;
                    object = (Bin)vector.get(i);
                    if (((Bin)object).equals(bin = (Bin)vector2.get(i))) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    return;
                }
            }
            this.m_dataSourcemodel.setBinBounds(this.m_selectedRow, vector);
            this.getCustomStats(string, d, d2, this.m_selectedRow);
            this.m_dataSourcemodel.setCustomBinning(this.m_selectedRow, this.m_settingsState.getCurrentNumberOfBins());
            this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, this.m_settingsState.getCurrentNumberOfBins());
            this.m_settingsState.invalidate();
        }
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                CustomBinningSettingsPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        block6: {
            String string = actionEvent.getActionCommand();
            if ("ok" == string) {
                Vector vector = new Vector();
                try {
                    this.m_settingsState.validateCurrentBinBoundaries(vector, this.tableModel, 3.4028234663852886E38);
                    this.m_settingsState.validateBinNumberValue(vector);
                    DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                    DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                    if (vector.isEmpty()) {
                        this.processUserInput();
                        this.m_settingsState.setCurrentBinBoundaries(this.tableModel, 3.4028234663852886E38);
                    }
                    break block6;
                }
                catch (Exception exception) {
                    if (DiscretizeDataSource.isDebug()) {
                        exception.printStackTrace();
                    }
                    break block6;
                }
            }
            if ("cancel" == string) {
                this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, this.m_prevNumberBins);
                this.m_dataSourcemodel.setBinBounds(this.m_selectedRow, this.m_prevBinBounds);
                this.m_dataSourcemodel.set1stOrderStatistics(this.m_selectedRow, this.m_prevStats);
                this.m_dataSourcemodel.markAttributeBinned(this.m_selectedRow, this.m_prevBinningType, this.m_prevNumberBins);
                this.m_settingsState.load();
            }
        }
    }

    double[] getCustomStats(String string, double d, double d2, int n) {
        double[] dArray;
        block7: {
            dArray = null;
            DiscretizeCustomStats discretizeCustomStats = null;
            try {
                discretizeCustomStats = new DiscretizeCustomStats(this.m_dataSourcemodel, string, d, d2, n);
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeCustomStats, true);
                discretizeCustomStats.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
                if (discretizeCustomStats.getException() != null) {
                    this.restoreAttrubuteValues();
                    dArray = this.m_dataSourcemodel.getStats(this.m_selectedRow);
                    if (DiscretizeDataSource.isDebug()) {
                        discretizeCustomStats.getException().printStackTrace();
                    }
                } else if (progressBar.hasUserCancelled()) {
                    this.restoreAttrubuteValues();
                    dArray = this.m_dataSourcemodel.getStats(this.m_selectedRow);
                } else {
                    dArray = discretizeCustomStats.getCustomStats();
                }
            }
            catch (Exception exception) {
                if (!DiscretizeDataSource.isDebug()) break block7;
                exception.printStackTrace();
            }
        }
        return dArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setWinsorizedBounds(String string, int n, int n2, double d) {
        boolean bl;
        block8: {
            Object var6_5 = null;
            DiscretizeWinsorizeBounds discretizeWinsorizeBounds = null;
            bl = false;
            try {
                discretizeWinsorizeBounds = new DiscretizeWinsorizeBounds(this.m_dataSourcemodel, this.tableModel, string, n, n2, d);
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeWinsorizeBounds, true);
                discretizeWinsorizeBounds.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
                if (discretizeWinsorizeBounds.getException() != null) {
                    this.restoreAttrubuteValues();
                    bl = false;
                    if (DiscretizeDataSource.isDebug()) {
                        discretizeWinsorizeBounds.getException().printStackTrace();
                    }
                    break block8;
                }
                if (progressBar.hasUserCancelled()) {
                    this.restoreAttrubuteValues();
                    bl = false;
                    break block8;
                }
                bl = discretizeWinsorizeBounds.isSuccess();
            }
            catch (Exception exception) {
                this.restoreAttrubuteValues();
                bl = false;
                if (DiscretizeDataSource.isDebug()) {
                    exception.printStackTrace();
                }
            }
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEqualWidthBounds(String string, int n, int n2) {
        Object var4_4 = null;
        DiscretizeEqualWidthBounds discretizeEqualWidthBounds = null;
        try {
            discretizeEqualWidthBounds = new DiscretizeEqualWidthBounds(this.m_dataSourcemodel, this.tableModel, string, n, n2);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeEqualWidthBounds, true);
            discretizeEqualWidthBounds.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
            if (discretizeEqualWidthBounds.getException() != null) {
                this.restoreAttrubuteValues();
                if (DiscretizeDataSource.isDebug()) {
                    discretizeEqualWidthBounds.getException().printStackTrace();
                }
            } else if (progressBar.hasUserCancelled()) {
                this.restoreAttrubuteValues();
            }
        }
        catch (Exception exception) {
            this.restoreAttrubuteValues();
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setQtileBounds(String string, int n, int n2) {
        Object var4_4 = null;
        DiscretizeQtileBounds discretizeQtileBounds = null;
        try {
            discretizeQtileBounds = new DiscretizeQtileBounds(this.m_dataSourcemodel, this.tableModel, string, n, n2);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), discretizeQtileBounds, true);
            discretizeQtileBounds.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("BINNING_BOUNDARIES_CALCULATION_DIALOG_DESC"));
            if (discretizeQtileBounds.getException() != null) {
                this.restoreAttrubuteValues();
                if (DiscretizeDataSource.isDebug()) {
                    discretizeQtileBounds.getException().printStackTrace();
                }
            } else if (progressBar.hasUserCancelled()) {
                this.restoreAttrubuteValues();
            }
        }
        catch (Exception exception) {
            this.restoreAttrubuteValues();
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
    }

    public void selectionChanged(JTable jTable) {
        int n = jTable.getRowCount();
        int[] nArray = jTable.getSelectedRows();
        int n2 = jTable.getSelectedRowCount();
        boolean bl = false;
        if (n2 > 0) {
            if (n2 == n) {
                bl = true;
            } else {
                bl = true;
                for (int i = 0; i < nArray.length; ++i) {
                    if (nArray[i] != 0) continue;
                    bl = false;
                    break;
                }
            }
        }
        this.butDelete.setEnabled(bl);
    }

    private DefaultCellEditor getDoubleEditor() {
        final DoubleNumberField doubleNumberField = new DoubleNumberField(0.0, 10);
        doubleNumberField.setHorizontalAlignment(2);
        DefaultCellEditor defaultCellEditor = new DefaultCellEditor(doubleNumberField){

            public Object getCellEditorValue() {
                return new Double(doubleNumberField.getValue());
            }
        };
        doubleNumberField.addFocusListener(new CellFocusListener(doubleNumberField, defaultCellEditor));
        defaultCellEditor.setClickCountToStart(1);
        return defaultCellEditor;
    }

    private class LowerBoundCellEditor
    implements TableCellEditor {
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            return CustomBinningSettingsPanel.this.m_LowerBoundTxt;
        }

        public Object getCellEditorValue() {
            return m_lowerBoundText;
        }

        public void addCellEditorListener(CellEditorListener cellEditorListener) {
        }

        public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        }

        public void cancelCellEditing() {
        }

        public boolean stopCellEditing() {
            return true;
        }

        public boolean shouldSelectCell(EventObject eventObject) {
            return false;
        }

        public boolean isCellEditable(EventObject eventObject) {
            return false;
        }
    }

    class CellFocusListener
    implements FocusListener {
        JTextField parent = null;
        DefaultCellEditor celEditor = null;

        public CellFocusListener(JTextField jTextField, DefaultCellEditor defaultCellEditor) {
            this.parent = jTextField;
            this.celEditor = defaultCellEditor;
        }

        public void focusGained(FocusEvent focusEvent) {
            this.parent.selectAll();
        }

        public void focusLost(FocusEvent focusEvent) {
            Component component = focusEvent.getOppositeComponent();
            if (component instanceof JButton) {
                JButton jButton = (JButton)component;
                String string = jButton.getText();
                String string2 = CustomBinningSettingsPanel.this.m_parentDialog.getOKButtonText();
                if (0 == string2.compareTo(string)) {
                    this.celEditor.stopCellEditing();
                    return;
                }
            }
            this.celEditor.cancelCellEditing();
        }
    }

    class DoubleNumberField
    extends JTextField {
        private NumberFormat cellFormatter;

        public DoubleNumberField() {
            this.cellFormatter = DM4JNumericFormat.getInstance();
        }

        public DoubleNumberField(double d, int n) {
            super(n);
            this.cellFormatter = DM4JNumericFormat.getInstance();
            this.setValue(d);
        }

        public void validateField() {
        }

        public double getValue() {
            double d;
            block2: {
                d = 0.0;
                try {
                    d = this.cellFormatter.parse(this.getText()).doubleValue();
                    CustomBinningSettingsPanel.this.m_settingsState.invalidate();
                }
                catch (ParseException parseException) {
                    if (!DiscretizeDataSource.isDebug()) break block2;
                    parseException.printStackTrace();
                }
            }
            return d;
        }

        public void setValue(double d) {
            this.setText(this.cellFormatter.format(d));
        }

        protected Document createDefaultModel() {
            return new DoubleNumberDocument();
        }

        protected class DoubleNumberDocument
        extends PlainDocument {
            protected DoubleNumberDocument() {
            }

            public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
                char[] cArray = string.toCharArray();
                char[] cArray2 = new char[cArray.length];
                int n2 = 0;
                for (int i = 0; i < cArray2.length; ++i) {
                    if (Character.isLetter(cArray[i])) continue;
                    cArray2[n2++] = cArray[i];
                }
                super.insertString(n, new String(cArray2, 0, n2), attributeSet);
            }
        }
    }
}

