/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.expressionbuilder.ComputeFieldContext;
import oracle.dmt.dm4j.expressionbuilder.ExpressionBuilderDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ComputeFieldEntry;
import oracle.dmt.dm4j.wizard.state.transformsteps.ComputeFieldSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ComputeFieldTableModel;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;

public class ComputeFieldSettingsPanel
extends DM4JStep {
    ComputeFieldSettingsState m_state;
    static int fieldCounter = 1;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JTable tblComputedFields = new JTable();
    JScrollPane scrTablePane = new JScrollPane();
    JButton btnAdd = new JButton(ResourceUtilities.getUILabel("NEW_BUTTON"));
    JButton btnEdit = new JButton(ResourceUtilities.getUILabel("EDIT_BUTTON"));
    JButton btnDelete = new JButton(ResourceUtilities.getUILabel("DELETE_BUTTON"));
    ComputeFieldTableModel tableModel = new ComputeFieldTableModel();
    String m_panelDescriptionResourceKey;

    public ComputeFieldSettingsPanel(ComputeFieldSettingsState computeFieldSettingsState) throws Exception {
        super(computeFieldSettingsState);
        this.m_state = computeFieldSettingsState;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("COMPUTEFIELD_SETTINGS_PAGE_DESCRIPTION"));
        this.mlblStepDescription.setPreferredAspectRatio(0.0f);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n, 0, 4, 2, 1);
        n += n + 2;
        this.tblComputedFields.setAutoCreateColumnsFromModel(false);
        this.tblComputedFields.setModel(this.tableModel);
        DefaultTableCellRenderer defaultTableCellRenderer = new DefaultTableCellRenderer();
        defaultTableCellRenderer.setHorizontalAlignment(2);
        TableColumn tableColumn = new TableColumn(0, 50, defaultTableCellRenderer, null);
        this.tblComputedFields.addColumn(tableColumn);
        tableColumn = new TableColumn(1, 50, defaultTableCellRenderer, null);
        this.tblComputedFields.addColumn(tableColumn);
        this.scrTablePane.getViewport().add(this.tblComputedFields);
        this.addFilledComponent(this.scrTablePane, MIDLABELITEMINSETS, n, 1, 2, 7, 1);
        this.btnAdd.setMnemonic(ResourceUtilities.getUIMnemonic("NEW_BUTTON"));
        this.btnEdit.setMnemonic(ResourceUtilities.getUIMnemonic("EDIT_BUTTON"));
        this.btnDelete.setMnemonic(ResourceUtilities.getUIMnemonic("DELETE_BUTTON"));
        this.addFilledComponent(this.btnAdd, TOPLABELITEMINSETS, n++, 4, 1, 1, 2);
        this.addFilledComponent(this.btnEdit, TOPLABELITEMINSETS, n++, 4, 1, 1, 2);
        this.addFilledComponent(this.btnDelete, TOPLABELITEMINSETS, n++, 4, 1, 1, 2);
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComputeFieldSettingsPanel.this.btnAdd_actionPerformed(actionEvent);
            }
        });
        this.btnEdit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComputeFieldSettingsPanel.this.btnEdit_actionPerformed(actionEvent);
            }
        });
        this.btnDelete.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ComputeFieldSettingsPanel.this.btnDelete_actionPerformed(actionEvent);
            }
        });
    }

    public void init() {
        this.loadDefaultValues();
    }

    private void btnAdd_actionPerformed(ActionEvent actionEvent) {
        String string = "NEWCOL" + fieldCounter++;
        ExpressionBuilderDialog expressionBuilderDialog = this.showExpressionDialog(string, "", this.tableModel);
        if (!expressionBuilderDialog.isOk()) {
            return;
        }
        ComputeFieldEntry computeFieldEntry = new ComputeFieldEntry(expressionBuilderDialog.getAttributeName(), expressionBuilderDialog.getExpression());
        this.tableModel.addEntry(computeFieldEntry);
    }

    private void btnEdit_actionPerformed(ActionEvent actionEvent) {
        if (this.tblComputedFields.getSelectedRowCount() > 1) {
            JOptionPane.showOptionDialog(this, ResourceUtilities.getUILabel("COMPUTEFIELD_SETTINGS_SELECT_SINGLE_ITEM"), ResourceUtilities.getUILabel("WARNING_DIALOG_TITLE"), 2, -1, null, null, null);
            return;
        }
        if (this.tblComputedFields.getSelectedRowCount() == 0) {
            JOptionPane.showOptionDialog(this, ResourceUtilities.getUILabel("COMPUTEFIELD_SETTINGS_SELECT_AN_ITEM"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), -1, 0, null, null, null);
            return;
        }
        if (this.tblComputedFields.getSelectedRowCount() == 1) {
            DefaultListSelectionModel defaultListSelectionModel = (DefaultListSelectionModel)this.tblComputedFields.getSelectionModel();
            int n = this.tblComputedFields.getSelectedRow();
            ComputeFieldEntry computeFieldEntry = this.tableModel.getFieldEntry(n);
            ExpressionBuilderDialog expressionBuilderDialog = this.showExpressionDialog(computeFieldEntry.getName(), computeFieldEntry.getValue(), this.tableModel);
            if (!expressionBuilderDialog.isOk()) {
                return;
            }
            ComputeFieldEntry computeFieldEntry2 = new ComputeFieldEntry(expressionBuilderDialog.getAttributeName(), expressionBuilderDialog.getExpression());
            this.tableModel.setFieldEntryAt(n, computeFieldEntry2);
            defaultListSelectionModel.setSelectionInterval(n, n);
            this.tblComputedFields.setSelectionModel(defaultListSelectionModel);
        }
    }

    private void btnDelete_actionPerformed(ActionEvent actionEvent) {
        int[] nArray = this.tblComputedFields.getSelectedRows();
        if (nArray.length > 0) {
            int n = JOptionPane.showConfirmDialog(this, ResourceUtilities.getUILabel("COMPUTEFIELD_SETTINGS_DELETE_ITEM"), ResourceUtilities.getUILabel("INFORMATIONAL_DIALOG_TITLE"), 0, 3);
            if (0 == n) {
                this.tableModel.deleteEntries(nArray);
            }
        } else {
            JOptionPane.showOptionDialog(this, ResourceUtilities.getUILabel("COMPUTEFIELD_SETTINGS_SELECT_ITEM_DELETE"), ResourceUtilities.getUILabel("ERROR_DIALOG_TITLE"), -1, 0, null, null, null);
        }
    }

    public void reinit() {
        this.init();
    }

    protected void loadDefaultValues() {
        if (this.m_state != null) {
            this.m_state.clear();
            this.tableModel = new ComputeFieldTableModel();
            this.tblComputedFields.setModel(this.tableModel);
        }
    }

    public void clear() {
        this.loadDefaultValues();
    }

    protected void processUserInput() {
        try {
            if (this.m_state != null) {
                ComputeFieldEntry[] computeFieldEntryArray = this.tableModel.getFieldEntries();
                this.m_state.setAttributes(computeFieldEntryArray);
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private ExpressionBuilderDialog showExpressionDialog(String string, String string2, ComputeFieldTableModel computeFieldTableModel) {
        DataState dataState = (DataState)this.m_state.getDataState();
        String string3 = dataState.getSelectedSchemaName();
        String string4 = dataState.getSelectedTableName();
        String[] stringArray = computeFieldTableModel.getFieldNames();
        ComputeFieldContext computeFieldContext = new ComputeFieldContext(string3, string4, string, string2, stringArray);
        ExpressionBuilderDialog expressionBuilderDialog = new ExpressionBuilderDialog(computeFieldContext);
        expressionBuilderDialog.setModal(true);
        expressionBuilderDialog.setVisible(true);
        return expressionBuilderDialog;
    }
}

