/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.util.Hashtable;
import java.util.Vector;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import oracle.dmt.dm4j.browser.viewer.activity.ActivityIconManager;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenWarningsTableModel;
import oracle.dmt.dm4j.wizard.steps.transformsteps.CodeGenResultsDetailsPanel;

public class CodeGenWarningsTable
extends JTable {
    private static Hashtable m_htColumnWidth = new Hashtable();
    private CodeGenResultsDetailsPanel m_parentPanel;
    private SeverityRenderer _severityColRenderer = new SeverityRenderer();

    public CodeGenWarningsTable(TableModel tableModel, CodeGenResultsDetailsPanel codeGenResultsDetailsPanel) {
        super(tableModel);
        this.m_parentPanel = codeGenResultsDetailsPanel;
        this.setSelectionMode(0);
    }

    public TableCellRenderer getCellRenderer(int n, int n2) {
        if (n2 == 0) {
            return this._severityColRenderer;
        }
        return super.getCellRenderer(n, n2);
    }

    public TableCellEditor getCellEditor(int n, int n2) {
        return super.getCellEditor(n, n2);
    }

    public Vector getSelectedIndexes() {
        int[] nArray = this.getSelectedRows();
        Vector<Integer> vector = new Vector<Integer>();
        for (int i = 0; i < nArray.length; ++i) {
            vector.add(new Integer(nArray[i]));
        }
        return vector;
    }

    public void resizeColumns() throws Exception {
        int n = this.getColumnCount();
        if (n == 0) {
            return;
        }
        for (int i = 0; i < n; ++i) {
            TableColumn tableColumn = this.getColumnModel().getColumn(i);
            Integer n2 = (Integer)m_htColumnWidth.get(new Integer(i));
            if (n2 == null) {
                throw new Exception();
            }
            tableColumn.setPreferredWidth(n2);
            tableColumn.setMinWidth(n2);
            tableColumn.setMaxWidth(n2);
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        super.valueChanged(listSelectionEvent);
        if (this.m_parentPanel != null) {
            this.m_parentPanel.valueChanged(listSelectionEvent);
        }
    }

    static {
        m_htColumnWidth.put(new Integer(CodeGenWarningsTableModel.CG_ACTIVITY_ICON_COLUMN), new Integer(140));
        m_htColumnWidth.put(new Integer(CodeGenWarningsTableModel.CG_ACTIVITY_NAME_COLUMN), new Integer(300));
        m_htColumnWidth.put(new Integer(CodeGenWarningsTableModel.CG_ACTIVITY_TYPE_COLUMN), new Integer(140));
    }

    class SeverityRenderer
    extends DefaultTableCellRenderer {
        private Icon _iconError;
        private Icon _iconWarning;
        private Icon _iconComplete;

        public SeverityRenderer() {
            ActivityIconManager activityIconManager = ActivityIconManager.getInstance();
            this._iconError = activityIconManager.getIcon("FAILED");
            this._iconWarning = activityIconManager.getIcon("WARNING");
            this._iconComplete = activityIconManager.getIcon("COMPLETE");
        }

        public void setValue(Object object) {
            String string = (String)object;
            if (string.equals(CodeGenWarningsTableModel.ERROR_ICON)) {
                this.setIcon(this._iconError);
                this.setText(CodeGenWarningsTableModel.ERROR_ICON);
            } else if (string.equals(CodeGenWarningsTableModel.WARNING_ICON)) {
                this.setIcon(this._iconWarning);
                this.setText(CodeGenWarningsTableModel.WARNING_ICON);
            } else {
                this.setIcon(this._iconComplete);
                this.setText(CodeGenWarningsTableModel.OK_ICON);
            }
        }
    }
}

