/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Insets;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.TableModel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.dmt.dm4j.datasources.CodeGenDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transforms.CodeGenState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenResultsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenWarningsTableModel;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.commonsteps.TableSorter;
import oracle.dmt.dm4j.wizard.steps.transformsteps.CodeGenWarningsTable;
import oracle.dmt.dm4j.wizard.validation.StateValidation;

public class CodeGenResultsDetailsPanel
extends DM4JStep {
    private MultiLineLabel mlblStepDescription = new MultiLineLabel();
    private CodeGenDataSource m_dataSource;
    private CodeGenWarningsTable m_table = null;
    private JScrollPane m_tableScroller = new JScrollPane();
    private JLabel m_lblDetails = new JLabel();
    private JTextArea m_edDetails = new JTextArea(3, 40);

    public CodeGenResultsDetailsPanel(CodeGenResultsState codeGenResultsState) throws Exception {
        super(codeGenResultsState);
        try {
            CodeGenState codeGenState = (CodeGenState)this.getparentWizardState();
            this.m_dataSource = codeGenState.getDataSource();
            this.jbInit();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("CODE_GEN_RESULTS_WARNINGS_GENERATED"));
        this.addFilledComponent((JComponent)this.mlblStepDescription, new Insets(1, 1, 19, 1), n++, 0, 3, 1, 1);
        TableSorter tableSorter = ((CodeGenResultsState)this.m_state).getTableModel();
        this.m_table = new CodeGenWarningsTable((TableModel)tableSorter, this);
        tableSorter.setTableHeader(this.m_table.getTableHeader());
        this.m_tableScroller.getViewport().add(this.m_table);
        this.addFilledComponent(this.m_tableScroller, new Insets(1, 1, 1, 1), n, 0, 3, 5, 1);
        n += 5;
        this.m_lblDetails.setText(ResourceUtilities.getUILabel("CODE_GEN_ACTIVITY_DETAILS"));
        this.m_lblDetails.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("CODE_GEN_ACTIVITY_DETAILS"));
        this.m_lblDetails.setLabelFor(this.m_edDetails);
        JScrollPane jScrollPane = new JScrollPane();
        jScrollPane.getViewport().add(this.m_edDetails);
        this.m_edDetails.setWrapStyleWord(true);
        this.m_edDetails.setEditable(false);
        this.addComponent(this.m_lblDetails, new Insets(5, 1, 1, 1), n++, 0, 1, 1, 12, 2);
        this.addComponent(jScrollPane, new Insets(1, 1, 1, 1), n++, 0, 3, 3, 12, 1);
    }

    public void load() throws Exception {
        this.init();
    }

    public void init() {
        try {
            this.m_table.resizeColumns();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        int n = this.m_table.getSelectedRow();
        TableSorter tableSorter = ((CodeGenResultsState)this.m_state).getTableModel();
        TableModel tableModel = tableSorter.getTableModel();
        String string = (String)tableModel.getValueAt(n, CodeGenWarningsTableModel.CG_ACTIVITY_NAME_COLUMN);
        this.m_lblDetails.setText(ResourceUtilities.getUILabel("CODE_GEN_ACTIVITY_DETAILS") + " " + string);
        HashMap hashMap = ((CodeGenResultsState)this.m_state).getExceptions();
        this.m_edDetails.setText("");
        if (hashMap == null || hashMap.isEmpty()) {
            this.m_edDetails.setText(ResourceUtilities.getUILabel("CODE_GEN_RESULTS_SUCCESFULLY_GENERATED_CODE_FOR_ACTIVITY"));
            return;
        }
        Vector vector = (Vector)hashMap.get(string);
        if (vector == null || vector.isEmpty()) {
            this.m_edDetails.setText(ResourceUtilities.getUILabel("CODE_GEN_RESULTS_SUCCESFULLY_GENERATED_CODE_FOR_ACTIVITY"));
            return;
        }
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < vector.size(); ++i) {
            StateValidation stateValidation = (StateValidation)vector.elementAt(i);
            stringBuffer.append(stateValidation.getDescription());
            stringBuffer.append("\n");
        }
        this.m_edDetails.setText(stringBuffer.toString());
    }
}

