/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.transformsteps;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import java.util.Vector;
import javax.swing.JComponent;
import javax.swing.JLabel;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.NumberTextField;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.dialogs.DM4JEvent;
import oracle.dmt.dm4j.wizard.dialogs.DialogUtilities;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.transformsteps.BaseSampleSettingsState;

public class AdvancedStratifiedSettingsPanel
extends GriddedPanel {
    protected DM4JDialog m_parentDialog;
    protected BaseSampleSettingsState m_state = null;
    protected MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblRandomNumberSeed = new JLabel();
    NumberTextField fldRandomNumberSeed = new NumberTextField();

    public AdvancedStratifiedSettingsPanel(DM4JDialog dM4JDialog, BaseSampleSettingsState baseSampleSettingsState) throws Exception {
        this.m_parentDialog = dM4JDialog;
        this.m_state = baseSampleSettingsState;
        this.loadValues();
        this.jbInit();
    }

    protected void loadValues() {
        if (this.m_state != null) {
            this.fldRandomNumberSeed.setNumber((Number)this.m_state.getRandomSeed());
        }
    }

    protected void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel("SAMPLE_ADVANCED_STRATIFIED_SETTINGS_DIALOG_DESCRIPTION"));
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.mlblStepDescription.setPreferredRows(1);
        this.mlblStepDescription.setMinimumRows(1);
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblRandomNumberSeed = new JLabel(ResourceUtilities.getUILabel("SAMPLE_SETTINGS_RANDOM_NUMBER_SEED"));
        this.fldRandomNumberSeed.setColumns(30);
        this.lblRandomNumberSeed.setLabelFor((Component)this.fldRandomNumberSeed);
        this.lblRandomNumberSeed.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("SAMPLE_SETTINGS_RANDOM_NUMBER_SEED"));
        this.addComponent(this.lblRandomNumberSeed, COL1_LABEL, n, 0);
        this.fldRandomNumberSeed.setLocale(Locale.getDefault());
        this.fldRandomNumberSeed.setDataType(Integer.TYPE);
        this.fldRandomNumberSeed.setSigned(false);
        this.addFilledComponent((JComponent)this.fldRandomNumberSeed, COL_VALUE, n, 1);
        this.addOKHelpCancelListeners();
    }

    protected void addOKHelpCancelListeners() {
        this.m_parentDialog.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                AdvancedStratifiedSettingsPanel.this.m_parentDialog_actionPerformed(actionEvent);
            }
        });
    }

    protected void m_parentDialog_actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("ok" == string) {
            Vector vector = new Vector();
            try {
                DM4JEvent dM4JEvent = (DM4JEvent)actionEvent;
                DialogUtilities.displayValidations(vector, dM4JEvent, this.m_parentDialog);
                if (vector.isEmpty()) {
                    this.processUserInput();
                }
            }
            catch (Exception exception) {
                System.out.println(exception.getMessage());
            }
        }
    }

    protected void processUserInput() {
        if (this.m_state != null) {
            this.m_state.setRandomSeed((Integer)this.fldRandomNumberSeed.getNumber());
        }
    }
}

