/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.miningsteps;

import oracle.dmt.dm4j.wizard.DM4JWizardHelp;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.minings.ExplainState;
import oracle.dmt.dm4j.wizard.state.minings.PredictState;
import oracle.dmt.dm4j.wizard.state.minings.WizardState;
import oracle.dmt.dm4j.wizard.state.miningsteps.TargetState;
import oracle.dmt.dm4j.wizard.steps.minings.DM4JPage;
import oracle.dmt.dm4j.wizard.steps.minings.StepType;
import oracle.dmt.dm4j.wizard.steps.miningsteps.TargetPanel;

public class TargetPage
extends DM4JPage {
    private TargetPanel m_targetPanel;
    private TargetState m_targetState;

    public TargetPage(WizardState wizardState, StepType stepType) throws Exception {
        super(wizardState);
        this.setStepType(stepType);
        this.create(wizardState);
        this.m_stepPanel = this.m_targetPanel;
        this.setWizardStepState(this.m_targetState);
        DM4JWizardHelp.registerTopic(this.getContent(), "dm4j_build_target_html");
    }

    private void create(WizardState wizardState) throws Exception {
        if (wizardState instanceof PredictState) {
            this.setLabel(ResourceUtilities.getUILabel("TARGET_STEP_NAME"));
            this.setImage(wizardState.getImage());
            this.m_targetState = new TargetState(wizardState, "TARGET_STEP_NAME", (StepType)this.getStepType());
            wizardState.addStep(this.getStepType(), this.m_targetState);
            this.m_targetPanel = new TargetPanel(wizardState, this.m_targetState, "TARGET_STEP_DESCRIPTION");
        } else if (wizardState instanceof ExplainState) {
            this.setLabel(ResourceUtilities.getUILabel("EXPLAIN_TARGET_STEP_NAME"));
            this.setImage(wizardState.getImage());
            this.m_targetState = new TargetState(wizardState, "EXPLAIN_TARGET_STEP_NAME", (StepType)this.getStepType());
            wizardState.addStep(this.getStepType(), this.m_targetState);
            this.m_targetPanel = new TargetPanel(wizardState, this.m_targetState, "EXPLAIN_TARGET_STEP_DESCRIPTION");
        } else {
            this.setLabel(ResourceUtilities.getUILabel("TARGET_STEP_NAME"));
            this.setImage(wizardState.getImage());
            this.m_targetState = new TargetState(wizardState, "TARGET_STEP_NAME", (StepType)this.getStepType());
            wizardState.addStep(this.getStepType(), this.m_targetState);
            this.m_targetPanel = new TargetPanel(wizardState, this.m_targetState, "TARGET_STEP_DESCRIPTION");
        }
        this.setInteractiveArea(this.m_targetPanel);
        TargetPanel targetPanel = (TargetPanel)this.getInteractiveArea();
        this.addWizardValidateListener(targetPanel);
    }
}

