/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.commonsteps;

import java.awt.Cursor;
import java.awt.Frame;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.DefaultComboBoxModel;
import oracle.bali.ewt.selection.OneDSelection;
import oracle.bali.ewt.table.SpreadTable;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LocalXMLDataSource;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CategoricDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeFrequency;
import oracle.dmt.dm4j.datasources.SummarizeDataSource;
import oracle.dmt.dm4j.wizard.dialogs.DM4JDialog;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricalDiscretizationSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationDataUsageState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierDataUsageState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.commonsteps.BaseHistogramPanel;
import oracle.dmt.odm.binning.BackupData;
import oracle.dmt.odm.binning.BinningType;
import oracle.dmt.odm.binning.CategoricBin;
import oracle.dmt.odm.binning.CategoricalBackupData;
import oracle.dss.graph.Graph;
import oracle.dss.util.DataSource;

public class HistogramPanel
extends BaseHistogramPanel {
    private WizardState m_state = null;
    private Connection m_conn = null;
    private SpreadTable m_spreadTable;
    private int m_selectedRow = -1;
    private DiscretizeDataSource m_dataSourcemodel = null;
    private String m_samplingView = null;
    private boolean m_brestore = false;
    private Cursor m_originalCursor = this.getCursor();

    public HistogramPanel(DM4JDialog dM4JDialog, WizardState wizardState, SpreadTable spreadTable, Graph graph) throws Exception {
        super(dM4JDialog, graph);
        this.m_state = wizardState;
        this.m_conn = this.m_state.getConnection();
        this.m_spreadTable = spreadTable;
        this.jbInit();
        if (this.m_brestore) {
            this.partialRestoreAttrubuteValues();
        }
    }

    public HistogramPanel(DM4JDialog dM4JDialog, Connection connection, DiscretizeDataSource discretizeDataSource, SpreadTable spreadTable, Graph graph, String string) throws Exception {
        super(dM4JDialog, graph);
        this.m_conn = connection;
        this.m_dataSourcemodel = discretizeDataSource;
        this.m_spreadTable = spreadTable;
        this.m_graph = graph;
        this.m_samplingView = string;
        this.jbInit();
        if (this.m_brestore) {
            this.partialRestoreAttrubuteValues();
        }
    }

    public HistogramPanel(Frame frame, Connection connection, DiscretizeDataSource discretizeDataSource, SpreadTable spreadTable, Graph graph, String string) throws Exception {
        super(frame, graph);
        this.m_conn = connection;
        this.m_dataSourcemodel = discretizeDataSource;
        this.m_spreadTable = spreadTable;
        this.m_graph = graph;
        this.m_samplingView = string;
        this.jbInit();
        if (this.m_brestore) {
            this.partialRestoreAttrubuteValues();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void reloadState() {
        WizardStepState wizardStepState;
        WizardStepState wizardStepState2 = null;
        if (this.m_state != null && (wizardStepState2 = this.m_state.getStep(StepType.DATA_USAGE_STEP)) != null) {
            if (wizardStepState2 instanceof DiscretizationDataUsageState) {
                wizardStepState = (DiscretizationDataUsageState)wizardStepState2;
                this.m_dataSourcemodel = ((DiscretizationDataUsageState)wizardStepState).isHistogramNumeric() ? ((DiscretizationDataUsageState)wizardStepState).getNumericModel() : ((DiscretizationDataUsageState)wizardStepState).getCategoricModel();
            } else if (wizardStepState2 instanceof OutlierDataUsageState) {
                wizardStepState = (OutlierDataUsageState)wizardStepState2;
                this.m_dataSourcemodel = ((OutlierDataUsageState)wizardStepState).getNumericModel();
            }
        }
        if (this.m_dataSourcemodel == null) {
            return;
        }
        this.m_attributeName = (String)this.comboAttributeName.getSelectedItem();
        this.m_selectedRow = this.m_dataSourcemodel.getAttributeRow(this.m_attributeName);
        if (this.m_selectedRow == -1) {
            return;
        }
        this.collectBackupData();
        this.m_brestore = false;
        try {
            this.setDialogBusy(true);
            if (wizardStepState2 != null) {
                if (wizardStepState2 instanceof DiscretizationDataUsageState) {
                    wizardStepState = (DiscretizationDataUsageState)wizardStepState2;
                    this.m_brestore = !((DiscretizationDataUsageState)wizardStepState).isHistogramNumeric() ? this.doTopNBinning() : this.doQtileBinning();
                } else if (wizardStepState2 instanceof OutlierDataUsageState) {
                    this.doOutlierQtileBinning();
                }
            } else if (!this.m_dataSourcemodel.isNumeric(this.m_selectedRow)) {
                this.m_brestore = this.doSummarizationTopNBinning();
            } else {
                this.doEqualBinning();
                this.m_brestore = true;
            }
            this.m_BinningType = this.m_dataSourcemodel.getBinningType(this.m_selectedRow).getName();
        }
        finally {
            this.setDialogBusy(false);
        }
        this.runTimePanelLoad();
        this.updateUIStats();
        if (this.m_brestore) {
            this.partialRestoreAttrubuteValues();
        }
    }

    protected void collectBackupData() {
        this.m_backupData = this.m_dataSourcemodel instanceof CategoricDiscretizeDataSource ? new CategoricalBackupData((CategoricDiscretizeDataSource)this.m_dataSourcemodel, this.m_selectedRow) : new BackupData(this.m_dataSourcemodel, this.m_selectedRow);
    }

    protected void restoreAttrubuteValues() {
        this.m_selectedRow = this.m_dataSourcemodel instanceof CategoricDiscretizeDataSource ? ((CategoricalBackupData)this.m_backupData).restoreBackupData((CategoricDiscretizeDataSource)this.m_dataSourcemodel) : ((BackupData)this.m_backupData).restoreBackupData(this.m_dataSourcemodel);
    }

    protected void partialRestoreAttrubuteValues() {
        this.m_selectedRow = this.m_dataSourcemodel instanceof CategoricDiscretizeDataSource ? ((CategoricalBackupData)this.m_backupData).partialRestoreBackupData((CategoricDiscretizeDataSource)this.m_dataSourcemodel) : ((BackupData)this.m_backupData).partialRestoreBackupData(this.m_dataSourcemodel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doSummarizationTopNBinning() {
        SummarizeDataSource summarizeDataSource = (SummarizeDataSource)this.m_dataSourcemodel;
        if (!summarizeDataSource.isAttributeBinned(this.m_selectedRow)) {
            Integer n = summarizeDataSource.getNumberOfBins(this.m_selectedRow);
            if (n != null && n == 0) {
                n = null;
            }
            int n2 = n != null ? n : DiscretizeDataSource.DEFAULT_BIN_NUMBER;
            summarizeDataSource.markAttributeBinned(this.m_selectedRow, BinningType.TOPN, n2);
            Integer n3 = summarizeDataSource.getDistinctCount(this.m_selectedRow);
            if (n3 != null && n3 < n2) {
                n2 = n3;
            }
            summarizeDataSource.setNumberOfBins(this.m_selectedRow, n2);
            try {
                this.setCursor(new Cursor(3));
                summarizeDataSource.getTopNStats(this.m_selectedRow, n2);
            }
            finally {
                this.setCursor(new Cursor(0));
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean doTopNBinning() {
        boolean bl = false;
        CategoricDiscretizeDataSource categoricDiscretizeDataSource = (CategoricDiscretizeDataSource)this.m_dataSourcemodel;
        if (!categoricDiscretizeDataSource.isAttributeBinned(this.m_selectedRow)) {
            bl = true;
            Integer n = categoricDiscretizeDataSource.getNumberOfBins(this.m_selectedRow);
            if (n != null && n == 0) {
                n = null;
            }
            int n2 = n != null ? n : CategoricDiscretizeDataSource.DEFAULT_BIN_NUMBER;
            categoricDiscretizeDataSource.markAttributeBinned(this.m_selectedRow, BinningType.TOPN, n2);
            Integer n3 = categoricDiscretizeDataSource.getDistinctValue(this.m_selectedRow);
            if (n3 != null && n3 < n2) {
                n2 = n3;
            }
            categoricDiscretizeDataSource.setNumberOfBins(this.m_selectedRow, n2);
            try {
                this.setCursor(new Cursor(3));
                categoricDiscretizeDataSource.getTopNStats(this.m_selectedRow, n2);
            }
            finally {
                this.setCursor(new Cursor(0));
            }
            if (this.m_state != null) {
                CategoricalDiscretizationSettingsState categoricalDiscretizationSettingsState = (CategoricalDiscretizationSettingsState)this.m_state.getStep(StepType.SETTING_STEP_2);
                categoricalDiscretizationSettingsState.invalidate();
            }
        }
        return bl;
    }

    protected void doEqualBinning() {
        if (!this.m_dataSourcemodel.isAttributeBinned(this.m_selectedRow) && this.m_dataSourcemodel.isNumeric(this.m_selectedRow)) {
            double d;
            double d2;
            Object object;
            Integer n = this.m_dataSourcemodel.getNumberOfBins(this.m_selectedRow);
            if (n != null && n == 0) {
                n = null;
            }
            int n2 = n != null ? n : DiscretizeDataSource.DEFAULT_BIN_NUMBER;
            this.m_dataSourcemodel.markAttributeBinned(this.m_selectedRow, BinningType.EQ_WIDTH, n2);
            this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, n2);
            this.m_dataSourcemodel.setTailPercent(this.m_selectedRow, DiscretizeDataSource.DEFAULT_TAIL_PERCENT);
            Double d3 = this.m_dataSourcemodel.getMin(this.m_selectedRow);
            Double d4 = this.m_dataSourcemodel.getMax(this.m_selectedRow);
            if (d3 == null || d4 == null) {
                object = this.m_dataSourcemodel.getEqualWidthStats(this.m_attributeName, null);
                this.m_dataSourcemodel.set1stOrderStatistics(this.m_selectedRow, (double[])object);
                d2 = object[DiscretizeDataSource.STAT_MIN];
                d = object[DiscretizeDataSource.STAT_MAX];
            } else {
                d2 = d3;
                d = d4;
            }
            object = this.m_dataSourcemodel.getEqualWidthBounds(d2, d, n2);
            this.m_dataSourcemodel.setBinBounds(this.m_selectedRow, (Vector)object);
            if (this.m_state != null) {
                DiscretizationSettingsState discretizationSettingsState = (DiscretizationSettingsState)this.m_state.getStep(StepType.SETTING_STEP_1);
                discretizationSettingsState.invalidate();
            }
        }
    }

    protected boolean doQtileBinning() {
        boolean bl = false;
        if (!this.m_dataSourcemodel.isAttributeBinned(this.m_selectedRow)) {
            bl = true;
            if (this.m_dataSourcemodel.isNumeric(this.m_selectedRow)) {
                Integer n = this.m_dataSourcemodel.getNumberOfBins(this.m_selectedRow);
                if (n != null && n == 0) {
                    n = null;
                }
                int n2 = n != null ? n : DiscretizeDataSource.DEFAULT_BIN_NUMBER;
                this.m_dataSourcemodel.markAttributeBinned(this.m_selectedRow, BinningType.QTILE, n2);
                this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, n2);
                this.m_dataSourcemodel.getHistogramQuantileBinning(this.m_selectedRow, new Integer(n2), true);
                if (this.m_state != null) {
                    DiscretizationSettingsState discretizationSettingsState = (DiscretizationSettingsState)this.m_state.getStep(StepType.SETTING_STEP_1);
                    discretizationSettingsState.invalidate();
                }
            }
        }
        return bl;
    }

    protected void doOutlierQtileBinning() {
        if (this.m_dataSourcemodel.isNumeric(this.m_selectedRow)) {
            this.m_dataSourcemodel.markAttributeUnBinned(this.m_selectedRow);
            int n = DiscretizeDataSource.DEFAULT_BIN_NUMBER;
            this.m_dataSourcemodel.markAttributeBinned(this.m_selectedRow, BinningType.QTILE, n);
            this.m_dataSourcemodel.setNumberOfBins(this.m_selectedRow, n);
            this.m_dataSourcemodel.getHistogramQuantileBinning(this.m_selectedRow, new Integer(n), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadState() {
        Object object;
        WizardStepState wizardStepState = null;
        if (this.m_state != null && (wizardStepState = this.m_state.getStep(StepType.DATA_USAGE_STEP)) != null) {
            if (wizardStepState instanceof DiscretizationDataUsageState) {
                object = (DiscretizationDataUsageState)wizardStepState;
                this.m_dataSourcemodel = ((DiscretizationDataUsageState)object).isHistogramNumeric() ? ((DiscretizationDataUsageState)object).getNumericModel() : ((DiscretizationDataUsageState)object).getCategoricModel();
            } else if (wizardStepState instanceof OutlierDataUsageState) {
                object = (OutlierDataUsageState)wizardStepState;
                this.m_dataSourcemodel = ((OutlierDataUsageState)object).getNumericModel();
            }
        }
        if (this.m_dataSourcemodel == null) {
            return;
        }
        object = this.m_spreadTable.getSelection();
        if (object == null) {
            return;
        }
        OneDSelection oneDSelection = object.getRowSelection();
        if (oneDSelection == null) {
            return;
        }
        Range[] rangeArray = oneDSelection.getRanges();
        if (rangeArray == null || 1 != rangeArray.length) {
            return;
        }
        this.m_selectedRow = rangeArray[0].getLowerLimit();
        this.m_attributeName = this.m_dataSourcemodel.getAttributeName(this.m_selectedRow);
        try {
            this.setDialogBusy(true);
            this.collectBackupData();
            if (wizardStepState != null) {
                if (wizardStepState instanceof DiscretizationDataUsageState) {
                    DiscretizationDataUsageState discretizationDataUsageState = (DiscretizationDataUsageState)wizardStepState;
                    this.m_brestore = !discretizationDataUsageState.isHistogramNumeric() ? this.doTopNBinning() : this.doQtileBinning();
                } else if (wizardStepState instanceof OutlierDataUsageState) {
                    this.doOutlierQtileBinning();
                }
            } else if (!this.m_dataSourcemodel.isNumeric(this.m_selectedRow)) {
                this.m_brestore = this.doSummarizationTopNBinning();
            } else {
                this.doEqualBinning();
                this.m_brestore = true;
            }
            this.m_BinningType = this.m_dataSourcemodel.getBinningType(this.m_selectedRow).getName();
        }
        finally {
            this.setDialogBusy(false);
        }
        this.runTimePanelLoad();
        this.loadCombo();
    }

    protected void loadCombo() {
        this.m_attributeNames = new DefaultComboBoxModel<String>(this.m_dataSourcemodel.getAllAttributeNames());
        this.m_attributeNames.setSelectedItem(this.m_attributeName);
        this.comboAttributeName.setModel(this.m_attributeNames);
        this.comboAttributeName.setSelectedItem(this.m_attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runTimePanelLoad() {
        int[] nArray = null;
        try {
            int n;
            DiscretizeFrequency discretizeFrequency = new DiscretizeFrequency(this.m_conn, this.m_dataSourcemodel, this.m_selectedRow, this.m_samplingView);
            ProgressBar progressBar = new ProgressBar(this.m_parent == null ? BrowserFrame.getMainFrame() : this.m_parent, ResourceUtilities.getUILabel("HISTOGRAM_CALCULATION_DIALOG_TITLE"), discretizeFrequency, true);
            discretizeFrequency.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("HISTOGRAM_CALCULATION_DIALOG_TITLE"), ResourceUtilities.getUILabel("HISTOGRAM_CALCULATION_DIALOG_DESC"));
            if (discretizeFrequency.getException() != null) {
                this.restoreAttrubuteValues();
                nArray = null;
                if (DiscretizeDataSource.isDebug()) {
                    discretizeFrequency.getException().printStackTrace();
                }
            } else {
                if (progressBar.hasUserCancelled()) {
                    this.restoreAttrubuteValues();
                    this.m_userCancelled = true;
                    this.comboAttributeName.setSelectedItem(this.m_dataSourcemodel.getAttributeName(this.m_selectedRow));
                    return;
                }
                nArray = discretizeFrequency.getFrequency();
            }
            Hashtable hashtable = this.m_dataSourcemodel.getDisplayNames(this.m_selectedRow);
            this.histogramTableModel.deleteAllEntries();
            Object[][] objectArray = null;
            Object[] objectArray2 = null;
            if (!this.m_dataSourcemodel.isNumeric(this.m_selectedRow) && hashtable != null) {
                int n2;
                n = hashtable.size();
                objectArray = new Object[n][1];
                objectArray2 = new Object[n];
                int n3 = 0;
                for (n2 = 0; n2 < n; ++n2) {
                    objectArray[n2][0] = nArray != null ? new Integer(nArray[n2]) : new Integer(0);
                    n3 += ((Integer)objectArray[n2][0]).intValue();
                }
                for (n2 = 0; n2 < hashtable.size(); ++n2) {
                    CategoricBin categoricBin = (CategoricBin)hashtable.get(new Integer(n2));
                    objectArray2[n2] = categoricBin.category;
                    String string = categoricBin.getBinStringValues();
                    if (n2 == hashtable.size() - 1 && (string == null || string.length() == 0)) {
                        string = ResourceUtilities.getUILabel("HISTOGRAM_NULLS");
                    }
                    this.histogramTableModel.addEntry(new Object[]{categoricBin.category, string, objectArray[n2][0], this.percentageOfTotal(objectArray[n2][0], n3)});
                }
            } else {
                n = this.m_dataSourcemodel.getNumberOfNonNulls(this.m_selectedRow);
                objectArray = new Object[n + 1][1];
                objectArray2 = new Object[n + 1];
                objectArray[n][0] = new Integer(this.m_dataSourcemodel.getNullCount());
                objectArray2[n] = ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE");
                int n4 = this.m_dataSourcemodel.getNullCount();
                for (int i = 0; i < n; ++i) {
                    objectArray[i][0] = nArray != null ? new Integer(nArray[i]) : new Integer(0);
                    n4 += ((Integer)objectArray[i][0]).intValue();
                }
                Vector vector = this.m_dataSourcemodel.getBinCategories(this.m_selectedRow);
                Hashtable hashtable2 = this.m_dataSourcemodel.getMapCategorytoRange(this.m_selectedRow);
                for (int i = 0; i < n; ++i) {
                    String string = (String)vector.elementAt(i);
                    string = DiscretizeDataSource.appendSingleQuotes(string);
                    String string2 = hashtable2 != null && !hashtable2.isEmpty() ? (String)hashtable2.get(string) : string;
                    objectArray2[i] = string2;
                    this.histogramTableModel.addEntry(new Object[]{String.valueOf(i), string2, objectArray[i][0], this.percentageOfTotal(objectArray[i][0], n4)});
                }
                if (objectArray != null) {
                    this.histogramTableModel.addEntry(new Object[]{String.valueOf(n), ResourceUtilities.getUILabel("HISTOGRAM_NULL_VALUE"), objectArray[n][0], this.percentageOfTotal(objectArray[n][0], n4)});
                }
            }
            Object[] objectArray3 = new Object[]{ResourceUtilities.getUILabel("HISTOGRAM_BIN_Y_TITLE")};
            this.m_graph.getTitle().setText(ResourceUtilities.getUILabel("HISTOGRAM_BIN_TITLE") + this.m_attributeName);
            this.m_graph.getO1Title().setText(ResourceUtilities.getUILabel("HISTOGRAM_BIN_X_TITLE"));
            this.m_graph.getY1Title().setText(ResourceUtilities.getUILabel("HISTOGRAM_BIN_Y_TITLE"));
            this.m_graph.getPFJ().setDisplay(this.m_graph.getPFJ().getLegendArea(), false);
            this.m_graph.setScrollbarPresenceGroups(1);
            this.m_graph.setDataRowShownAsASeries(true);
            this.m_graph.setDataSource((DataSource)new LocalXMLDataSource(objectArray2, objectArray3, objectArray));
        }
        catch (Exception exception) {
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
    }

    protected boolean showStatistics() {
        return this.m_dataSourcemodel.isNumeric(this.m_selectedRow);
    }

    protected Double getSkew() {
        return this.m_dataSourcemodel.getSkew(this.m_selectedRow);
    }

    protected Double getKurtosis() {
        return this.m_dataSourcemodel.getKurtosis(this.m_selectedRow);
    }

    protected Double getAverage() {
        return this.m_dataSourcemodel.getAverage(this.m_selectedRow);
    }

    protected Double getMin() {
        return this.m_dataSourcemodel.getMin(this.m_selectedRow);
    }

    protected Double getMax() {
        return this.m_dataSourcemodel.getMax(this.m_selectedRow);
    }

    protected Double getVariance() {
        return this.m_dataSourcemodel.getVariance(this.m_selectedRow);
    }

    protected Double getSigma() {
        return this.m_dataSourcemodel.getSigma(this.m_selectedRow);
    }

    protected Integer getTotal() {
        return this.m_dataSourcemodel.getTotalCount(this.m_selectedRow);
    }

    protected String getMode() {
        return this.m_dataSourcemodel.getMode(this.m_selectedRow);
    }

    protected String getOriginalData() {
        return this.m_dataSourcemodel.getDataSource();
    }

    public void setDialogBusy(boolean bl) {
        if (bl) {
            this.m_originalCursor = this.getCursor();
            this.setCursor(Cursor.getPredefinedCursor(3));
        } else {
            this.setCursor(this.m_originalCursor);
        }
        if (this.m_parentDialog != null) {
            this.m_parentDialog.repaint();
        } else if (this.m_parent != null) {
            this.m_parent.repaint();
        }
    }

    protected Hashtable getDisplayNames() {
        Hashtable hashtable = null;
        try {
            hashtable = this.m_dataSourcemodel.getDisplayNames(this.m_selectedRow);
        }
        catch (Exception exception) {
            hashtable = null;
        }
        return hashtable;
    }
}

