/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.commonsteps;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Locale;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import oracle.bali.ewt.button.DialogButtonBar;
import oracle.bali.ewt.table.SpreadTable;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.GriddedPanel;
import oracle.dmt.dm4j.browser.IconManager;
import oracle.dmt.dm4j.browser.viewer.summarization.DataSummarizationCommonViewer;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.steps.commonsteps.BaseHistogramPanel;
import oracle.dmt.dm4j.wizard.steps.commonsteps.HistogramPanel;
import oracle.dmt.jdm.resource.OraConnection;
import oracle.dss.graph.Graph;
import oracle.dss.util.DefaultErrorHandler;
import oracle.dss.util.ErrorHandler;
import oracle.help.CSHManager;
import oracle.help.Help;

public class HistogramFrame
extends JFrame {
    private OraConnection m_jdmConnection;
    private Graph m_graph = null;
    private DiscretizeDataSource m_dataSourcemodel;
    private SpreadTable m_spreadTable;
    private String m_samplingView;
    private BaseHistogramPanel m_panel;
    private DialogButtonBar m_bar = new DialogButtonBar();
    private JButton m_ok;
    private JButton m_help;
    private GridBagConstraints constraints;
    private UIListener _listener = new UIListener();
    private CSHManager m_helpCxtMgr = null;
    private String m_okText = ResourceUtilities.getUILabel("DATA_SUMMARIZATION_HISTOGRAM_OK");
    private String m_helpText = ResourceUtilities.getUILabel("DATA_SUMMARIZATION_HELP");
    private DataSummarizationCommonViewer m_parentFrame;

    public boolean isUserCancelled() {
        if (this.m_panel != null) {
            return this.m_panel.isUserCancelled();
        }
        return false;
    }

    public HistogramFrame(DataSummarizationCommonViewer dataSummarizationCommonViewer, DiscretizeDataSource discretizeDataSource, SpreadTable spreadTable, String string) throws Exception {
        this.m_parentFrame = dataSummarizationCommonViewer;
        this.m_dataSourcemodel = discretizeDataSource;
        this.m_spreadTable = spreadTable;
        this.m_samplingView = string;
        this.jbInit();
    }

    private void jbInit() throws Exception {
        this.addWindowListener(new WindowAdapter(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void windowClosing(WindowEvent windowEvent) {
                if (null != HistogramFrame.this.m_graph) {
                    HistogramFrame.this.m_graph.cleanUp();
                    HistogramFrame.this.m_graph = null;
                }
                HistogramFrame.this.m_parentFrame.removeHistogram(HistogramFrame.this);
                if (HistogramFrame.this.m_jdmConnection != null) {
                    try {
                        HistogramFrame.this.m_jdmConnection.close();
                    }
                    catch (Exception exception) {}
                }
                Window window = windowEvent.getWindow();
                window.setVisible(false);
                window.dispose();
            }
        });
        this.m_jdmConnection = (OraConnection)DM4JConnectionManager.getConnection();
        ImageIcon imageIcon = (ImageIcon)IconManager.createIcon("oracle/dmt/dm4j/browser/resource/images/client.gif");
        this.setIconImage(imageIcon.getImage());
        this.getContentPane().setLayout(new GridBagLayout());
        this.constraints = new GridBagConstraints();
        this.constraints.anchor = 18;
        this.setSize(new Dimension(BaseHistogramPanel.WIDTH, BaseHistogramPanel.HEIGHT));
        this.setTitle(ResourceUtilities.getUILabel("HISTOGRAM_DIALOG_TITLE"));
        Help.registerClientWindow((Window)this);
        this.m_helpCxtMgr = BrowserFrame.getCSHManager();
        this.m_helpCxtMgr.addComponent((Component)this, "dm4j_histogram_html", true, false);
        if (null == this.m_graph) {
            DefaultErrorHandler defaultErrorHandler = new DefaultErrorHandler();
            defaultErrorHandler.setDebugMode(0);
            this.m_graph = new Graph((ErrorHandler)defaultErrorHandler);
            this.m_graph.setLocale(Locale.getDefault());
            this.m_graph.setGraphType(17);
            this.m_graph.setAutoLayout(2);
            this.m_graph.getPFJ().setDisplay(this.m_graph.getPFJ().getLegendArea(), false);
        }
        this.m_panel = new HistogramPanel(this, this.m_jdmConnection.getDatabaseConnection(), this.m_dataSourcemodel, this.m_spreadTable, this.m_graph, this.m_samplingView);
        if (!this.m_panel.isUserCancelled()) {
            this.addComponent(this.m_panel, GriddedPanel.MIDLABELITEMINSETS, 0, 0, 6, 9, 18, 1);
            this.m_ok = new JButton(this.m_okText);
            this.m_ok.setDefaultCapable(true);
            this.m_ok.setActionCommand("OK");
            this.m_ok.addActionListener(this._listener);
            this.m_bar.add((Component)this.m_ok, DialogButtonBar.CONSTRAINT_YES);
            this.m_help = new JButton(this.m_helpText);
            this.m_help.setDefaultCapable(false);
            this.m_help.setMnemonic(ResourceUtilities.getUIMnemonic("DATA_SUMMARIZATION_HELP"));
            this.m_help.setActionCommand("Help");
            this.m_help.addActionListener(this._listener);
            this.m_bar.add((Component)this.m_help, DialogButtonBar.CONSTRAINT_HELP);
            this.addComponent((JComponent)this.m_bar, GriddedPanel.BOTTOM_RELATED_CONTROL, 9, 0, 6, 1, 18, 1);
        }
    }

    private void addComponent(JComponent jComponent, Insets insets, int n, int n2, int n3, int n4, int n5, int n6) {
        this.constraints.gridx = n2;
        this.constraints.gridy = n;
        this.constraints.gridwidth = n3;
        this.constraints.gridheight = n4;
        this.constraints.anchor = n5;
        this.constraints.insets = insets;
        double d = 0.0;
        double d2 = 0.0;
        if (n3 > 1) {
            d = (double)n3 / 10.0;
        }
        if (n4 > 1) {
            d2 = (double)n4 / 10.0;
        }
        switch (n6) {
            case 2: {
                this.constraints.weightx = d;
                this.constraints.weighty = 0.0;
                break;
            }
            case 3: {
                this.constraints.weighty = d2;
                this.constraints.weightx = 0.0;
                break;
            }
            case 1: {
                this.constraints.weightx = d;
                this.constraints.weighty = d2;
                break;
            }
            case 0: {
                this.constraints.weightx = 0.0;
                this.constraints.weighty = 0.0;
                break;
            }
        }
        this.constraints.fill = n6;
        this.getContentPane().add((Component)jComponent, this.constraints);
    }

    private void _registerKeyboardActions() {
        JRootPane jRootPane = this.getRootPane();
        jRootPane.registerKeyboardAction(this._listener, this.m_helpText, KeyStroke.getKeyStroke(112, 0), 1);
        jRootPane.registerKeyboardAction(this._listener, this.m_helpText, KeyStroke.getKeyStroke(156, 0), 1);
    }

    public void fireHelpEvent() {
        this.setCursor(new Cursor(3));
        try {
            this.m_helpCxtMgr.showTopic("dm4j_histogram_html");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.setCursor(new Cursor(0));
    }

    public void closeWindow() {
        WindowEvent windowEvent = new WindowEvent(this, 201);
        super.processWindowEvent(windowEvent);
    }

    private class UIListener
    implements ActionListener {
        private UIListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = actionEvent.getActionCommand();
            if (HistogramFrame.this.m_okText.equals(string)) {
                HistogramFrame.this.closeWindow();
            } else if (HistogramFrame.this.m_helpText.equals(string)) {
                HistogramFrame.this.fireHelpEvent();
            }
        }
    }
}

