/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.steps.commonsteps;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import oracle.bali.ewt.text.MultiLineLabel;
import oracle.bali.ewt.text.WordWrapper;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.state.commonsteps.MultiRecordCaseData;
import oracle.dmt.dm4j.wizard.steps.DM4JStep;
import oracle.dmt.dm4j.wizard.steps.commonsteps.MRCFormatDialog;

public class DataPanel
extends DM4JStep {
    DataState m_state;
    MultiRecordCaseData m_mrcState;
    String m_panelDescriptionResourceKey;
    MultiLineLabel mlblStepDescription = new MultiLineLabel();
    JLabel lblSchemaName = new JLabel();
    JLabel lblSchemaNameValue = new JLabel();
    JComboBox comboSchema = new JComboBox();
    DefaultComboBoxModel schemaModel;
    JLabel lblTableName = new JLabel();
    JLabel lblTableNameValue = new JLabel();
    JComboBox comboTable = new JComboBox();
    DefaultComboBoxModel tableModel;
    JLabel lblComment = new JLabel();
    JTextArea txtComment = new JTextArea();
    JScrollPane scrollComment = new JScrollPane();
    MultiLineLabel mlblFormatDescription = new MultiLineLabel();
    JRadioButton optMRCFormatYes = new JRadioButton();
    JRadioButton optMRCFormatNo = new JRadioButton();
    ButtonGroup groupMRCFormat = new ButtonGroup();
    JButton butFormatDetails = new JButton();
    JLabel lblFiller = new JLabel();
    boolean m_allowDataSelection = true;
    boolean m_allowDataFormatSelection = true;
    boolean m_ignoreSchemaComboEvent = false;
    boolean m_ignoreTableComboEvent = false;

    public DataPanel(DataState dataState, String string) throws Exception {
        super(dataState);
        this.m_state = dataState;
        this.m_panelDescriptionResourceKey = string;
        this.setState();
        this.jbInit();
    }

    private void setState() throws Exception {
        if (this.m_state instanceof MultiRecordCaseData) {
            this.m_mrcState = (MultiRecordCaseData)this.m_state;
            this.m_allowDataSelection = this.m_mrcState.allowDataSelection();
            this.m_allowDataFormatSelection = this.m_mrcState.allowDataFormatSelection();
        } else {
            this.m_mrcState = null;
            this.m_allowDataSelection = this.m_state.allowDataSelection();
            this.m_allowDataFormatSelection = true;
        }
    }

    private void jbInit() throws Exception {
        int n = 0;
        this.mlblStepDescription.setText(ResourceUtilities.getUILabel(this.m_panelDescriptionResourceKey));
        this.mlblStepDescription.setPreferredRows(2);
        this.mlblStepDescription.setMinimumRows(2);
        this.mlblStepDescription.setTextWrapper(WordWrapper.getTextWrapper());
        this.addFilledComponent((JComponent)this.mlblStepDescription, TOP_DESC, n++, 0, 2, 1, 1);
        this.lblSchemaName.setText(ResourceUtilities.getUILabel("SCHEMA_NAME"));
        this.lblSchemaName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("SCHEMA_NAME"));
        this.lblSchemaName.setLabelFor(this.comboSchema);
        this.addComponent(this.lblSchemaName, COL1_LABEL, n, 0);
        if (this.m_allowDataSelection) {
            this.comboSchema.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataPanel.this.comboSchema_actionPerformed(actionEvent);
                }
            });
            this.addFilledComponent(this.comboSchema, COL_VALUE, n++, 1);
        } else {
            this.addFilledComponent(this.lblSchemaNameValue, COL_VALUE, n++, 1);
        }
        this.lblTableName.setText(ResourceUtilities.getUILabel("TABLE_NAME"));
        this.lblTableName.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("TABLE_NAME"));
        this.lblTableName.setLabelFor(this.comboTable);
        this.addComponent(this.lblTableName, COL1_LABEL, n, 0);
        if (this.m_allowDataSelection) {
            this.comboTable.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataPanel.this.comboTable_actionPerformed(actionEvent);
                }
            });
            this.addFilledComponent(this.comboTable, COL_VALUE, n++, 1);
        } else {
            this.addFilledComponent(this.lblTableNameValue, COL_VALUE, n++, 1);
        }
        this.lblComment.setText(ResourceUtilities.getUILabel("COMMENT"));
        this.lblComment.setDisplayedMnemonic(ResourceUtilities.getUIMnemonic("COMMENT"));
        this.lblComment.setLabelFor(this.txtComment);
        this.addComponent(this.lblComment, COL1_LABEL, n, 0);
        this.txtComment.setLineWrap(true);
        this.txtComment.setWrapStyleWord(true);
        this.txtComment.setEditable(false);
        this.txtComment.setBackground(this.getBackground());
        this.scrollComment.getViewport().add((Component)this.txtComment, null);
        this.scrollComment.setPreferredSize(new Dimension(250, 60));
        this.addFilledComponent(this.scrollComment, COL_VALUE, n++, 1);
        if (this.m_state instanceof MultiRecordCaseData) {
            n = this.addMRCFormatControls(n);
        }
        this.addFilledComponent(this.lblFiller, COL1_LABEL, n, 0, 2, 2, 1);
    }

    private int addMRCFormatControls(int n) {
        if (this.m_mrcState == null || !this.m_mrcState.isOnlyTransactional()) {
            this.mlblFormatDescription.setText(ResourceUtilities.getUILabel("DATA_FORMAT_DESCRIPTION"));
            this.mlblFormatDescription.setPreferredRows(1);
            this.mlblFormatDescription.setMinimumRows(1);
            this.addFilledComponent((JComponent)this.mlblFormatDescription, COL1_SUBHEAD, n++, 0, 2, 1, 1);
            this.optMRCFormatNo.setText(ResourceUtilities.getUILabel("SINGLE_RECORD_CASE_OPTION"));
            this.groupMRCFormat.add(this.optMRCFormatNo);
            this.optMRCFormatNo.setMnemonic(ResourceUtilities.getUIMnemonic("SINGLE_RECORD_CASE_OPTION"));
            this.optMRCFormatNo.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataPanel.this.optMRCFormat_actionPerformed(actionEvent);
                }
            });
            this.addComponent(this.optMRCFormatNo, COL1_INDENTED1_CONTROL, n++, 0, 2, 1);
            this.optMRCFormatYes.setText(ResourceUtilities.getUILabel("MULTIPLE_RECORD_CASE_OPTION"));
            this.groupMRCFormat.add(this.optMRCFormatYes);
            this.optMRCFormatYes.setMnemonic(ResourceUtilities.getUIMnemonic("MULTIPLE_RECORD_CASE_OPTION"));
            this.optMRCFormatYes.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    DataPanel.this.optMRCFormat_actionPerformed(actionEvent);
                }
            });
            this.addComponent(this.optMRCFormatYes, COL1_INDENTED1_CONTROL, n++, 0, 2, 1);
        }
        this.butFormatDetails.setText(ResourceUtilities.getUILabel("DATA_FORMAT_DETAILS_BUTTON"));
        this.butFormatDetails.setMnemonic(ResourceUtilities.getUIMnemonic("DATA_FORMAT_DETAILS_BUTTON"));
        this.butFormatDetails.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DataPanel.this.butFormatDetails_actionPerformed(actionEvent);
            }
        });
        this.addComponent(this.butFormatDetails, COL1_INDENTED2_CONTROL, n++, 0, 2, 1);
        return n;
    }

    private void comboSchema_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreSchemaComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)((DefaultComboBoxModel)jComboBox.getModel()).getSelectedItem();
                String string2 = (String)jComboBox.getSelectedItem();
                this.m_state.setSelectedSchemaName(string2);
                this.loadTableCombo();
                this.clearMappingColumns();
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    private void clearMappingColumns() {
        if (this.m_state instanceof MultiRecordCaseData) {
            this.m_mrcState.clearMappingColumns();
        }
    }

    private void comboTable_actionPerformed(ActionEvent actionEvent) {
        try {
            if (!this.m_ignoreTableComboEvent) {
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)((DefaultComboBoxModel)jComboBox.getModel()).getSelectedItem();
                String string2 = (String)jComboBox.getSelectedItem();
                this.m_state.setSelectedTableName(string2);
                this.loadTableComment();
                this.clearMappingColumns();
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    public void init() throws Exception {
        if (this.m_allowDataSelection) {
            this.loadSchemaCombo();
            this.loadTableCombo();
        } else {
            this.lblTableNameValue.setText(this.m_state.getSelectedTableName());
            this.lblSchemaNameValue.setText(this.m_state.getSelectedSchemaName());
            this.loadTableComment();
        }
        this.loadDefaultValues();
    }

    public void reinit() throws Exception {
        this.init();
    }

    private void loadSchemaCombo() {
        this.m_ignoreSchemaComboEvent = true;
        this.schemaModel = new DefaultComboBoxModel(this.m_state.getSchemaNames());
        this.schemaModel.setSelectedItem(this.m_state.getSelectedSchemaName());
        this.comboSchema.setModel(this.schemaModel);
        this.comboSchema.setSelectedItem(this.m_state.getSelectedSchemaName());
        this.m_ignoreSchemaComboEvent = false;
    }

    private void loadTableCombo() {
        this.m_ignoreTableComboEvent = true;
        this.tableModel = new DefaultComboBoxModel(this.m_state.getTableNames());
        this.tableModel.setSelectedItem(this.m_state.getSelectedTableName());
        this.comboTable.setModel(this.tableModel);
        this.comboTable.setSelectedItem(this.m_state.getSelectedTableName());
        this.loadTableComment();
        this.m_ignoreTableComboEvent = false;
    }

    private void loadTableComment() {
        this.txtComment.setText(this.m_state.getSelectedTableComment());
    }

    private void loadDefaultValues() {
        if (this.m_mrcState != null) {
            if (this.m_mrcState.isMultipleRecordCaseFormat()) {
                this.optMRCFormatYes.setSelected(true);
                this.butFormatDetails.setEnabled(true);
            } else {
                this.optMRCFormatNo.setSelected(true);
                this.butFormatDetails.setEnabled(false);
            }
            if (!this.m_allowDataFormatSelection) {
                this.mlblFormatDescription.setEnabled(false);
                this.optMRCFormatNo.setEnabled(false);
                this.optMRCFormatYes.setEnabled(false);
                this.butFormatDetails.setEnabled(false);
            }
        }
    }

    private void optMRCFormat_actionPerformed(ActionEvent actionEvent) {
        if (this.optMRCFormatYes.isSelected()) {
            this.m_mrcState.setMultipleRecordCaseFormat(true);
            this.butFormatDetails.setEnabled(true);
        } else {
            this.m_mrcState.setMultipleRecordCaseFormat(false);
            this.butFormatDetails.setEnabled(false);
        }
    }

    private void butFormatDetails_actionPerformed(ActionEvent actionEvent) {
        try {
            MRCFormatDialog mRCFormatDialog = new MRCFormatDialog(this.getparentWizardState().getDialog(), this.m_mrcState);
        }
        catch (Exception exception) {
            this.m_state.getparentWizardState().doAbortCancel(exception);
        }
    }
}

