/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.AllDBColumnsDataSource;
import oracle.dmt.dm4j.datasources.TextLDSDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class TextDataState
extends DataState {
    protected TextLDSDataSource m_ldsDataSource;
    private AllDBColumnsDataSource m_ds = null;
    private boolean m_isActivity = false;
    String[] allowableTextDataTypes = new String[]{"VARCHAR2", "CHAR", "BFILE", "XMLTYPE", "LONG", "RAW", "LONG RAW", "BLOB", "CLOB"};

    public TextDataState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = wizardState.getBrowserContext();
        this.m_isActivity = browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postValidate(Vector vector) throws Exception {
        Connection connection = null;
        boolean bl = true;
        try {
            connection = DM4JConnectionManager.getDbConnection();
            this.m_ds = new AllDBColumnsDataSource(connection, this.getSelectedSchemaName(), this.getSelectedTableName());
            this.m_ds.setAcceptableDataTypes(this.allowableTextDataTypes, true);
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("GETTING_ATTRS_DIALOG_TITLE"), this.m_ds, true, this.m_isActivity);
            this.m_ds.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("GETTING_ATTRS_DIALOG_TITLE"), "");
            if (this.m_isActivity) {
                progressBar.waitUntilDone();
            }
            if (this.m_ds.getException() != null) {
                this.setState(StepStateType.DIRTY);
                bl = false;
                this.getparentWizardState().doAbortCancel(this.m_ds.getException());
            } else if (progressBar.hasUserCancelled()) {
                this.setState(StepStateType.DIRTY);
                bl = false;
            }
            boolean bl2 = bl;
            return bl2;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AllDBColumnsDataSource getModel() {
        if (this.m_ds == null) {
            Connection connection = null;
            try {
                connection = DM4JConnectionManager.getDbConnection();
                this.m_ds = new AllDBColumnsDataSource(connection, this.getSelectedSchemaName(), this.getSelectedTableName());
                this.m_ds.setAcceptableDataTypes(this.allowableTextDataTypes, true);
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("GETTING_ATTRS_DIALOG_TITLE"), this.m_ds, true);
                this.m_ds.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("GETTING_ATTRS_DIALOG_TITLE"), "");
                if (this.m_ds.getException() != null) {
                    this.setState(StepStateType.DIRTY);
                    this.getparentWizardState().doAbortCancel(this.m_ds.getException());
                } else if (progressBar.hasUserCancelled()) {
                    this.setState(StepStateType.DIRTY);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return this.m_ds;
    }

    public void setAllDBColumnsDataSource(AllDBColumnsDataSource allDBColumnsDataSource) {
        this.m_ds = allDBColumnsDataSource;
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TextLDSDataSource getLDSDataSource() {
        if (this.m_ldsDataSource == null) {
            Connection connection = null;
            ProgressBar progressBar = null;
            try {
                connection = DM4JConnectionManager.getDbConnection();
                this.m_ldsDataSource = new TextLDSDataSource(connection, this, this.getSelectedSchemaName(), this.getSelectedTableName(), true, true);
                progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("GETTING_ATTRS_DIALOG_TITLE"), this.m_ldsDataSource, true, this.m_isActivity);
                this.m_ldsDataSource.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("GETTING_ATTRS_DIALOG_TITLE"), "");
                if (this.m_isActivity) {
                    progressBar.waitUntilDone();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
        return this.m_ldsDataSource;
    }

    public void setLDSDataSource(TextLDSDataSource textLDSDataSource) {
        this.m_ldsDataSource = textLDSDataSource;
    }

    public Vector getInEligibleTextSequenceAttributes(boolean bl) {
        return this.getLDSDataSource().getInEligibleTextSequenceAttributes(bl);
    }
}

