/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.Vector;
import oracle.dmt.dm4j.datasources.LDSDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TextDataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.TextCaseIdStateError;

public class TextCaseIdState
extends WizardStepState {
    private Vector m_sequenceAttributesIdx = null;
    private StringBuffer m_sequenceAttribute = new StringBuffer(0);
    private boolean m_newWizard = true;

    public TextCaseIdState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public Vector getInSequenceAttributes() {
        TextDataState textDataState = (TextDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return textDataState.getInEligibleTextSequenceAttributes(false);
    }

    public void setSequenceAttribute(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_sequenceAttribute.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_sequenceAttribute.setLength(0);
            this.m_sequenceAttribute.append(string);
        }
    }

    public String getSequenceAttribute() {
        return this.m_sequenceAttribute.length() > 0 ? this.m_sequenceAttribute.toString() : null;
    }

    public String getSequenceAttributeDataType() {
        String string = null;
        if (this.m_sequenceAttribute.length() > 0) {
            LDSDataSource lDSDataSource = this.getLDSDataSource();
            string = lDSDataSource.getAttributeDataType(this.m_sequenceAttribute.toString());
        }
        return string;
    }

    public LDSDataSource getLDSDataSource() {
        TextDataState textDataState = (TextDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return textDataState.getLDSDataSource();
    }

    public void refresh() throws Exception {
        this.load();
    }

    public boolean postValidate(Vector vector) throws Exception {
        boolean bl = true;
        return bl;
    }

    protected void loadDefault() {
        this.m_sequenceAttribute.setLength(0);
        TextDataState textDataState = (TextDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        this.m_sequenceAttributesIdx = textDataState.getInEligibleTextSequenceAttributes(false);
    }

    public void load() throws Exception {
        this.m_newWizard = true;
        this.loadDefault();
        if (!this.m_sequenceAttributesIdx.isEmpty()) {
            String string = (String)this.m_sequenceAttributesIdx.get(0);
            this.setSequenceAttribute((String)this.getLDSDataSource().getData(1, Integer.parseInt(string)));
        }
    }

    protected void validateSequenceAttribute(Vector vector) throws Exception {
        if (this.m_sequenceAttribute.length() == 0) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("SEQUENCEID_SEQID_NAME")};
            vector.add(new StateValidation(TextCaseIdStateError.SEQUENCE_ATTR_EMPTY, string, stringArray));
            return;
        }
    }

    protected void validateSequenceAttributeType(Vector vector) throws Exception {
        String string = this.getSequenceAttributeDataType();
        if (!(string.equalsIgnoreCase("NUMBER") || string.equalsIgnoreCase("LONG") || string.equalsIgnoreCase("FLOAT"))) {
            String string2 = ResourceUtilities.getstateExceptionMessage("NUMERIC_DATA_TYPE_ONLY");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("SEQUENCEID_STEP_NAME")};
            vector.add(new StateValidation(TextCaseIdStateError.SEQUENCE_ATTR_INVALID_DATA_TYPE, string2, stringArray));
            return;
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateSequenceAttribute(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateSequenceAttributeType(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }
}

