/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.AbstractActivity;
import oracle.dmt.dm4j.activity.steps.SampleStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.datasources.AttrValueCountDataSource;
import oracle.dmt.dm4j.datasources.CDSAttrValueCountDataSource;
import oracle.dmt.dm4j.datasources.CDSLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.state.commonsteps.MultiRecordCaseData;
import oracle.dmt.dm4j.wizard.state.transformsteps.AttrValCountsTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.CaseCountDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.StratifiedSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.StratifiedSettingsStateError;

public class StratifiedTargetState
extends WizardStepState {
    private StringBuffer m_targetColName = new StringBuffer(0);
    private CaseCountDataState m_dataState;
    private Long m_sampleNumOfCases = null;
    private Double m_samplePercentage = new Double(100.0);
    private boolean m_isByNumberOfCases = true;
    private ArrayList m_attrList = null;
    private DiscretizationLDSDataSource m_ds;
    private SampleStepOptions m_options = null;
    private boolean m_isActivity = false;

    public StratifiedTargetState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        this.m_dataState = (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        BrowserContext browserContext = wizardState.getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            this.m_isActivity = true;
            if (browserContext.getOptions() instanceof SampleStepOptions) {
                this.m_options = (SampleStepOptions)browserContext.getOptions();
                if (this.m_options != null) {
                    this.m_sampleNumOfCases = this.m_options.getSampleNumOfCases();
                    this.m_samplePercentage = this.m_options.getSamplePercentage();
                }
            }
        }
    }

    public boolean isActivity() {
        return this.m_isActivity;
    }

    public void validate(Vector vector) throws Exception {
        this.validateTotalCaseCount(vector);
        if (this.m_isByNumberOfCases) {
            this.validateSampleNumberOfCases(vector);
        } else {
            this.validateSamplePercentage(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    protected void validateTotalCaseCount(Vector vector) throws Exception {
        if (this.m_dataState.getCaseCount() <= 0) {
            String string = ResourceUtilities.getstateExceptionMessage("SOURCE_TABLE_EMPTY");
            String[] stringArray = new String[]{this.m_dataState.getSelectedSchemaName() + "." + this.m_dataState.getSelectedTableName()};
            vector.add(new StateValidation(StratifiedSettingsStateError.SOURCE_TABLE_EMPTY, string, stringArray));
        } else if (this.m_dataState.getCaseCount() < 2) {
            String string = ResourceUtilities.getstateExceptionMessage("SOURCE_TABLE_MUST_HAVE_MIN_CASES");
            String[] stringArray = new String[]{this.m_dataState.getSelectedSchemaName() + "." + this.m_dataState.getSelectedTableName(), "2"};
            vector.add(new StateValidation(StratifiedSettingsStateError.SOURCE_TABLE_MUST_HAVE_MIN_CASES, string, stringArray));
        }
    }

    protected void validateSamplePercentage(Vector vector) throws Exception {
        if (this.m_samplePercentage == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES")};
            vector.add(new StateValidation(StratifiedSettingsStateError.REQUIRED_FIELD, string, stringArray));
        } else {
            double d = this.m_samplePercentage;
            if (d > 100.0 || d <= 0.0) {
                String string = ResourceUtilities.getstateExceptionMessage("RANGE_VALIDATION");
                String[] stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES"), "0", "100"};
                vector.add(new StateValidation(StratifiedSettingsStateError.RANGE_VALIDATION, string, stringArray));
            }
        }
    }

    protected void validateSampleNumberOfCases(Vector vector) throws Exception {
        if (this.m_sampleNumOfCases == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_NUMBER_OF_CASES")};
            vector.add(new StateValidation(StratifiedSettingsStateError.REQUIRED_FIELD, string, stringArray));
        } else {
            long l = this.m_sampleNumOfCases;
            if (l <= 0L || l > (long)this.m_dataState.getCaseCount()) {
                String string = ResourceUtilities.getstateExceptionMessage("RANGE_VALIDATION");
                String[] stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_NUMBER_OF_CASES"), "1", "" + this.m_dataState.getCaseCount()};
                vector.add(new StateValidation(StratifiedSettingsStateError.RANGE_VALIDATION, string, stringArray));
            }
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
        try {
            Object object;
            WizardState wizardState = this.getparentWizardState();
            BrowserContext browserContext = wizardState.getBrowserContext();
            this.m_dataState = (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
                object = browserContext.getActivity();
                this.m_ds = new CDSLDSDataSource(DM4JConnectionManager.getDbConnection(), (DataState)this.m_dataState, (AbstractActivity)object, browserContext.getSampledInputDataDescriptor(), browserContext.getInputDataDescriptor(), false, false);
            } else {
                boolean bl = false;
                if (this.m_dataState instanceof MultiRecordCaseData) {
                    CaseCountDataState caseCountDataState = this.m_dataState;
                    bl = caseCountDataState.isSingleMetric();
                }
                this.m_ds = new DiscretizationLDSDataSource(DM4JConnectionManager.getDbConnection(), this.m_dataState, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName(), false, true, bl);
            }
            object = null;
            boolean bl = !this.getparentWizardState().getDisplayUI();
            object = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("ATTRIBUTE_VALUE_COUNT_DIALOG_TITLE"), this.m_ds, true, bl);
            this.m_ds.setProgressBar((ProgressBar)object);
            ((ProgressBar)object).start(ResourceUtilities.getUILabel("ATTRIBUTE_CASES_DIALOG_TITLE"), "");
            ((ProgressBar)object).waitUntilDone();
            if (this.m_ds.getException() != null) {
                this.setState(StepStateType.DIRTY);
                this.getparentWizardState().doAbortCancel(this.m_ds.getException());
            } else if (((ProgressBar)object).hasUserCancelled()) {
                this.setState(StepStateType.DIRTY);
            } else {
                this.m_attrList = this.m_ds.getAttributeList();
                this.loadDefaults();
                this.setState(StepStateType.LOADED);
            }
        }
        catch (Exception exception) {
            this.getparentWizardState().doAbortCancel(exception);
        }
    }

    public String getTargetColumnName() {
        return this.m_targetColName.toString();
    }

    public void setTargetColumnName(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_targetColName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_targetColName.setLength(0);
            this.m_targetColName.append(string);
        }
    }

    public void setSampleNumberOfCases(Long l) {
        if (this.m_sampleNumOfCases == null || l == null || 0 != this.m_sampleNumOfCases.compareTo(l)) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.INCONSISTENT);
            }
            this.m_sampleNumOfCases = l;
            double d = this.m_sampleNumOfCases.doubleValue() / (double)this.m_dataState.getCaseCount() * 100.0;
            this.m_samplePercentage = new Double(d);
            if (this.m_options != null) {
                this.m_options.setSampleNumOfCases(this.m_sampleNumOfCases);
                this.m_options.setSamplePercentage(this.m_samplePercentage);
            }
        }
    }

    public void setSamplePercentageOfCases(Double d) {
        if (this.m_samplePercentage == null || d == null || this.m_samplePercentage.compareTo(d) != 0) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.INCONSISTENT);
            }
            this.m_samplePercentage = d;
            long l = (long)(this.m_samplePercentage * (double)this.m_dataState.getCaseCount() / 100.0);
            this.m_sampleNumOfCases = new Long(l);
            if (this.m_options != null) {
                this.m_options.setSamplePercentage(this.m_samplePercentage);
                this.m_options.setSampleNumOfCases(this.m_sampleNumOfCases);
            }
        }
    }

    public void setSampleByNumberOfCases(boolean bl) {
        if (!this.m_isByNumberOfCases == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_isByNumberOfCases = bl;
            if (this.m_options != null) {
                this.m_options.setSampleByNumberOfCases(bl);
            }
        }
    }

    public Long getSampleNumberOfCases() {
        if (this.m_sampleNumOfCases == null) {
            long l = (long)(this.m_samplePercentage * (double)this.m_dataState.getCaseCount() / 100.0);
            this.m_sampleNumOfCases = new Long(l);
        }
        return this.m_sampleNumOfCases;
    }

    public Double getSamplePercentageOfCases() {
        return this.m_samplePercentage;
    }

    public boolean isSampleByNumOfCases() {
        return this.m_isByNumberOfCases;
    }

    public CaseCountDataState getDataState() {
        return this.m_dataState;
    }

    protected void loadDefaults() throws Exception {
        if (this.m_options == null) {
            int n;
            this.m_dataState = (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            int n2 = this.m_dataState.getCaseCount();
            int n3 = n2 > (n = UserPreferences.getInstance().getSampleSize()) ? n : n2;
            this.setSampleNumberOfCases(new Long(n3));
        } else if (this.m_options != null) {
            if (this.m_options.getCaseCount() == 0) {
                this.m_dataState = (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
                int n = this.m_dataState.getCaseCount();
                this.m_options.setCaseCount(n);
            }
            BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
            this.m_targetColName = new StringBuffer(browserContext.getActivity().getTargetColumn().getAlias());
            this.m_isByNumberOfCases = this.m_options.isSampleByNumberOfCases();
            Long l = this.m_options.getSampleNumOfCases();
            Double d = this.m_options.getSamplePercentage();
            int n = this.m_options.getCaseCount();
            if (this.m_isByNumberOfCases) {
                this.m_sampleNumOfCases = l;
                this.m_samplePercentage = new Double(l.doubleValue() / (double)n * 100.0);
            } else {
                this.m_samplePercentage = d;
                this.m_sampleNumOfCases = new Long((long)(d * (double)n / 100.0));
            }
        }
    }

    public Vector getColumnNames() throws Exception {
        return new Vector(this.m_attrList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postValidate(Vector vector) throws Exception {
        Connection connection = null;
        boolean bl = true;
        try {
            if (this.m_dataState.getSelectedTableName() == null || this.m_dataState.getSelectedTableName().trim().equals("")) {
                boolean bl2 = bl;
                return bl2;
            }
            AttrValueCountDataSource attrValueCountDataSource = null;
            WizardState wizardState = this.getparentWizardState();
            connection = DM4JConnectionManager.getDbConnection();
            BrowserContext browserContext = wizardState.getBrowserContext();
            if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
                AbstractActivity abstractActivity = browserContext.getActivity();
                attrValueCountDataSource = new CDSAttrValueCountDataSource(connection, browserContext.getActivity().getInputDataDescriptor(), this.getTargetColumnName(), this.m_dataState.getCaseCount(), this.getSamplePercentageOfCases(), this.getSampleNumberOfCases());
            } else if (this.m_dataState.isMultipleRecordCaseFormat()) {
                attrValueCountDataSource = new AttrValueCountDataSource(connection, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName(), this.getTargetColumnName(), this.m_dataState.getCaseCount(), this.getSamplePercentageOfCases(), this.getSampleNumberOfCases(), this.m_dataState.getSequenceIDMapping(), this.m_dataState.getAttributeNameMapping(), this.m_dataState.getValueMapping());
                if (this.m_ds.isSingleMetric()) {
                    attrValueCountDataSource.setSingleMetric();
                }
            } else {
                attrValueCountDataSource = new AttrValueCountDataSource(connection, this.m_dataState.getSelectedSchemaName(), this.m_dataState.getSelectedTableName(), this.getTargetColumnName(), this.m_dataState.getCaseCount(), this.getSamplePercentageOfCases(), this.getSampleNumberOfCases());
            }
            boolean bl3 = !this.getparentWizardState().getDisplayUI();
            ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("ATTRIBUTE_VALUE_COUNT_DIALOG_TITLE"), attrValueCountDataSource, true, bl3);
            attrValueCountDataSource.setProgressBar(progressBar);
            progressBar.start(ResourceUtilities.getUILabel("ATTRIBUTE_CASES_DIALOG_TITLE"), "");
            progressBar.waitUntilDone();
            if (attrValueCountDataSource.getException() != null) {
                this.setState(StepStateType.DIRTY);
                bl = false;
                this.getparentWizardState().doAbortCancel(attrValueCountDataSource.getException());
            } else if (progressBar.hasUserCancelled()) {
                this.setState(StepStateType.DIRTY);
                bl = false;
            } else {
                if (attrValueCountDataSource.getSamplePercentageOfCases() != this.getSampleNumberOfCases().longValue()) {
                    this.setSampleNumberOfCases(new Long(attrValueCountDataSource.getSamplePercentageOfCases()));
                    this.setState(StepStateType.INCONSISTENT);
                }
                StratifiedSettingsState stratifiedSettingsState = (StratifiedSettingsState)this.getparentWizardState().getStep(StepType.SETTING_STEP_1);
                AttrValCountsTableModel attrValCountsTableModel = new AttrValCountsTableModel(this.m_ds.isSingleMetric() ? this.m_dataState.getValueMapping() : this.getTargetColumnName(), attrValueCountDataSource.getAttributeValueCounts(), this.getSampleNumberOfCases(), stratifiedSettingsState);
                stratifiedSettingsState.setTableModel(attrValCountsTableModel);
            }
            boolean bl4 = bl;
            return bl4;
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public DiscretizationLDSDataSource getLDSDataSource() {
        return this.m_ds;
    }
}

