/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.activity.steps.ODMrTextStep;
import oracle.dmt.dm4j.activity.steps.SplitStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.ComplexDataStructure;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.NameStateError;

public class SplitNameState
extends WizardStepState {
    private final int NAME_LENGTH_MAX = 30;
    private final int COMMENT_LENGTH_MAX = 4000;
    private StringBuffer m_buildTable = new StringBuffer(0);
    private StringBuffer m_testTable = new StringBuffer(0);
    private StringBuffer m_buildComment = new StringBuffer(0);
    private StringBuffer m_testComment = new StringBuffer(0);
    private boolean m_createTable = true;
    private SplitStepOptions m_options;

    public SplitNameState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        this.validateSplitBuildTableName(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateSplitTestTableName(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateDuplicateNames(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateComments(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateQuotedName(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    private void validateDuplicateNames(Vector vector) throws Exception {
        String string;
        String string2 = this.m_buildTable.toString();
        if (string2.equals(string = this.m_testTable.toString())) {
            vector.add(new StateValidation(NameStateError.SPLIT_TEST_BUILD_TABLE_NAME_DUPLICATE));
        }
    }

    private void validateComments(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (!ValidationUtil.checkStringLength(this.m_buildComment.toString(), 4000)) {
            string = ResourceUtilities.getstateExceptionMessage("FIELD_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("SPLIT_BUILD_COMMENT"), Integer.toString(4000)};
            vector.add(new StateValidation(NameStateError.SPLIT_BUILD_TABLE_COMMENT_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_testComment.toString(), 4000)) {
            string = ResourceUtilities.getstateExceptionMessage("FIELD_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("SPLIT_TEST_COMMENT"), Integer.toString(4000)};
            vector.add(new StateValidation(NameStateError.SPLIT_TEST_TABLE_COMMENT_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
    }

    private void validateSplitBuildTableName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (this.m_buildTable.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("SPLIT_NAME_BUILD_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.SPLIT_BUILD_TABLE_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_buildTable.toString(), 30)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("SPLIT_NAME_BUILD_TABLE_NAME"), Integer.toString(30)};
            vector.add(new StateValidation(NameStateError.SPLIT_BUILD_TABLE_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (ValidationUtil.isGreater32BytesInDB(this.m_buildTable.toString(), this.getparentWizardState().getConnection())) {
            string = ResourceUtilities.getstateExceptionMessage("GREATER_THAN_30BYTES");
            stringArray = new String[]{ResourceUtilities.getUILabel("SPLIT_NAME_BUILD_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.SPLIT_BUILD_TABLE_NAME_GREATER_30BYTES, string, stringArray));
        }
        if (ValidationUtil.isEqualToROWID(this.m_buildTable.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("EQUALS_ROWID");
            stringArray = new String[]{ResourceUtilities.getUILabel("SPLIT_NAME_BUILD_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.SPLIT_BUILD_TABLE_NAME_EQUALS_ROWID, string, stringArray));
        }
        string = DM4JConnectionManager.getUser();
        if (!ValidationUtil.isTableNameUnique(this.m_buildTable.toString(), this.getparentWizardState().getConnection())) {
            vector.add(new StateValidation(NameStateError.SPLIT_BUILD_TABLE_NAME_DUPLICATE));
        }
    }

    private void validateSplitTestTableName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (this.m_testTable.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getUILabel("SPLIT_NAME_TEST_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.SPLIT_TEST_TABLE_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_testTable.toString(), 30)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getUILabel("SPLIT_NAME_TEST_TABLE_NAME"), Integer.toString(30)};
            vector.add(new StateValidation(NameStateError.SPLIT_TEST_TABLE_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (ValidationUtil.isGreater32BytesInDB(this.m_testTable.toString(), this.getparentWizardState().getConnection())) {
            string = ResourceUtilities.getstateExceptionMessage("GREATER_THAN_30BYTES");
            stringArray = new String[]{ResourceUtilities.getUILabel("SPLIT_NAME_TEST_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.SPLIT_TEST_TABLE_NAME_GREATER_30BYTES, string, stringArray));
        }
        if (ValidationUtil.isEqualToROWID(this.m_testTable.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("EQUALS_ROWID");
            stringArray = new String[]{ResourceUtilities.getUILabel("SPLIT_NAME_TEST_TABLE_NAME")};
            vector.add(new StateValidation(NameStateError.SPLIT_TEST_TABLE_NAME_EQUALS_ROWID, string, stringArray));
        }
        string = DM4JConnectionManager.getUser();
        if (!ValidationUtil.isTableNameUnique(this.m_testTable.toString(), this.getparentWizardState().getConnection())) {
            vector.add(new StateValidation(NameStateError.SPLIT_TEST_TABLE_NAME_DUPLICATE));
        }
    }

    private void validateQuotedName(Vector vector) throws Exception {
        boolean bl = DM4JStringUtils.isDoubleQuotedString(this.m_buildTable.toString());
        String string = this.m_buildTable.toString();
        if (bl) {
            string = DM4JStringUtils.trimDoubleQuotes(string);
        }
        if (!bl && !ValidationUtil.isValidNonQuotedDBObjectName(string)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
        boolean bl2 = DM4JStringUtils.isDoubleQuotedString(this.m_testTable.toString());
        String string2 = this.m_testTable.toString();
        if (bl2) {
            string2 = DM4JStringUtils.trimDoubleQuotes(string2);
        }
        if (!bl2 && !ValidationUtil.isValidNonQuotedDBObjectName(string2)) {
            vector.add(new StateValidation(NameStateError.DATAMINING_NAME_INVALID_DB_OBJECT_NAME));
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
        this.loadDefaults();
    }

    public String getOutputBuildTable() {
        return this.m_buildTable.toString();
    }

    public String getOutputTestTable() {
        return this.m_testTable.toString();
    }

    public String getBuildComment() {
        return this.m_buildComment.toString();
    }

    public String getTestComment() {
        return this.m_testComment.toString();
    }

    public void setBuildComment(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_buildComment.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_buildComment.setLength(0);
            this.m_buildComment.append(string.trim());
        }
    }

    public void setTestComment(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_testComment.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_testComment.setLength(0);
            this.m_testComment.append(string.trim());
        }
    }

    public void setOutputBuildTable(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_buildTable.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_buildTable.setLength(0);
                this.m_buildTable.append(string);
            }
        }
    }

    public void setOutputTestTable(String string) {
        if (string != null) {
            String string2;
            if (!DM4JStringUtils.isDoubleQuotedString(string)) {
                string = string.toUpperCase();
            }
            if (!string.equals(string2 = this.m_testTable.toString())) {
                if (this.getState() == StepStateType.VALIDATED) {
                    this.setState(StepStateType.DIRTY);
                }
                this.m_testTable.setLength(0);
                this.m_testTable.append(string);
            }
        }
    }

    protected void loadDefaults() throws Exception {
        String string;
        Object object;
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            object = browserContext.getInputDataDescriptor();
            string = ((ComplexDataStructure)object).getCaseTable();
            this.m_options = (SplitStepOptions)browserContext.getOptions();
            this.m_createTable = this.m_options != null && this.allowViewGeneration() ? this.m_options.isCreateTable() : true;
        } else {
            object = (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            string = ((DataState)object).getSelectedTableName();
        }
        object = this.getparentWizardState().getStep(StepType.SETTING_STEP);
        ((WizardStepState)object).setState(StepStateType.UNLOADED);
        Connection connection = this.getparentWizardState().getConnection();
        StringBuffer stringBuffer = new StringBuffer(string);
        if (stringBuffer.length() > 17) {
            stringBuffer.setLength(17);
        }
        stringBuffer.append("B");
        String string2 = DM4JConnectionManager.getUser();
        String string3 = ValidationUtil.createUniqueTableNameUsingRandom(stringBuffer.toString(), connection, "");
        this.m_buildTable.setLength(0);
        if (ValidationUtil.isValidNonQuotedDBObjectName(string3)) {
            this.m_buildTable.append(string3);
        } else {
            this.m_buildTable.append(DM4JStringUtils.addDoubleQuotes(string3));
        }
        StringBuffer stringBuffer2 = new StringBuffer(string);
        if (stringBuffer2.length() > 17) {
            stringBuffer2.setLength(17);
        }
        stringBuffer2.append("T");
        String string4 = ValidationUtil.createUniqueTableNameUsingRandom(stringBuffer2.toString(), connection, "");
        this.m_testTable.setLength(0);
        if (ValidationUtil.isValidNonQuotedDBObjectName(string4)) {
            this.m_testTable.append(string4);
        } else {
            this.m_testTable.append(DM4JStringUtils.addDoubleQuotes(string4));
        }
        this.m_buildComment.setLength(0);
        this.m_testComment.setLength(0);
    }

    public DataState getDataState() {
        return (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
    }

    public boolean getCreateTable() {
        return this.m_createTable;
    }

    public void setCreateTable(boolean bl) {
        if (!this.m_createTable == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_createTable = bl;
            if (this.m_options != null) {
                this.m_options.setCreateTable(bl);
            }
        }
    }

    public boolean allowViewGeneration() {
        ODMrTextStep oDMrTextStep;
        boolean bl = true;
        BrowserContext browserContext = this.getparentWizardState().getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && (oDMrTextStep = browserContext.getActivity().findTextStep()) != null) {
            bl = false;
        }
        return bl;
    }
}

