/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.Vector;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.BaseSampleSettingsState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CaseCountDataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.SampleSettingsStateError;

public class SampleSettingsState
extends BaseSampleSettingsState {
    private String m_sourceTableName = null;
    private String m_sourceSchemaName = null;
    private CaseCountDataState m_dataState = (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
    private Long m_sampleNumOfCases = new Long("0");
    private Double m_samplePercentage = new Double("10");
    private boolean m_isByNumberOfCases = true;

    public SampleSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        super.validate(vector);
        this.validateTotalCaseCount(vector);
        if (this.m_isByNumberOfCases) {
            this.validateSampleNumberOfCases(vector);
        } else {
            this.validateSamplePercentage(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    protected void validateTotalCaseCount(Vector vector) throws Exception {
        if (this.m_dataState.getCaseCount() <= 0) {
            String string = ResourceUtilities.getstateExceptionMessage("SOURCE_TABLE_EMPTY");
            String[] stringArray = new String[]{this.m_dataState.getSelectedSchemaName() + "." + this.m_dataState.getSelectedTableName()};
            vector.add(new StateValidation(SampleSettingsStateError.SOURCE_TABLE_EMPTY, string, stringArray));
        } else if (this.m_dataState.getCaseCount() < 2) {
            String string = ResourceUtilities.getstateExceptionMessage("SOURCE_TABLE_MUST_HAVE_MIN_CASES");
            String[] stringArray = new String[]{this.m_dataState.getSelectedSchemaName() + "." + this.m_dataState.getSelectedTableName(), "2"};
            vector.add(new StateValidation(SampleSettingsStateError.SOURCE_TABLE_MUST_HAVE_MIN_CASES, string, stringArray));
        }
    }

    protected void validateSamplePercentage(Vector vector) throws Exception {
        if (this.m_samplePercentage == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES")};
            vector.add(new StateValidation(SampleSettingsStateError.REQUIRED_FIELD, string, stringArray));
        } else {
            double d = this.m_samplePercentage;
            if (d > 100.0 || d <= 0.0) {
                String string = ResourceUtilities.getstateExceptionMessage("RANGE_VALIDATION");
                String[] stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_PERCENTAGE_OF_CASES"), "0", "100"};
                vector.add(new StateValidation(SampleSettingsStateError.RANGE_VALIDATION, string, stringArray));
            }
        }
    }

    protected void validateSampleNumberOfCases(Vector vector) throws Exception {
        if (this.m_sampleNumOfCases == null) {
            String string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            String[] stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_NUMBER_OF_CASES")};
            vector.add(new StateValidation(SampleSettingsStateError.REQUIRED_FIELD, string, stringArray));
        } else {
            long l = this.m_sampleNumOfCases;
            if (l <= 0L || l > (long)this.m_dataState.getCaseCount()) {
                String string = ResourceUtilities.getstateExceptionMessage("RANGE_VALIDATION");
                String[] stringArray = new String[]{ResourceUtilities.getUILabel("SAMPLE_SETTINGS_NUMBER_OF_CASES"), "1", "" + this.m_dataState.getCaseCount()};
                vector.add(new StateValidation(SampleSettingsStateError.RANGE_VALIDATION, string, stringArray));
            }
        }
    }

    public void refresh() throws Exception {
    }

    public void load() throws Exception {
        CaseCountDataState caseCountDataState = (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        this.m_sourceSchemaName = caseCountDataState.getSelectedSchemaName();
        this.m_sourceTableName = caseCountDataState.getSelectedTableName();
        this.loadDefaults();
    }

    public void setSampleNumberOfCases(Long l) {
        if (this.m_sampleNumOfCases == null || l == null || this.m_sampleNumOfCases.compareTo(l) != 0) {
            this.m_sampleNumOfCases = l;
            if (this.m_options != null) {
                this.m_options.setSampleNumOfCases(l);
            }
            this.setState(StepStateType.LOADED);
        }
    }

    public void setSamplePercentageOfCases(Double d) {
        if (this.m_samplePercentage == null || d == null || this.m_samplePercentage.compareTo(d) != 0) {
            this.m_samplePercentage = d;
            if (this.m_options != null) {
                this.m_options.setSamplePercentage(d);
            }
            this.setState(StepStateType.LOADED);
        }
    }

    public void setSampleByNumberOfCases(boolean bl) {
        this.m_isByNumberOfCases = bl;
        if (this.m_options != null) {
            this.m_options.setSampleByNumberOfCases(bl);
        }
        this.setState(StepStateType.LOADED);
    }

    public Long getSampleNumberOfCases() {
        return this.m_sampleNumOfCases;
    }

    public Double getSamplePercentageOfCases() {
        if (this.m_isByNumberOfCases) {
            long l = this.m_sampleNumOfCases;
            double d = (double)l / (double)this.m_dataState.getCaseCount() * 100.0;
            return new Double(d);
        }
        return this.m_samplePercentage;
    }

    public boolean isSampleByNumOfCases() {
        return this.m_isByNumberOfCases;
    }

    protected void loadDefaults() {
        if (this.m_options == null) {
            super.loadDefaults();
            this.m_dataState = (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            int n = this.getDataState().getCaseCount();
            int n2 = UserPreferences.getInstance().getSampleSize();
            int n3 = n > n2 ? n2 : n;
            this.m_sampleNumOfCases = new Long(n3);
            this.m_samplePercentage = new Double(n > 0 ? (double)n3 / (double)n * 100.0 : 0.0);
        } else if (this.m_options != null) {
            if (this.m_options.getCaseCount() == 0) {
                this.m_dataState = (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
                int n = this.m_dataState.getCaseCount();
                this.m_options.setCaseCount(n);
            }
            this.m_isByNumberOfCases = this.m_options.isSampleByNumberOfCases();
            this.m_sampleNumOfCases = this.m_options.getSampleNumOfCases();
            this.m_samplePercentage = this.m_options.getSamplePercentage();
        }
        this.setState(StepStateType.LOADED);
    }

    public CaseCountDataState getDataState() {
        return (CaseCountDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
    }
}

