/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.awt.Cursor;
import java.sql.Connection;
import java.util.Hashtable;
import java.util.Vector;
import oracle.bali.ewt.model.TwoDModelAdapter;
import oracle.bali.ewt.model.TwoDModelEvent;
import oracle.bali.ewt.model.TwoDModelListener;
import oracle.bali.share.collection.Range;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.CDSOutlierDiscretizeDataSource;
import oracle.dmt.dm4j.datasources.DiscretizationLDSDataSource;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.datasources.OutlierDiscretizeDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transformsteps.DiscretizationViewNameState;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.OutlierSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.miningsteps.DataUsageError;
import oracle.dmt.dm4j.wizard.validation.miningsteps.DataUsageWarning;

public class OutlierDataUsageState
extends WizardStepState {
    private static int TRANSACTIONAL_NAME_MAX_LENGTH = 30;
    CheckForDataSourceChanges m_dataSourcelistener;
    OutlierDiscretizeDataSource m_numericModel = null;

    public OutlierDataUsageState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    protected void setDataUsageListener(boolean bl) {
        this.m_dataSourcelistener = new CheckForDataSourceChanges(bl);
        this.getLDSDataSource().addModelListener((TwoDModelListener)this.m_dataSourcelistener);
    }

    protected void loadNew() throws Exception {
        this.setDataUsageListener(true);
    }

    public DiscretizationLDSDataSource getLDSDataSource() {
        OutlierDataState outlierDataState = (OutlierDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return outlierDataState.getLDSDataSource();
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() {
        this.loadDefaults();
    }

    protected void loadDefaults() {
    }

    protected void validateMinimumAttributes(Vector vector) throws Exception {
        int n = this.getLDSDataSource().getActiveAttributeCountExcludingTargets();
        WizardState wizardState = this.getparentWizardState();
        if (n == 0) {
            vector.add(new StateValidation(DataUsageError.DATA_USAGE_NO_ACTIVE_ATTRIBUTES));
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateMinimumAttributes(vector);
        if (vector.isEmpty() && this.isMulitpleRecordCaseFormat()) {
            this.validateTxnAttributeName(vector);
        }
        if (vector.isEmpty()) {
            // empty if block
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    private void validateQuotedAttributeName(Vector vector) throws Exception {
        for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
            String string = (String)this.getLDSDataSource().getData(1, i);
            if (ValidationUtil.isValidNonQuotedDBObjectName(string)) continue;
            String string2 = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_NAME_INVALID_NONQUOTED_COL_NAME");
            String[] stringArray = new String[]{string};
            vector.add(new StateValidation(DataUsageError.INVALID_NONQUOTED_DBNAME, string2, stringArray));
            i = this.getLDSDataSource().getRowCount();
        }
    }

    private void validateTxnAttributeName(Vector vector) throws Exception {
        Boolean bl = new Boolean(false);
        for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
            String[] stringArray;
            String string;
            bl = (Boolean)this.getLDSDataSource().getData(0, i);
            if (!bl.booleanValue()) continue;
            String string2 = (String)this.getLDSDataSource().getData(1, i);
            if (string2.length() == 0) {
                string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                stringArray = new String[]{ResourceUtilities.getUILabel("DATA_USAGE_ATTRIBUTE_NAME")};
                vector.add(new StateValidation(DataUsageError.ATTRIBUTE_NAME_EMPTY, string, stringArray));
                i = this.getLDSDataSource().getRowCount();
                continue;
            }
            if (ValidationUtil.checkStringLength(string2, TRANSACTIONAL_NAME_MAX_LENGTH)) continue;
            string = ResourceUtilities.getstateExceptionMessage("DATA_USAGE_ATTRIBUTE_NAME_EXCEEDS_MAXIMUM_LENGTH_W");
            stringArray = new String[]{string2, Integer.toString(TRANSACTIONAL_NAME_MAX_LENGTH)};
            vector.add(new StateValidation(DataUsageWarning.DATA_USAGE_ATTRIBUTE_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
            i = this.getLDSDataSource().getRowCount();
        }
    }

    public String getAttributeCount() {
        return Integer.toString(this.getLDSDataSource().getRowCount());
    }

    public String getActiveAttributeCountExcludingTargets() {
        return Integer.toString(this.getLDSDataSource().getActiveAttributeCountExcludingTargets());
    }

    public String getActiveAttributeCountIncludingTargets() {
        return Integer.toString(this.getLDSDataSource().getActiveAttributeCountIncludingTargets());
    }

    public String getCaseCount() {
        return Integer.toString(this.getLDSDataSource().getCaseCount());
    }

    public boolean isMulitpleRecordCaseFormat() {
        OutlierDataState outlierDataState = (OutlierDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        return outlierDataState.isMultipleRecordCaseFormat();
    }

    public String[] getMiningTypeAllowableValues() {
        String[] stringArray = new String[]{"categorical", "numerical"};
        return stringArray;
    }

    public void setAttributeToCategorical(Range[] rangeArray) {
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                if (null != this.getLDSDataSource().getData(16, j) || !((String)this.getLDSDataSource().getData(2, j)).equals("VARCHAR2") && !((String)this.getLDSDataSource().getData(2, j)).equals("CHAR") && !((String)this.getLDSDataSource().getData(2, j)).equals("FLOAT") && !((String)this.getLDSDataSource().getData(2, j)).equals("NUMBER")) continue;
                this.getLDSDataSource().setData(3, j, "categorical");
            }
        }
        this.setState(StepStateType.DIRTY);
    }

    public void setAttributeToNumerical(Range[] rangeArray) {
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                if (null != this.getLDSDataSource().getData(16, j) || ((String)this.getLDSDataSource().getData(2, j)).equals("CHAR") || ((String)this.getLDSDataSource().getData(2, j)).equals("VARCHAR2")) continue;
                this.getLDSDataSource().setData(3, j, "numerical");
            }
        }
        this.setState(StepStateType.DIRTY);
    }

    public void setAttributeToInclude(Range[] rangeArray) {
        DiscretizationLDSDataSource discretizationLDSDataSource = this.getLDSDataSource();
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                discretizationLDSDataSource.setData(0, j, new Boolean(true));
            }
        }
        this.setState(StepStateType.DIRTY);
    }

    public void setAttributeToExclude(Range[] rangeArray) {
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                if (((String)this.getLDSDataSource().getData(5, j)).equals("target")) continue;
                this.getLDSDataSource().setData(0, j, new Boolean(false));
            }
        }
        this.setState(StepStateType.DIRTY);
    }

    public void restoreAttributeToDefault() {
        for (int i = 0; i < this.getLDSDataSource().getRowCount(); ++i) {
            if (!((String)this.getLDSDataSource().getData(5, i)).equals("target")) {
                this.getLDSDataSource().setData(5, i, (String)this.getLDSDataSource().getData(7, i));
                this.getLDSDataSource().setData(0, i, (Boolean)this.getLDSDataSource().getData(8, i));
            }
            this.getLDSDataSource().setData(3, i, (String)this.getLDSDataSource().getData(6, i));
        }
        this.setState(StepStateType.DIRTY);
    }

    protected void refreshNew() throws Exception {
        this.setDataUsageListener(true);
    }

    protected void refreshOld() throws Exception {
        this.setDataUsageListener(false);
    }

    protected void loadOld() throws Exception {
        this.setDataUsageListener(false);
    }

    public boolean preload() throws Exception {
        boolean bl = true;
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean postValidate(Vector vector) throws Exception {
        DiscretizationViewNameState discretizationViewNameState = (DiscretizationViewNameState)this.getparentWizardState().getStep(StepType.NAME_STEP);
        OutlierDataState outlierDataState = (OutlierDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        String string = outlierDataState.getSelectedSchemaName();
        String string2 = outlierDataState.getSelectedTableName();
        String string3 = outlierDataState.getAttributeNameMapping();
        String string4 = outlierDataState.getValueMapping();
        BrowserContext browserContext = null;
        Connection connection = null;
        boolean bl = true;
        try {
            Object object;
            connection = DM4JConnectionManager.getDbConnection();
            if (this.m_numericModel != null && this.m_numericModel.isTransactional() == outlierDataState.isMultipleRecordCaseFormat()) {
                BrowserFrame.getMainFrame().setCursor(new Cursor(3));
                object = (OutlierSettingsState)this.getparentWizardState().getStep(StepType.SETTING_STEP_1);
                ((WizardStepState)object).setState(StepStateType.UNLOADED);
                DiscretizationLDSDataSource discretizationLDSDataSource = this.getLDSDataSource();
                Vector vector2 = discretizationLDSDataSource.getNonUniqueAttributes();
                Hashtable<String, String> hashtable = new Hashtable<String, String>(vector2.size());
                for (int i = 0; i < vector2.size(); ++i) {
                    String string5 = (String)vector2.elementAt(i);
                    hashtable.put(string5, discretizationLDSDataSource.getMiningType(string5));
                }
                DiscretizeDataSource.synchronize(this.m_numericModel, hashtable);
                this.m_numericModel.augmentDataSource(connection, hashtable, discretizationLDSDataSource);
                this.m_numericModel.performDefaultTreatment();
                this.m_numericModel.refreshAllColumnList();
                BrowserFrame.getMainFrame().setCursor(new Cursor(0));
            } else {
                browserContext = this.getparentWizardState().getBrowserContext();
                this.m_numericModel = outlierDataState.isMultipleRecordCaseFormat() ? new OutlierDiscretizeDataSource(connection, this.getLDSDataSource(), string2, string, DM4JConnectionManager.getUser(), discretizationViewNameState.getViewName(), string3, string4, outlierDataState.getSequenceIDMapping(), outlierDataState.isSingleMetric()) : (browserContext.getLaunchPoint() == LaunchPoint.ACTIVITY_GUIDE ? new CDSOutlierDiscretizeDataSource(connection, this.getLDSDataSource(), DM4JConnectionManager.getUser(), discretizationViewNameState.getSampledViewName(), discretizationViewNameState.getViewName()) : new OutlierDiscretizeDataSource(connection, this.getLDSDataSource(), string2, string, DM4JConnectionManager.getUser(), discretizationViewNameState.getViewName()));
                this.m_numericModel.setBrowserContext(browserContext);
                if (browserContext.getLaunchPoint() == LaunchPoint.ACTIVITY_GUIDE) {
                    object = new ProgressBar(BrowserFrame.getMainFrame(), "", this.m_numericModel, true, true);
                    this.m_numericModel.setProgressBar((ProgressBar)object);
                    ((ProgressBar)object).start("", "");
                    ((ProgressBar)object).waitUntilDone();
                    if (this.m_numericModel.getException() != null) {
                        throw this.m_numericModel.getException();
                    }
                } else {
                    object = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("CALCULATING_STATS_DIALOG_TITLE"), this.m_numericModel, true);
                    this.m_numericModel.setProgressBar((ProgressBar)object);
                    ((ProgressBar)object).start(ResourceUtilities.getUILabel("CALCULATING_STATS_DIALOG_TITLE"), "");
                    if (this.m_numericModel.getException() != null) {
                        this.setState(StepStateType.DIRTY);
                        bl = false;
                        this.getparentWizardState().doAbortCancel(this.m_numericModel.getException());
                    } else if (((ProgressBar)object).hasUserCancelled()) {
                        this.setState(StepStateType.DIRTY);
                        bl = false;
                    }
                }
            }
        }
        catch (Exception exception) {
            bl = false;
            if (DiscretizeDataSource.isDebug()) {
                exception.printStackTrace();
            }
        }
        finally {
            BrowserFrame.getMainFrame().setCursor(new Cursor(0));
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
        return bl;
    }

    public OutlierDiscretizeDataSource getNumericModel() {
        return this.m_numericModel;
    }

    public String getNumeriBinBoundatyTableName() {
        return this.m_numericModel.getNumericBinBoundatyTableName();
    }

    public String getCategoricBinBoundatyTableName() {
        return this.m_numericModel.getCategoricBinBoundatyTableName();
    }

    public String getUserSchemaName() {
        return this.m_numericModel.getUserSchemaName();
    }

    public void abortCleanUp() {
        if (this.m_numericModel != null) {
            this.m_numericModel.abortCleanUp();
            this.m_numericModel = null;
        }
    }

    public void finishCleanUp() {
        if (this.m_numericModel != null) {
            this.m_numericModel.finishCleanUp();
            this.m_numericModel = null;
        }
    }

    public void setAttributeToUnique(Range[] rangeArray) {
        DiscretizationLDSDataSource discretizationLDSDataSource = this.getLDSDataSource();
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                discretizationLDSDataSource.setData(15, j, new Boolean(true));
            }
        }
        this.setState(StepStateType.DIRTY);
    }

    public void setAttributeToNonUnique(Range[] rangeArray) {
        for (int i = 0; i < rangeArray.length; ++i) {
            for (int j = rangeArray[i].getLowerLimit(); j < rangeArray[i].getUpperLimit() + 1; ++j) {
                if (((String)this.getLDSDataSource().getData(5, j)).equals("target")) continue;
                this.getLDSDataSource().setData(15, j, new Boolean(false));
            }
        }
        this.setState(StepStateType.DIRTY);
    }

    public void setNumericModel(OutlierDiscretizeDataSource outlierDiscretizeDataSource) {
        this.m_numericModel = outlierDiscretizeDataSource;
    }

    private class CheckForDataSourceChanges
    extends TwoDModelAdapter {
        private boolean m_newWizard;

        public CheckForDataSourceChanges(boolean bl) {
            this.m_newWizard = bl;
        }

        public void invalidateCells(TwoDModelEvent twoDModelEvent) {
            if (this.m_newWizard) {
                if (OutlierDataUsageState.this.getState() == StepStateType.VALIDATED) {
                    OutlierDataUsageState.this.setState(StepStateType.DIRTY);
                }
            } else if (OutlierDataUsageState.this.getState() == StepStateType.VALIDATED) {
                OutlierDataUsageState.this.setState(StepStateType.INCONSISTENT);
            }
        }
    }
}

