/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.SQLException;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.activity.steps.ODMrTextStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TextDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TextSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.ODMrTextContextIndexSettingsStateError;

public class ODMrTextContextIndexSettingsState
extends WizardStepState {
    private boolean m_useMultilexer;
    private boolean m_overwriteExistingIndex;
    private final String m_defaultSchema = "CTXSYS";
    private Vector m_schemaNames = new Vector();
    private StringBuffer m_dataStoreSchema = new StringBuffer(0);
    private StringBuffer m_dataStoreName = new StringBuffer(0);
    private Vector m_dataStoreNames = new Vector();
    private StringBuffer m_lexerSchema = new StringBuffer(0);
    private StringBuffer m_lexerName = new StringBuffer(0);
    private Vector m_lexerNames = new Vector();
    private StringBuffer m_wordListSchema = new StringBuffer(0);
    private StringBuffer m_wordListName = new StringBuffer(0);
    private Vector m_wordListNames = new Vector();
    private StringBuffer m_storageSchema = new StringBuffer(0);
    private StringBuffer m_storageName = new StringBuffer(0);
    private Vector m_storageNames = new Vector();
    private StringBuffer m_stoplistSchema = new StringBuffer(0);
    private StringBuffer m_stoplistName = new StringBuffer(0);
    private Vector m_stoplistNames = new Vector();
    private StringBuffer m_filterSchema = new StringBuffer(0);
    private StringBuffer m_filterName = new StringBuffer(0);
    private Vector m_filterNames = new Vector();
    private StringBuffer m_sectionSchema = new StringBuffer(0);
    private StringBuffer m_sectionName = new StringBuffer(0);
    private Vector m_sectionNames = new Vector();
    private String m_textSchema;
    String m_caseTextColumnDataType;
    TextDataState m_dataState;
    TextSettingsState m_settingsState;
    protected ODMrTextStepOptions m_options = null;

    public ODMrTextContextIndexSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = wizardState.getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE)) {
            if (browserContext.getOptions() instanceof ODMrTextStepOptions) {
                this.m_options = (ODMrTextStepOptions)browserContext.getOptions();
            }
            this.m_textSchema = browserContext.getActivity().getTextTable().getSchema();
        }
        if (this.m_options != null) {
            try {
                this.m_schemaNames = this.m_options.getSchemaNames();
                this.m_useMultilexer = this.m_options.getUseMultilexer();
                this.m_overwriteExistingIndex = this.m_options.getOverwriteExistingIndex();
                this.m_dataStoreSchema = new StringBuffer(this.m_options.getDataStoreSchema());
                this.loadDataStoreNames();
                this.m_dataStoreName = new StringBuffer(this.m_options.getDataStoreName());
                this.m_lexerSchema = new StringBuffer(this.m_options.getLexerSchema());
                this.loadLexerNames();
                this.m_lexerName = new StringBuffer(this.m_options.getLexerName());
                this.m_wordListSchema = new StringBuffer(this.m_options.getWordListSchema());
                this.loadWordListNames();
                this.m_wordListName = new StringBuffer(this.m_options.getWordListName());
                this.m_storageSchema = new StringBuffer(this.m_options.getStorageSchema());
                this.loadStorageNames();
                this.m_storageName = new StringBuffer(this.m_options.getStorageName());
                this.m_stoplistSchema = new StringBuffer(this.m_options.getStoplistSchema());
                this.loadStoplistNames();
                this.m_stoplistName = new StringBuffer(this.m_options.getStoplistName());
                this.m_filterSchema = new StringBuffer(this.m_options.getFilterSchema());
                this.loadFilterNames();
                this.m_filterName = new StringBuffer(this.m_options.getFilterName());
                this.m_sectionSchema = new StringBuffer(this.m_options.getSectionSchema());
                this.loadSectionNames();
                this.m_sectionName = new StringBuffer(this.m_options.getSectionName());
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateUseMultilexe(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateOverwriteExistingIndex(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    protected void validateOverwriteExistingIndex(Vector vector) throws Exception {
        try {
            this.m_dataState = (TextDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            this.m_settingsState = (TextSettingsState)this.getparentWizardState().getStep(StepType.SETTING_STEP_1);
            if (this.m_dataState != null && this.m_settingsState != null) {
                String string = DM4JConnectionManager.getUser();
                String string2 = this.m_dataState.getSelectedSchemaName();
                if (this.m_options != null && this.m_textSchema != null) {
                    string2 = this.m_textSchema;
                }
                if (!this.m_overwriteExistingIndex && !string2.equalsIgnoreCase(string)) {
                    vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_CANNOT_USE_EXISITING_INDEX));
                }
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_CANNOT_USE_EXISITING_INDEX));
        }
    }

    protected void validateUseMultilexe(Vector vector) throws Exception {
        try {
            this.m_dataState = (TextDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            this.m_settingsState = (TextSettingsState)this.getparentWizardState().getStep(StepType.SETTING_STEP_1);
            if (this.m_dataState != null && this.m_settingsState != null) {
                Object[] objectArray = this.m_settingsState.getSelectedAttributes();
                String string = (String)objectArray[0];
                this.m_caseTextColumnDataType = this.m_dataState.getLDSDataSource().getAttributeDataType(string);
            }
            int n = -1;
            if (this.getUseMultilexer()) {
                if (this.m_caseTextColumnDataType.equalsIgnoreCase("CLOB") && (n = this.m_dataState.getLDSDataSource().getAttributeIndex("LANGUAGE")) <= 0) {
                    vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_NO_LANGUAGE_COLUMN));
                }
                if (this.m_caseTextColumnDataType.equalsIgnoreCase("BLOB")) {
                    n = this.m_dataState.getLDSDataSource().getAttributeIndex("LANGUAGE");
                    if (n <= 0) {
                        vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_NO_LANGUAGE_COLUMN));
                    }
                    if ((n = this.m_dataState.getLDSDataSource().getAttributeIndex("FORMAT")) <= 0) {
                        vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_NO_FORMAT_COLUMN));
                    }
                    if ((n = this.m_dataState.getLDSDataSource().getAttributeIndex("CHARACTERSET")) <= 0) {
                        vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_NO_CHARSET_COLUMN));
                    }
                }
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(ODMrTextContextIndexSettingsStateError.ODMR_TEXT_SETTINGS_NO_LANGUAGE_COLUMN));
        }
    }

    public void refresh() throws Exception {
        this.load();
    }

    public void load() throws Exception {
        if (this.m_options == null) {
            this.m_schemaNames = DatabaseMetadata.getAccessibleSchemas(this.getparentWizardState().getConnection());
            this.loadDefaultDataStoreName();
            this.loadDefaultLexerName();
            this.loadDefaultWordListName();
            this.loadDefaultStorageName();
            this.loadDefaultStoplistName();
            this.loadDefaultFilterName();
            this.loadDefaultSectionName();
            this.m_overwriteExistingIndex = false;
            this.m_useMultilexer = false;
        }
    }

    protected void loadDefaultDataStoreName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_dataStoreSchema.length() == 0) {
                this.setDataStoreSchema("CTXSYS");
            }
            this.loadDataStoreNames();
            if (this.m_dataStoreNames.contains("DEFAULT_DATASTORE")) {
                this.setDataStoreName("DEFAULT_DATASTORE");
            } else {
                this.setDataStoreName((String)this.m_dataStoreNames.get(0));
            }
        }
    }

    protected void loadDefaultLexerName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_lexerSchema.length() == 0) {
                this.setLexerSchema("CTXSYS");
            }
            this.loadLexerNames();
            if (this.m_lexerNames.contains("DEFAULT_LEXER")) {
                this.setLexerName("DEFAULT_LEXER");
            } else {
                this.setLexerName((String)this.m_lexerNames.get(0));
            }
        }
    }

    protected void loadDefaultWordListName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_wordListSchema.length() == 0) {
                this.setWordListSchema("CTXSYS");
            }
            this.loadWordListNames();
            if (this.m_wordListNames.contains("DEFAULT_WORDLIST")) {
                this.setWordListName("DEFAULT_WORDLIST");
            } else {
                this.setWordListName((String)this.m_wordListNames.get(0));
            }
        }
    }

    protected void loadDefaultStorageName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_storageSchema.length() == 0) {
                this.setStorageSchema("CTXSYS");
            }
            this.loadStorageNames();
            if (this.m_storageNames.contains("DEFAULT_STORAGE")) {
                this.setStorageName("DEFAULT_STORAGE");
            } else {
                this.setStorageName((String)this.m_storageNames.get(0));
            }
        }
    }

    protected void loadDefaultStoplistName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_stoplistSchema.length() == 0) {
                this.setStoplistSchema("CTXSYS");
            }
            this.loadStoplistNames();
            if (this.m_stoplistNames.contains("DEFAULT_STOPLIST")) {
                this.setStoplistName("DEFAULT_STOPLIST");
            } else {
                this.setStoplistName((String)this.m_stoplistNames.get(0));
            }
        }
    }

    protected void loadDefaultFilterName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_filterSchema.length() == 0) {
                this.setFilterSchema("CTXSYS");
            }
            this.loadFilterNames();
            if (this.m_filterNames.contains(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"))) {
                this.setFilterName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            } else {
                this.setFilterName((String)this.m_filterNames.get(0));
            }
        }
    }

    protected void loadDefaultSectionName() throws Exception {
        if (!this.m_schemaNames.isEmpty()) {
            if (this.m_sectionSchema.length() == 0) {
                this.setSectionSchema("CTXSYS");
            }
            this.loadSectionNames();
            if (this.m_sectionNames.contains(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"))) {
                this.setSectionName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            } else {
                this.setSectionName((String)this.m_sectionNames.get(0));
            }
        }
    }

    protected void loadDataStoreNames() throws Exception {
        try {
            this.m_dataStoreNames = DatabaseMetadata.getContextSettingsNames(this.getparentWizardState().getConnection(), this.m_dataStoreSchema.toString(), "DATASTORE");
            this.m_dataStoreNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_dataStoreNames.clear();
            this.m_dataStoreNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setDataStoreName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
    }

    protected void loadLexerNames() throws Exception {
        try {
            this.m_lexerNames = DatabaseMetadata.getContextSettingsNames(this.getparentWizardState().getConnection(), this.m_lexerSchema.toString(), "LEXER");
            this.m_lexerNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_lexerNames.clear();
            this.m_lexerNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setLexerName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
    }

    protected void loadWordListNames() throws Exception {
        try {
            this.m_wordListNames = DatabaseMetadata.getContextSettingsNames(this.getparentWizardState().getConnection(), this.m_wordListSchema.toString(), "WORDLIST");
            this.m_wordListNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_wordListNames.clear();
            this.m_wordListNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setWordListName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
    }

    protected void loadStorageNames() throws Exception {
        try {
            this.m_storageNames = DatabaseMetadata.getContextSettingsNames(this.getparentWizardState().getConnection(), this.m_storageSchema.toString(), "STORAGE");
            this.m_storageNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_storageNames.clear();
            this.m_storageNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setStorageName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
    }

    protected void loadStoplistNames() throws Exception {
        try {
            this.m_stoplistNames = DatabaseMetadata.getContextSettingsStoplistNames(this.getparentWizardState().getConnection(), this.m_stoplistSchema.toString());
            this.m_stoplistNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_stoplistNames.clear();
            this.m_stoplistNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setStoplistName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
    }

    protected void loadFilterNames() throws Exception {
        try {
            this.m_filterNames = DatabaseMetadata.getContextSettingsNames(this.getparentWizardState().getConnection(), this.m_filterSchema.toString(), "FILTER");
            this.m_filterNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_filterNames.clear();
            this.m_filterNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setFilterName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
    }

    protected void loadSectionNames() throws Exception {
        try {
            this.m_sectionNames = DatabaseMetadata.getContextSettingsSectionNames(this.getparentWizardState().getConnection(), this.m_sectionSchema.toString());
            this.m_sectionNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
        catch (SQLException sQLException) {
            this.m_sectionNames.clear();
            this.m_sectionNames.add(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
            this.setSectionName(ResourceUtilities.getUILabel("ODMR_TEXT_CONTEXT_INDEX_SETTINGS_NOT_APPLICABLE"));
        }
    }

    public Vector getSchemaNames() {
        return (Vector)this.m_schemaNames.clone();
    }

    public Vector getDataStoreNames() {
        return (Vector)this.m_dataStoreNames.clone();
    }

    public Vector getLexerNames() {
        return (Vector)this.m_lexerNames.clone();
    }

    public Vector getWordListNames() {
        return (Vector)this.m_wordListNames.clone();
    }

    public Vector getStorageNames() {
        return (Vector)this.m_storageNames.clone();
    }

    public Vector getStoplistNames() {
        return (Vector)this.m_stoplistNames.clone();
    }

    public Vector getFilterNames() {
        return (Vector)this.m_filterNames.clone();
    }

    public Vector getSectionNames() {
        return (Vector)this.m_sectionNames.clone();
    }

    public String getDataStoreSchema() {
        return this.m_dataStoreSchema.toString();
    }

    public String getLexerSchema() {
        return this.m_lexerSchema.toString();
    }

    public String getWordListSchema() {
        return this.m_wordListSchema.toString();
    }

    public String getStorageSchema() {
        return this.m_storageSchema.toString();
    }

    public String getStoplistSchema() {
        return this.m_stoplistSchema.toString();
    }

    public String getFilterSchema() {
        return this.m_filterSchema.toString();
    }

    public String getSectionSchema() {
        return this.m_sectionSchema.toString();
    }

    public void setDataStoreSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_dataStoreSchema.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_dataStoreSchema = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setDataStoreSchema(string);
            }
            this.loadDefaultDataStoreName();
        }
    }

    public void setLexerSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_lexerSchema.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_lexerSchema = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setLexerSchema(string);
            }
            this.loadDefaultLexerName();
        }
    }

    public void setWordListSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_wordListSchema.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_wordListSchema = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setWordListSchema(string);
            }
            this.loadDefaultWordListName();
        }
    }

    public void setStorageSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_storageSchema.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_storageSchema = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setStorageSchema(string);
            }
            this.loadDefaultStorageName();
        }
    }

    public void setStoplistSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_stoplistSchema.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_stoplistSchema = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setStoplistSchema(string);
            }
            this.loadDefaultStoplistName();
        }
    }

    public void setFilterSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_filterSchema.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_filterSchema = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setFilterSchema(string);
            }
            this.loadDefaultFilterName();
        }
    }

    public void setSectionSchema(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_sectionSchema.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_sectionSchema = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setSectionSchema(string);
            }
            this.loadDefaultSectionName();
        }
    }

    public String getDataStoreName() {
        return this.m_dataStoreName.toString();
    }

    public String getLexerName() {
        return this.m_lexerName.toString();
    }

    public String getWordListName() {
        return this.m_wordListName.toString();
    }

    public String getStorageName() {
        return this.m_storageName.toString();
    }

    public String getStoplistName() {
        return this.m_stoplistName.toString();
    }

    public String getFilterName() {
        return this.m_filterName.toString();
    }

    public String getSectionName() {
        return this.m_sectionName.toString();
    }

    public void setDataStoreName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_dataStoreName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_dataStoreName = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setDataStoreName(string);
            }
        }
    }

    public void setLexerName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_lexerName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_lexerName = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setLexerName(string);
            }
        }
    }

    public void setWordListName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_wordListName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_wordListName = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setWordListName(string);
            }
        }
    }

    public void setStorageName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_storageName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_storageName = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setStorageName(string);
            }
        }
    }

    public void setStoplistName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_stoplistName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_stoplistName = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setStoplistName(string);
            }
        }
    }

    public void setFilterName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_filterName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_filterName = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setFilterName(string);
            }
        }
    }

    public void setSectionName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_sectionName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_sectionName = new StringBuffer(string);
            if (this.m_options != null) {
                this.m_options.setSectionName(string);
            }
        }
    }

    public boolean postValidate(Vector vector) throws Exception {
        return true;
    }

    public void setUseMultilexer(boolean bl) {
        if (this.m_useMultilexer != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_useMultilexer = bl;
            if (this.m_options != null) {
                this.m_options.setUseMultilexer(this.m_useMultilexer);
            }
        }
    }

    public boolean getUseMultilexer() {
        return this.m_useMultilexer;
    }

    public void setOverwriteExistingIndex(boolean bl) {
        if (this.m_overwriteExistingIndex != bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_overwriteExistingIndex = bl;
            if (this.m_options != null) {
                this.m_options.setOverwriteExistingIndex(this.m_overwriteExistingIndex);
            }
        }
    }

    public boolean getOverwriteExistingIndex() {
        return this.m_overwriteExistingIndex;
    }
}

