/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import oracle.dmt.dm4j.datasources.NormalizeScheme;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.validation.StateActionException;

public class NormalizeSchemeStat {
    Connection m_conn = null;
    String m_schemaName = null;
    String m_tableName = null;
    String m_attributeNameMapping = null;
    String m_valueNameMapping = null;
    boolean m_isTransaction = true;
    boolean m_bSingleMetric = false;
    String m_attrib = null;
    NormalizeScheme m_scheme = null;

    public NormalizeSchemeStat(Connection connection, String string, String string2, String string3, String string4, boolean bl, String string5, NormalizeScheme normalizeScheme) throws Exception {
        this.m_conn = connection;
        this.m_schemaName = string;
        this.m_tableName = string2;
        this.m_attrib = string5;
        this.m_scheme = normalizeScheme;
        this.m_attributeNameMapping = string3;
        this.m_valueNameMapping = string4;
        this.m_isTransaction = string3 != null && string4 != null;
        this.m_bSingleMetric = bl;
    }

    public NormalizeSchemeStat(Connection connection, String string, String string2, String string3, NormalizeScheme normalizeScheme) throws Exception {
        this(connection, string, string2, null, null, false, string3, normalizeScheme);
    }

    public NormalizeScheme getStat() throws Exception {
        this.validateFormula(this.m_scheme.getType(), this.m_scheme.getArg1(), this.m_scheme.getArg2());
        if (this.m_isTransaction && !this.m_bSingleMetric) {
            this.createDataFromTransactionalDBTable();
        } else {
            this.createDataFrom2DDBTable();
        }
        return this.m_scheme;
    }

    public static String get2DSchemeFormula(String string, int n, float f, float f2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        switch (n) {
            case 1: {
                String string2 = "EXP({0})";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string2, objectArray));
                break;
            }
            case 2: {
                String string3 = "LN({0} + {1})";
                Object[] objectArray = new Object[]{"\"" + string + "\"", f + ""};
                stringBuffer.append(MessageFormat.format(string3, objectArray));
                break;
            }
            case 3: {
                String string4 = "LN(({0} - {1}) / ({2} - {0}))";
                Object[] objectArray = new Object[]{"\"" + string + "\"", f + "", f2 + ""};
                stringBuffer.append(MessageFormat.format(string4, objectArray));
                break;
            }
            case 4: {
                String string5 = "LOG(10, {0} + {1})";
                Object[] objectArray = new Object[]{"\"" + string + "\"", f + ""};
                stringBuffer.append(MessageFormat.format(string5, objectArray));
                break;
            }
            case 5: {
                String string6 = "SQRT({0})";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string6, objectArray));
                break;
            }
            case 6: {
                String string7 = "1 / EXP(AVG({0}) OVER() - {0})";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string7, objectArray));
                break;
            }
            case 7: {
                String string8 = "DECODE(VARIANCE({0}) OVER(), 0, {2}, (({1} / VARIANCE({0}) OVER()) * ({0} - ({2} - AVG({0}) OVER()))))";
                Object[] objectArray = new Object[]{"\"" + string + "\"", f + "", f2 + ""};
                stringBuffer.append(MessageFormat.format(string8, objectArray));
                break;
            }
            case 8: {
                String string9 = "DECODE((MAX({0}) OVER() - MIN({0}) OVER()), 0, {2}, (({0} - MIN({0}) OVER()) / (MAX({0}) OVER() - MIN({0}) OVER()) * ({2} - {1}) + {1}))";
                Object[] objectArray = new Object[]{"\"" + string + "\"", f + "", f2 + ""};
                stringBuffer.append(MessageFormat.format(string9, objectArray));
                break;
            }
            case 9: {
                String string10 = "({0} - AVG({0}) OVER()) / SQRT(VARIANCE({0}) OVER())";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string10, objectArray));
                break;
            }
            case 10: {
                String string11 = "({0} / GREATEST(ABS(MIN({0}) OVER()), ABS(MAX({0}) OVER())))";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string11, objectArray));
                break;
            }
            default: {
                String string12 = "{0}";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string12, objectArray));
            }
        }
        return stringBuffer.toString();
    }

    public static String getTxnSchemeFormula(String string, int n, float f, float f2) {
        StringBuffer stringBuffer = new StringBuffer(100);
        switch (n) {
            case 1: {
                String string2 = "EXP({0})";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string2, objectArray));
                break;
            }
            case 2: {
                String string3 = "LN({0} + {1})";
                Object[] objectArray = new Object[]{"\"" + string + "\"", f + ""};
                stringBuffer.append(MessageFormat.format(string3, objectArray));
                break;
            }
            case 3: {
                String string4 = "LN(({0} - {1}) / ({2} - {0}))";
                Object[] objectArray = new Object[]{"\"" + string + "\"", f + "", f2 + ""};
                stringBuffer.append(MessageFormat.format(string4, objectArray));
                break;
            }
            case 4: {
                String string5 = "LOG(10, {0} + {1})";
                Object[] objectArray = new Object[]{"\"" + string + "\"", f + ""};
                stringBuffer.append(MessageFormat.format(string5, objectArray));
                break;
            }
            case 5: {
                String string6 = "SQRT({0})";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string6, objectArray));
                break;
            }
            case 6: {
                String string7 = "1 / EXP(AVG({0}) OVER() - {0})";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string7, objectArray));
                break;
            }
            case 7: {
                String string8 = "DECODE(VARIANCE({0}) OVER(), 0, {2}, (({1} / VARIANCE({0}) OVER()) * ({0} - ({2} - AVG({0}) OVER()))))";
                Object[] objectArray = new Object[]{"\"" + string + "\"", f + "", f2 + ""};
                stringBuffer.append(MessageFormat.format(string8, objectArray));
                break;
            }
            case 8: {
                String string9 = "DECODE((MAX({0}) OVER() - MIN({0}) OVER()), 0, {2}, (({0} - MIN({0}) OVER()) / (MAX({0}) OVER() - MIN({0}) OVER()) * ({2} - {1}) + {1}))";
                Object[] objectArray = new Object[]{"\"" + string + "\"", f + "", f2 + ""};
                stringBuffer.append(MessageFormat.format(string9, objectArray));
                break;
            }
            case 9: {
                String string10 = "({0} - AVG({0}) OVER()) / SQRT(VARIANCE({0}) OVER())";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string10, objectArray));
                break;
            }
            case 10: {
                String string11 = "({0} / GREATEST(ABS(MIN({0}) OVER()), ABS(MAX({0}) OVER())))";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string11, objectArray));
                break;
            }
            default: {
                String string12 = "{0}";
                Object[] objectArray = new Object[]{"\"" + string + "\""};
                stringBuffer.append(MessageFormat.format(string12, objectArray));
            }
        }
        return stringBuffer.toString();
    }

    private void validateFormula(int n, float f, float f2) throws Exception {
        float f3 = this.m_scheme.getOrgMin();
        float f4 = this.m_scheme.getOrgMax();
        float f5 = this.m_scheme.getOrgMean();
        switch (n) {
            case 1: {
                if (!(f4 > 70.0f)) break;
                String string = MessageFormat.format(ResourceUtilities.getstateExceptionMessage("NORMALIZE_SCHEME_INVALID_USE_EXP"), this.m_attrib);
                throw new StateActionException(string);
            }
            case 2: {
                if (!(f3 + f <= 0.0f)) break;
                String string = MessageFormat.format(ResourceUtilities.getstateExceptionMessage("NORMALIZE_SCHEME_INVALID_USE_LN"), this.m_attrib, f + "");
                throw new StateActionException(string);
            }
            case 3: {
                if (!(f3 - f <= 0.0f) && !(f2 - f4 <= 0.0f)) break;
                String string = MessageFormat.format(ResourceUtilities.getstateExceptionMessage("NORMALIZE_SCHEME_INVALID_USE_LN2"), this.m_attrib, f + "", f2 + "");
                throw new StateActionException(string);
            }
            case 4: {
                if (!(f3 + f <= 0.0f)) break;
                String string = MessageFormat.format(ResourceUtilities.getstateExceptionMessage("NORMALIZE_SCHEME_INVALID_USE_LOG"), this.m_attrib, f + "");
                throw new StateActionException(string);
            }
            case 5: {
                if (!(f3 < 0.0f)) break;
                String string = MessageFormat.format(ResourceUtilities.getstateExceptionMessage("NORMALIZE_SCHEME_INVALID_USE_SQRT"), this.m_attrib);
                throw new StateActionException(string);
            }
            case 6: {
                if (!(f5 - f3 > 70.0f)) break;
                String string = MessageFormat.format(ResourceUtilities.getstateExceptionMessage("NORMALIZE_SCHEME_INVALID_USE_EXP2"), this.m_attrib);
                throw new StateActionException(string);
            }
            case 7: {
                if (!(f <= 0.0f)) break;
                throw new StateActionException(ResourceUtilities.getstateExceptionMessage("NORMALIZE_SCHEME_INVALID_USE_MEAN"));
            }
            case 8: {
                if (!(f >= f2)) break;
                String string = MessageFormat.format(ResourceUtilities.getstateExceptionMessage("NORMALIZE_SCHEME_INVALID_USE_SCALE"), this.m_attrib, f + "", f2 + "");
                throw new StateActionException(string);
            }
        }
    }

    protected void createDataFrom2DDBTable() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(1000);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        StringBuffer stringBuffer3 = new StringBuffer(100);
        StringBuffer stringBuffer4 = new StringBuffer(100);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object[] objectArray = new Object[]{"a", this.m_attrib};
            stringBuffer.append(MessageFormat.format("ROUND((SUM(POWER(\"{0}\",3)) / GREATEST(((COUNT(\"{1}\")-1)*POWER(STDDEV(\"{1}\"),3)),0.001)), 2) skewness,ROUND((SUM(POWER(\"{0}\",4)) / GREATEST(((COUNT(\"{1}\")-1)*POWER(STDDEV(\"{1}\"),4)),0.001)-3), 2) kurtosis,ROUND(AVG(\"{1}\"), 2) mean,ROUND(STDDEV(\"{1}\"), 2) std,ROUND(MIN(\"{1}\"), 2) min,ROUND(MAX(\"{1}\"), 2) max", objectArray));
            stringBuffer2.append(MessageFormat.format("\"{1}\", (\"{1}\"-(AVG(\"{1}\") OVER())) \"{0}\"", objectArray));
            Object[] objectArray2 = new Object[]{stringBuffer.toString(), stringBuffer2.toString()};
            stringBuffer3.append(MessageFormat.format("SELECT {0} FROM (SELECT {1} FROM r)", objectArray2));
            Object[] objectArray3 = new Object[]{NormalizeSchemeStat.get2DSchemeFormula(this.getColumnValue(this.m_attrib), this.m_scheme.getType(), this.m_scheme.getArg1(), this.m_scheme.getArg2()), this.m_attrib, this.m_schemaName, this.m_tableName, stringBuffer3.toString()};
            stringBuffer4.append(MessageFormat.format("WITH r AS (SELECT {0} \"{1}\" FROM \"{2}\".\"{3}\") {4}", objectArray3));
            statement = this.m_conn.createStatement();
            resultSet = statement.executeQuery(stringBuffer4.toString());
            int n = 1;
            if (resultSet.next()) {
                String string = resultSet.getString(n++);
                String string2 = resultSet.getString(n++);
                String string3 = resultSet.getString(n++);
                String string4 = resultSet.getString(n++);
                String string5 = resultSet.getString(n++);
                String string6 = resultSet.getString(n++);
                this.m_scheme.setNewSkewness(Float.parseFloat(string.trim()));
                this.m_scheme.setNewKurtosis(Float.parseFloat(string2.trim()));
                this.m_scheme.setNewMean(Float.parseFloat(string3.trim()));
                this.m_scheme.setNewStd(Float.parseFloat(string4.trim()));
                this.m_scheme.setNewMin(Float.parseFloat(string5.trim()));
                this.m_scheme.setNewMax(Float.parseFloat(string6.trim()));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }

    private String getColumnValue(String string) {
        return this.m_bSingleMetric ? this.m_valueNameMapping : string;
    }

    private void createDataFromTransactionalDBTable() throws SQLException {
        StringBuffer stringBuffer = new StringBuffer(1000);
        StringBuffer stringBuffer2 = new StringBuffer(100);
        StringBuffer stringBuffer3 = new StringBuffer(100);
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            Object[] objectArray = new Object[]{this.m_valueNameMapping};
            stringBuffer.append(MessageFormat.format("ROUND((SUM(power(a,3))/GREATEST(((count(\"{0}\")-1)*power(stddev(\"{0}\"),3)),0.001)), 2) skewness, ROUND((SUM(power(a,4))/GREATEST(((count(\"{0}\")-1)*power(stddev(\"{0}\"),4)),0.001)-3), 2) kurtosis, ROUND(AVG(\"{0}\"), 2) mean, ROUND(VARIANCE(\"{0}\"), 2) std, ROUND(MIN(\"{0}\"), 2) min, ROUND(MAX(\"{0}\"), 2) max ", objectArray));
            Object[] objectArray2 = new Object[]{stringBuffer.toString(), this.m_valueNameMapping};
            stringBuffer2.append(MessageFormat.format("SELECT {0} FROM (SELECT \"{1}\", (\"{1}\"-(AVG(\"{1}\") over())) a FROM r)", objectArray2));
            Object[] objectArray3 = new Object[]{NormalizeSchemeStat.getTxnSchemeFormula(this.m_valueNameMapping, this.m_scheme.getType(), this.m_scheme.getArg1(), this.m_scheme.getArg2()), this.m_valueNameMapping, this.m_schemaName, this.m_tableName, this.m_attributeNameMapping, this.m_attrib, stringBuffer2.toString()};
            stringBuffer3.append(MessageFormat.format("WITH r AS (SELECT {0} \"{1}\" FROM \"{2}\".\"{3}\" WHERE \"{4}\" = ''{5}'') {6}", objectArray3));
            statement = this.m_conn.createStatement();
            resultSet = statement.executeQuery(stringBuffer3.toString());
            int n = 1;
            if (resultSet.next()) {
                String string = resultSet.getString(n++);
                String string2 = resultSet.getString(n++);
                String string3 = resultSet.getString(n++);
                String string4 = resultSet.getString(n++);
                String string5 = resultSet.getString(n++);
                String string6 = resultSet.getString(n++);
                this.m_scheme.setNewSkewness(Float.parseFloat(string.trim()));
                this.m_scheme.setNewKurtosis(Float.parseFloat(string2.trim()));
                this.m_scheme.setNewMean(Float.parseFloat(string3.trim()));
                this.m_scheme.setNewStd(Float.parseFloat(string4.trim()));
                this.m_scheme.setNewMin(Float.parseFloat(string5.trim()));
                this.m_scheme.setNewMax(Float.parseFloat(string6.trim()));
            }
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
            throw sQLException;
        }
        finally {
            try {
                resultSet.close();
                statement.close();
            }
            catch (Exception exception) {}
        }
    }
}

