/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.SQLException;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transforms.TransformWizardState;
import oracle.dmt.dm4j.wizard.state.transformsteps.ViewNameState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.FinishStateError;

public class FinishState
extends WizardStepState {
    protected StringBuffer m_componentName = new StringBuffer();
    protected final int NAME_LENGTH_MAX = 30;
    protected final String DEFAULT_PACKAGE_NAME = "MINING_TRANSFORMATION";
    private boolean m_generateStoredProcedure = false;

    public FinishState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public Vector validatePackageName() throws Exception {
        Vector vector = new Vector();
        this.validatePackageName(vector);
        return vector;
    }

    private void validatePackageName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (this.m_componentName.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("PACKAGE_NAME")};
            vector.add(new StateValidation(FinishStateError.PACKAGE_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_componentName.toString(), 30)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("PACKAGE_NAME"), Integer.toString(30)};
            vector.add(new StateValidation(FinishStateError.PACKAGE_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (ValidationUtil.isGreater32BytesInDB(this.m_componentName.toString(), this.getparentWizardState().getConnection())) {
            string = ResourceUtilities.getstateExceptionMessage("GREATER_THAN_30BYTES");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("PACKAGE_NAME")};
            vector.add(new StateValidation(FinishStateError.PACKAGE_NAME_GREATER_30BYTES, string, stringArray));
        }
        if (!ValidationUtil.isValidNonQuotedDBObjectName(this.m_componentName.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("INVALID_NON_QUOTED_PACKAGE_NAME");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("PACKAGE_NAME")};
            vector.add(new StateValidation(FinishStateError.INVALID_NON_QUOTED_PACKAGE_NAME, string, stringArray));
        }
        if (ValidationUtil.containsDoubleQuote(this.m_componentName.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("CONTAINS_DOUBLE_QUOTES");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("PACKAGE_NAME")};
            vector.add(new StateValidation(FinishStateError.PACKAGE_NAME_CONTAINS_DOUBLE_QUOTES, string, stringArray));
        }
        if (ValidationUtil.isEqualToROWID(this.m_componentName.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("EQUALS_ROWID");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("PACKAGE_NAME")};
            vector.add(new StateValidation(FinishStateError.PACKAGE_NAME_EQUALS_ROWID, string, stringArray));
        }
        if (ValidationUtil.containsSingleQuote(this.m_componentName.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("CONTAINS_SINGLE_QUOTES");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("PACKAGE_NAME")};
            vector.add(new StateValidation(FinishStateError.PACKAGE_NAME_CONTAINS_SINGLE_QUOTES, string, stringArray));
        }
        string = DM4JConnectionManager.getUser();
        if (!ValidationUtil.isTableNameUnique(this.m_componentName.toString(), this.getparentWizardState().getConnection())) {
            vector.add(new StateValidation(FinishStateError.PACKAGE_NAME_DUPLICATE));
        }
        if (this.doesNameConflictWithViewNameState(this.m_componentName.toString())) {
            vector.add(new StateValidation(FinishStateError.PACKAGE_NAME_CONFLICTS_WITH_OUTPUT));
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    protected boolean doesNameConflictWithViewNameState(String string) {
        ViewNameState viewNameState = (ViewNameState)this.getparentWizardState().getStep(StepType.NAME_STEP);
        return viewNameState.getViewName().equals(string);
    }

    public void refresh() throws Exception {
        this.load();
    }

    public void load() throws Exception {
    }

    public TransformWizardState getTransformWizardState() {
        return (TransformWizardState)this.getparentWizardState();
    }

    protected void generateDefaultComponentName() throws SQLException {
    }

    public String getComponentName() {
        return this.m_componentName.toString();
    }

    public void setComponentName(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_componentName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_componentName = new StringBuffer(string);
        }
    }

    public boolean isGenerateStoredProcedure() {
        return this.m_generateStoredProcedure;
    }

    public void setGenerateStoredProcedure(boolean bl) {
        if (!this.m_generateStoredProcedure == bl) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_generateStoredProcedure = bl;
        }
    }
}

