/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.browser.BrowserFrame;
import oracle.dmt.dm4j.browser.ProgressBar;
import oracle.dmt.dm4j.datasources.XnlAttrListDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.MultiRecordCaseData;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.FilterXnlSettingsStateError;

public class FilterXnlAttrListState
extends WizardStepState {
    private ArrayList m_attrList = null;
    private Object[] m_selectedAttrs = null;

    public FilterXnlAttrListState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        if (this.m_selectedAttrs == null || this.m_selectedAttrs.length < 2) {
            String string = ResourceUtilities.getstateExceptionMessage("FILTER_XNL_MIN_ATTRIBUTES");
            String[] stringArray = null;
            vector.add(new StateValidation(FilterXnlSettingsStateError.FILTER_XNL_MIN_ATTRIBUTES, string, stringArray));
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void refresh() throws Exception {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() throws Exception {
        Connection connection = null;
        boolean bl = true;
        MultiRecordCaseData multiRecordCaseData = (MultiRecordCaseData)this.getparentWizardState().getStep(StepType.DATA_STEP);
        XnlAttrListDataSource xnlAttrListDataSource = null;
        if (multiRecordCaseData.getSelectedTableName() != null) {
            try {
                connection = DM4JConnectionManager.getDbConnection();
                xnlAttrListDataSource = new XnlAttrListDataSource(connection, multiRecordCaseData.getSelectedSchemaName(), multiRecordCaseData.getSelectedTableName(), multiRecordCaseData.getSequenceIDMapping(), multiRecordCaseData.getAttributeNameMapping(), multiRecordCaseData.getValueMapping());
                ProgressBar progressBar = new ProgressBar(BrowserFrame.getMainFrame(), ResourceUtilities.getUILabel("ATTRIBUTE_VALUE_COUNT_DIALOG_TITLE"), xnlAttrListDataSource, true);
                xnlAttrListDataSource.setProgressBar(progressBar);
                progressBar.start(ResourceUtilities.getUILabel("ATTRIBUTE_CASES_DIALOG_TITLE"), "");
                if (xnlAttrListDataSource.getException() != null) {
                    this.setState(StepStateType.DIRTY);
                    bl = false;
                    this.getparentWizardState().doAbortCancel(xnlAttrListDataSource.getException());
                } else if (progressBar.hasUserCancelled()) {
                    this.setState(StepStateType.DIRTY);
                    bl = false;
                } else {
                    this.m_attrList = xnlAttrListDataSource.getAttributeList();
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
        }
    }

    public ArrayList getAttributeList() {
        return this.m_attrList;
    }

    public void setSelectedAttributes(Object[] objectArray) {
        this.m_selectedAttrs = objectArray;
        this.setState(StepStateType.LOADED);
    }

    public Object[] getSelectedAttributes() {
        return this.m_selectedAttrs;
    }
}

