/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.sql.PLSQLAnonymousBlock;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.Filter2DSettingsStateError;
import oracle.jdbc.OracleCallableStatement;

public class Filter2DSettingsState
extends WizardStepState {
    protected StringBuffer m_condition = new StringBuffer("");

    public Filter2DSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        this.validateEmptyExpression(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateExpression(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void validateExpression(Vector vector) throws Exception {
        try {
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            String string = this.m_condition.toString();
            Object var4_5 = null;
            if (null == string || string.equalsIgnoreCase("")) {
                vector.add(new StateValidation(Filter2DSettingsStateError.FILTER_2D_EMPTY_EXPRESSION));
            }
            Object[] objectArray = new Object[]{((DataState)this.getDataState()).getSelectedSchemaName(), ((DataState)this.getDataState()).getSelectedTableName(), string};
            String string2 = MessageFormat.format("SELECT * FROM \"{0}\".\"{1}\" WHERE {2}", objectArray);
            StringBuffer stringBuffer = new StringBuffer(string2);
            StringBuffer[] stringBufferArray = new StringBuffer[]{stringBuffer};
            PLSQLAnonymousBlock pLSQLAnonymousBlock = new PLSQLAnonymousBlock(stringBufferArray, true);
            String string3 = pLSQLAnonymousBlock.getResult();
            Connection connection = null;
            String string4 = null;
            try {
                connection = DM4JConnectionManager.getDbConnection();
                OracleCallableStatement oracleCallableStatement = (OracleCallableStatement)connection.prepareCall(string3);
                oracleCallableStatement.registerOutParameter(1, 12);
                oracleCallableStatement.execute();
                string4 = oracleCallableStatement.getString(1);
                if (null != string4 && string4.length() > 0) {
                    vector.add(new StateValidation(Filter2DSettingsStateError.FILTER_2D_INVALID_EXPRESSION));
                }
            }
            catch (SQLException sQLException) {
                vector.add(new StateValidation(Filter2DSettingsStateError.FILTER_2D_INVALID_EXPRESSION));
            }
            finally {
                try {
                    connection.close();
                }
                catch (Exception exception) {}
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(Filter2DSettingsStateError.FILTER_2D_INVALID_EXPRESSION));
        }
    }

    public void validateEmptyExpression(Vector vector) throws Exception {
        String string = this.m_condition.toString();
        if (string.length() == 0) {
            vector.add(new StateValidation(Filter2DSettingsStateError.FILTER_2D_EMPTY_EXPRESSION));
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
        this.loadDefaults();
    }

    protected void loadDefaults() {
    }

    public void setCondition(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_condition.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_condition = new StringBuffer(string);
        }
    }

    public String getCondition() {
        return this.m_condition.toString();
    }

    public WizardStepState getDataState() {
        return this.getparentWizardState().getStep(StepType.DATA_STEP);
    }
}

