/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dmt.dm4j.wizard.director.transforms.TransformsDirector;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.OpenFileState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.transformsteps.FileImportTableSettingsPanel;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.FileImportTableSettingsStateError;
import oracle.dmt.dm4j.wizard.validation.transformsteps.NameStateError;

public class FileImportTableSettingsState
extends WizardStepState {
    public final String VARCHAR2 = "VARCHAR2(SIZE)";
    public final String NVARCHAR2 = "NVARCHAR2(SIZE)";
    public final String CHAR = "CHAR(SIZE)";
    public final String NCHAR = "NCHAR(SIZE)";
    public final String RAW = "RAW(SIZE)";
    public final String NUMBER = "NUMBER(PRECISION,SCALE)";
    public final String EMPTY = "EMPTY(SIZE)";
    public String EMPTY_SIZE = "0";
    public String VARCHAR2_SIZE = "4000";
    public final String NVARCHAR2_SIZE = "4000";
    public final String CHAR_SIZE = "1";
    public final String NCHAR_SIZE = "1";
    public final String RAW_SIZE = "500";
    public String NUMBER_SIZE = "10,2";
    public String NUMBER_PRECISION = "10";
    public String NUMBER_SCALE = "2";
    public final String NO_SIZE = "N/A";
    public final String DATE = "DATE";
    public final String DATE_FORMAT = "DD/MM/YYYY";
    public final String LONG = "LONG";
    public final String LONG_RAW = "LONG RAW";
    public final String ROWID = "ROWID";
    public final String CLOB = "CLOB";
    public final String NCLOB = "NCLOB";
    public final String BLOB = "BLOB";
    public final String BFILE = "BFILE";
    public final String NUMBER_NO_SIZE = "NUMBER";
    public final String DEFAULT_NAME = "NAME";
    public final String DEFAULT_TYPE = "VARCHAR2(SIZE)";
    public String DEFAULT_SIZE = "100";
    private String[] m_fieldNames;
    private String[] m_fieldDataTypes;
    private String[] m_fieldSizes;
    private String[] m_fieldNullIfs;
    private FileImportTableSettingsPanel m_panel;

    public FileImportTableSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateFieldName(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void validateSizeValues(Vector vector, Integer n, String string) throws Exception {
        if (n == null) {
            vector.add(new StateValidation(FileImportTableSettingsStateError.FILEIMPORT_EMPTY_SIZE));
        } else if (n != null) {
            if (string.equalsIgnoreCase("VARCHAR2(SIZE)") && (n < 1 || n > 4000)) {
                vector.add(new StateValidation(FileImportTableSettingsStateError.FILEIMPORT_INVALID_VARCHAR2_SIZE));
            }
            if (string.equalsIgnoreCase("NVARCHAR2(SIZE)") && (n < 1 || n > 2000)) {
                vector.add(new StateValidation(FileImportTableSettingsStateError.FILEIMPORT_INVALID_NVARCHAR2_SIZE));
            }
            if (string.equalsIgnoreCase("CHAR(SIZE)") && (n < 1 || n > 2000)) {
                vector.add(new StateValidation(FileImportTableSettingsStateError.FILEIMPORT_INVALID_CHAR_SIZE));
            }
            if (string.equalsIgnoreCase("NCHAR(SIZE)") && (n < 1 || n > 1000)) {
                vector.add(new StateValidation(FileImportTableSettingsStateError.FILEIMPORT_INVALID_NCHAR_SIZE));
            }
            if (string.equalsIgnoreCase("RAW(SIZE)") && (n < 1 || n > 2000)) {
                vector.add(new StateValidation(FileImportTableSettingsStateError.FILEIMPORT_INVALID_RAW_SIZE));
            }
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void validatePrecisionScaleValues(Vector vector, Integer n, Integer n2) throws Exception {
        if (n == null || n2 == null) {
            vector.add(new StateValidation(FileImportTableSettingsStateError.FILEIMPORT_EMPTY_NUMBER_PRECISION_SCALE));
        }
        if (n != null && n > 38) {
            vector.add(new StateValidation(FileImportTableSettingsStateError.FILEIMPORT_INVALID_PRECISION));
        }
        if (n2 != null && (n2 < -84 || n2 > 127)) {
            vector.add(new StateValidation(FileImportTableSettingsStateError.FILEIMPORT_INVALID_SCALE));
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    private void validateFieldName(Vector vector) throws Exception {
        Object object;
        Object object2;
        Object object3;
        for (int i = 0; i < this.m_fieldNames.length; ++i) {
            String[] stringArray;
            object3 = "";
            String string = null;
            object2 = null;
            object3 = new String(this.m_fieldNames[i]);
            int n = ((String)object3).length();
            if (n > 0) {
                string = ((String)object3).substring(0, 1);
                object2 = ((String)object3).substring(n - 1, n);
                if (!string.equalsIgnoreCase("\"") | !((String)object2).equalsIgnoreCase("\"")) {
                    object = ResourceUtilities.getstateExceptionMessage("COLUMN_NAME_NOT_DOUBLE_QUOTED");
                    stringArray = new String[]{object3};
                    vector.add(new StateValidation(NameStateError.COLUMN_NAME_NOT_DOUBLE_QUOTED, (String)object, stringArray));
                }
            }
            if (ValidationUtil.validationsContainsErrors(vector)) continue;
            object3 = "";
            if (this.m_fieldNames[i].length() > 0) {
                object3 = new String(this.m_fieldNames[i].substring(1, this.m_fieldNames[i].length() - 1));
            }
            if (((String)object3).length() == 0) {
                object = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                stringArray = new String[]{object3};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_EMPTY, (String)object, stringArray));
            }
            if (!ValidationUtil.checkStringLength((String)object3, 30)) {
                object = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
                stringArray = new String[]{object3, Integer.toString(30)};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_EXCEEDS_MAXIMUM_LENGTH, (String)object, stringArray));
            }
            if (ValidationUtil.isGreater32BytesInDB((String)object3, this.getparentWizardState().getConnection())) {
                object = ResourceUtilities.getstateExceptionMessage("GREATER_THAN_30BYTES");
                stringArray = new String[]{object3};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_GREATER_30BYTES, (String)object, stringArray));
            }
            if (ValidationUtil.containsDoubleQuote((String)object3)) {
                object = ResourceUtilities.getstateExceptionMessage("CONTAINS_DOUBLE_QUOTES");
                stringArray = new String[]{object3};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_CONTAINS_DOUBLE_QUOTES, (String)object, stringArray));
            }
            if (!ValidationUtil.isEqualToROWID((String)object3)) continue;
            object = ResourceUtilities.getstateExceptionMessage("EQUALS_ROWID");
            stringArray = new String[]{object3};
            vector.add(new StateValidation(NameStateError.VIEW_NAME_EQUALS_ROWID, (String)object, stringArray));
        }
        HashMap<String, String> hashMap = new HashMap<String, String>();
        object3 = new Vector();
        for (int i = 0; i < this.m_fieldNames.length; ++i) {
            if (hashMap.containsKey(this.m_fieldNames[i])) {
                ((Vector)object3).add(this.m_fieldNames[i]);
                continue;
            }
            hashMap.put(this.m_fieldNames[i], this.m_fieldNames[i]);
        }
        if (((Vector)object3).size() > 0) {
            String string = ResourceUtilities.getstateExceptionMessage("DUPLICATE_COLUMN_NAME");
            object2 = ((Vector)object3).iterator();
            StringBuffer stringBuffer = new StringBuffer();
            while (object2.hasNext()) {
                stringBuffer.append((String)object2.next());
                if (!object2.hasNext()) continue;
                stringBuffer.append(", ");
            }
            object = new String[]{stringBuffer.toString()};
            vector.add(new StateValidation(NameStateError.DUPLICATE_COLUMN_NAME, string, (String[])object));
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() throws Exception {
        this.loadDefaults();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadDefaults() {
        block52: {
            OpenFileState openFileState = (OpenFileState)this.getparentWizardState().getStep(StepType.DATA_STEP);
            FileImportSettingsState fileImportSettingsState = (FileImportSettingsState)this.getparentWizardState().getStep(StepType.SETTING_STEP);
            boolean bl = fileImportSettingsState.getHasColumnHeader();
            File file = openFileState.getFile();
            BufferedReader bufferedReader = null;
            try {
                int n;
                String string;
                int n2;
                StringTokenizer stringTokenizer;
                if (file == null) break block52;
                String string2 = fileImportSettingsState.getFieldDelimiter();
                String string3 = fileImportSettingsState.getEnclosure();
                bufferedReader = new BufferedReader(new FileReader(file));
                String string4 = bufferedReader.readLine();
                int n3 = 0;
                if (string2.equalsIgnoreCase("WHITESPACE")) {
                    stringTokenizer = new StringTokenizer(string4);
                    n3 = stringTokenizer.countTokens();
                } else {
                    stringTokenizer = new StringTokenizer(string4, string2, true);
                    StringTokenizer stringTokenizer2 = new StringTokenizer(string4, string2, false);
                    n3 = stringTokenizer.countTokens() - stringTokenizer2.countTokens() + 1;
                }
                String[] stringArray = new String[n3];
                String[] stringArray2 = new String[n3];
                String[] stringArray3 = new String[n3];
                String[] stringArray4 = new String[n3];
                boolean bl2 = false;
                if (bl) {
                    for (n2 = 0; n2 < n3; ++n2) {
                        if (stringTokenizer.hasMoreTokens()) {
                            string = stringTokenizer.nextToken();
                        } else {
                            string = "NONE" + n2;
                            bl2 = true;
                        }
                        if (string.equalsIgnoreCase(string2)) {
                            if (bl2) {
                                stringArray[n2] = "\"" + FileImportTableSettingsState.getReplacedString("NONE" + n2, string3, "") + "\"";
                                ++n2;
                                bl2 = false;
                            }
                            if (stringTokenizer.hasMoreTokens()) {
                                string = stringTokenizer.nextToken();
                            } else {
                                string = "NONE" + n2;
                                bl2 = true;
                            }
                            if (string.equalsIgnoreCase(string2)) {
                                stringArray[n2] = "\"" + FileImportTableSettingsState.getReplacedString("NONE" + n2, string3, "") + "\"";
                                bl2 = true;
                            }
                        }
                        if (string.equalsIgnoreCase(string2)) continue;
                        if (ValidationUtil.containsDoubleQuote(string = FileImportTableSettingsState.getReplacedString(string, string3, ""))) {
                            string = TransformsDirector.getReplacedString(string, "\"", "");
                        }
                        stringArray[n2] = "\"" + string + "\"";
                        bl2 = false;
                    }
                } else {
                    for (n2 = 0; n2 < n3; ++n2) {
                        stringArray[n2] = string = "\"NAME" + n2 + "\"";
                    }
                }
                if (bl) {
                    string4 = bufferedReader.readLine();
                    if (string4 != null) {
                        stringTokenizer = string2.equalsIgnoreCase("WHITESPACE") ? new StringTokenizer(string4) : new StringTokenizer(string4, string2, true);
                    } else if (string4 == null) {
                        for (n2 = 0; n2 < n3; ++n2) {
                            stringArray2[n2] = "VARCHAR2(SIZE)";
                            stringArray3[n2] = this.VARCHAR2_SIZE;
                        }
                    }
                }
                n2 = fileImportSettingsState.getFileImportAdvanceState().getRowsToScan();
                int n4 = 0;
                bl2 = false;
                while (string4 != null & n4 < n2) {
                    for (n = 0; n < n3; ++n) {
                        try {
                            if (stringTokenizer.hasMoreTokens()) {
                                string = stringTokenizer.nextToken();
                            } else {
                                string = "";
                                bl2 = true;
                            }
                            if (string.equalsIgnoreCase(string2)) {
                                if (bl2) {
                                    if (stringArray2[n] == null) {
                                        stringArray2[n] = "VARCHAR2(SIZE)";
                                        stringArray3[n] = this.VARCHAR2_SIZE;
                                    }
                                    ++n;
                                    bl2 = false;
                                }
                                if (n == n3) break;
                                if (stringTokenizer.hasMoreTokens()) {
                                    string = stringTokenizer.nextToken();
                                } else {
                                    if (stringArray2[n] == null) {
                                        stringArray2[n] = "VARCHAR2(SIZE)";
                                        stringArray3[n] = this.VARCHAR2_SIZE;
                                    }
                                    bl2 = true;
                                }
                                if (string.equalsIgnoreCase(string2)) {
                                    if (stringArray2[n] == null) {
                                        stringArray2[n] = "VARCHAR2(SIZE)";
                                        stringArray3[n] = this.VARCHAR2_SIZE;
                                    }
                                    bl2 = true;
                                }
                            }
                            if (string.equalsIgnoreCase(string2)) continue;
                            string = FileImportTableSettingsState.getReplacedString(string, string3, "");
                            bl2 = false;
                            try {
                                if (string.length() > 0) {
                                    float f = Float.parseFloat(string);
                                    if (stringArray2[n] == "VARCHAR2(SIZE)") continue;
                                    stringArray2[n] = "NUMBER";
                                    stringArray3[n] = "N/A";
                                    continue;
                                }
                                if (stringArray2[n] != null) continue;
                                stringArray2[n] = "EMPTY(SIZE)";
                                stringArray3[n] = this.EMPTY_SIZE;
                            }
                            catch (Exception exception) {
                                stringArray2[n] = "VARCHAR2(SIZE)";
                                if (n4 > 0 && string.length() > Integer.parseInt(stringArray3[n])) {
                                    Float f = new Float((double)string.length() + (double)string.length() * 0.5);
                                    stringArray3[n] = f.intValue() + "";
                                }
                                if (n4 > 0) continue;
                                stringArray3[n] = this.VARCHAR2_SIZE;
                            }
                            continue;
                        }
                        catch (Exception exception) {
                            stringArray2[n] = "VARCHAR2(SIZE)";
                            stringArray3[n] = this.VARCHAR2_SIZE;
                        }
                    }
                    ++n4;
                    string4 = bufferedReader.readLine();
                    if (string4 == null) continue;
                    if (string2.equalsIgnoreCase("WHITESPACE")) {
                        stringTokenizer = new StringTokenizer(string4);
                        continue;
                    }
                    stringTokenizer = new StringTokenizer(string4, string2, true);
                }
                for (n = 0; n < n3; ++n) {
                    if (!stringArray2[n].equals("EMPTY(SIZE)")) continue;
                    stringArray2[n] = "VARCHAR2(SIZE)";
                    stringArray3[n] = this.VARCHAR2_SIZE;
                }
                for (n = 0; n < n3; ++n) {
                    stringArray4[n] = "";
                }
                this.m_fieldNames = stringArray;
                this.m_fieldDataTypes = stringArray2;
                this.m_fieldSizes = stringArray3;
                this.m_fieldNullIfs = stringArray4;
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    if (bufferedReader != null) {
                        bufferedReader.close();
                    }
                }
                catch (Exception exception) {
                    exception.printStackTrace();
                }
            }
        }
    }

    public void setFieldNames(String[] stringArray) {
        this.m_fieldNames = stringArray;
    }

    public String[] getFieldNames() {
        return this.m_fieldNames;
    }

    public void setFieldDataTypes(String[] stringArray) {
        this.m_fieldDataTypes = stringArray;
    }

    public String[] getFieldDataTypes() {
        return this.m_fieldDataTypes;
    }

    public void setFieldSizes(String[] stringArray) {
        this.m_fieldSizes = stringArray;
    }

    public String[] getFieldSizes() {
        return this.m_fieldSizes;
    }

    public void setFieldNullIfs(String[] stringArray) {
        this.m_fieldNullIfs = stringArray;
    }

    public String[] getFieldNullIfs() {
        return this.m_fieldNullIfs;
    }

    public void setPanel(FileImportTableSettingsPanel fileImportTableSettingsPanel) {
        this.m_panel = fileImportTableSettingsPanel;
    }

    public FileImportTableSettingsPanel getPanel() {
        return this.m_panel;
    }

    public static String getReplacedString(String string, String string2, String string3) throws Exception {
        return FileImportTableSettingsState.getReplacedString(string, string2, string3.toCharArray());
    }

    public static String getReplacedString(String string, String string2, char[] cArray) throws Exception {
        int n = 0;
        int n2 = 0;
        StringBuffer stringBuffer = new StringBuffer();
        if (string2.length() > 0) {
            while ((n2 = string.indexOf(string2, n)) >= 0) {
                stringBuffer.append(string.substring(n, n2));
                stringBuffer.append(cArray);
                n = n2 + string2.length();
            }
        }
        stringBuffer.append(string.substring(n));
        return stringBuffer.toString();
    }
}

