/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.DM4JListResourceBundle;
import oracle.dmt.dm4j.browser.BrowserUtils;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.OpenFileState;
import oracle.dmt.dm4j.wizard.state.transformsteps.FileImportTableSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.FileImportDestinationStateError;
import oracle.dmt.dm4j.wizard.validation.transformsteps.NameStateError;

public class FileImportDestinationState
extends WizardStepState {
    private boolean m_useNewTable = true;
    private String m_newTableName = "";
    private StringBuffer m_dBName = new StringBuffer(0);
    private StringBuffer m_schemaName = new StringBuffer(0);
    private StringBuffer m_tableName = new StringBuffer(0);
    private Vector m_dBNames = new Vector();
    private Vector m_schemaNames = new Vector();
    private Vector m_tableNames = new Vector();

    public FileImportDestinationState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        this.validateSchemaName(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.validateTableName(vector);
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void refresh() throws Exception {
        this.loadDBNames();
        this.loadSchemaNames();
        this.loadDefaultSelectedDBName();
        this.loadDefaultSelectedSchemaName();
        this.loadDefaultSelectedTableName();
    }

    public void load() throws Exception {
        this.loadDBNames();
        this.loadSchemaNames();
        this.loadDefaultSelectedDBName();
        this.loadDefaultSelectedSchemaName();
        this.loadDefaultSelectedTableName();
        this.loadDefaultNewTableName();
    }

    private void loadDefaultNewTableName() throws Exception {
        String string;
        OpenFileState openFileState = (OpenFileState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        String string2 = openFileState.getFile().getName();
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        string2 = stringTokenizer.nextToken();
        Connection connection = this.getparentWizardState().getConnection();
        StringBuffer stringBuffer = new StringBuffer(string2.toUpperCase());
        if (stringBuffer.length() > 28) {
            stringBuffer.setLength(28);
        }
        String string3 = DM4JConnectionManager.getUser().toUpperCase();
        String string4 = ValidationUtil.createNonQuotedCompliantName(stringBuffer.toString());
        this.m_newTableName = string = ValidationUtil.createUniqueTableName(string4, connection, "");
    }

    protected void loadDBNames() throws Exception {
        Vector<String> vector = new Vector<String>();
        String string = DM4JConnectionManager.getHost();
        String string2 = DM4JConnectionManager.getPort();
        String string3 = DM4JConnectionManager.getSid();
        String string4 = string + ":" + string2 + ":" + string3;
        vector.add(string4.toUpperCase());
        this.m_dBNames = vector;
    }

    protected void loadSchemaNames() throws Exception {
        this.m_schemaNames = DatabaseMetadata.getAccessibleSchemas(this.getparentWizardState().getConnection());
    }

    protected void loadDefaultSelectedDBName() throws Exception {
        if (this.m_dBNames.isEmpty()) {
            return;
        }
        String string = DM4JConnectionManager.getHost();
        String string2 = DM4JConnectionManager.getPort();
        String string3 = DM4JConnectionManager.getSid();
        String string4 = string + ":" + string2 + ":" + string3;
        this.setSelectedDBName(string4.toUpperCase());
    }

    protected void loadDefaultSelectedSchemaName() throws Exception {
        if (this.m_schemaNames.isEmpty()) {
            return;
        }
        this.setSelectedSchemaName(DM4JConnectionManager.getUser().toUpperCase());
    }

    protected void loadTableNames() throws Exception {
        this.m_tableNames = DatabaseMetadata.getAccessableTablesAndViews(this.getparentWizardState().getConnection(), this.m_schemaName.toString());
    }

    protected void loadDefaultSelectedTableName() throws Exception {
        if (this.m_tableNames.isEmpty()) {
            return;
        }
        this.setSelectedTableName((String)this.m_tableNames.firstElement());
    }

    public Vector getDBNames() {
        return (Vector)this.m_dBNames.clone();
    }

    public Vector getSchemaNames() {
        return (Vector)this.m_schemaNames.clone();
    }

    public Vector getTableNames() {
        return (Vector)this.m_tableNames.clone();
    }

    public String getSelectedDBName() {
        return this.m_dBName.toString();
    }

    public String getSelectedSchemaName() {
        return this.m_schemaName.toString();
    }

    public void setSelectedDBName(String string) throws Exception {
        String string2;
        if (string != null && !this.m_dBName.equals(string2 = this.m_dBName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_dBName = new StringBuffer(string);
            this.loadDBNames();
            this.loadDefaultSelectedTableName();
        }
    }

    public void setSelectedSchemaName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_schemaName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_schemaName = new StringBuffer(string);
            this.loadTableNames();
            this.loadDefaultSelectedTableName();
        }
    }

    public String getSelectedTableName() {
        return this.m_tableName.toString();
    }

    public void setSelectedTableName(String string) throws Exception {
        String string2;
        if (string != null && !string.equals(string2 = this.m_tableName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_tableName = new StringBuffer(string);
        }
    }

    private void validateSchemaName(Vector vector) throws Exception {
        String string = this.m_schemaName.toString();
        if (!this.isSchemaNameValid(string)) {
            // empty if block
        }
    }

    private void validateTableName(Vector vector) throws Exception {
        if (!this.m_useNewTable) {
            this.checkAppendedTable(vector);
        }
        if (this.m_useNewTable) {
            String[] stringArray;
            String string;
            if (this.m_newTableName.length() == 0) {
                string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
                stringArray = new String[]{this.m_newTableName};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_EMPTY, string, stringArray));
            }
            if (!ValidationUtil.checkStringLength(this.m_newTableName, 30)) {
                string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
                stringArray = new String[]{this.m_newTableName, Integer.toString(30)};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
            }
            if (ValidationUtil.isGreater32BytesInDB(this.m_newTableName, this.getparentWizardState().getConnection())) {
                string = ResourceUtilities.getstateExceptionMessage("GREATER_THAN_30BYTES");
                stringArray = new String[]{this.m_newTableName};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_GREATER_30BYTES, string, stringArray));
            }
            if (ValidationUtil.containsDoubleQuote(this.m_newTableName)) {
                string = ResourceUtilities.getstateExceptionMessage("CONTAINS_DOUBLE_QUOTES");
                stringArray = new String[]{this.m_newTableName};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_CONTAINS_DOUBLE_QUOTES, string, stringArray));
            }
            if (ValidationUtil.isEqualToROWID(this.m_newTableName)) {
                string = ResourceUtilities.getstateExceptionMessage("EQUALS_ROWID");
                stringArray = new String[]{this.m_newTableName};
                vector.add(new StateValidation(NameStateError.VIEW_NAME_EQUALS_ROWID, string, stringArray));
            }
            string = DM4JConnectionManager.getUser().toUpperCase();
            if (!ValidationUtil.isTableNameUnique(this.m_newTableName, this.getparentWizardState().getConnection())) {
                vector.add(new StateValidation(NameStateError.VIEW_NAME_DUPLICATE));
            }
        } else {
            String string = this.m_tableName.toString();
            if (!this.isTableNameValid(string)) {
                // empty if block
            }
        }
    }

    public boolean postValidate(Vector vector) throws Exception {
        return true;
    }

    public boolean isSchemaNameValid(String string) {
        Iterator iterator = this.m_schemaNames.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public boolean isTableNameValid(String string) {
        Iterator iterator = this.m_tableNames.iterator();
        boolean bl = false;
        while (iterator.hasNext() && !bl) {
            String string2 = (String)iterator.next();
            if (!string.equals(string2)) continue;
            bl = true;
        }
        return bl;
    }

    public void setUseNewTable(boolean bl) {
        this.m_useNewTable = bl;
    }

    public boolean getUseNewTable() {
        return this.m_useNewTable;
    }

    public void setNewTableName(String string) {
        this.m_newTableName = string;
    }

    public String getNewTableName() {
        return this.m_newTableName;
    }

    private String getJavaTypeName(int n) throws Exception {
        String string = null;
        if (n == 12) {
            string = "VARCHAR2";
        } else if (n == 1) {
            string = "CHAR";
        } else if (n == 93) {
            string = "DATE";
        } else if (n == -1) {
            string = "LONG";
        } else if (n == -4) {
            string = "LONG_RAW";
        } else if (n == -3) {
            string = "RAW";
        } else if (n == 2005) {
            string = "CLOB";
        } else if (n == 2004) {
            string = "BLOB";
        } else if (n == 2) {
            string = "NUMBER";
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void checkAppendedTable(Vector vector) throws Exception {
        FileImportTableSettingsState fileImportTableSettingsState = (FileImportTableSettingsState)this.getparentWizardState().getStep(StepType.SETTING_STEP_1);
        String[] stringArray = fileImportTableSettingsState.getFieldNames();
        String[] stringArray2 = fileImportTableSettingsState.getFieldDataTypes();
        String[] stringArray3 = fileImportTableSettingsState.getFieldSizes();
        Statement statement = null;
        ResultSet resultSet = null;
        Connection connection = null;
        try {
            int n;
            DM4JListResourceBundle dM4JListResourceBundle = BrowserUtils.getBundleInstance();
            Object[] objectArray = new Object[]{this.getSelectedSchemaName(), this.getSelectedTableName()};
            String string = MessageFormat.format("SELECT * FROM \"{0}\".\"{1}\"", objectArray);
            connection = DM4JConnectionManager.getDbConnection();
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string);
            ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
            int n2 = resultSetMetaData.getColumnCount();
            String[] stringArray4 = new String[n2];
            int[] nArray = new int[n2];
            for (n = 0; n < n2; ++n) {
                stringArray4[n] = "\"" + resultSetMetaData.getColumnName(n + 1) + "\"";
                nArray[n] = resultSetMetaData.getColumnType(n + 1);
            }
            if (stringArray4.length != stringArray.length) {
                vector.add(new StateValidation(FileImportDestinationStateError.FILEIMPORT_INVALID_COLUMN_COUNT));
                return;
            }
            for (n = 0; n < n2; ++n) {
                if (!stringArray[n].equalsIgnoreCase(stringArray4[n])) {
                    vector.add(new StateValidation((ValidationType)FileImportDestinationStateError.FILEIMPORT_INVALID_COLUMN_NAME, new String[]{stringArray[n], stringArray4[n]}));
                    return;
                }
                String string2 = stringArray2[n];
                fileImportTableSettingsState.getClass();
                if (string2.equalsIgnoreCase("VARCHAR2(SIZE)") & nArray[n] != 12 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.NVARCHAR2) & nArray[n] != 12 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.CHAR) & nArray[n] != 1 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.NCHAR) & nArray[n] != 1 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.DATE) & nArray[n] != 93 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.LONG) & nArray[n] != -1 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.LONG_RAW) & nArray[n] != -4 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.RAW) & nArray[n] != -3 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.CLOB) & nArray[n] != 2005 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.NCLOB) & nArray[n] != 2005 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.BLOB) & nArray[n] != 2004 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.NUMBER) & nArray[n] != 2 | stringArray2[n].equalsIgnoreCase(fileImportTableSettingsState.NUMBER_NO_SIZE) & nArray[n] != 2) {
                    vector.add(new StateValidation((ValidationType)FileImportDestinationStateError.FILEIMPORT_INVALID_COLUMN_TYPE, new String[]{stringArray[n], this.getJavaTypeName(nArray[n])}));
                    return;
                }
                if (stringArray3[n].equalsIgnoreCase(fileImportTableSettingsState.NO_SIZE)) continue;
                StringTokenizer stringTokenizer = new StringTokenizer(stringArray3[n], ",");
                int n3 = stringTokenizer.countTokens();
                if (n3 == 1) {
                    int n4 = Integer.parseInt((String)stringTokenizer.nextElement());
                    if (resultSetMetaData.getColumnDisplaySize(n + 1) >= n4) continue;
                    vector.add(new StateValidation((ValidationType)FileImportDestinationStateError.FILEIMPORT_INVALID_COLUMN_SIZE, new String[]{stringArray[n], "SIZE < or =" + resultSetMetaData.getColumnDisplaySize(n + 1)}));
                    return;
                }
                if (n3 != 2) continue;
                int n5 = Integer.parseInt((String)stringTokenizer.nextElement());
                int n6 = Integer.parseInt((String)stringTokenizer.nextElement());
                if (resultSetMetaData.getPrecision(n + 1) <= 0) continue;
                if (resultSetMetaData.getPrecision(n + 1) < n5) {
                    vector.add(new StateValidation((ValidationType)FileImportDestinationStateError.FILEIMPORT_INVALID_COLUMN_SIZE, new String[]{stringArray[n], "PRECISION < or =" + resultSetMetaData.getPrecision(n + 1)}));
                    return;
                }
                if (resultSetMetaData.getScale(n + 1) >= n6) continue;
                vector.add(new StateValidation((ValidationType)FileImportDestinationStateError.FILEIMPORT_INVALID_COLUMN_SIZE, new String[]{stringArray[n], "SCALE < or =" + resultSetMetaData.getScale(n + 1)}));
                return;
            }
        }
        catch (Exception exception) {
        }
        finally {
            resultSet.close();
            statement.close();
            connection.close();
        }
    }
}

