/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.io.File;
import java.util.Vector;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardStepState;

public class FileImportAdvanceState {
    boolean m_save = false;
    private File m_log_dir;
    private File m_bad_dir;
    private File m_discard_dir;
    private Integer m_discard_maximum;
    private Integer m_skip_count;
    private Integer m_load_count;
    private Integer m_max_error;
    private boolean m_use_direct_path;
    private Integer m_rows_to_scan;
    private WizardStepState m_wizardStepState;
    static final String g_rows_to_scan = "TRANSFORMFILEIMPORTROWSSCAN";
    static final String g_use_direct_path = "TRANSFORMFILEIMPORTDIRECTPATH";
    static final String g_max_error = "TRANSFORMFILEIMPORTMAXERROR";
    static final String g_load_count = "TRANSFORMFILEIMPORTLOADCOUNT";
    static final String g_skip_count = "TRANSFORMFILEIMPORTSKIPCOUNT";
    static final String g_discard_maximum = "TRANSFORMFILEIMPORTDISCMAX";

    public FileImportAdvanceState(WizardStepState wizardStepState) throws Exception {
        this.m_wizardStepState = wizardStepState;
        this.loadDefaults();
    }

    public void validate(Vector vector) throws Exception {
    }

    public void setSave(boolean bl) {
        this.m_save = bl;
    }

    public boolean getSave() {
        return this.m_save;
    }

    protected void loadDefaults() throws Exception {
        this.m_discard_maximum = new Integer(100);
        this.m_skip_count = new Integer(0);
        this.m_load_count = new Integer(0);
        this.m_max_error = new Integer(100);
        this.m_use_direct_path = true;
        this.m_rows_to_scan = new Integer(1000);
        try {
            UserPreferences userPreferences = UserPreferences.getInstance();
            if (userPreferences.isKeyThere(g_use_direct_path)) {
                this.m_use_direct_path = userPreferences.getBooleanValue(g_use_direct_path);
            }
            if (userPreferences.isKeyThere(g_discard_maximum)) {
                this.m_discard_maximum = userPreferences.getIntegerValue(g_discard_maximum);
            }
            if (userPreferences.isKeyThere(g_skip_count)) {
                this.m_skip_count = userPreferences.getIntegerValue(g_skip_count);
            }
            if (userPreferences.isKeyThere(g_load_count)) {
                this.m_load_count = userPreferences.getIntegerValue(g_load_count);
            }
            if (userPreferences.isKeyThere(g_max_error)) {
                this.m_max_error = userPreferences.getIntegerValue(g_max_error);
            }
            if (userPreferences.isKeyThere(g_rows_to_scan)) {
                this.m_rows_to_scan = userPreferences.getIntegerValue(g_rows_to_scan);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public File getLogDirectory() {
        return this.m_log_dir;
    }

    public void setLogDirectory(File file) {
        if (file != null) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_log_dir = file;
        }
    }

    public File getBadDirectory() {
        return this.m_bad_dir;
    }

    public void setBadDirectory(File file) {
        if (file != null) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_bad_dir = file;
        }
    }

    public File getDiscardDirectory() {
        return this.m_discard_dir;
    }

    public void setDiscardDirectory(File file) {
        if (file != null) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_discard_dir = file;
        }
    }

    public Integer getDiscardMaximum() {
        return this.m_discard_maximum;
    }

    public void setDiscardMaximum(Integer n) {
        if (n != null) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_discard_maximum = n;
            try {
                UserPreferences userPreferences = UserPreferences.getInstance();
                userPreferences.setIntegerValue(g_discard_maximum, this.m_discard_maximum);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Integer getSkipCount() {
        return this.m_skip_count;
    }

    public void setSkipCount(Integer n) {
        if (n != null) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_skip_count = n;
            try {
                UserPreferences userPreferences = UserPreferences.getInstance();
                userPreferences.setIntegerValue(g_skip_count, this.m_skip_count);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Integer getLoadCount() {
        return this.m_load_count;
    }

    public void setLoadCount(Integer n) {
        if (n != null) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_load_count = n;
            try {
                UserPreferences userPreferences = UserPreferences.getInstance();
                userPreferences.setIntegerValue(g_load_count, this.m_load_count);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Integer getMaxError() {
        return this.m_max_error;
    }

    public void setMaxError(Integer n) {
        if (n != null) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_max_error = n;
            try {
                UserPreferences userPreferences = UserPreferences.getInstance();
                userPreferences.setIntegerValue(g_max_error, this.m_max_error);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public Integer getRowsToScan() {
        return this.m_rows_to_scan;
    }

    public void setRowsToScan(Integer n) {
        if (n != null) {
            if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
                this.m_wizardStepState.setState(StepStateType.DIRTY);
            }
            this.m_rows_to_scan = n;
            try {
                UserPreferences userPreferences = UserPreferences.getInstance();
                userPreferences.setIntegerValue(g_rows_to_scan, this.m_rows_to_scan);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public boolean getUseDirectPath() {
        return this.m_use_direct_path;
    }

    public void setUseDirectPath(boolean bl) {
        if (this.m_wizardStepState.getState() == StepStateType.VALIDATED) {
            this.m_wizardStepState.setState(StepStateType.DIRTY);
        }
        this.m_use_direct_path = bl;
        try {
            UserPreferences userPreferences = UserPreferences.getInstance();
            userPreferences.setBooleanValue(g_use_direct_path, this.m_use_direct_path);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }
}

