/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.util.Vector;
import oracle.dmt.dm4j.activity.steps.DiscretizationStepOptions;
import oracle.dmt.dm4j.browser.BrowserContext;
import oracle.dmt.dm4j.browser.LaunchPoint;
import oracle.dmt.dm4j.datasources.DiscretizeDataSource;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.commonsteps.DataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.BinBoundary;
import oracle.dmt.dm4j.wizard.state.transformsteps.BinBoundaryTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.CategoricalDiscretizationSettingsState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationType;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.DiscretizeSettingsStateError;
import oracle.dmt.odm.binning.Bin;
import oracle.dmt.odm.binning.BinningType;

public class DiscretizationSettingsState
extends WizardStepState {
    protected StringBuffer m_viewDefinition = null;
    protected int m_currentNumberOfBins = DiscretizeDataSource.DEFAULT_BIN_NUMBER;
    protected double m_currentTailPercent = 0.0;
    protected Vector m_vectorBins = new Vector();
    protected boolean m_bRecalulate = true;
    protected BinningType m_binningType = BinningType.QTILE;
    protected DiscretizationStepOptions m_options = null;
    static String QUANTILE_BINNING = ResourceUtilities.getUILabel("QUANTILE_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String EQUAL_WIDTH_BINNING = ResourceUtilities.getUILabel("EQUAL_WIDTH_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String TOPN_BINNING = ResourceUtilities.getUILabel("TOPN_BINNING_STRATEGY_DIALOG_DESCRIPTION");
    static String NONE = ResourceUtilities.getUILabel("NONE");

    public DiscretizationSettingsState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        BrowserContext browserContext = wizardState.getBrowserContext();
        if (browserContext.getLaunchPoint().equals(LaunchPoint.ACTIVITY_GUIDE) && browserContext.getOptions() instanceof DiscretizationStepOptions) {
            this.m_options = (DiscretizationStepOptions)browserContext.getOptions();
        }
        if (this.m_options != null) {
            this.m_binningType = this.m_options.getNumericalDiscretizeTreatment().equalsIgnoreCase(QUANTILE_BINNING) ? BinningType.QTILE : (this.m_options.getNumericalDiscretizeTreatment().equalsIgnoreCase(EQUAL_WIDTH_BINNING) ? BinningType.EQ_WIDTH : (this.m_options.getNumericalDiscretizeTreatment().equalsIgnoreCase(NONE) ? BinningType.NONE : BinningType.QTILE));
        }
    }

    public void validate(Vector vector) throws Exception {
        this.validateValues(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void refresh() throws Exception {
        this.loadDefaults();
    }

    public void load() {
        this.loadDefaults();
    }

    protected void loadDefaults() {
        this.m_currentNumberOfBins = DiscretizeDataSource.DEFAULT_BIN_NUMBER;
        this.m_currentTailPercent = 0.0;
        if (this.m_options == null) {
            this.m_binningType = BinningType.QTILE;
        }
    }

    public DataState getDataState() {
        return (DataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
    }

    public void invalidate() {
        if (this.getState() == StepStateType.VALIDATED) {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void validateState() {
        this.setState(StepStateType.VALIDATED);
    }

    public boolean postValidate(Vector vector) throws Exception {
        CategoricalDiscretizationSettingsState categoricalDiscretizationSettingsState = (CategoricalDiscretizationSettingsState)this.getparentWizardState().getStep(StepType.SETTING_STEP_2);
        categoricalDiscretizationSettingsState.invalidate();
        boolean bl = true;
        return bl;
    }

    public StringBuffer getViewDefinition() {
        if (this.m_viewDefinition != null && this.getState() != StepStateType.VALIDATED) {
            this.m_viewDefinition.setLength(0);
            this.m_viewDefinition = null;
        }
        return this.m_viewDefinition;
    }

    public void validateBinNumberValue(Vector vector) throws Exception {
        try {
            if (this.m_currentNumberOfBins < 1) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_NUMBER));
            }
            if (this.m_currentNumberOfBins > 127) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_NUMBER));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_NUMBER));
        }
    }

    public void validateTailPercentValue(Vector vector) throws Exception {
        try {
            if (this.m_currentTailPercent < 0.0 || this.m_currentTailPercent >= 100.0) {
                vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_TAIL_PERCENTAGE));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_TAIL_PERCENTAGE));
        }
    }

    private void validateBins(Vector vector, Vector vector2) throws Exception {
        try {
            int n = this.checkValidBinBoundaries(vector2);
            if (n != -1) {
                Bin bin = (Bin)vector2.get(n);
                vector.add(new StateValidation((ValidationType)DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_BOUNDARIES, new String[]{String.valueOf(bin.getBinNumber()), String.valueOf(bin.getLowerBound()), String.valueOf(bin.getUpperBound())}));
            }
        }
        catch (Exception exception) {
            vector.add(new StateValidation(DiscretizeSettingsStateError.DISCRETIZE_INVALID_BIN_BOUNDARIES));
        }
    }

    public void validateValues(Vector vector) throws Exception {
        this.validateTailPercentValue(vector);
        this.validateBinNumberValue(vector);
        this.validateBins(vector, this.m_vectorBins);
    }

    public void setBinned(boolean bl) {
        if (!bl && this.getState() == StepStateType.VALIDATED) {
            this.setState(StepStateType.DIRTY);
        }
    }

    public void setCurrentNumberOfBins(int n) {
        if (n != this.m_currentNumberOfBins) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_currentNumberOfBins = n;
        }
    }

    public int getCurrentNumberOfBins() {
        return this.m_currentNumberOfBins;
    }

    public void setQtileBinning() {
        this.m_binningType = BinningType.QTILE;
        if (this.m_options != null) {
            this.m_options.setNumericalDiscretizeTreatment(QUANTILE_BINNING);
        }
    }

    public void setEqualWidthBinning() {
        this.m_binningType = BinningType.EQ_WIDTH;
        if (this.m_options != null) {
            this.m_options.setNumericalDiscretizeTreatment(EQUAL_WIDTH_BINNING);
        }
    }

    public boolean isQtileBinning() {
        return this.m_binningType.equal(BinningType.QTILE);
    }

    public void setCurrentTailPercent(double d) {
        if (d != this.m_currentTailPercent) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_currentTailPercent = d;
        }
    }

    public double getCurrentTailPercent() {
        return this.m_currentTailPercent;
    }

    public void setCurrentBinBoundaries(BinBoundaryTableModel binBoundaryTableModel, double d) {
        if (this.getState() == StepStateType.VALIDATED) {
            this.setState(StepStateType.DIRTY);
        }
        this.m_vectorBins.clear();
        int n = binBoundaryTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            BinBoundary binBoundary = binBoundaryTableModel.getFieldEntry(i);
            Bin bin = null;
            if (i < n - 1) {
                BinBoundary binBoundary2 = binBoundaryTableModel.getFieldEntry(i + 1);
                bin = new Bin(binBoundary.getBinNumber(), binBoundary.getLowerBound(), binBoundary2.getLowerBound());
            } else {
                bin = new Bin(binBoundary.getBinNumber(), binBoundary.getLowerBound(), d);
            }
            this.m_vectorBins.add(bin);
        }
    }

    public Vector getCurrentBinBoundaries() {
        return this.m_vectorBins;
    }

    private int checkValidBinBoundaries(Vector vector) {
        if (vector.isEmpty()) {
            return -1;
        }
        for (int i = 0; i < vector.size() - 1; ++i) {
            Bin bin = (Bin)vector.get(i);
            if (bin.getLowerBound() >= bin.getUpperBound()) {
                return i;
            }
            Bin bin2 = (Bin)vector.get(i + 1);
            if (bin2.getLowerBound() > bin2.getUpperBound()) {
                return i;
            }
            if (bin.getUpperBound() == bin2.getLowerBound()) continue;
            return i;
        }
        return -1;
    }

    public boolean isValid() {
        return this.getState() == StepStateType.VALIDATED;
    }

    public void setRecalculate(boolean bl) {
        this.m_bRecalulate = bl;
    }

    public boolean isRecalculate() {
        return this.m_bRecalulate;
    }

    public void validateCurrentBinBoundaries(Vector vector, BinBoundaryTableModel binBoundaryTableModel, double d) throws Exception {
        Vector<Bin> vector2 = new Vector<Bin>();
        int n = binBoundaryTableModel.getRowCount();
        for (int i = 0; i < n; ++i) {
            BinBoundary binBoundary = binBoundaryTableModel.getFieldEntry(i);
            Bin bin = null;
            if (i < n - 1) {
                BinBoundary binBoundary2 = binBoundaryTableModel.getFieldEntry(i + 1);
                bin = new Bin(binBoundary.getBinNumber(), binBoundary.getLowerBound(), binBoundary2.getLowerBound());
            } else {
                bin = new Bin(binBoundary.getBinNumber(), binBoundary.getLowerBound(), d);
            }
            vector2.add(bin);
        }
        this.validateBins(vector, vector2);
    }
}

