/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.SQLException;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JConnectionManager;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CreateContextIndexDataState;
import oracle.dmt.dm4j.wizard.state.transformsteps.TableNameState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.transformsteps.FinishStateError;

public class CreateContextIndexFinishState
extends WizardStepState {
    StringBuffer m_indexName = new StringBuffer();
    static final String INDEX_SUFFIX = "_CTX";
    protected final int NAME_LENGTH_MAX = 25;

    public CreateContextIndexFinishState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void validate(Vector vector) throws Exception {
        this.validateIndexName(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    private void validateIndexName(Vector vector) throws Exception {
        String[] stringArray;
        String string;
        if (this.m_indexName.length() == 0) {
            string = ResourceUtilities.getstateExceptionMessage("REQUIRED_FIELD");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("INDEX_NAME")};
            vector.add(new StateValidation(FinishStateError.INDEX_NAME_EMPTY, string, stringArray));
        }
        if (!ValidationUtil.checkStringLength(this.m_indexName.toString(), 25)) {
            string = ResourceUtilities.getstateExceptionMessage("MAXIMUM_LENGTH_EXCEEDED");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("INDEX_NAME"), Integer.toString(25)};
            vector.add(new StateValidation(FinishStateError.INDEX_NAME_EXCEEDS_MAXIMUM_LENGTH, string, stringArray));
        }
        if (ValidationUtil.isGreater25BytesInDB(this.m_indexName.toString(), this.getparentWizardState().getConnection())) {
            string = ResourceUtilities.getstateExceptionMessage("GREATER_THAN_30BYTES");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("INDEX_NAME")};
            vector.add(new StateValidation(FinishStateError.INDEX_NAME_GREATER_25BYTES, string, stringArray));
        }
        if (ValidationUtil.containsDoubleQuote(this.m_indexName.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("CONTAINS_DOUBLE_QUOTES");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("INDEX_NAME")};
            vector.add(new StateValidation(FinishStateError.INDEX_NAME_CONTAINS_DOUBLE_QUOTES, string, stringArray));
        }
        if (ValidationUtil.isEqualToROWID(this.m_indexName.toString())) {
            string = ResourceUtilities.getstateExceptionMessage("EQUALS_ROWID");
            stringArray = new String[]{ResourceUtilities.getstateExceptionMessage("INDEX_NAME")};
            vector.add(new StateValidation(FinishStateError.INDEX_NAME_EQUALS_ROWID, string, stringArray));
        }
        string = DM4JConnectionManager.getUser();
        if (!ValidationUtil.isIndexNameUnique(this.m_indexName.toString(), this.getparentWizardState().getConnection())) {
            vector.add(new StateValidation(FinishStateError.INDEX_NAME_DUPLICATE));
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public Vector validateIndexName() throws Exception {
        Vector vector = new Vector();
        this.validateIndexName(vector);
        return vector;
    }

    public void refresh() throws Exception {
        this.load();
    }

    public void load() throws Exception {
        this.generateDefaultIndexName();
    }

    protected void generateDefaultIndexName() throws SQLException {
        StringBuffer stringBuffer;
        CreateContextIndexDataState createContextIndexDataState = (CreateContextIndexDataState)this.getparentWizardState().getStep(StepType.DATA_STEP);
        if (createContextIndexDataState.isNewTableRequired()) {
            TableNameState tableNameState = (TableNameState)this.getparentWizardState().getStep(StepType.NAME_STEP);
            stringBuffer = new StringBuffer(tableNameState.getViewName());
        } else {
            stringBuffer = new StringBuffer(createContextIndexDataState.getSelectedTableName());
        }
        if (stringBuffer.length() > 21) {
            stringBuffer.setLength(21);
        }
        stringBuffer.append(INDEX_SUFFIX);
        this.m_indexName = new StringBuffer(ValidationUtil.createUniqueIndexName(stringBuffer.toString(), createContextIndexDataState.getparentWizardState().getConnection(), ""));
    }

    public String getIndexName() {
        return this.m_indexName.toString();
    }

    public void setIndexName(String string) {
        String string2;
        if (string != null && !string.equals(string2 = this.m_indexName.toString())) {
            if (this.getState() == StepStateType.VALIDATED) {
                this.setState(StepStateType.DIRTY);
            }
            this.m_indexName = new StringBuffer(string);
        }
    }
}

