/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.awt.Component;
import java.sql.Connection;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.datasources.CodeGenDataSource;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transforms.CodeGenState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenActivityState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenProcNameTableModel;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenProcNameTableSorter;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.steps.commonsteps.TableSorter;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class CodeGenTargetState
extends WizardStepState
implements Runnable {
    private CodeGenProcNameTableModel m_tableModel = new CodeGenProcNameTableModel(this);
    private CodeGenProcNameTableSorter m_sorter = new CodeGenProcNameTableSorter(this.m_tableModel);
    private String m_targetPackageName;
    private String m_packageComment;
    private String m_targetSchemaName;
    private boolean m_bDropExistingObjects = false;
    private boolean m_bSupportWorkflowAPI = true;
    private boolean m_bDefiner = true;
    private CodeGenDataSource m_ds;

    public CodeGenTargetState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
        this.m_ds = ((CodeGenState)wizardState).getDataSource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        CodeGenActivityState codeGenActivityState = (CodeGenActivityState)this.getparentWizardState().getStep(StepType.SETTING_STEP_1);
        Connection connection = null;
        CodeGenState codeGenState = (CodeGenState)this.getparentWizardState();
        try {
            connection = codeGenState.getContextConnection();
            if (connection != null) {
                this.m_tableModel.load(connection, codeGenActivityState.getSelectedActivities());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public void refresh() throws Exception {
        this.load();
    }

    public void registerPackageDetailsHelpTopic(Component component) {
        this.m_ds.registerPackageDetailsHelpTopic(component);
    }

    public void validate(Vector vector) throws Exception {
        this.validatePackageName(vector);
        if (!this.m_sorter.validateNamesUnique()) {
            vector.add(new StateValidation(DataStateError.CG_RECORD_TYPE_NAME_NON_UNIQUE));
            return;
        }
        this.validateProcedureLength(vector);
        this.validateSchemaIntegrity(vector);
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
        CodeGenState codeGenState = (CodeGenState)this.getparentWizardState();
        codeGenState.invalidateResultsStep();
    }

    private void validateProcedureLength(Vector vector) throws Exception {
        Vector vector2 = this.getProcedures();
        for (int i = 0; i < vector2.size(); ++i) {
            String string = (String)vector2.elementAt(i);
            if (27 >= string.toCharArray().length) continue;
            vector.add(new StateValidation(DataStateError.CG_PPROCEDURE_NAME_TOO_LONG));
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void validateSchemaIntegrity(Vector vector) {
        CodeGenState codeGenState = (CodeGenState)this.getparentWizardState();
        if (codeGenState.isDataMiner()) {
            return;
        }
        if (codeGenState.isJDevOffline()) {
            return;
        }
        Connection connection = null;
        try {
            connection = codeGenState.getSelectedDBConnection();
            if (connection == null) {
                return;
            }
            Vector<String> vector2 = new Vector<String>();
            vector2.add(this.m_targetPackageName);
            Vector vector3 = this.getProcedures();
            vector2.addAll(vector3);
            for (int i = 0; i < vector3.size(); ++i) {
                String string;
                String string2 = (String)vector3.elementAt(i);
                String string3 = this.m_sorter.getRecordTypeName(string2);
                if (string3 != null) {
                    vector2.add(string3);
                }
                if ((string = this.m_sorter.getTableTypeName(string2)) == null) continue;
                vector2.add(string);
            }
            if (DMEMetadata.doObjectExist(connection, vector2)) {
                vector.add(new StateValidation(DataStateError.CG_NAME_EXISTS_INSCHEMA));
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        finally {
            try {
                connection.close();
            }
            catch (Exception exception) {}
        }
    }

    public TableSorter getTableModel() {
        return this.m_sorter;
    }

    public void validateProcedureName(String string, Vector vector) throws Exception {
        if (!this.isValidDbNameName(string)) {
            vector.add(new StateValidation(DataStateError.CG_PROCEDURE_NAME_INVALID));
            return;
        }
        if (!this.m_sorter.isProcedureNameUnique(string)) {
            vector.add(new StateValidation(DataStateError.CG_PROCEDURE_NAME_NON_UNIQUE));
        }
    }

    private void validatePackageName(Vector vector) throws Exception {
        if (this.m_targetPackageName == null || 0 == this.m_targetPackageName.length()) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_MISSING));
        } else if (!this.isValidDbNameName(this.m_targetPackageName)) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_INVALID));
        } else if (-1 != this.m_targetPackageName.indexOf("'")) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_INVALID));
        } else if (-1 != this.m_targetPackageName.indexOf(":")) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_INVALID));
        } else if (30 < this.m_targetPackageName.toCharArray().length) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_TOO_LONG));
        } else if (((CodeGenState)this.getparentWizardState()).isPackageNameInUse(this.m_targetSchemaName, this.m_targetPackageName)) {
            vector.add(new StateValidation(DataStateError.CG_PACKAGE_NAME_EXISTS));
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        } else {
            this.setState(StepStateType.DIRTY);
        }
    }

    public boolean isValidDbNameName(String string) {
        if (DM4JStringUtils.isDoubleQuotedString(string)) {
            if (!Character.isLetter(string.charAt(1))) {
                return false;
            }
        } else {
            int n = string.indexOf("'");
            if (n != -1) {
                return false;
            }
            n = string.indexOf("\"");
            if (n != -1) {
                return false;
            }
            n = string.indexOf("-");
            if (n != -1) {
                return false;
            }
            n = string.indexOf("\\");
            if (n != -1) {
                return false;
            }
            n = string.indexOf("/");
            if (n != -1) {
                return false;
            }
        }
        return true;
    }

    public String getTargetPackageName() {
        return this.m_targetPackageName;
    }

    public void setTargetPackageName(String string) {
        if (null == string || null == this.m_targetPackageName || 0 == string.length()) {
            this.setState(StepStateType.DIRTY);
        } else if (0 != string.compareTo(this.m_targetPackageName)) {
            this.setState(StepStateType.DIRTY);
        }
        if (string != null && 0 != string.length() && this.m_targetPackageName != null && string.equals(this.m_targetPackageName)) {
            return;
        }
        this.m_targetPackageName = !DM4JStringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : string;
    }

    public void setPackageComment(String string) {
        if (null == string && null == this.m_packageComment) {
            return;
        }
        if (null == string || null == this.m_packageComment) {
            this.setState(StepStateType.DIRTY);
        } else if (0 != string.compareTo(this.m_packageComment)) {
            this.setState(StepStateType.DIRTY);
        }
        this.m_packageComment = string;
    }

    public String getPackageComment() {
        return this.m_packageComment;
    }

    public String getTargetSchemaName() {
        return this.m_targetSchemaName;
    }

    public void setTargetSchemaName(String string) {
        this.m_targetSchemaName = !DM4JStringUtils.isDoubleQuotedString(string) ? string.toUpperCase() : string;
    }

    public void run() {
    }

    public boolean postValidate(Vector vector) {
        int n;
        for (n = 0; n < this.m_sorter.getRowCount(); ++n) {
            boolean bl = this.m_sorter.isRealTimeSupport(n);
            if (bl) continue;
            String string = this.m_sorter.getProcedureName(n);
            this.m_sorter.removeRealTimeSupportTypes(string);
        }
        n = 1;
        return n != 0;
    }

    public Vector getProcedures() {
        return this.m_sorter.getProcedureNames();
    }

    public Vector getSelectedData() {
        return this.m_sorter.getSelectedData();
    }

    public void setDropExistingObjects(boolean bl) {
        this.m_bDropExistingObjects = bl;
    }

    public boolean isDropExistingObjects() {
        return this.m_bDropExistingObjects;
    }

    public void setSupportWorkflowAPI(boolean bl) {
        this.m_bSupportWorkflowAPI = bl;
    }

    public boolean isSupportWorkflowAPI() {
        return this.m_bSupportWorkflowAPI;
    }

    public void setDefiner(boolean bl) {
        this.m_bDefiner = bl;
    }

    public boolean isDefiner() {
        return this.m_bDefiner;
    }

    public String getRecordTypeName(String string) {
        return this.m_sorter.getRecordTypeName(string);
    }

    public String getTableTypeName(String string) {
        return this.m_sorter.getTableTypeName(string);
    }
}

