/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.io.File;
import java.util.Vector;
import oracle.dmt.dm4j.DM4JStringUtils;
import oracle.dmt.dm4j.browser.UserPreferences;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardState;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.state.transformsteps.CodeGenTargetState;
import oracle.dmt.dm4j.wizard.steps.StepType;
import oracle.dmt.dm4j.wizard.validation.StateValidation;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;
import oracle.dmt.dm4j.wizard.validation.commonsteps.DataStateError;

public class CodeGenTargetFileState
extends WizardStepState {
    private String m_directory;
    private String m_fileName;
    public static final String EXT = "sql";
    private static final String DOT = ".";
    public static final String DIR_SEPARATOR = "/";

    public CodeGenTargetFileState(WizardState wizardState, String string, StepType stepType) {
        super(wizardState, string, stepType);
    }

    public void load() {
        CodeGenTargetState codeGenTargetState;
        String string;
        UserPreferences userPreferences = UserPreferences.getInstance();
        this.m_directory = userPreferences.getWorkingDirectory();
        if (this.m_directory == null || 0 == this.m_directory.length()) {
            this.m_directory = System.getProperty("user.dir", "");
        }
        if (DM4JStringUtils.isDoubleQuotedString(string = (codeGenTargetState = (CodeGenTargetState)this.getparentWizardState().getStep(StepType.SETTING_STEP_2)).getTargetPackageName())) {
            string = DM4JStringUtils.trimDoubleQuotes(string);
        }
        this.m_fileName = string;
        String string2 = new String(this.m_directory + System.getProperty("file.separator"));
        int n = 0;
        String string3 = string2 + this.m_fileName + DOT + EXT;
        File file = new File(string3);
        while (file.exists()) {
            this.m_fileName = string + ++n;
            string3 = string2 + this.m_fileName + DOT + EXT;
            file = new File(string3);
        }
        this.m_fileName = this.m_fileName + ".sql";
    }

    public void refresh() throws Exception {
        this.load();
    }

    public void validate(Vector vector) throws Exception {
        File file = new File(this.m_directory);
        if (!file.exists()) {
            vector.add(new StateValidation(DataStateError.CG_DIRECTORY_DOES_NOT_EXIST));
        }
        if (this.m_fileName == null || 0 == this.m_fileName.length()) {
            vector.add(new StateValidation(DataStateError.CG_FILE_NAME_MISSING));
        }
        if (!ValidationUtil.validationsContainsErrors(vector)) {
            this.setState(StepStateType.VALIDATED);
        }
    }

    public String getDirectory() {
        return this.m_directory;
    }

    public void setDirectory(String string) {
        this.m_directory = string;
    }

    public void setFilename(String string) {
        this.m_fileName = string;
    }

    public String getFilename() {
        return this.m_fileName;
    }

    public String getFullFileName() {
        String string = this.m_directory + System.getProperty("file.separator") + this.m_fileName;
        string = DM4JStringUtils.getReplacedString(string, "\\", DIR_SEPARATOR);
        return string;
    }
}

