/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dm4j.wizard.state.transformsteps;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.table.AbstractTableModel;
import oracle.dmt.dm4j.activity.ActivityType;
import oracle.dmt.dm4j.datasources.DMEMetadata;
import oracle.dmt.dm4j.datasources.DatabaseMetadata;
import oracle.dmt.dm4j.wizard.resources.ResourceUtilities;
import oracle.dmt.dm4j.wizard.state.StepStateType;
import oracle.dmt.dm4j.wizard.state.WizardStepState;
import oracle.dmt.dm4j.wizard.validation.ValidationUtil;

public class CodeGenProcNameTableModel
extends AbstractTableModel {
    private ArrayList m_rows;
    private WizardStepState m_parentState;
    private static int START = 0;
    public static final int ACTIVITY_COL = START++;
    public static final int ACTIVITY_TYPE = START++;
    public static final int PROCEDURE_COL = START++;
    public static final int REALTIME_SUPPORT = START++;
    private static int LAST_COL = START;
    private Hashtable m_types = new Hashtable();
    private static String[] columns = new String[LAST_COL];
    public static final int TYPE_AVAILABLE_LENGTH = 30;
    public static final int TABLE_AVAILABLE_LENGTH = 30;
    public static final int PROC_AVAILABLE_LENGTH = 27;
    public static final int SEQUENCE_ID_DIGISTS = 2;
    private static final String RECORD_TYPE_SUFFIX = "_R";
    private static final String TABLE_TYPE_SUFFIX = "_T";

    public CodeGenProcNameTableModel(WizardStepState wizardStepState) {
        this.m_parentState = wizardStepState;
    }

    public WizardStepState getParentState() {
        return this.m_parentState;
    }

    public int getColumnAlignment(int n) {
        return 2;
    }

    public Comparator getColumnSortComparator(int n) {
        return null;
    }

    public int getColumnCount() {
        return columns.length;
    }

    public String getColumnName(int n) {
        return columns[n];
    }

    public int getRowCount() {
        return this.m_rows != null ? this.m_rows.size() : 0;
    }

    public Class getColumnClass(int n) {
        if (n == REALTIME_SUPPORT) {
            return Boolean.class;
        }
        if (n == ACTIVITY_TYPE) {
            return ActivityType.class;
        }
        return String.class;
    }

    public Object getValueAt(int n, int n2) {
        ArrayList arrayList = (ArrayList)this.m_rows.get(n);
        if (arrayList == null) {
            return null;
        }
        Object e = arrayList.get(n2);
        return e;
    }

    public void load(Connection connection, Vector vector) throws Exception {
        this.m_rows = new ArrayList(vector.size());
        HashMap hashMap = DatabaseMetadata.getPrimaryObjectNamespaceHashMap(connection);
        for (int i = 0; i < vector.size(); ++i) {
            ArrayList<Object> arrayList = new ArrayList<Object>(LAST_COL);
            Hashtable hashtable = (Hashtable)vector.get(i);
            String string = (String)hashtable.get(new Integer(DMEMetadata.CG_ACTIVITY_NAME_COLUMN));
            arrayList.add(ACTIVITY_COL, string);
            String string2 = (String)hashtable.get(new Integer(DMEMetadata.CG_ACTIVITY_TYPE_COLUMN));
            ActivityType activityType = ActivityType.getInstance(string2);
            arrayList.add(ACTIVITY_TYPE, activityType);
            String string3 = this.generateProcName(hashMap, string, activityType);
            arrayList.add(PROCEDURE_COL, string3);
            arrayList.add(REALTIME_SUPPORT, new Boolean(ActivityType.isApplyActivity(activityType)));
            this.m_rows.add(i, arrayList);
            if (!ActivityType.isApplyActivity(activityType)) continue;
            String string4 = this.generateRecordTypeName(hashMap, string3);
            String string5 = this.generateTableTypeName(hashMap, string3);
            this.setRealTimeSupportTypes(string3, string4, string5);
        }
        this.fireTableStructureChanged();
    }

    public void setValueAt(Object object, int n, int n2) {
        if (n2 == PROCEDURE_COL || n2 == REALTIME_SUPPORT) {
            ArrayList arrayList = (ArrayList)this.m_rows.get(n);
            arrayList.set(n2, object);
            this.m_parentState.setState(StepStateType.DIRTY);
            this.fireTableCellUpdated(n, n2);
        }
    }

    private String generateProcName(HashMap hashMap, String string, ActivityType activityType) {
        String string2 = null;
        string2 = ActivityType.isBuildActivity(activityType) ? "_BA" : (ActivityType.isTestActivity(activityType) ? "_TA" : "_AA");
        return this.generateUniqueName(hashMap, string, string2, 27);
    }

    private String generateUniqueName(HashMap hashMap, String string, String string2, int n) {
        int n2 = n - (string2.length() + 9);
        String string3 = string.length() > n2 ? string.substring(0, n2) : string;
        String string4 = ValidationUtil.createUniqueDBObjNameCodeGen(string3, hashMap, string2);
        hashMap.put(string4, string4);
        return string4.toUpperCase();
    }

    private boolean isProcNameUnique(String string) {
        Vector vector = this.getProcedureNames();
        for (int i = 0; i < vector.size(); ++i) {
            String string2 = (String)vector.elementAt(i);
            if (0 != string2.compareToIgnoreCase(string)) continue;
            return false;
        }
        return true;
    }

    private Vector getProcedureNames() {
        int n = this.getRowCount();
        Vector<String> vector = new Vector<String>(n);
        for (int i = 0; i < n; ++i) {
            String string = (String)this.getValueAt(i, PROCEDURE_COL);
            vector.add(string);
        }
        return vector;
    }

    public void setRealTimeSupportTypes(String string, String string2, String string3) {
        this.m_types.put(string, new RealTimeTypes(string2, string3));
    }

    public void removeRealTimeSupportTypes(String string) {
        this.m_types.remove(string);
    }

    public boolean isTypeNameUnique(String string) {
        if (this.m_types.isEmpty()) {
            return true;
        }
        Enumeration enumeration = this.m_types.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            RealTimeTypes realTimeTypes = (RealTimeTypes)this.m_types.get(string2);
            if (realTimeTypes == null || !realTimeTypes.isNameUsed(string)) continue;
            return false;
        }
        return true;
    }

    public boolean validateNamesUnique() {
        if (this.m_types.isEmpty()) {
            return true;
        }
        Hashtable<String, String> hashtable = new Hashtable<String, String>();
        Enumeration enumeration = this.m_types.keys();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            RealTimeTypes realTimeTypes = (RealTimeTypes)this.m_types.get(string);
            if (realTimeTypes == null) continue;
            String string2 = realTimeTypes.getRecordType();
            String string3 = realTimeTypes.getTableType();
            if (null != hashtable.get(string2)) {
                hashtable.clear();
                return false;
            }
            if (null != hashtable.get(string3)) {
                hashtable.clear();
                return false;
            }
            hashtable.put(string2, string2);
            hashtable.put(string3, string3);
        }
        hashtable.clear();
        return true;
    }

    public String[] getTypeNames(String string) {
        RealTimeTypes realTimeTypes = (RealTimeTypes)this.m_types.get(string);
        if (realTimeTypes != null) {
            return new String[]{realTimeTypes.getRecordType(), realTimeTypes.getTableType()};
        }
        return null;
    }

    public String generateRecordTypeName(HashMap hashMap, String string) {
        return this.generateUniqueName(hashMap, string, RECORD_TYPE_SUFFIX, 30);
    }

    public String getRecordTypeName(String string) {
        RealTimeTypes realTimeTypes = (RealTimeTypes)this.m_types.get(string);
        if (realTimeTypes != null) {
            return realTimeTypes.getRecordType();
        }
        return null;
    }

    public String generateTableTypeName(HashMap hashMap, String string) {
        return this.generateUniqueName(hashMap, string, TABLE_TYPE_SUFFIX, 30);
    }

    public String getTableTypeName(String string) {
        RealTimeTypes realTimeTypes = (RealTimeTypes)this.m_types.get(string);
        if (realTimeTypes != null) {
            return realTimeTypes.getTableType();
        }
        return null;
    }

    static {
        CodeGenProcNameTableModel.columns[CodeGenProcNameTableModel.ACTIVITY_COL] = ResourceUtilities.getUILabel("CODE_GEN_ACTIVITY_NAME");
        CodeGenProcNameTableModel.columns[CodeGenProcNameTableModel.ACTIVITY_TYPE] = ResourceUtilities.getUILabel("CODE_GEN_ACTIVITY_TYPE");
        CodeGenProcNameTableModel.columns[CodeGenProcNameTableModel.PROCEDURE_COL] = ResourceUtilities.getUILabel("CODE_GEN_PROCEDURE_NAME");
        CodeGenProcNameTableModel.columns[CodeGenProcNameTableModel.REALTIME_SUPPORT] = ResourceUtilities.getUILabel("CODE_GEN_SQL_INTEGRATION");
    }

    class RealTimeTypes {
        private String m_recordType;
        private String m_tableType;

        public String getRecordType() {
            return this.m_recordType;
        }

        public String getTableType() {
            return this.m_tableType;
        }

        RealTimeTypes(String string, String string2) {
            this.m_recordType = string;
            this.m_tableType = string2;
        }

        public boolean isNameUsed(String string) {
            return 0 == string.compareToIgnoreCase(this.m_recordType) || 0 == string.compareToIgnoreCase(this.m_tableType);
        }
    }
}

